/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.fader.impl;

import com.waxmonster.fader.impl.CommonFaderCurveCustomizer;
import com.waxmonster.fader.impl.ExponentialFaderCurve;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ExponentialFaderCurveCustomizer
extends JPanel
implements Customizer {
    private static final long serialVersionUID = 804188150325151767L;
    private static final String PROPERTY_EXPONENT = "exponent";
    private static final int SLIDER_MAX = 1000;
    private boolean refreshing;
    private ExponentialFaderCurve exponentialFaderCurve;
    private CommonFaderCurveCustomizer commonFaderCurveCustomizer;
    private JSlider sliderExponent;

    public ExponentialFaderCurveCustomizer() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.commonFaderCurveCustomizer = new CommonFaderCurveCustomizer();
        this.commonFaderCurveCustomizer.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ExponentialFaderCurveCustomizer.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        });
        GridBagConstraints gbc_commonFaderCurveCustomizer = new GridBagConstraints();
        gbc_commonFaderCurveCustomizer.insets = new Insets(0, 0, 5, 0);
        gbc_commonFaderCurveCustomizer.weightx = 1.0;
        gbc_commonFaderCurveCustomizer.fill = 1;
        gbc_commonFaderCurveCustomizer.gridx = 0;
        gbc_commonFaderCurveCustomizer.gridy = 0;
        this.add((Component)this.commonFaderCurveCustomizer, gbc_commonFaderCurveCustomizer);
        JPanel panelArrayCurve = new JPanel();
        GridBagConstraints gbc_panelArrayCurve = new GridBagConstraints();
        gbc_panelArrayCurve.weighty = 1.0;
        gbc_panelArrayCurve.weightx = 1.0;
        gbc_panelArrayCurve.fill = 1;
        gbc_panelArrayCurve.gridx = 0;
        gbc_panelArrayCurve.gridy = 1;
        this.add((Component)panelArrayCurve, gbc_panelArrayCurve);
        GridBagLayout gbl_panelArrayCurve = new GridBagLayout();
        gbl_panelArrayCurve.columnWidths = new int[]{0, 0, 0};
        gbl_panelArrayCurve.rowHeights = new int[]{0, 0};
        gbl_panelArrayCurve.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelArrayCurve.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelArrayCurve.setLayout(gbl_panelArrayCurve);
        JLabel lblExponent = new JLabel("Exponent:");
        GridBagConstraints gbc_lblExponent = new GridBagConstraints();
        gbc_lblExponent.insets = new Insets(4, 4, 0, 5);
        gbc_lblExponent.gridx = 0;
        gbc_lblExponent.gridy = 0;
        panelArrayCurve.add((Component)lblExponent, gbc_lblExponent);
        this.sliderExponent = new JSlider();
        this.sliderExponent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!ExponentialFaderCurveCustomizer.this.refreshing) {
                    ExponentialFaderCurveCustomizer.this.applyExponent();
                }
            }
        });
        this.sliderExponent.setOpaque(false);
        GridBagConstraints gbc_sliderExponent = new GridBagConstraints();
        gbc_sliderExponent.fill = 2;
        gbc_sliderExponent.weightx = 1.0;
        gbc_sliderExponent.gridx = 1;
        gbc_sliderExponent.gridy = 0;
        panelArrayCurve.add((Component)this.sliderExponent, gbc_sliderExponent);
        this.initExponentialFaderCurveCustomizer();
    }

    public ExponentialFaderCurve getExponentialFaderCurve() {
        return this.exponentialFaderCurve;
    }

    public void setExponentialFaderCurve(ExponentialFaderCurve exponentialFaderCurve) {
        this.exponentialFaderCurve = exponentialFaderCurve;
        this.commonFaderCurveCustomizer.setFaderCurve(exponentialFaderCurve);
        this.refresh();
    }

    @Override
    public void setObject(Object bean) {
        this.setExponentialFaderCurve((ExponentialFaderCurve)bean);
    }

    protected void initExponentialFaderCurveCustomizer() {
        this.sliderExponent.setMinimum(0);
        this.sliderExponent.setMaximum(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void refresh() {
        try {
            this.refreshing = true;
            float exponent = 1.0f;
            ExponentialFaderCurve efc = this.exponentialFaderCurve;
            if (efc != null) {
                exponent = efc.getExponent();
            }
            int sliderValue = 500;
            if (exponent < 1.0f) {
                sliderValue = Math.round(exponent * 1000.0f / 2.0f);
            } else if (exponent > 1.0f) {
                sliderValue = 1000 - Math.round(500.0f / exponent);
            }
            if (sliderValue < 0) {
                sliderValue = 0;
            }
            if (sliderValue > 1000) {
                sliderValue = 1000;
            }
            this.sliderExponent.setValue(sliderValue);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected CommonFaderCurveCustomizer getCommonFaderCurveCustomizer() {
        return this.commonFaderCurveCustomizer;
    }

    protected void applyExponent() {
        ExponentialFaderCurve curve = this.exponentialFaderCurve;
        if (curve != null) {
            float oldExponent = curve.getExponent();
            float sliderValue = (float)this.sliderExponent.getValue() / 1000.0f;
            float newExponent = 1.0f;
            if (sliderValue < 0.5f) {
                newExponent = sliderValue * 2.0f;
            }
            if (sliderValue > 0.5f) {
                newExponent = 1.0f / ((1.0f - sliderValue) * 2.0f);
            }
            curve.setExponent(newExponent);
            this.firePropertyChange(PROPERTY_EXPONENT, oldExponent, newExponent);
        }
    }

    protected JSlider getSliderExponent() {
        return this.sliderExponent;
    }
}

