/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.fader.impl;

import com.waxmonster.fader.FaderCurve;
import com.waxmonster.fader.impl.AbstractFaderCurve;
import com.waxmonster.fader.impl.FaderCurveEditor;
import com.waxmonster.fader.impl.FaderCurveUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class FaderCurveChooser
extends JPanel
implements PropertyEditor {
    private static final long serialVersionUID = -2785851234752393999L;
    private static final String PROPERTY_FADER_CURVE = "faderCurve";
    private FaderCurve faderCurve;
    private Color curveColor = Color.BLUE;
    private int curveOrientation = 1;
    private boolean curveReverse = false;
    private boolean refreshing;
    private JButton buttonEditCurve;
    private JComboBox comboBoxCurve;

    public FaderCurveChooser() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.comboBoxCurve = new JComboBox();
        this.comboBoxCurve.setToolTipText("Fader curve");
        this.comboBoxCurve.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!FaderCurveChooser.this.refreshing) {
                    FaderCurveChooser.this.apply();
                }
            }
        });
        this.comboBoxCurve.setOpaque(false);
        GridBagConstraints gbc_comboBoxCurve = new GridBagConstraints();
        gbc_comboBoxCurve.weightx = 1.0;
        gbc_comboBoxCurve.insets = new Insets(0, 0, 0, 4);
        gbc_comboBoxCurve.fill = 1;
        gbc_comboBoxCurve.gridx = 0;
        gbc_comboBoxCurve.gridy = 0;
        this.add((Component)this.comboBoxCurve, gbc_comboBoxCurve);
        this.buttonEditCurve = new JButton("");
        this.buttonEditCurve.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaderCurveChooser.this.showFaderCurveEditorDialog();
            }
        });
        this.buttonEditCurve.setMargin(new Insets(2, 2, 2, 2));
        this.buttonEditCurve.setToolTipText("Fader curve editor...");
        this.buttonEditCurve.setIcon(new ImageIcon(FaderCurveChooser.class.getResource("/com/waxmonster/fader/impl/icons/chilli_curve_icon16.png")));
        GridBagConstraints gbc_buttonEditCurve = new GridBagConstraints();
        gbc_buttonEditCurve.fill = 1;
        gbc_buttonEditCurve.gridx = 1;
        gbc_buttonEditCurve.gridy = 0;
        this.add((Component)this.buttonEditCurve, gbc_buttonEditCurve);
    }

    @Override
    public void setValue(Object value) {
        this.setFaderCurve((FaderCurve)value);
    }

    @Override
    public Object getValue() {
        return this.getFaderCurve();
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this;
    }

    public FaderCurve getFaderCurve() {
        return this.faderCurve;
    }

    public synchronized void setFaderCurve(FaderCurve faderCurve) {
        FaderCurve oldCurve = this.faderCurve;
        this.faderCurve = faderCurve;
        this.refresh();
        this.firePropertyChange(PROPERTY_FADER_CURVE, oldCurve, faderCurve);
    }

    @Override
    public String getJavaInitializationString() {
        return null;
    }

    @Override
    public String getAsText() {
        FaderCurve curve = this.getFaderCurve();
        if (curve == null) {
            return null;
        }
        return FaderCurveUtil.formatFaderCurve(curve);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        FaderCurve curve = FaderCurveUtil.parseFaderCurve(text);
        this.setFaderCurve(curve);
    }

    protected JButton getButtonEditCurve() {
        return this.buttonEditCurve;
    }

    protected JComboBox getComboBoxCurve() {
        return this.comboBoxCurve;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.comboBoxCurve.setEnabled(enabled);
        this.buttonEditCurve.setEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void refresh() {
        try {
            this.refreshing = true;
            this.comboBoxCurve.removeAllItems();
            String name = null;
            FaderCurve curve = this.getFaderCurve();
            if (curve != null) {
                if (curve instanceof AbstractFaderCurve) {
                    AbstractFaderCurve afc = (AbstractFaderCurve)curve;
                    name = afc.getName();
                }
                if (name == null) {
                    name = curve.toString();
                }
            }
            int index = -1;
            if (name != null) {
                index = this.comboBoxCurve.getItemCount();
                this.comboBoxCurve.addItem(name);
            }
            if (index >= 0) {
                this.comboBoxCurve.setSelectedIndex(index);
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void apply() {
        Object item = this.comboBoxCurve.getSelectedItem();
        if (item == null) {
            this.setFaderCurve(null);
            return;
        }
        if (item instanceof FaderCurve) {
            FaderCurve fc = (FaderCurve)item;
            this.setFaderCurve(fc);
            return;
        }
    }

    protected void showFaderCurveEditorDialog() {
        FaderCurve currentCurve = this.getFaderCurve();
        FaderCurve clonedCurve = null;
        if (currentCurve != null) {
            if (currentCurve instanceof AbstractFaderCurve) {
                AbstractFaderCurve afc = (AbstractFaderCurve)currentCurve;
                try {
                    clonedCurve = afc.cloneFaderCurve();
                }
                catch (CloneNotSupportedException e) {
                    // empty catch block
                }
            }
            if (clonedCurve == null) {
                clonedCurve = currentCurve;
            }
        }
        FaderCurveEditor editor = new FaderCurveEditor();
        editor.setCurveVisible(true);
        editor.setCurveColor(this.curveColor);
        editor.setCurveOrientation(this.curveOrientation);
        editor.setCurveReverse(this.curveReverse);
        editor.setFaderCurve(clonedCurve);
        String title = "Fader Curve Editor";
        int optionType = 2;
        int messageType = -1;
        FaderCurveEditor message = editor;
        int rc = JOptionPane.showConfirmDialog(this, message, title, optionType, messageType);
        if (rc != 0) {
            return;
        }
        FaderCurve newCurve = editor.getFaderCurve();
        this.setFaderCurve(newCurve);
    }

    public Color getCurveColor() {
        return this.curveColor;
    }

    public void setCurveColor(Color curveColor) {
        this.curveColor = curveColor;
    }

    public int getCurveOrientation() {
        return this.curveOrientation;
    }

    public void setCurveOrientation(int curveOrientation) {
        this.curveOrientation = curveOrientation;
    }

    public boolean isCurveReverse() {
        return this.curveReverse;
    }

    public void setCurveReverse(boolean curveReverse) {
        this.curveReverse = curveReverse;
    }
}

