/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.fader.impl;

import com.spacekiller.util.Platform;
import com.waxmonster.fader.FaderCurve;
import com.waxmonster.fader.impl.AbstractFaderCurve;
import com.waxmonster.fader.impl.ArrayFaderCurve;
import com.waxmonster.fader.impl.ArrayFaderCurveCustomizer;
import com.waxmonster.fader.impl.CommonFaderCurveCustomizer;
import com.waxmonster.fader.impl.Cosine1FaderCurve;
import com.waxmonster.fader.impl.Cosine2FaderCurve;
import com.waxmonster.fader.impl.ExponentialFaderCurve;
import com.waxmonster.fader.impl.ExponentialFaderCurveCustomizer;
import com.waxmonster.fader.impl.FaderCurveUtil;
import com.waxmonster.fader.impl.FaderCurveViewer;
import com.waxmonster.fader.impl.LinearFaderCurve;
import com.waxmonster.fader.impl.SharpFaderCurve;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.StreamCorruptedException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;

public class FaderCurveEditor
extends JPanel {
    private static final long serialVersionUID = -7904730614543878099L;
    private static final Logger logger = Logger.getLogger(FaderCurveEditor.class.getName());
    private static final String FADER_CURVE_FILE_EXTENSION = ".fcv";
    private static final String FADER_CURVE_HEADER = "#FaderCurve";
    private static final String CURVE_TYPE_LINEAR = "Linear";
    private static final String CURVE_TYPE_SHARP = "Sharp";
    private static final String CURVE_TYPE_COSINE1 = "Cosine 1";
    private static final String CURVE_TYPE_COSINE2 = "Cosine 2";
    private static final String CURVE_TYPE_EXPONENTIAL = "Exponential";
    private static final String CURVE_TYPE_ARRAY = "Array";
    private FaderCurve faderCurve;
    private boolean refreshing;
    private boolean curveVisible = true;
    private Color curveColor = Color.BLUE;
    private int curveOrientation = 1;
    private boolean curveReverse = false;
    private File currentDirectory;
    private PropertyChangeHandler propertyChangeHandler = new PropertyChangeHandler();
    private JComboBox comboBoxCurveType;
    private JPanel panelCustom;
    private JPanel panelContent;
    private JPanel panelViewer;
    private FaderCurveViewer faderCurveViewer;
    private JPanel panelView;
    private JPanel panel;
    private JButton btnImport;
    private JButton btnExport;

    public FaderCurveEditor() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.insets = new Insets(0, 0, 5, 0);
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 0;
        this.add((Component)this.panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panel.setLayout(gbl_panel);
        JLabel lblCurveType = new JLabel("Curve:");
        GridBagConstraints gbc_lblCurveType = new GridBagConstraints();
        gbc_lblCurveType.insets = new Insets(4, 4, 4, 4);
        gbc_lblCurveType.gridx = 0;
        gbc_lblCurveType.gridy = 0;
        this.panel.add((Component)lblCurveType, gbc_lblCurveType);
        this.comboBoxCurveType = new JComboBox();
        GridBagConstraints gbc_comboBoxCurveType = new GridBagConstraints();
        gbc_comboBoxCurveType.fill = 1;
        gbc_comboBoxCurveType.weightx = 1.0;
        gbc_comboBoxCurveType.insets = new Insets(4, 4, 4, 4);
        gbc_comboBoxCurveType.gridx = 1;
        gbc_comboBoxCurveType.gridy = 0;
        this.panel.add((Component)this.comboBoxCurveType, gbc_comboBoxCurveType);
        this.comboBoxCurveType.setToolTipText("Curve type");
        this.comboBoxCurveType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!FaderCurveEditor.this.refreshing) {
                    FaderCurveEditor.this.applyCurveType();
                }
            }
        });
        this.comboBoxCurveType.setOpaque(false);
        this.btnImport = new JButton("");
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaderCurveEditor.this.actionImportCurve();
            }
        });
        this.btnImport.setIcon(new ImageIcon(FaderCurveEditor.class.getResource("/com/waxmonster/fader/impl/icons/import_curve.gif")));
        this.btnImport.setToolTipText("Import fader curve...");
        this.btnImport.setMargin(new Insets(2, 2, 2, 2));
        GridBagConstraints gbc_btnImport = new GridBagConstraints();
        gbc_btnImport.insets = new Insets(4, 0, 4, 4);
        gbc_btnImport.gridx = 2;
        gbc_btnImport.gridy = 0;
        this.panel.add((Component)this.btnImport, gbc_btnImport);
        this.btnExport = new JButton("");
        this.btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaderCurveEditor.this.actionExportCurve();
            }
        });
        this.btnExport.setIcon(new ImageIcon(FaderCurveEditor.class.getResource("/com/waxmonster/fader/impl/icons/export_curve.gif")));
        this.btnExport.setToolTipText("Export fader curve...");
        this.btnExport.setMargin(new Insets(2, 2, 2, 2));
        GridBagConstraints gbc_btnExport = new GridBagConstraints();
        gbc_btnExport.insets = new Insets(4, 0, 4, 4);
        gbc_btnExport.gridx = 3;
        gbc_btnExport.gridy = 0;
        this.panel.add((Component)this.btnExport, gbc_btnExport);
        this.panelContent = new JPanel();
        GridBagConstraints gbc_panelContent = new GridBagConstraints();
        gbc_panelContent.weighty = 1.0;
        gbc_panelContent.weightx = 1.0;
        gbc_panelContent.fill = 1;
        gbc_panelContent.gridx = 0;
        gbc_panelContent.gridy = 1;
        this.add((Component)this.panelContent, gbc_panelContent);
        GridBagLayout gbl_panelContent = new GridBagLayout();
        gbl_panelContent.columnWidths = new int[]{0, 0};
        gbl_panelContent.rowHeights = new int[]{0, 0, 0};
        gbl_panelContent.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelContent.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.panelContent.setLayout(gbl_panelContent);
        this.panelCustom = new JPanel();
        GridBagConstraints gbc_panelCustom = new GridBagConstraints();
        gbc_panelCustom.insets = new Insets(0, 0, 5, 0);
        gbc_panelCustom.weighty = 1.0;
        gbc_panelCustom.weightx = 1.0;
        gbc_panelCustom.fill = 1;
        gbc_panelCustom.gridx = 0;
        gbc_panelCustom.gridy = 0;
        this.panelContent.add((Component)this.panelCustom, gbc_panelCustom);
        this.panelCustom.setOpaque(false);
        this.panelCustom.setLayout(new GridLayout(1, 0, 0, 0));
        this.panelView = new JPanel();
        GridBagConstraints gbc_panelView = new GridBagConstraints();
        gbc_panelView.insets = new Insets(0, 4, 4, 4);
        gbc_panelView.fill = 1;
        gbc_panelView.gridx = 0;
        gbc_panelView.gridy = 1;
        this.panelContent.add((Component)this.panelView, gbc_panelView);
        this.panelView.setLayout(new GridLayout(0, 1, 0, 0));
        this.panelViewer = new JPanel();
        this.panelViewer.setMinimumSize(new Dimension(100, 100));
        this.panelView.add(this.panelViewer);
        this.panelViewer.setBorder(new LineBorder(Color.LIGHT_GRAY));
        this.panelViewer.setPreferredSize(new Dimension(100, 100));
        this.panelViewer.setLayout(new GridLayout(0, 1, 0, 0));
        this.faderCurveViewer = new FaderCurveViewer();
        this.panelViewer.add(this.faderCurveViewer);
        this.initFaderCurveEditor();
    }

    protected JComboBox getComboBoxCurveType() {
        return this.comboBoxCurveType;
    }

    protected JPanel getPanelCustom() {
        return this.panelCustom;
    }

    protected void initFaderCurveEditor() {
        this.setPreferredSize(new Dimension(300, 300));
        this.comboBoxCurveType.removeAllItems();
        this.comboBoxCurveType.addItem(CURVE_TYPE_LINEAR);
        this.comboBoxCurveType.addItem(CURVE_TYPE_SHARP);
        this.comboBoxCurveType.addItem(CURVE_TYPE_COSINE1);
        this.comboBoxCurveType.addItem(CURVE_TYPE_COSINE2);
        this.comboBoxCurveType.addItem(CURVE_TYPE_EXPONENTIAL);
        this.comboBoxCurveType.addItem(CURVE_TYPE_ARRAY);
    }

    public FaderCurve getFaderCurve() {
        return this.faderCurve;
    }

    public void setFaderCurve(FaderCurve faderCurve) {
        this.faderCurve = faderCurve;
        this.refresh();
    }

    public void setFaderCurve(FaderCurve faderCurve, boolean refresh) {
        this.faderCurve = faderCurve;
        if (refresh) {
            this.refresh();
        }
    }

    public boolean isCurveVisible() {
        return this.curveVisible;
    }

    public void setCurveVisible(boolean curveVisible) {
        this.curveVisible = curveVisible;
        this.refresh();
    }

    protected JPanel getPanelViewer() {
        return this.panelViewer;
    }

    protected JPanel getPanelView() {
        return this.panelView;
    }

    protected FaderCurveViewer getFaderCurveViewer() {
        return this.faderCurveViewer;
    }

    public Color getCurveColor() {
        return this.curveColor;
    }

    public void setCurveColor(Color curveColor) {
        this.curveColor = curveColor;
        this.refresh();
    }

    public int getCurveOrientation() {
        return this.curveOrientation;
    }

    public void setCurveOrientation(int curveOrientation) {
        this.curveOrientation = curveOrientation;
        this.refresh();
    }

    public boolean isCurveReverse() {
        return this.curveReverse;
    }

    public void setCurveReverse(boolean curveReverse) {
        this.curveReverse = curveReverse;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        try {
            Component oldComp;
            this.refreshing = true;
            if (this.panelCustom.getComponentCount() > 0 && (oldComp = this.panelCustom.getComponent(0)) != null) {
                oldComp.removePropertyChangeListener(this.propertyChangeHandler);
            }
            this.panelCustom.removeAll();
            Component comp = null;
            String type = null;
            FaderCurve curve = this.faderCurve;
            if (curve != null) {
                JPanel cust;
                if (curve instanceof LinearFaderCurve) {
                    type = CURVE_TYPE_LINEAR;
                }
                if (curve instanceof SharpFaderCurve) {
                    type = CURVE_TYPE_SHARP;
                }
                if (curve instanceof ExponentialFaderCurve) {
                    type = CURVE_TYPE_EXPONENTIAL;
                    cust = new ExponentialFaderCurveCustomizer();
                    ((ExponentialFaderCurveCustomizer)cust).setExponentialFaderCurve((ExponentialFaderCurve)curve);
                    comp = cust;
                }
                if (curve instanceof Cosine1FaderCurve) {
                    type = CURVE_TYPE_COSINE1;
                }
                if (curve instanceof Cosine2FaderCurve) {
                    type = CURVE_TYPE_COSINE2;
                }
                if (curve instanceof ArrayFaderCurve) {
                    type = CURVE_TYPE_ARRAY;
                    cust = new ArrayFaderCurveCustomizer();
                    ((ArrayFaderCurveCustomizer)cust).setFaderCurveEditor(this);
                    ((ArrayFaderCurveCustomizer)cust).setArrayFaderCurve((ArrayFaderCurve)curve);
                    comp = cust;
                }
                if (comp == null) {
                    cust = new CommonFaderCurveCustomizer();
                    ((CommonFaderCurveCustomizer)cust).setFaderCurve(curve);
                    comp = cust;
                }
            }
            if (type != null) {
                this.comboBoxCurveType.setSelectedItem(type);
            } else {
                this.comboBoxCurveType.setSelectedIndex(-1);
            }
            if (comp != null) {
                comp.addPropertyChangeListener(this.propertyChangeHandler);
                this.panelCustom.add(comp);
            }
            this.refreshCurveViewer();
            if (this.curveVisible) {
                this.getPanelView().removeAll();
                this.getPanelView().add(this.getPanelViewer());
            } else {
                this.getPanelView().removeAll();
            }
            this.validate();
            this.repaint();
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void refreshCurveViewer() {
        this.getFaderCurveViewer().removeAllFaderCurves();
        this.getFaderCurveViewer().setOrientation(this.curveOrientation);
        FaderCurve curve = this.faderCurve;
        if (curve != null) {
            if (this.curveReverse) {
                curve = FaderCurveUtil.getReversedFaderCurve(curve);
            }
            this.getFaderCurveViewer().addFaderCurve(curve, this.curveColor);
        }
        this.getFaderCurveViewer().repaint();
    }

    protected void applyCurveType() {
        Object item;
        FaderCurve oldCurve = this.faderCurve;
        String name = "New Fader Curve";
        float cutIn = 0.0f;
        float decay = 1.0f;
        if (oldCurve != null && oldCurve instanceof AbstractFaderCurve) {
            AbstractFaderCurve afc = (AbstractFaderCurve)oldCurve;
            name = afc.getName();
            cutIn = afc.getCutIn();
            decay = afc.getDecay();
        }
        if (cutIn <= 1.0E-4f) {
            cutIn = 1.0E-4f;
        }
        if (CURVE_TYPE_LINEAR.equals(item = this.comboBoxCurveType.getSelectedItem())) {
            LinearFaderCurve newCurve = new LinearFaderCurve();
            newCurve.setName(name);
            newCurve.setCutIn(cutIn);
            newCurve.setDecay(decay);
            this.setFaderCurve(newCurve);
            return;
        }
        if (CURVE_TYPE_SHARP.equals(item)) {
            SharpFaderCurve newCurve = new SharpFaderCurve();
            newCurve.setName(name);
            newCurve.setCutIn(cutIn);
            newCurve.setDecay(decay);
            this.setFaderCurve(newCurve);
            return;
        }
        if (CURVE_TYPE_EXPONENTIAL.equals(item)) {
            ExponentialFaderCurve newCurve = new ExponentialFaderCurve();
            newCurve.setName(name);
            newCurve.setCutIn(cutIn);
            newCurve.setDecay(decay);
            this.setFaderCurve(newCurve);
            return;
        }
        if (CURVE_TYPE_COSINE1.equals(item)) {
            Cosine1FaderCurve newCurve = new Cosine1FaderCurve();
            newCurve.setName(name);
            newCurve.setCutIn(cutIn);
            newCurve.setDecay(decay);
            this.setFaderCurve(newCurve);
            return;
        }
        if (CURVE_TYPE_COSINE2.equals(item)) {
            Cosine2FaderCurve newCurve = new Cosine2FaderCurve();
            newCurve.setName(name);
            newCurve.setCutIn(cutIn);
            newCurve.setDecay(decay);
            this.setFaderCurve(newCurve);
            return;
        }
        if (CURVE_TYPE_ARRAY.equals(item)) {
            float[] array = new float[]{0.0f, 0.4f, 0.7f, 0.9f, 1.0f};
            if (oldCurve == null) {
                cutIn = 0.0f;
            }
            ArrayFaderCurve newCurve = new ArrayFaderCurve(array);
            newCurve.setName(name);
            newCurve.setCutIn(cutIn);
            newCurve.setDecay(decay);
            this.setFaderCurve(newCurve);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionExportCurve() {
        try {
            FaderCurve theCurve = this.getFaderCurve();
            if (theCurve == null) {
                return;
            }
            String curveName = null;
            if (theCurve instanceof AbstractFaderCurve) {
                AbstractFaderCurve afc = (AbstractFaderCurve)theCurve;
                curveName = afc.getName();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Formatting fader curve: " + theCurve);
            }
            String curveSpec = FaderCurveUtil.formatFaderCurve(theCurve);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Formatted fader curve: " + curveSpec);
            }
            if (curveSpec == null) {
                return;
            }
            JFileChooser chooser = new JFileChooser();
            File dataDir = Platform.getInstance().getDataDir();
            if (dataDir != null) {
                chooser.setCurrentDirectory(dataDir);
            }
            chooser.setDialogType(1);
            chooser.setDialogTitle("Export Fader Curve");
            chooser.setMultiSelectionEnabled(false);
            if (this.currentDirectory != null) {
                chooser.setCurrentDirectory(this.currentDirectory);
            }
            if (curveName != null) {
                chooser.setSelectedFile(new File(curveName + FADER_CURVE_FILE_EXTENSION));
            }
            chooser.setFileFilter(new FaderCurveFileFilter());
            int rc = chooser.showSaveDialog(this);
            if (rc != 0) {
                return;
            }
            File file = chooser.getSelectedFile();
            if (file == null) {
                return;
            }
            if (file.exists()) {
                int messageType;
                int optionType;
                String title = "Overwrite File ?";
                String message = "Are you sure to overwrite file: " + file;
                int overwrite = JOptionPane.showConfirmDialog(this, message, title, optionType = 2, messageType = 3);
                if (overwrite != 0) {
                    return;
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Writing fader curve: " + file);
            }
            this.currentDirectory = file.getParentFile();
            String lineSeparator = System.getProperty("line.separator");
            if (lineSeparator == null) {
                lineSeparator = "\n";
            }
            FileWriter fw = new FileWriter(file);
            try {
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(FADER_CURVE_HEADER);
                bw.write(lineSeparator);
                bw.write(curveSpec);
                bw.write(lineSeparator);
                bw.flush();
            }
            finally {
                fw.close();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionImportCurve() {
        try {
            JFileChooser chooser = new JFileChooser();
            File dataDir = Platform.getInstance().getDataDir();
            if (dataDir != null) {
                chooser.setCurrentDirectory(dataDir);
            }
            chooser.setDialogType(0);
            chooser.setDialogTitle("Import Fader Curve");
            chooser.setMultiSelectionEnabled(false);
            if (this.currentDirectory != null) {
                chooser.setCurrentDirectory(this.currentDirectory);
            }
            chooser.setFileFilter(new FaderCurveFileFilter());
            int rc = chooser.showOpenDialog(this);
            if (rc != 0) {
                return;
            }
            File file = chooser.getSelectedFile();
            if (file == null) {
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Reading fader curve: " + file);
            }
            this.currentDirectory = file.getParentFile();
            FileReader fr = new FileReader(file);
            try {
                BufferedReader br = new BufferedReader(fr);
                String header = br.readLine();
                if (header != null) {
                    header = header.trim();
                }
                if (!FADER_CURVE_HEADER.equals(header)) {
                    throw new StreamCorruptedException("Invalid fader curve file: " + file);
                }
                String curveSpec = br.readLine();
                if (curveSpec == null) {
                    throw new StreamCorruptedException("Invalid fader curve file: " + file);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Parsing fader curve: " + curveSpec);
                }
                FaderCurve theCurve = FaderCurveUtil.parseFaderCurve(curveSpec);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Parsed fader curve: " + theCurve);
                }
                if (theCurve == null) {
                    return;
                }
                this.setFaderCurve(theCurve);
            }
            finally {
                fr.close();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    public static class FaderCurveFileFilter
    extends FileFilter {
        @Override
        public String getDescription() {
            return "Fader Curve Files (.fcv)";
        }

        @Override
        public boolean accept(File f) {
            String lower = f.getName().toLowerCase();
            if (lower.endsWith(FaderCurveEditor.FADER_CURVE_FILE_EXTENSION)) {
                return true;
            }
            return f.isDirectory();
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            FaderCurveEditor.this.refreshCurveViewer();
        }
    }
}

