/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.fader.impl;

import com.spacekiller.util.Tools;
import com.waxmonster.fader.FaderCurve;
import com.waxmonster.fader.impl.AbstractFaderCurve;
import com.waxmonster.fader.impl.ArrayFaderCurve;
import com.waxmonster.fader.impl.Cosine1FaderCurve;
import com.waxmonster.fader.impl.Cosine2FaderCurve;
import com.waxmonster.fader.impl.ExponentialFaderCurve;
import com.waxmonster.fader.impl.LinearFaderCurve;
import com.waxmonster.fader.impl.ReverseFaderCurve;
import com.waxmonster.fader.impl.SharpFaderCurve;
import java.util.Properties;
import java.util.StringTokenizer;

public class FaderCurveUtil {
    public static final float DEFAULT_MINIMUM_CUTIN = 1.0E-4f;
    public static final float DEFAULT_CROSSFADER_DECAY = 0.49f;
    public static final float DEFAULT_LINEFADER_DECAY = 1.0f;
    public static final String DEFAULT_ARRAY_SEPARATOR = " : ";
    public static final String ARRAY_SEPARATORS = " :  ,;:/|\\\t\r\n";
    private static final Class[] CURVE_TYPES = new Class[]{LinearFaderCurve.class, SharpFaderCurve.class, Cosine1FaderCurve.class, Cosine2FaderCurve.class, ExponentialFaderCurve.class, ArrayFaderCurve.class};

    private FaderCurveUtil() {
    }

    public static final FaderCurve createDefaultFaderCurve(String name, boolean crossfader) {
        LinearFaderCurve curve = new LinearFaderCurve();
        curve.setName(name);
        curve.setCutIn(1.0E-4f);
        curve.setDecay(crossfader ? 0.49f : 1.0f);
        return curve;
    }

    public static final FaderCurve getReversedFaderCurve(FaderCurve curve) {
        if (curve == null) {
            return null;
        }
        if (curve instanceof ReverseFaderCurve) {
            ReverseFaderCurve rfc = (ReverseFaderCurve)curve;
            return rfc.getCurve();
        }
        return new ReverseFaderCurve(curve);
    }

    public static final String formatFaderCurve(FaderCurve curve) throws IllegalArgumentException {
        String typeName = curve.getClass().getName();
        int x = typeName.lastIndexOf(46);
        if (x >= 0) {
            typeName = typeName.substring(x + 1);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(typeName);
        if (curve instanceof AbstractFaderCurve) {
            AbstractFaderCurve afc = (AbstractFaderCurve)curve;
            String name = afc.getName();
            float cutIn = afc.getCutIn();
            float decay = afc.getDecay();
            sb.append("[name=");
            sb.append(String.valueOf(name));
            sb.append("]");
            sb.append("[cutIn=");
            sb.append(String.valueOf(cutIn));
            sb.append("]");
            sb.append("[decay=");
            sb.append(String.valueOf(decay));
            sb.append("]");
            if (afc instanceof ExponentialFaderCurve) {
                ExponentialFaderCurve efc = (ExponentialFaderCurve)afc;
                float exponent = efc.getExponent();
                sb.append("[exponent=");
                sb.append(String.valueOf(exponent));
                sb.append("]");
            } else if (afc instanceof ArrayFaderCurve) {
                ArrayFaderCurve arfc = (ArrayFaderCurve)afc;
                int len = arfc.getArrayLength();
                float[] arr = new float[len];
                arfc.getArrayValues(arr, 0, len);
                sb.append("[array=");
                String arrayString = FaderCurveUtil.formatFloatArray(arr, DEFAULT_ARRAY_SEPARATOR);
                sb.append(String.valueOf(arrayString));
                sb.append("]");
            }
        }
        return sb.toString();
    }

    public static final FaderCurve parseFaderCurve(String text) throws IllegalArgumentException {
        Class curveType;
        String shortType;
        if (text == null || text.length() < 1 || "null".equalsIgnoreCase(text)) {
            return null;
        }
        String type = text;
        String spec = null;
        int x = type.indexOf(91);
        if (x >= 0) {
            spec = type.substring(x + 1);
            type = type.substring(0, x);
        }
        if ((x = (shortType = type).lastIndexOf(46)) >= 0) {
            shortType = shortType.substring(x + 1);
        }
        if ((curveType = null) == null && type != null) {
            String curveTypeName;
            Class ct;
            int i;
            Class[] availCurveTypes = CURVE_TYPES;
            for (i = 0; i < availCurveTypes.length; ++i) {
                ct = availCurveTypes[i];
                if (ct == null || !(curveTypeName = ct.getName()).equalsIgnoreCase(type)) continue;
                curveType = ct;
                break;
            }
            if (curveType == null) {
                for (i = 0; i < availCurveTypes.length; ++i) {
                    ct = availCurveTypes[i];
                    if (ct == null) continue;
                    curveTypeName = ct.getName();
                    x = curveTypeName.lastIndexOf(46);
                    if (x >= 0) {
                        curveTypeName = curveTypeName.substring(x + 1);
                    }
                    if (!curveTypeName.equalsIgnoreCase(type)) continue;
                    curveType = ct;
                    break;
                }
            }
        }
        AbstractFaderCurve faderCurve = null;
        Properties curveProps = FaderCurveUtil.parseProperties(spec);
        if (curveType != null) {
            if (LinearFaderCurve.class == curveType) {
                faderCurve = new LinearFaderCurve();
            } else if (SharpFaderCurve.class == curveType) {
                faderCurve = new SharpFaderCurve();
            } else if (Cosine1FaderCurve.class == curveType) {
                faderCurve = new Cosine1FaderCurve();
            } else if (Cosine2FaderCurve.class == curveType) {
                faderCurve = new Cosine2FaderCurve();
            } else if (ExponentialFaderCurve.class == curveType) {
                String value = curveProps.getProperty("exponent");
                float exponent = 1.0f;
                if (value != null && (value = value.trim()).length() > 0) {
                    try {
                        exponent = Float.parseFloat(value);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                faderCurve = new ExponentialFaderCurve(exponent);
            } else if (ArrayFaderCurve.class == curveType) {
                float[] array = null;
                String value = curveProps.getProperty("array");
                if (value != null) {
                    array = FaderCurveUtil.parseFloatArray(value, ARRAY_SEPARATORS);
                }
                if (array != null && array.length > 0) {
                    faderCurve = new ArrayFaderCurve(array);
                }
            } else if (FaderCurve.class.isAssignableFrom(curveType)) {
                try {
                    faderCurve = (FaderCurve)Tools.newInstance((Class)curveType);
                }
                catch (Throwable e) {
                    throw new IllegalArgumentException("s");
                }
            }
        }
        if (faderCurve == null) {
            throw new IllegalArgumentException("Unsupported fader curve specification: " + text);
        }
        if (faderCurve instanceof AbstractFaderCurve) {
            AbstractFaderCurve afc = faderCurve;
            String value = curveProps.getProperty("name");
            if (value != null) {
                afc.setName(value);
            }
            if ((value = curveProps.getProperty("cutIn")) != null && (value = value.trim()).length() > 0) {
                try {
                    afc.setCutIn(Float.parseFloat(value));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ((value = curveProps.getProperty("decay")) != null && (value = value.trim()).length() > 0) {
                try {
                    afc.setDecay(Float.parseFloat(value));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return faderCurve;
    }

    protected static final Properties parseProperties(String text) {
        Properties props = new Properties();
        if (text == null) {
            return props;
        }
        StringTokenizer tok = new StringTokenizer(text, "[]", false);
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            int x = s.indexOf(61);
            if (x < 0) continue;
            String key = s.substring(0, x).trim();
            String val = s.substring(x + 1).trim();
            props.setProperty(key, val);
        }
        return props;
    }

    public static final String formatFloatArray(float[] array, String separator) {
        StringBuffer sb = new StringBuffer();
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    sb.append(separator);
                }
                sb.append(Float.toString(array[i]));
            }
        }
        return sb.toString();
    }

    public static final float[] parseFloatArray(String text, String separators) {
        int size = 0;
        float[] arr = new float[16];
        StringTokenizer tok = new StringTokenizer(text, separators, false);
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if ((s = s.trim()).length() < 1) continue;
            try {
                float value = Float.parseFloat(s);
                if (value < 0.0f) {
                    value = 0.0f;
                } else if (value > 1.0f) {
                    value = 1.0f;
                }
                if (size >= arr.length) {
                    float[] a = new float[arr.length * 2];
                    System.arraycopy(arr, 0, a, 0, size);
                    arr = a;
                }
                arr[size++] = value;
            }
            catch (NumberFormatException e) {}
        }
        float[] a = new float[size];
        System.arraycopy(arr, 0, a, 0, size);
        return a;
    }
}

