/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.fader.impl;

import com.waxmonster.fader.FaderCurve;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;

public class FaderCurveViewer
extends JComponent {
    private static final long serialVersionUID = -3715879809322575368L;
    public static final int LEFT_RIGHT = 1;
    public static final int BOTTOM_UP = 2;
    private List curves = new LinkedList();
    private List colors = new LinkedList();
    private int orientation = 1;

    public FaderCurveViewer() {
        this.setPreferredSize(new Dimension(100, 100));
    }

    public int getFaderCurveCount() {
        return this.curves.size();
    }

    public FaderCurve getFaderCurveAt(int index) {
        return (FaderCurve)this.curves.get(index);
    }

    public Color getFaderCurveColorAt(int index) {
        return (Color)this.colors.get(index);
    }

    public void addFaderCurve(FaderCurve curve, Color color) {
        if (curve != null && color != null) {
            this.curves.add(curve);
            this.colors.add(color);
        }
    }

    public void removeAllFaderCurves() {
        this.curves.clear();
        this.colors.clear();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Iterator ci = this.colors.iterator();
        Iterator i = this.curves.iterator();
        while (i.hasNext()) {
            if (!ci.hasNext()) continue;
            FaderCurve curve = (FaderCurve)i.next();
            Color color = (Color)ci.next();
            this.paintFaderCurve(curve, g, color);
        }
    }

    protected void paintFaderCurve(FaderCurve curve, Graphics g, Color color) {
        Dimension size = this.getSize();
        int w = size.width;
        int h = size.height;
        boolean horiz = this.orientation == 1;
        int n = horiz ? w : h;
        int p = horiz ? h - 1 : w - 1;
        int[] xPoints = new int[n];
        int[] yPoints = new int[n];
        block4: for (int i = 0; i < n; ++i) {
            float value = (float)i / (float)(n - 1);
            float volume = curve.getVolume(value);
            if (volume < 0.0f) {
                volume = 0.0f;
            }
            if (volume > 1.0f) {
                volume = 1.0f;
            }
            switch (this.orientation) {
                case 1: {
                    xPoints[i] = i;
                    yPoints[i] = Math.round((float)p - volume * (float)p);
                    continue block4;
                }
                case 2: {
                    xPoints[i] = Math.round(volume * (float)p);
                    yPoints[i] = i;
                }
            }
        }
        g.setColor(color);
        g.drawPolyline(xPoints, yPoints, w);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }
}

