/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.fader.impl;

import com.waxmonster.fader.Fader;
import com.waxmonster.fader.VolumeShader;

public abstract class VolumeShaderBase
implements VolumeShader {
    public static final Fader[] NO_FADERS = new Fader[0];
    protected double sampleRate;
    protected double nps;
    protected double[] buf;
    protected int ofs;
    protected int chs = 1;
    protected int mask;
    protected int queueSize;
    protected long[] evt;
    protected double[] evp;
    protected volatile int tail;
    protected Fader[] faders = NO_FADERS;
    protected double prev = -1.0;
    protected double initVolume;
    protected double volumeFactor = 1.0;

    public double getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(double sampleRate) {
        if (sampleRate < 1.0) {
            throw new IllegalArgumentException("Invalid sample rate: " + sampleRate);
        }
        this.sampleRate = sampleRate;
        this.nps = 1.0E9 / sampleRate;
    }

    public double[] getOutputBuffer() {
        return this.buf;
    }

    public void setOutputBuffer(double[] buf) {
        this.buf = buf;
    }

    public int getOutputOffset() {
        return this.ofs;
    }

    public void setOutputOffset(int ofs) {
        this.ofs = ofs;
    }

    public int getOutputChannels() {
        return this.chs;
    }

    public void setOutputChannels(int chs) {
        if (chs < 1) {
            throw new IllegalArgumentException("channels=" + chs + " < 1");
        }
        this.chs = chs;
    }

    public double getVolumeFactor() {
        return this.volumeFactor;
    }

    public void setVolumeFactor(double volumeFactor) {
        this.volumeFactor = volumeFactor;
    }

    public int getChannelMask() {
        return this.mask;
    }

    public void setChannelMask(int mask) {
        this.mask = mask;
    }

    public int getEventQueueSize() {
        return this.queueSize;
    }

    public void setEventQueueSize(int eventQueueSize) {
        if (eventQueueSize < 1) {
            throw new IllegalArgumentException("Invalid event queue size: " + eventQueueSize);
        }
        this.queueSize = eventQueueSize;
        this.evt = new long[eventQueueSize];
        this.evp = new double[eventQueueSize];
    }

    public Fader[] getFaders() {
        return this.faders;
    }

    public void setFaders(Fader[] faders) {
        if (faders == null) {
            faders = NO_FADERS;
        }
        this.faders = faders;
        this.initVolume = this.computeInitVolume(faders);
    }

    protected double computeInitVolume(Fader[] faders) {
        double vol = 1.0;
        int num = faders.length;
        for (int i = 0; i < num; ++i) {
            vol *= faders[i].getInitVolume();
        }
        return vol;
    }

    public double getInitVolume() {
        return this.initVolume;
    }

    protected double volume() {
        Fader[] arr = this.faders;
        int num = arr.length;
        double v = this.volumeFactor;
        int i = 0;
        while (i < num) {
            v *= arr[i++].volume;
        }
        return v;
    }

    public boolean move(long time) {
        double v = this.volume();
        if (v == this.prev) {
            return false;
        }
        this.prev = v;
        int idx = this.tail;
        this.evt[idx] = time;
        this.evp[idx] = v;
        this.tail = (idx + 1) % this.queueSize;
        return true;
    }
}

