/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.fader.impl;

import com.waxmonster.fader.impl.VolumeShaderBase;

public class VolumeShaderV07
extends VolumeShaderBase {
    protected int idx;
    protected long rt;
    protected double rp;
    protected double rv;
    protected double sp;
    protected double fcm;
    protected double fcs;
    protected double vol;
    protected double vel;
    protected double sdt;
    protected boolean sdi;
    protected double sdm;
    protected double sds;
    protected double sda;
    protected double mul;
    protected double div;

    public VolumeShaderV07() {
        this.setSmoothnessFactor(3.0);
        this.setForecastMillis(5.0);
        this.setSlowdownThreshold(2.0E7);
        this.setSlowdownMillis(2.0);
    }

    public double getSmoothnessFactor() {
        return this.mul;
    }

    public void setSmoothnessFactor(double factor) {
        if (factor < 1.0) {
            throw new IllegalArgumentException("Invalid smoothness factor: " + factor);
        }
        this.mul = factor;
        this.div = this.mul + 1.0;
    }

    public double getForecastMillis() {
        return this.fcm;
    }

    public void setForecastMillis(double ms) {
        if (ms < 1.0) {
            throw new IllegalArgumentException("Invalid forecast millis: " + ms);
        }
        this.fcm = ms;
        this.computeForecastSamples();
    }

    public double getSlowdownThreshold() {
        return this.sdt;
    }

    public void setSlowdownThreshold(double nanos) {
        this.sdt = nanos;
    }

    public double getSlowdownMillis() {
        return this.sdm;
    }

    public void setSlowdownMillis(double ms) {
        if (ms < 1.0) {
            throw new IllegalArgumentException("Invalid slowdown millis: " + ms);
        }
        this.sdm = ms;
        this.computeSlowdownSamples();
    }

    @Override
    public void setSampleRate(double sampleRate) {
        super.setSampleRate(sampleRate);
        this.computeForecastSamples();
        this.computeSlowdownSamples();
    }

    protected void computeForecastSamples() {
        this.fcs = this.fcm * this.sampleRate / 1000.0;
    }

    protected void computeSlowdownSamples() {
        this.sds = this.sdm * this.sampleRate / 1000.0;
    }

    public double getVolume() {
        return this.vol;
    }

    public void setVolume(double v) {
        this.vol = v;
    }

    public double getVelocity() {
        return this.vel;
    }

    public void setVelocity(double v) {
        this.vel = v;
    }

    public void reset(double v) {
        this.prev = -1.0;
        this.vel = 0.0;
        this.vol = v;
        this.rv = this.vel;
        this.rp = this.vol;
        this.sp = this.vol;
    }

    public double seek() {
        this.vel = 0.0;
        this.vol = this.volume();
        this.rv = this.vel;
        this.rp = this.vol;
        this.sp = this.vol;
        return this.vol;
    }

    public void produce(long time, int frames) {
        double ep;
        long et;
        int tail = this.tail;
        if (this.idx == tail) {
            et = Long.MAX_VALUE;
            ep = 0.0;
        } else {
            et = this.evt[this.idx];
            ep = this.evp[this.idx];
        }
        long st = time;
        int o = this.ofs;
        for (int i = 0; i < frames; ++i) {
            double dp;
            if (st < et) {
                if (this.rv != 0.0 && (this.sdi || (double)(st - this.rt) > this.sdt)) {
                    if (!this.sdi) {
                        this.sdi = true;
                        this.sda = -this.rv / this.sds;
                    }
                    this.rv += this.sda;
                    if (this.sda < 0.0 == this.rv < 0.0) {
                        this.sdi = false;
                        this.rv = this.sda > 0.0 ? -0.0 : 0.0;
                    }
                }
                dp = this.sp + this.fcs * this.rv - (this.vol + this.fcs * this.vel);
                double dv = dp / this.fcs;
                this.vel += dv / this.fcs;
                this.sp += this.rv;
            } else {
                long nt;
                this.idx = (this.idx + 1) % this.queueSize;
                while (this.idx != tail && st >= (nt = this.evt[this.idx])) {
                    et = nt;
                    ep = this.evp[this.idx];
                    this.idx = (this.idx + 1) % this.queueSize;
                }
                dp = ep - this.rp;
                long dt = et - this.rt;
                this.rv = (this.rv * this.mul + dp * this.nps / (double)dt) / this.div;
                this.sp = ep;
                this.rt = et;
                this.rp = ep;
                if (this.idx == tail) {
                    et = Long.MAX_VALUE;
                } else {
                    et = this.evt[this.idx];
                    ep = this.evp[this.idx];
                }
            }
            this.vol += this.vel;
            if (this.vol > 1.0) {
                this.vol = 1.0;
            } else if (this.vol < 0.0) {
                this.vol = 0.0;
            }
            this.buf[o] = this.vol;
            o += this.chs;
            st = (long)((double)st + this.nps);
        }
    }
}

