/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.mixtape;

import com.spacekiller.util.Execution;
import com.spacekiller.util.ExecutionManager;
import com.spacekiller.util.Platform;
import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.manager.MediaTableEntry;
import com.spacekiller.util.media.manager.MediaTableModel;
import com.spacekiller.util.media.manager.MediaTableToolContext;
import com.spacekiller.util.media.manager.MediaTableViewPanel;
import com.spacekiller.util.tooling.TAction;
import com.spacekiller.util.tooling.ToolContext;
import com.waxmonster.editor.InterpolatorRegistry;
import com.waxmonster.mixtape.MixTapeGeneratorExecution;
import com.waxmonster.mixtape.MixTapeGeneratorOptions;
import com.waxmonster.mixtape.MixTapeGeneratorPanel;
import com.waxmonster.mixtape.MixTapeProducerExecution;
import com.waxmonster.mixtape.MixTapeProducerOptions;
import com.waxmonster.mixtape.MixTapeProducerPanel;
import com.waxmonster.mixtape.WaxMonsterMixTapeGenerator;
import com.waxmonster.mixtape.WaxMonsterMixTapeProducer;
import com.waxmonster.mixtape.WaxMonsterMixTapeValidator;
import com.waxmonster.studio.DeviceInfo;
import com.waxmonster.waxlab.WaxLab;
import com.waxmonster.waxlab.impl.WaxLabDevice;
import com.waxmonster.waxlab.impl.WaxLabDeviceInfo;
import com.waxmonster.waxlab.impl.WaxLabPanel;
import com.waxmonster.waxlab.plugin.WaxLabDeviceProvider;
import java.awt.Component;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class MixTapeExtensions {
    private static final Logger logger = Logger.getLogger(MixTapeExtensions.class.getName());
    private static MixTapeGeneratorOptions lastMixTapeGeneratorOptions;
    private static MixTapeProducerOptions lastMixTapeProducerOptions;

    protected static MediaEntry[] getAudioMediaEntryArray(MediaTableModel mediaTableModel) {
        int rowCount = mediaTableModel.getRowCount();
        LinkedList<MediaEntry> mediaEntryList = new LinkedList<MediaEntry>();
        for (int i = 0; i < rowCount; ++i) {
            AudioEntry ae;
            MediaEntry me;
            MediaTableEntry mte = mediaTableModel.getEntryAt(i);
            if (mte == null || (me = mte.getMediaEntry()) == null || (ae = me.getAudioEntry()) == null) continue;
            mediaEntryList.add(me);
        }
        return mediaEntryList.toArray(new MediaEntry[mediaEntryList.size()]);
    }

    public static void showMixTapeGeneratorDialog(MediaTableToolContext context) {
        if (context == null) {
            return;
        }
        MediaTableViewPanel mediaTableViewPanel = context.getMediaTableViewPanel();
        if (mediaTableViewPanel == null) {
            return;
        }
        MediaLibrary mediaLibrary = mediaTableViewPanel.getMediaLibrary();
        if (mediaLibrary == null) {
            return;
        }
        MediaTableModel mediaTableModel = mediaTableViewPanel.getMediaTableModel();
        if (mediaTableModel == null) {
            return;
        }
        try {
            MediaEntry[] audioEntries = MixTapeExtensions.getAudioMediaEntryArray(mediaTableModel);
            if (audioEntries == null || audioEntries.length < 1) {
                return;
            }
            MixTapeGeneratorOptions generatorOptions = lastMixTapeGeneratorOptions;
            if (generatorOptions == null) {
                generatorOptions = new MixTapeGeneratorOptions();
                generatorOptions.setName("Mix Tape");
            }
            MixTapeGeneratorPanel generatorPanel = new MixTapeGeneratorPanel();
            generatorPanel.setMixTapeGeneratorOptions(generatorOptions);
            boolean perform = generatorPanel.showMixTapeGeneratorDialog((Component)mediaTableViewPanel);
            if (!perform) {
                return;
            }
            generatorOptions = generatorPanel.getMixTapeGeneratorOptions();
            if (generatorOptions == null) {
                return;
            }
            lastMixTapeGeneratorOptions = generatorOptions;
            double bpmMaximum = 300.0;
            double rmsMaximum = 1.0;
            WaxMonsterMixTapeValidator validator = new WaxMonsterMixTapeValidator(bpmMaximum, rmsMaximum);
            Random random = new Random();
            WaxMonsterMixTapeGenerator mixTapeGenerator = new WaxMonsterMixTapeGenerator(random, validator);
            MixTapeGeneratorExecution exec = new MixTapeGeneratorExecution(audioEntries, mediaTableViewPanel, generatorOptions, mixTapeGenerator);
            ExecutionManager execManager = Platform.getInstance().getExecutionManager();
            if (execManager != null) {
                execManager.addExecution((Execution)exec);
            }
            exec.start();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static void showMixTapeProducerDialog(MediaTableToolContext context) {
        if (context == null) {
            return;
        }
        MediaTableViewPanel mediaTableViewPanel = context.getMediaTableViewPanel();
        if (mediaTableViewPanel == null) {
            return;
        }
        MediaLibrary mediaLibrary = mediaTableViewPanel.getMediaLibrary();
        if (mediaLibrary == null) {
            return;
        }
        MediaTableModel mediaTableModel = mediaTableViewPanel.getMediaTableModel();
        if (mediaTableModel == null) {
            return;
        }
        try {
            MediaEntry[] audioEntries = MixTapeExtensions.getAudioMediaEntryArray(mediaTableModel);
            if (audioEntries == null || audioEntries.length < 1) {
                return;
            }
            WaxLab waxLab = MixTapeExtensions.createWaxLab();
            InterpolatorRegistry interpolatorRegistry = waxLab.getInterpolatorRegistry();
            MixTapeProducerOptions producerOptions = lastMixTapeProducerOptions;
            if (producerOptions == null) {
                producerOptions = new MixTapeProducerOptions();
            }
            SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyyMMdd'T'HHmm");
            String timeStamp = timestampFormat.format(new Date());
            String fileName = "MixTape-" + timeStamp + ".wav";
            File dataDir = Platform.getInstance().getDataDir();
            File audioOutputFile = new File(dataDir, fileName);
            producerOptions.setAudioOutputFile(audioOutputFile);
            MixTapeProducerPanel producerPanel = new MixTapeProducerPanel();
            producerPanel.setInterpolatorRegistry(interpolatorRegistry);
            producerPanel.setMixTapeProducerOptions(producerOptions);
            boolean perform = producerPanel.showMixTapeProducerDialog((Component)mediaTableViewPanel);
            if (!perform) {
                return;
            }
            producerOptions = producerPanel.getMixTapeProducerOptions();
            if (producerOptions == null) {
                return;
            }
            audioOutputFile = producerOptions.getAudioOutputFile();
            if (audioOutputFile == null) {
                return;
            }
            lastMixTapeProducerOptions = producerOptions;
            if (audioOutputFile.exists()) {
                int messageType;
                int optionType;
                String title = "Overwrite existing file ?";
                String message = "Are you sure to overwrite the existing file:\n" + audioOutputFile;
                int rc = JOptionPane.showConfirmDialog((Component)mediaTableViewPanel, message, title, optionType = 2, messageType = 2);
                if (rc != 0) {
                    return;
                }
            }
            Random random = new Random();
            WaxMonsterMixTapeProducer mixTapeProducer = new WaxMonsterMixTapeProducer(waxLab, random);
            MixTapeProducerExecution exec = new MixTapeProducerExecution(audioEntries, producerOptions, mixTapeProducer, waxLab);
            ExecutionManager execManager = Platform.getInstance().getExecutionManager();
            if (execManager != null) {
                execManager.addExecution((Execution)exec);
            }
            exec.start();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected static WaxLab createWaxLab() throws Exception {
        WaxLabDeviceProvider waxLabProvider = new WaxLabDeviceProvider();
        WaxLabDevice waxLabDevice = (WaxLabDevice)waxLabProvider.createDevice((DeviceInfo)new WaxLabDeviceInfo("WaxLabDevice", null));
        WaxLabPanel waxLabPanel = (WaxLabPanel)waxLabDevice.getCustomizer();
        return waxLabPanel.getWaxLab();
    }

    public static class MixTapeProducerAction
    extends TAction {
        public void invoke(Object instance) {
            ToolContext context = this.getToolContext(instance);
            if (context != null && context instanceof MediaTableToolContext) {
                MediaTableToolContext mttc = (MediaTableToolContext)context;
                MixTapeExtensions.showMixTapeProducerDialog(mttc);
            }
        }
    }

    public static class MixTapeGeneratorAction
    extends TAction {
        public void invoke(Object instance) {
            ToolContext context = this.getToolContext(instance);
            if (context != null && context instanceof MediaTableToolContext) {
                MediaTableToolContext mttc = (MediaTableToolContext)context;
                MixTapeExtensions.showMixTapeGeneratorDialog(mttc);
            }
        }
    }
}

