/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.mixtape;

import com.spacekiller.util.AbstractExecution;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MutableMediaCrate;
import com.spacekiller.util.media.manager.MediaManagerPanel;
import com.spacekiller.util.media.manager.MediaTableViewPanel;
import com.spacekiller.util.media.manager.MediaTreeToolContext;
import com.spacekiller.util.media.manager.MediaTreeViewPanel;
import com.waxmonster.mixtape.MixTapeGenerator;
import com.waxmonster.mixtape.MixTapeGeneratorOptions;
import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class MixTapeGeneratorExecution
extends AbstractExecution {
    private final MediaEntry[] mediaEntries;
    private final MediaTableViewPanel mediaTableViewPanel;
    private final MixTapeGeneratorOptions generatorOptions;
    private final MixTapeGenerator mixTapeGenerator;

    public MixTapeGeneratorExecution(MediaEntry[] mediaEntries, MediaTableViewPanel mediaTableViewPanel, MixTapeGeneratorOptions generatorOptions, MixTapeGenerator mixTapeGenerator) {
        this.mediaEntries = mediaEntries;
        this.mediaTableViewPanel = mediaTableViewPanel;
        this.generatorOptions = generatorOptions;
        this.mixTapeGenerator = mixTapeGenerator;
        this.setName("Mix Tape Generator");
        this.setDescription("Mix Tape Generator");
        this.setStopSupported(true);
    }

    protected void execute() throws Exception {
        final MediaCrate mixTapeCrate = this.mixTapeGenerator.generateMixTape(this.mediaEntries, this.generatorOptions);
        if (mixTapeCrate == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MediaManagerPanel mmp = MixTapeGeneratorExecution.this.mediaTableViewPanel.getMediaManagerPanel();
                MediaTreeToolContext mediaTreeToolContext = mmp.getMediaTreeToolContext();
                MediaTreeViewPanel mtvp = mediaTreeToolContext.getMediaTreeViewPanel();
                MutableMediaCrate rootCrate = mtvp.getRootCrate();
                rootCrate.addCrate(mixTapeCrate);
                mediaTreeToolContext.setSelectedCrate(mixTapeCrate);
                double startErrorRate = MixTapeGeneratorExecution.this.mixTapeGenerator.getStartErrorRate();
                double currentErrorRate = MixTapeGeneratorExecution.this.mixTapeGenerator.getCurrentErrorRate();
                String title = String.valueOf(MixTapeGeneratorExecution.this.getName());
                String message = "Generated new mix tape crate: " + mixTapeCrate.getName() + "\n\n";
                message = message + "Source error rate: " + (double)Math.round(startErrorRate * 1000.0) / 1000.0 + "\n";
                message = message + "Output error rate: " + (double)Math.round(currentErrorRate * 1000.0) / 1000.0 + "\n";
                int messageType = 1;
                JOptionPane.showMessageDialog((Component)MixTapeGeneratorExecution.this.mediaTableViewPanel, message, title, messageType);
            }
        });
    }

    public double getProgress() {
        return this.mixTapeGenerator.getProgress();
    }

    public void stop() {
        this.mixTapeGenerator.stop();
        super.stop();
    }
}

