/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.mixtape;

import com.waxmonster.mixtape.MixTapeGeneratorOptions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MixTapeGeneratorPanel
extends JPanel {
    private static final long serialVersionUID = -7869906123669032095L;
    private MixTapeGeneratorOptions mixTapeGeneratorOptions;
    private boolean refreshing;
    private JTextField textFieldName;
    private JCheckBox chckbxShuffle;
    private JCheckBox chckbxStartTempo;
    private JCheckBox chckbxEndTempo;
    private JCheckBox chckbxAppendUnusedEntries;
    private JComboBox comboBoxStartBpm;
    private JComboBox comboBoxEndBpm;
    private JSlider sliderBpmWeight;
    private JSlider sliderVolumeWeight;
    private JComboBox comboBoxIterations;
    private JComboBox comboBoxTimeout;

    public MixTapeGeneratorPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelOptions = new JPanel();
        GridBagConstraints gbc_panelOptions = new GridBagConstraints();
        gbc_panelOptions.weighty = 1.0;
        gbc_panelOptions.weightx = 1.0;
        gbc_panelOptions.fill = 1;
        gbc_panelOptions.gridx = 0;
        gbc_panelOptions.gridy = 0;
        this.add((Component)panelOptions, gbc_panelOptions);
        GridBagLayout gbl_panelOptions = new GridBagLayout();
        gbl_panelOptions.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panelOptions.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        gbl_panelOptions.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelOptions.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelOptions.setLayout(gbl_panelOptions);
        JLabel lblMixTapeName = new JLabel("Mix Tape Name:");
        GridBagConstraints gbc_lblMixTapeName = new GridBagConstraints();
        gbc_lblMixTapeName.anchor = 17;
        gbc_lblMixTapeName.insets = new Insets(4, 4, 5, 5);
        gbc_lblMixTapeName.gridx = 0;
        gbc_lblMixTapeName.gridy = 0;
        panelOptions.add((Component)lblMixTapeName, gbc_lblMixTapeName);
        this.textFieldName = new JTextField();
        GridBagConstraints gbc_textFieldName = new GridBagConstraints();
        gbc_textFieldName.gridwidth = 2;
        gbc_textFieldName.insets = new Insets(4, 4, 5, 0);
        gbc_textFieldName.fill = 1;
        gbc_textFieldName.gridx = 1;
        gbc_textFieldName.gridy = 0;
        panelOptions.add((Component)this.textFieldName, gbc_textFieldName);
        this.textFieldName.setColumns(10);
        this.chckbxShuffle = new JCheckBox("Initial Shuffle");
        this.chckbxShuffle.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MixTapeGeneratorPanel.this.refreshing) {
                    MixTapeGeneratorPanel.this.apply();
                }
            }
        });
        this.chckbxShuffle.setToolTipText("Initial shuffle entries");
        GridBagConstraints gbc_chckbxShuffle = new GridBagConstraints();
        gbc_chckbxShuffle.gridwidth = 2;
        gbc_chckbxShuffle.anchor = 17;
        gbc_chckbxShuffle.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxShuffle.gridx = 0;
        gbc_chckbxShuffle.gridy = 1;
        panelOptions.add((Component)this.chckbxShuffle, gbc_chckbxShuffle);
        this.chckbxStartTempo = new JCheckBox("Start Tempo:");
        this.chckbxStartTempo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MixTapeGeneratorPanel.this.refreshing) {
                    MixTapeGeneratorPanel.this.apply();
                }
                MixTapeGeneratorPanel.this.checkEnable();
            }
        });
        this.chckbxStartTempo.setToolTipText("Preferred start tempo (BPM)");
        GridBagConstraints gbc_chckbxStartTempo = new GridBagConstraints();
        gbc_chckbxStartTempo.anchor = 17;
        gbc_chckbxStartTempo.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxStartTempo.gridx = 0;
        gbc_chckbxStartTempo.gridy = 2;
        panelOptions.add((Component)this.chckbxStartTempo, gbc_chckbxStartTempo);
        this.comboBoxStartBpm = new JComboBox();
        this.comboBoxStartBpm.setToolTipText("Preferred start tempo (BPM)");
        this.comboBoxStartBpm.setEditable(true);
        GridBagConstraints gbc_comboBoxStartBpm = new GridBagConstraints();
        gbc_comboBoxStartBpm.weightx = 1.0;
        gbc_comboBoxStartBpm.insets = new Insets(4, 4, 5, 5);
        gbc_comboBoxStartBpm.fill = 2;
        gbc_comboBoxStartBpm.gridx = 1;
        gbc_comboBoxStartBpm.gridy = 2;
        panelOptions.add((Component)this.comboBoxStartBpm, gbc_comboBoxStartBpm);
        JLabel lblBpm = new JLabel("BPM");
        GridBagConstraints gbc_lblBpm = new GridBagConstraints();
        gbc_lblBpm.insets = new Insets(4, 4, 5, 0);
        gbc_lblBpm.gridx = 2;
        gbc_lblBpm.gridy = 2;
        panelOptions.add((Component)lblBpm, gbc_lblBpm);
        this.chckbxEndTempo = new JCheckBox("End Tempo:");
        this.chckbxEndTempo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MixTapeGeneratorPanel.this.refreshing) {
                    MixTapeGeneratorPanel.this.apply();
                }
                MixTapeGeneratorPanel.this.checkEnable();
            }
        });
        this.chckbxEndTempo.setToolTipText("Preferred end tempo (BPM)");
        GridBagConstraints gbc_chckbxEndTempo = new GridBagConstraints();
        gbc_chckbxEndTempo.anchor = 17;
        gbc_chckbxEndTempo.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxEndTempo.gridx = 0;
        gbc_chckbxEndTempo.gridy = 3;
        panelOptions.add((Component)this.chckbxEndTempo, gbc_chckbxEndTempo);
        this.comboBoxEndBpm = new JComboBox();
        this.comboBoxEndBpm.setToolTipText("Preferred end tempo (BPM)");
        this.comboBoxEndBpm.setEditable(true);
        GridBagConstraints gbc_comboBoxEndBpm = new GridBagConstraints();
        gbc_comboBoxEndBpm.weightx = 1.0;
        gbc_comboBoxEndBpm.insets = new Insets(4, 4, 5, 5);
        gbc_comboBoxEndBpm.fill = 2;
        gbc_comboBoxEndBpm.gridx = 1;
        gbc_comboBoxEndBpm.gridy = 3;
        panelOptions.add((Component)this.comboBoxEndBpm, gbc_comboBoxEndBpm);
        JLabel lblBpm_1 = new JLabel("BPM");
        GridBagConstraints gbc_lblBpm_1 = new GridBagConstraints();
        gbc_lblBpm_1.insets = new Insets(4, 4, 5, 0);
        gbc_lblBpm_1.gridx = 2;
        gbc_lblBpm_1.gridy = 3;
        panelOptions.add((Component)lblBpm_1, gbc_lblBpm_1);
        JLabel lblTempoWeight = new JLabel("Tempo Weight:");
        lblTempoWeight.setToolTipText("Tempo optimization weight");
        GridBagConstraints gbc_lblTempoWeight = new GridBagConstraints();
        gbc_lblTempoWeight.anchor = 17;
        gbc_lblTempoWeight.insets = new Insets(4, 4, 5, 5);
        gbc_lblTempoWeight.gridx = 0;
        gbc_lblTempoWeight.gridy = 4;
        panelOptions.add((Component)lblTempoWeight, gbc_lblTempoWeight);
        this.sliderBpmWeight = new JSlider();
        GridBagConstraints gbc_sliderBpmWeight = new GridBagConstraints();
        gbc_sliderBpmWeight.weightx = 1.0;
        gbc_sliderBpmWeight.fill = 2;
        gbc_sliderBpmWeight.insets = new Insets(4, 4, 5, 5);
        gbc_sliderBpmWeight.gridx = 1;
        gbc_sliderBpmWeight.gridy = 4;
        panelOptions.add((Component)this.sliderBpmWeight, gbc_sliderBpmWeight);
        JLabel lblVolumeWeight = new JLabel("Volume Weight:");
        lblVolumeWeight.setToolTipText("Volume optimization weight");
        GridBagConstraints gbc_lblVolumeWeight = new GridBagConstraints();
        gbc_lblVolumeWeight.anchor = 17;
        gbc_lblVolumeWeight.insets = new Insets(4, 4, 5, 5);
        gbc_lblVolumeWeight.gridx = 0;
        gbc_lblVolumeWeight.gridy = 5;
        panelOptions.add((Component)lblVolumeWeight, gbc_lblVolumeWeight);
        this.sliderVolumeWeight = new JSlider();
        GridBagConstraints gbc_sliderVolumeWeight = new GridBagConstraints();
        gbc_sliderVolumeWeight.weightx = 1.0;
        gbc_sliderVolumeWeight.fill = 2;
        gbc_sliderVolumeWeight.insets = new Insets(4, 4, 5, 5);
        gbc_sliderVolumeWeight.gridx = 1;
        gbc_sliderVolumeWeight.gridy = 5;
        panelOptions.add((Component)this.sliderVolumeWeight, gbc_sliderVolumeWeight);
        JLabel lblIterations = new JLabel("Opt. Iterations:");
        lblIterations.setToolTipText("Maximum optimization iterations");
        GridBagConstraints gbc_lblIterations = new GridBagConstraints();
        gbc_lblIterations.anchor = 17;
        gbc_lblIterations.insets = new Insets(4, 4, 5, 5);
        gbc_lblIterations.gridx = 0;
        gbc_lblIterations.gridy = 6;
        panelOptions.add((Component)lblIterations, gbc_lblIterations);
        this.comboBoxIterations = new JComboBox();
        this.comboBoxIterations.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MixTapeGeneratorPanel.this.refreshing) {
                    MixTapeGeneratorPanel.this.apply();
                }
            }
        });
        this.comboBoxIterations.setEditable(true);
        this.comboBoxIterations.setToolTipText("Maximum optimization iterations");
        GridBagConstraints gbc_comboBoxIterations = new GridBagConstraints();
        gbc_comboBoxIterations.insets = new Insets(4, 4, 5, 5);
        gbc_comboBoxIterations.fill = 2;
        gbc_comboBoxIterations.gridx = 1;
        gbc_comboBoxIterations.gridy = 6;
        panelOptions.add((Component)this.comboBoxIterations, gbc_comboBoxIterations);
        JLabel lblTimeout = new JLabel("Opt. Timeout:");
        lblTimeout.setToolTipText("Maximum optimization time in minutes");
        GridBagConstraints gbc_lblTimeout = new GridBagConstraints();
        gbc_lblTimeout.anchor = 17;
        gbc_lblTimeout.insets = new Insets(4, 4, 5, 5);
        gbc_lblTimeout.gridx = 0;
        gbc_lblTimeout.gridy = 7;
        panelOptions.add((Component)lblTimeout, gbc_lblTimeout);
        this.comboBoxTimeout = new JComboBox();
        this.comboBoxTimeout.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MixTapeGeneratorPanel.this.refreshing) {
                    MixTapeGeneratorPanel.this.apply();
                }
            }
        });
        this.comboBoxTimeout.setToolTipText("Maximum optimization time (minutes)");
        this.comboBoxTimeout.setEditable(true);
        GridBagConstraints gbc_comboBoxTimeout = new GridBagConstraints();
        gbc_comboBoxTimeout.insets = new Insets(4, 4, 5, 5);
        gbc_comboBoxTimeout.fill = 2;
        gbc_comboBoxTimeout.gridx = 1;
        gbc_comboBoxTimeout.gridy = 7;
        panelOptions.add((Component)this.comboBoxTimeout, gbc_comboBoxTimeout);
        JLabel lblSec = new JLabel("Min.");
        GridBagConstraints gbc_lblSec = new GridBagConstraints();
        gbc_lblSec.insets = new Insets(4, 4, 5, 0);
        gbc_lblSec.gridx = 2;
        gbc_lblSec.gridy = 7;
        panelOptions.add((Component)lblSec, gbc_lblSec);
        this.chckbxAppendUnusedEntries = new JCheckBox("Append Unused Entries");
        this.chckbxAppendUnusedEntries.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MixTapeGeneratorPanel.this.refreshing) {
                    MixTapeGeneratorPanel.this.apply();
                }
            }
        });
        this.chckbxAppendUnusedEntries.setToolTipText("Append or ignore unused entries ?");
        GridBagConstraints gbc_chckbxAppendUnusedEntries = new GridBagConstraints();
        gbc_chckbxAppendUnusedEntries.anchor = 17;
        gbc_chckbxAppendUnusedEntries.gridwidth = 2;
        gbc_chckbxAppendUnusedEntries.insets = new Insets(4, 0, 0, 5);
        gbc_chckbxAppendUnusedEntries.gridx = 0;
        gbc_chckbxAppendUnusedEntries.gridy = 8;
        panelOptions.add((Component)this.chckbxAppendUnusedEntries, gbc_chckbxAppendUnusedEntries);
        this.initMixTapeGeneratorPanel();
    }

    protected void initMixTapeGeneratorPanel() {
        this.textFieldName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!MixTapeGeneratorPanel.this.refreshing) {
                    MixTapeGeneratorPanel.this.apply();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!MixTapeGeneratorPanel.this.refreshing) {
                    MixTapeGeneratorPanel.this.apply();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!MixTapeGeneratorPanel.this.refreshing) {
                    MixTapeGeneratorPanel.this.apply();
                }
            }
        });
        this.comboBoxIterations.addItem("100");
        this.comboBoxIterations.addItem("200");
        this.comboBoxIterations.addItem("500");
        this.comboBoxTimeout.addItem("1");
        this.comboBoxTimeout.addItem("2");
        this.comboBoxTimeout.addItem("5");
        this.comboBoxTimeout.addItem("10");
        this.comboBoxTimeout.addItem("30");
        this.comboBoxTimeout.addItem("60");
    }

    public boolean showMixTapeGeneratorDialog(Component parent) {
        String title = "Mix Tape Generator";
        int optionType = 2;
        int messageType = -1;
        int rc = JOptionPane.showConfirmDialog(parent, this, title, optionType, messageType);
        return rc == 0;
    }

    public MixTapeGeneratorOptions getMixTapeGeneratorOptions() {
        return this.mixTapeGeneratorOptions;
    }

    public void setMixTapeGeneratorOptions(MixTapeGeneratorOptions mixTapeGeneratorOptions) {
        this.mixTapeGeneratorOptions = mixTapeGeneratorOptions;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        MixTapeGeneratorOptions options = this.getMixTapeGeneratorOptions();
        if (options == null) {
            return;
        }
        try {
            this.refreshing = true;
            String name = options.getName();
            if (name == null) {
                name = "New Mix Tape";
            }
            this.textFieldName.setText(name);
            this.chckbxShuffle.setSelected(options.isShuffleEntries());
            this.chckbxAppendUnusedEntries.setSelected(options.isAppendUnusedEntries());
        }
        finally {
            this.refreshing = false;
        }
        this.checkEnable();
    }

    protected void apply() {
        String sTimeout;
        MixTapeGeneratorOptions options = this.getMixTapeGeneratorOptions();
        if (options == null) {
            return;
        }
        options.setName(this.textFieldName.getText());
        options.setShuffleEntries(this.chckbxShuffle.isSelected());
        options.setAppendUnusedEntries(this.chckbxAppendUnusedEntries.isSelected());
        double startBpm = Double.NaN;
        double startBpmWeight = 0.0;
        if (this.chckbxStartTempo.isSelected()) {
            // empty if block
        }
        options.setStartBpm(startBpm);
        options.setStartBpmWheight(startBpmWeight);
        double endBpm = Double.NaN;
        double endBpmWeight = 0.0;
        if (this.chckbxEndTempo.isSelected()) {
            // empty if block
        }
        options.setEndBpm(endBpm);
        options.setEndBpmWheight(endBpmWeight);
        String sIters = String.valueOf(this.comboBoxIterations.getSelectedItem());
        if (sIters != null && (sIters = sIters.trim()).length() > 0) {
            try {
                int maxIters = Integer.parseInt(sIters);
                if (maxIters < 1) {
                    maxIters = 1;
                }
                options.setMaxIterations(maxIters);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((sTimeout = String.valueOf(this.comboBoxTimeout.getSelectedItem())) != null && (sTimeout = sTimeout.trim()).length() > 0) {
            try {
                int timeoutMillis = Integer.parseInt(sTimeout) * 60000;
                if (timeoutMillis < 1) {
                    timeoutMillis = 1;
                }
                options.setTimeoutMillis(timeoutMillis);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    protected void checkEnable() {
        this.comboBoxStartBpm.setEnabled(this.chckbxStartTempo.isSelected());
        this.comboBoxEndBpm.setEnabled(this.chckbxEndTempo.isSelected());
    }

    protected JCheckBox getChckbxShuffle() {
        return this.chckbxShuffle;
    }

    protected JCheckBox getChckbxStartTempo() {
        return this.chckbxStartTempo;
    }

    protected JCheckBox getChckbxEndTempo() {
        return this.chckbxEndTempo;
    }

    protected JCheckBox getChckbxAppendUnusedEntries() {
        return this.chckbxAppendUnusedEntries;
    }

    protected JTextField getTextFieldName() {
        return this.textFieldName;
    }

    protected JComboBox getComboBoxStartBpm() {
        return this.comboBoxStartBpm;
    }

    protected JComboBox getComboBoxEndBpm() {
        return this.comboBoxEndBpm;
    }

    protected JSlider getSliderBpmWeight() {
        return this.sliderBpmWeight;
    }

    protected JSlider getSliderVolumeWeight() {
        return this.sliderVolumeWeight;
    }

    protected JComboBox getComboBoxIterations() {
        return this.comboBoxIterations;
    }

    protected JComboBox getComboBoxTimeout() {
        return this.comboBoxTimeout;
    }
}

