/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.mixtape;

import com.spacekiller.util.AbstractExecution;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.wave.WaveAudioFile;
import com.spacekiller.util.sound.AudioFile;
import com.spacekiller.util.sound.SampleModel;
import com.spacekiller.util.sound.SoundUtil;
import com.waxmonster.mixtape.MixTapeProducer;
import com.waxmonster.mixtape.MixTapeProducerEntry;
import com.waxmonster.mixtape.MixTapeProducerOptions;
import com.waxmonster.model.impl.CachedAudioModel;
import com.waxmonster.waxlab.WaxLab;
import java.io.File;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;

public class MixTapeProducerExecution
extends AbstractExecution {
    private static final Logger logger = Logger.getLogger(MixTapeProducerExecution.class.getName());
    private final MediaEntry[] mediaEntries;
    private final MixTapeProducerOptions producerOptions;
    private final MixTapeProducer mixTapeProducer;
    private final WaxLab waxLab;

    public MixTapeProducerExecution(MediaEntry[] mediaEntries, MixTapeProducerOptions producerOptions, MixTapeProducer mixTapeProducer, WaxLab waxLab) {
        this.mediaEntries = mediaEntries;
        this.producerOptions = producerOptions;
        this.mixTapeProducer = mixTapeProducer;
        this.waxLab = waxLab;
        this.setName("Mix Tape Producer");
        this.setDescription("Mix Tape Producer");
        this.setStopSupported(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        long totalSamples;
        File targetFile = this.producerOptions.getAudioOutputFile();
        int targetChannels = this.producerOptions.getAudioChannels();
        int targetBits = this.producerOptions.getAudioBitDepth();
        float targetRate = this.producerOptions.getAudioSampleRate();
        int targetFrameSize = (targetBits + 7) / 8 * targetChannels;
        boolean bigEndian = false;
        AudioFormat.Encoding encoding = SoundUtil.PCM_SIGNED;
        AudioFormat targetAudioFormat = new AudioFormat(encoding, targetRate, targetBits, targetChannels, targetFrameSize, targetRate, bigEndian);
        MixTapeProducerEntry[] entries = this.mixTapeProducer.prepareMixTape(this.mediaEntries, this.producerOptions);
        if (entries.length < 1) {
            // empty if block
        }
        WaveAudioFile targetWaveFile = new WaveAudioFile(targetFile, targetAudioFormat);
        try {
            CachedAudioModel targetAudioModel = this.waxLab.createCachedAudioModel((AudioFile)targetWaveFile);
            try {
                totalSamples = this.mixTapeProducer.produceMixTape(entries, this.producerOptions, (SampleModel)targetAudioModel);
                targetAudioModel.flush();
            }
            finally {
                targetAudioModel.close();
            }
        }
        finally {
            targetWaveFile.close();
        }
        logger.info("Produced mix tape: " + targetFile);
        logger.info("Number of samples: " + totalSamples);
    }

    public double getProgress() {
        return this.mixTapeProducer.getProgress();
    }

    public void stop() {
        this.mixTapeProducer.cancel();
        super.stop();
    }
}

