/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.mixtape;

import com.spacekiller.util.Tools;
import com.spacekiller.util.media.control.AbstractDoubleControl;
import com.spacekiller.util.media.control.AbstractIntControl;
import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.media.control.TextFieldControlPanel;
import com.spacekiller.util.swing.FileField;
import com.waxmonster.editor.InterpolatorProvider;
import com.waxmonster.editor.InterpolatorRegistry;
import com.waxmonster.mixtape.MixTapeProducerOptions;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MixTapeProducerPanel
extends JPanel {
    private static final long serialVersionUID = -1583339597257880215L;
    private static final int[] COMMON_AUDIO_BIT_DEPTHS = new int[]{16, 24, 32};
    private static final float[] COMMON_AUDIO_FRAME_RATES = new float[]{44100.0f, 48000.0f, 88200.0f, 96000.0f};
    private InterpolatorRegistry interpolatorRegistry;
    private InterpolatorProvider[] interpolatorProviders;
    private MixTapeProducerOptions mixTapeProducerOptions;
    private boolean refreshing;
    private MinTrackControl minTrackControl = new MinTrackControl();
    private MaxTrackControl maxTrackControl = new MaxTrackControl();
    private MinPitchControl minPitchControl = new MinPitchControl();
    private MaxPitchControl maxPitchControl = new MaxPitchControl();
    private MinFadeControl minFadeControl = new MinFadeControl();
    private MaxFadeControl maxFadeControl = new MaxFadeControl();
    private InitialFadeControl initialFadeControl = new InitialFadeControl();
    private FinalFadeControl finalFadeControl = new FinalFadeControl();
    private MixBeatsControl mixBeatsControl = new MixBeatsControl();
    private TextFieldControlPanel textFieldControlPanelMinTrack;
    private TextFieldControlPanel textFieldControlPanelMaxTrack;
    private TextFieldControlPanel textFieldControlPanelMinPitch;
    private TextFieldControlPanel textFieldControlPanelMaxPitch;
    private TextFieldControlPanel textFieldControlPanelMaxFade;
    private TextFieldControlPanel textFieldControlPanelInitialFade;
    private TextFieldControlPanel textFieldControlPanelFinalFade;
    private TextFieldControlPanel textFieldControlPanelMinFade;
    private TextFieldControlPanel textFieldControlPanelMixBeats;
    private FileField fileField;
    private JComboBox comboBoxBitDepth;
    private JComboBox comboBoxSampleRate;
    private JCheckBox chckbxNormalizeTracks;
    private JComboBox comboBoxInterpolation;
    private JComboBox comboBoxResampleRate;

    public MixTapeProducerPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelProducer = new JPanel();
        GridBagConstraints gbc_panelProducer = new GridBagConstraints();
        gbc_panelProducer.weighty = 1.0;
        gbc_panelProducer.weightx = 1.0;
        gbc_panelProducer.fill = 1;
        gbc_panelProducer.gridx = 0;
        gbc_panelProducer.gridy = 0;
        this.add((Component)panelProducer, gbc_panelProducer);
        GridBagLayout gbl_panelProducer = new GridBagLayout();
        gbl_panelProducer.columnWidths = new int[]{0, 0, 0, 0, 0};
        gbl_panelProducer.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        gbl_panelProducer.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelProducer.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelProducer.setLayout(gbl_panelProducer);
        JLabel lblOutputFile = new JLabel("Audio Output File:");
        lblOutputFile.setToolTipText("Audio output file (.wav)");
        GridBagConstraints gbc_lblOutputFile = new GridBagConstraints();
        gbc_lblOutputFile.anchor = 17;
        gbc_lblOutputFile.insets = new Insets(0, 0, 5, 5);
        gbc_lblOutputFile.gridx = 0;
        gbc_lblOutputFile.gridy = 0;
        panelProducer.add((Component)lblOutputFile, gbc_lblOutputFile);
        this.fileField = new FileField();
        this.fileField.setPreferredSize(new Dimension(300, 23));
        this.fileField.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MixTapeProducerPanel.this.refreshing) {
                    MixTapeProducerPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_fileField = new GridBagConstraints();
        gbc_fileField.gridwidth = 3;
        gbc_fileField.insets = new Insets(0, 0, 5, 0);
        gbc_fileField.fill = 2;
        gbc_fileField.gridx = 1;
        gbc_fileField.gridy = 0;
        panelProducer.add((Component)this.fileField, gbc_fileField);
        JLabel lblAudioFormat = new JLabel("Audio Format:");
        lblAudioFormat.setToolTipText("Output audio format");
        GridBagConstraints gbc_lblAudioFormat = new GridBagConstraints();
        gbc_lblAudioFormat.anchor = 17;
        gbc_lblAudioFormat.insets = new Insets(0, 0, 5, 5);
        gbc_lblAudioFormat.gridx = 0;
        gbc_lblAudioFormat.gridy = 1;
        panelProducer.add((Component)lblAudioFormat, gbc_lblAudioFormat);
        JPanel panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.gridwidth = 3;
        gbc_panel.insets = new Insets(0, 0, 5, 0);
        gbc_panel.fill = 1;
        gbc_panel.gridx = 1;
        gbc_panel.gridy = 1;
        panelProducer.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0, 0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JLabel lblBitDepth = new JLabel("Bit Depth:");
        GridBagConstraints gbc_lblBitDepth = new GridBagConstraints();
        gbc_lblBitDepth.insets = new Insets(0, 0, 0, 5);
        gbc_lblBitDepth.anchor = 13;
        gbc_lblBitDepth.gridx = 0;
        gbc_lblBitDepth.gridy = 0;
        panel.add((Component)lblBitDepth, gbc_lblBitDepth);
        this.comboBoxBitDepth = new JComboBox();
        this.comboBoxBitDepth.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MixTapeProducerPanel.this.refreshing) {
                    MixTapeProducerPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_comboBoxBitDepth = new GridBagConstraints();
        gbc_comboBoxBitDepth.weightx = 1.0;
        gbc_comboBoxBitDepth.insets = new Insets(0, 0, 0, 5);
        gbc_comboBoxBitDepth.fill = 2;
        gbc_comboBoxBitDepth.gridx = 1;
        gbc_comboBoxBitDepth.gridy = 0;
        panel.add((Component)this.comboBoxBitDepth, gbc_comboBoxBitDepth);
        JLabel lblSampleRate = new JLabel("Sample Rate:");
        GridBagConstraints gbc_lblSampleRate = new GridBagConstraints();
        gbc_lblSampleRate.insets = new Insets(0, 4, 0, 5);
        gbc_lblSampleRate.gridx = 2;
        gbc_lblSampleRate.gridy = 0;
        panel.add((Component)lblSampleRate, gbc_lblSampleRate);
        this.comboBoxSampleRate = new JComboBox();
        this.comboBoxSampleRate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MixTapeProducerPanel.this.refreshing) {
                    MixTapeProducerPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_comboBoxSampleRate = new GridBagConstraints();
        gbc_comboBoxSampleRate.insets = new Insets(0, 0, 0, 5);
        gbc_comboBoxSampleRate.weightx = 1.0;
        gbc_comboBoxSampleRate.fill = 2;
        gbc_comboBoxSampleRate.gridx = 3;
        gbc_comboBoxSampleRate.gridy = 0;
        panel.add((Component)this.comboBoxSampleRate, gbc_comboBoxSampleRate);
        JLabel lblHz = new JLabel("Hz.");
        GridBagConstraints gbc_lblHz = new GridBagConstraints();
        gbc_lblHz.insets = new Insets(4, 4, 4, 4);
        gbc_lblHz.gridx = 4;
        gbc_lblHz.gridy = 0;
        panel.add((Component)lblHz, gbc_lblHz);
        this.chckbxNormalizeTracks = new JCheckBox("Normalize Tracks");
        this.chckbxNormalizeTracks.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MixTapeProducerPanel.this.refreshing) {
                    MixTapeProducerPanel.this.apply();
                }
            }
        });
        JLabel lblNormalize = new JLabel("Normalize:");
        GridBagConstraints gbc_lblNormalize = new GridBagConstraints();
        gbc_lblNormalize.anchor = 17;
        gbc_lblNormalize.insets = new Insets(0, 0, 5, 5);
        gbc_lblNormalize.gridx = 0;
        gbc_lblNormalize.gridy = 2;
        panelProducer.add((Component)lblNormalize, gbc_lblNormalize);
        this.chckbxNormalizeTracks.setToolTipText("Normalize audio tracks ?");
        GridBagConstraints gbc_chckbxNormalizeTracks = new GridBagConstraints();
        gbc_chckbxNormalizeTracks.gridwidth = 3;
        gbc_chckbxNormalizeTracks.anchor = 17;
        gbc_chckbxNormalizeTracks.insets = new Insets(0, 0, 5, 0);
        gbc_chckbxNormalizeTracks.gridx = 1;
        gbc_chckbxNormalizeTracks.gridy = 2;
        panelProducer.add((Component)this.chckbxNormalizeTracks, gbc_chckbxNormalizeTracks);
        JLabel lblResampling = new JLabel("Resampling:");
        GridBagConstraints gbc_lblResampling = new GridBagConstraints();
        gbc_lblResampling.anchor = 17;
        gbc_lblResampling.insets = new Insets(0, 0, 5, 5);
        gbc_lblResampling.gridx = 0;
        gbc_lblResampling.gridy = 3;
        panelProducer.add((Component)lblResampling, gbc_lblResampling);
        JPanel panelResampling = new JPanel();
        GridBagConstraints gbc_panelResampling = new GridBagConstraints();
        gbc_panelResampling.gridwidth = 3;
        gbc_panelResampling.insets = new Insets(0, 0, 5, 5);
        gbc_panelResampling.fill = 1;
        gbc_panelResampling.gridx = 1;
        gbc_panelResampling.gridy = 3;
        panelProducer.add((Component)panelResampling, gbc_panelResampling);
        GridBagLayout gbl_panelResampling = new GridBagLayout();
        gbl_panelResampling.columnWidths = new int[]{0, 0, 0};
        gbl_panelResampling.rowHeights = new int[]{0, 0};
        gbl_panelResampling.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelResampling.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelResampling.setLayout(gbl_panelResampling);
        this.comboBoxResampleRate = new JComboBox();
        GridBagConstraints gbc_comboBoxResampleRate = new GridBagConstraints();
        gbc_comboBoxResampleRate.insets = new Insets(0, 0, 0, 5);
        gbc_comboBoxResampleRate.anchor = 17;
        gbc_comboBoxResampleRate.gridx = 0;
        gbc_comboBoxResampleRate.gridy = 0;
        panelResampling.add((Component)this.comboBoxResampleRate, gbc_comboBoxResampleRate);
        JLabel lblHz_1 = new JLabel("Hz.");
        GridBagConstraints gbc_lblHz_1 = new GridBagConstraints();
        gbc_lblHz_1.insets = new Insets(4, 4, 4, 4);
        gbc_lblHz_1.gridx = 1;
        gbc_lblHz_1.gridy = 0;
        panelResampling.add((Component)lblHz_1, gbc_lblHz_1);
        JLabel lblInterpolation = new JLabel("Interpolation:");
        GridBagConstraints gbc_lblInterpolation = new GridBagConstraints();
        gbc_lblInterpolation.anchor = 17;
        gbc_lblInterpolation.insets = new Insets(0, 0, 5, 5);
        gbc_lblInterpolation.gridx = 0;
        gbc_lblInterpolation.gridy = 4;
        panelProducer.add((Component)lblInterpolation, gbc_lblInterpolation);
        JPanel panelInterpolation = new JPanel();
        GridBagConstraints gbc_panelInterpolation = new GridBagConstraints();
        gbc_panelInterpolation.gridwidth = 3;
        gbc_panelInterpolation.insets = new Insets(0, 0, 5, 5);
        gbc_panelInterpolation.fill = 1;
        gbc_panelInterpolation.gridx = 1;
        gbc_panelInterpolation.gridy = 4;
        panelProducer.add((Component)panelInterpolation, gbc_panelInterpolation);
        GridBagLayout gbl_panelInterpolation = new GridBagLayout();
        gbl_panelInterpolation.columnWidths = new int[]{337, 0};
        gbl_panelInterpolation.rowHeights = new int[]{25, 0};
        gbl_panelInterpolation.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelInterpolation.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelInterpolation.setLayout(gbl_panelInterpolation);
        this.comboBoxInterpolation = new JComboBox();
        this.comboBoxInterpolation.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!MixTapeProducerPanel.this.refreshing) {
                    MixTapeProducerPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_comboBoxInterpolation = new GridBagConstraints();
        gbc_comboBoxInterpolation.anchor = 17;
        gbc_comboBoxInterpolation.gridx = 0;
        gbc_comboBoxInterpolation.gridy = 0;
        panelInterpolation.add((Component)this.comboBoxInterpolation, gbc_comboBoxInterpolation);
        JLabel lblMixBeats = new JLabel("Mix Beats:");
        GridBagConstraints gbc_lblMixBeats = new GridBagConstraints();
        gbc_lblMixBeats.anchor = 17;
        gbc_lblMixBeats.insets = new Insets(0, 0, 5, 5);
        gbc_lblMixBeats.gridx = 0;
        gbc_lblMixBeats.gridy = 5;
        panelProducer.add((Component)lblMixBeats, gbc_lblMixBeats);
        this.textFieldControlPanelMixBeats = new TextFieldControlPanel();
        GridBagConstraints gbc_textFieldControlPanelMixBeats = new GridBagConstraints();
        gbc_textFieldControlPanelMixBeats.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldControlPanelMixBeats.fill = 1;
        gbc_textFieldControlPanelMixBeats.gridx = 1;
        gbc_textFieldControlPanelMixBeats.gridy = 5;
        panelProducer.add((Component)this.textFieldControlPanelMixBeats, gbc_textFieldControlPanelMixBeats);
        JLabel lblMinTrackMillis = new JLabel("Min. Track Time:");
        lblMinTrackMillis.setToolTipText("Minimum track time in seconds");
        GridBagConstraints gbc_lblMinTrackMillis = new GridBagConstraints();
        gbc_lblMinTrackMillis.anchor = 17;
        gbc_lblMinTrackMillis.insets = new Insets(0, 0, 5, 5);
        gbc_lblMinTrackMillis.gridx = 0;
        gbc_lblMinTrackMillis.gridy = 6;
        panelProducer.add((Component)lblMinTrackMillis, gbc_lblMinTrackMillis);
        this.textFieldControlPanelMinTrack = new TextFieldControlPanel();
        GridBagConstraints gbc_textFieldControlPanelMinTrack = new GridBagConstraints();
        gbc_textFieldControlPanelMinTrack.weightx = 1.0;
        gbc_textFieldControlPanelMinTrack.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldControlPanelMinTrack.fill = 1;
        gbc_textFieldControlPanelMinTrack.gridx = 1;
        gbc_textFieldControlPanelMinTrack.gridy = 6;
        panelProducer.add((Component)this.textFieldControlPanelMinTrack, gbc_textFieldControlPanelMinTrack);
        JLabel lblMaxTrackMillis = new JLabel("Max. Track Time:");
        lblMaxTrackMillis.setToolTipText("Maximum track time in seconds");
        GridBagConstraints gbc_lblMaxTrackMillis = new GridBagConstraints();
        gbc_lblMaxTrackMillis.anchor = 17;
        gbc_lblMaxTrackMillis.insets = new Insets(0, 4, 5, 5);
        gbc_lblMaxTrackMillis.gridx = 2;
        gbc_lblMaxTrackMillis.gridy = 6;
        panelProducer.add((Component)lblMaxTrackMillis, gbc_lblMaxTrackMillis);
        this.textFieldControlPanelMaxTrack = new TextFieldControlPanel();
        GridBagConstraints gbc_textFieldControlPanelMaxTrack = new GridBagConstraints();
        gbc_textFieldControlPanelMaxTrack.weightx = 1.0;
        gbc_textFieldControlPanelMaxTrack.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldControlPanelMaxTrack.fill = 1;
        gbc_textFieldControlPanelMaxTrack.gridx = 3;
        gbc_textFieldControlPanelMaxTrack.gridy = 6;
        panelProducer.add((Component)this.textFieldControlPanelMaxTrack, gbc_textFieldControlPanelMaxTrack);
        JLabel lblMinPitchMillis = new JLabel("Min. Pitch Time:");
        lblMinPitchMillis.setToolTipText("Minimum pitch time in seconds");
        GridBagConstraints gbc_lblMinPitchMillis = new GridBagConstraints();
        gbc_lblMinPitchMillis.anchor = 17;
        gbc_lblMinPitchMillis.insets = new Insets(0, 0, 5, 5);
        gbc_lblMinPitchMillis.gridx = 0;
        gbc_lblMinPitchMillis.gridy = 7;
        panelProducer.add((Component)lblMinPitchMillis, gbc_lblMinPitchMillis);
        this.textFieldControlPanelMinPitch = new TextFieldControlPanel();
        GridBagConstraints gbc_textFieldControlPanelMinPitch = new GridBagConstraints();
        gbc_textFieldControlPanelMinPitch.weightx = 1.0;
        gbc_textFieldControlPanelMinPitch.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldControlPanelMinPitch.fill = 1;
        gbc_textFieldControlPanelMinPitch.gridx = 1;
        gbc_textFieldControlPanelMinPitch.gridy = 7;
        panelProducer.add((Component)this.textFieldControlPanelMinPitch, gbc_textFieldControlPanelMinPitch);
        JLabel lblMaxPitchMillis = new JLabel("Max. Pitch Time:");
        lblMaxPitchMillis.setToolTipText("Maximum pitch time in seconds");
        GridBagConstraints gbc_lblMaxPitchMillis = new GridBagConstraints();
        gbc_lblMaxPitchMillis.anchor = 17;
        gbc_lblMaxPitchMillis.insets = new Insets(0, 4, 5, 5);
        gbc_lblMaxPitchMillis.gridx = 2;
        gbc_lblMaxPitchMillis.gridy = 7;
        panelProducer.add((Component)lblMaxPitchMillis, gbc_lblMaxPitchMillis);
        this.textFieldControlPanelMaxPitch = new TextFieldControlPanel();
        GridBagConstraints gbc_textFieldControlPanelMaxPitch = new GridBagConstraints();
        gbc_textFieldControlPanelMaxPitch.weightx = 1.0;
        gbc_textFieldControlPanelMaxPitch.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldControlPanelMaxPitch.fill = 1;
        gbc_textFieldControlPanelMaxPitch.gridx = 3;
        gbc_textFieldControlPanelMaxPitch.gridy = 7;
        panelProducer.add((Component)this.textFieldControlPanelMaxPitch, gbc_textFieldControlPanelMaxPitch);
        JLabel lblMinFadeMillis = new JLabel("Min. Fade Time:");
        lblMinFadeMillis.setToolTipText("Minimum fade time in seconds");
        GridBagConstraints gbc_lblMinFadeMillis = new GridBagConstraints();
        gbc_lblMinFadeMillis.anchor = 17;
        gbc_lblMinFadeMillis.insets = new Insets(0, 0, 5, 5);
        gbc_lblMinFadeMillis.gridx = 0;
        gbc_lblMinFadeMillis.gridy = 8;
        panelProducer.add((Component)lblMinFadeMillis, gbc_lblMinFadeMillis);
        this.textFieldControlPanelMinFade = new TextFieldControlPanel();
        GridBagConstraints gbc_textFieldControlPanelMinFade = new GridBagConstraints();
        gbc_textFieldControlPanelMinFade.weightx = 1.0;
        gbc_textFieldControlPanelMinFade.insets = new Insets(0, 0, 5, 5);
        gbc_textFieldControlPanelMinFade.fill = 1;
        gbc_textFieldControlPanelMinFade.gridx = 1;
        gbc_textFieldControlPanelMinFade.gridy = 8;
        panelProducer.add((Component)this.textFieldControlPanelMinFade, gbc_textFieldControlPanelMinFade);
        JLabel lblMaxFadeMillis = new JLabel("Max. Fade Time:");
        lblMaxFadeMillis.setToolTipText("Maximum fade time in seconds");
        GridBagConstraints gbc_lblMaxFadeMillis = new GridBagConstraints();
        gbc_lblMaxFadeMillis.anchor = 17;
        gbc_lblMaxFadeMillis.insets = new Insets(0, 4, 5, 5);
        gbc_lblMaxFadeMillis.gridx = 2;
        gbc_lblMaxFadeMillis.gridy = 8;
        panelProducer.add((Component)lblMaxFadeMillis, gbc_lblMaxFadeMillis);
        this.textFieldControlPanelMaxFade = new TextFieldControlPanel();
        GridBagConstraints gbc_textFieldControlPanelMaxFade = new GridBagConstraints();
        gbc_textFieldControlPanelMaxFade.weightx = 1.0;
        gbc_textFieldControlPanelMaxFade.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldControlPanelMaxFade.fill = 1;
        gbc_textFieldControlPanelMaxFade.gridx = 3;
        gbc_textFieldControlPanelMaxFade.gridy = 8;
        panelProducer.add((Component)this.textFieldControlPanelMaxFade, gbc_textFieldControlPanelMaxFade);
        JLabel lblInitialFadeMillis = new JLabel("Initial Fade-In Time:");
        lblInitialFadeMillis.setToolTipText("Initial fade-in time in seconds");
        GridBagConstraints gbc_lblInitialFadeMillis = new GridBagConstraints();
        gbc_lblInitialFadeMillis.anchor = 17;
        gbc_lblInitialFadeMillis.insets = new Insets(0, 0, 0, 5);
        gbc_lblInitialFadeMillis.gridx = 0;
        gbc_lblInitialFadeMillis.gridy = 9;
        panelProducer.add((Component)lblInitialFadeMillis, gbc_lblInitialFadeMillis);
        this.textFieldControlPanelInitialFade = new TextFieldControlPanel();
        GridBagConstraints gbc_textFieldControlPanelInitialFade = new GridBagConstraints();
        gbc_textFieldControlPanelInitialFade.weightx = 1.0;
        gbc_textFieldControlPanelInitialFade.insets = new Insets(0, 0, 0, 5);
        gbc_textFieldControlPanelInitialFade.fill = 1;
        gbc_textFieldControlPanelInitialFade.gridx = 1;
        gbc_textFieldControlPanelInitialFade.gridy = 9;
        panelProducer.add((Component)this.textFieldControlPanelInitialFade, gbc_textFieldControlPanelInitialFade);
        JLabel lblFinalFadeMillis = new JLabel("Final Fade-Out Time:");
        lblFinalFadeMillis.setToolTipText("Final fade-out time in seconds");
        GridBagConstraints gbc_lblFinalFadeMillis = new GridBagConstraints();
        gbc_lblFinalFadeMillis.anchor = 17;
        gbc_lblFinalFadeMillis.insets = new Insets(0, 4, 0, 5);
        gbc_lblFinalFadeMillis.gridx = 2;
        gbc_lblFinalFadeMillis.gridy = 9;
        panelProducer.add((Component)lblFinalFadeMillis, gbc_lblFinalFadeMillis);
        this.textFieldControlPanelFinalFade = new TextFieldControlPanel();
        GridBagConstraints gbc_textFieldControlPanelFinalFade = new GridBagConstraints();
        gbc_textFieldControlPanelFinalFade.weightx = 1.0;
        gbc_textFieldControlPanelFinalFade.fill = 1;
        gbc_textFieldControlPanelFinalFade.gridx = 3;
        gbc_textFieldControlPanelFinalFade.gridy = 9;
        panelProducer.add((Component)this.textFieldControlPanelFinalFade, gbc_textFieldControlPanelFinalFade);
        this.initMixTapeProducerPanel();
    }

    public boolean showMixTapeProducerDialog(Component parent) {
        String title = "Mix Tape Producer";
        int optionType = 2;
        int messageType = -1;
        Icon icon = Tools.getIcon(this.getClass(), (String)"/com/waxmonster/mixtape/icons/mixtape_icon32.png");
        int rc = JOptionPane.showConfirmDialog(parent, this, title, optionType, messageType, icon);
        return rc == 0;
    }

    protected void initMixTapeProducerPanel() {
        this.textFieldControlPanelMinTrack.setControl((Control)this.minTrackControl);
        this.textFieldControlPanelMaxTrack.setControl((Control)this.maxTrackControl);
        this.textFieldControlPanelMinPitch.setControl((Control)this.minPitchControl);
        this.textFieldControlPanelMaxPitch.setControl((Control)this.maxPitchControl);
        this.textFieldControlPanelMinFade.setControl((Control)this.minFadeControl);
        this.textFieldControlPanelMaxFade.setControl((Control)this.maxFadeControl);
        this.textFieldControlPanelInitialFade.setControl((Control)this.initialFadeControl);
        this.textFieldControlPanelFinalFade.setControl((Control)this.finalFadeControl);
        this.textFieldControlPanelMixBeats.setControl((Control)this.mixBeatsControl);
    }

    public MixTapeProducerOptions getMixTapeProducerOptions() {
        return this.mixTapeProducerOptions;
    }

    public void setMixTapeProducerOptions(MixTapeProducerOptions mixTapeProducerOptions) {
        this.mixTapeProducerOptions = mixTapeProducerOptions;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        MixTapeProducerOptions options = this.getMixTapeProducerOptions();
        if (options == null) {
            return;
        }
        try {
            this.refreshing = true;
            this.getFileField().setFile(options.getAudioOutputFile());
            int bitDepth = options.getAudioBitDepth();
            int selBitDepthIndex = -1;
            this.comboBoxBitDepth.removeAllItems();
            for (int i = 0; i < COMMON_AUDIO_BIT_DEPTHS.length; ++i) {
                if (bitDepth == COMMON_AUDIO_BIT_DEPTHS[i]) {
                    selBitDepthIndex = i;
                }
                this.comboBoxBitDepth.addItem(Integer.toString(COMMON_AUDIO_BIT_DEPTHS[i]));
            }
            if (selBitDepthIndex < 0) {
                selBitDepthIndex = this.comboBoxBitDepth.getItemCount();
                this.comboBoxBitDepth.addItem(Integer.toString(bitDepth));
            }
            this.comboBoxBitDepth.setSelectedIndex(selBitDepthIndex);
            float sampleRate = options.getAudioSampleRate();
            int selSampleRateIndex = -1;
            this.comboBoxSampleRate.removeAllItems();
            for (int i = 0; i < COMMON_AUDIO_FRAME_RATES.length; ++i) {
                String sRate;
                if (sampleRate == COMMON_AUDIO_FRAME_RATES[i]) {
                    selSampleRateIndex = i;
                }
                if ((sRate = Float.toString(COMMON_AUDIO_FRAME_RATES[i])).endsWith(".0")) {
                    sRate = sRate.substring(0, sRate.length() - 2);
                }
                this.comboBoxSampleRate.addItem(sRate);
            }
            if (selSampleRateIndex < 0) {
                selSampleRateIndex = this.comboBoxSampleRate.getItemCount();
                this.comboBoxSampleRate.addItem(Float.toString(sampleRate));
            }
            this.comboBoxSampleRate.setSelectedIndex(selSampleRateIndex);
            this.chckbxNormalizeTracks.setSelected(options.isNormalizeTracks());
            float resampleRate = options.getResampleRate();
            int selResampleRateIndex = -1;
            this.comboBoxResampleRate.removeAllItems();
            for (int i = 0; i < COMMON_AUDIO_FRAME_RATES.length; ++i) {
                String sRate;
                if (resampleRate == COMMON_AUDIO_FRAME_RATES[i]) {
                    selResampleRateIndex = i;
                }
                if ((sRate = Float.toString(COMMON_AUDIO_FRAME_RATES[i])).endsWith(".0")) {
                    sRate = sRate.substring(0, sRate.length() - 2);
                }
                this.comboBoxResampleRate.addItem(sRate);
            }
            if (selResampleRateIndex < 0) {
                selResampleRateIndex = this.comboBoxSampleRate.getItemCount();
                this.comboBoxResampleRate.addItem(Float.toString(resampleRate));
            }
            this.comboBoxResampleRate.setSelectedIndex(selResampleRateIndex);
            String interpolation = options.getInterpolation();
            int selInterpolation = -1;
            this.comboBoxInterpolation.removeAllItems();
            if (this.interpolatorRegistry != null) {
                InterpolatorProvider[] providers = this.interpolatorRegistry.getInterpolatorProviders();
                this.interpolatorProviders = providers;
                if (providers != null) {
                    for (int i = 0; i < providers.length; ++i) {
                        this.comboBoxInterpolation.addItem(providers[i].getTitle());
                        if (interpolation == null || !interpolation.equals(providers[i].getName())) continue;
                        selInterpolation = i;
                    }
                }
            }
            this.comboBoxInterpolation.setSelectedIndex(selInterpolation);
            this.minTrackControl.setDouble(options.getMinTrackMillis() / 1000.0);
            this.maxTrackControl.setDouble(options.getMaxTrackMillis() / 1000.0);
            this.minPitchControl.setDouble(options.getMinPitchMillis() / 1000.0);
            this.maxPitchControl.setDouble(options.getMaxPitchMillis() / 1000.0);
            this.minFadeControl.setDouble(options.getMinFadeMillis() / 1000.0);
            this.maxFadeControl.setDouble(options.getMaxFadeMillis() / 1000.0);
            this.initialFadeControl.setDouble(options.getInitialFadeMillis() / 1000.0);
            this.finalFadeControl.setDouble(options.getFinalFadeMillis() / 1000.0);
            this.mixBeatsControl.setInt(options.getMixBeats());
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void apply() {
        Object item;
        if (this.mixTapeProducerOptions == null) {
            return;
        }
        this.mixTapeProducerOptions.setAudioOutputFile(this.getFileField().getFile());
        this.mixTapeProducerOptions.setNormalizeTracks(this.chckbxNormalizeTracks.isSelected());
        String interpolation = null;
        int interIndex = this.comboBoxInterpolation.getSelectedIndex();
        if (interIndex >= 0 && this.interpolatorProviders != null && interIndex < this.interpolatorProviders.length) {
            interpolation = this.interpolatorProviders[interIndex].getName();
        }
        this.mixTapeProducerOptions.setInterpolation(interpolation);
        try {
            item = this.comboBoxBitDepth.getSelectedItem();
            int bitDepth = Integer.parseInt(String.valueOf(item).trim());
            if (bitDepth > 0) {
                this.mixTapeProducerOptions.setAudioBitDepth(bitDepth);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            item = this.comboBoxSampleRate.getSelectedItem();
            float sampleRate = Float.parseFloat(String.valueOf(item).trim());
            if (sampleRate > 0.0f) {
                this.mixTapeProducerOptions.setAudioSampleRate(sampleRate);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            item = this.comboBoxResampleRate.getSelectedItem();
            float resampleRate = Float.parseFloat(String.valueOf(item).trim());
            if (resampleRate > 0.0f) {
                this.mixTapeProducerOptions.setResampleRate(resampleRate);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected TextFieldControlPanel getTextFieldControlPanelMinTrack() {
        return this.textFieldControlPanelMinTrack;
    }

    protected TextFieldControlPanel getTextFieldControlPanelMaxTrack() {
        return this.textFieldControlPanelMaxTrack;
    }

    protected TextFieldControlPanel getTextFieldControlPanelMinPitch() {
        return this.textFieldControlPanelMinPitch;
    }

    protected TextFieldControlPanel getTextFieldControlPanelMaxPitch() {
        return this.textFieldControlPanelMaxPitch;
    }

    protected TextFieldControlPanel getTextFieldControlPanelMaxFade() {
        return this.textFieldControlPanelMaxFade;
    }

    protected TextFieldControlPanel getTextFieldControlPanelInitialFade() {
        return this.textFieldControlPanelInitialFade;
    }

    protected TextFieldControlPanel getTextFieldControlPanelFinalFade() {
        return this.textFieldControlPanelFinalFade;
    }

    protected TextFieldControlPanel getTextFieldControlPanelMinFade() {
        return this.textFieldControlPanelMinFade;
    }

    protected FileField getFileField() {
        return this.fileField;
    }

    protected JComboBox getComboBoxBitDepth() {
        return this.comboBoxBitDepth;
    }

    protected JComboBox getComboBoxSampleRate() {
        return this.comboBoxSampleRate;
    }

    protected JCheckBox getChckbxNormalizeTracks() {
        return this.chckbxNormalizeTracks;
    }

    public InterpolatorRegistry getInterpolatorRegistry() {
        return this.interpolatorRegistry;
    }

    public void setInterpolatorRegistry(InterpolatorRegistry interpolatorRegistry) {
        this.interpolatorRegistry = interpolatorRegistry;
        this.refresh();
    }

    protected JComboBox getComboBoxInterpolation() {
        return this.comboBoxInterpolation;
    }

    protected TextFieldControlPanel getTextFieldControlPanelMixBeats() {
        return this.textFieldControlPanelMixBeats;
    }

    protected JComboBox getComboBoxResampleRate() {
        return this.comboBoxResampleRate;
    }

    protected class MixBeatsControl
    extends AbstractIntControl {
        public MixBeatsControl() {
            this.setMinimum(1);
            this.setMaximum(32);
        }

        protected void applyInt(int v) {
            if (MixTapeProducerPanel.this.mixTapeProducerOptions != null && !MixTapeProducerPanel.this.refreshing) {
                MixTapeProducerPanel.this.mixTapeProducerOptions.setMixBeats(v);
            }
        }
    }

    protected class FinalFadeControl
    extends AbstractProducerControl {
        protected FinalFadeControl() {
        }

        protected void applyDouble(double v) {
            if (MixTapeProducerPanel.this.mixTapeProducerOptions != null && !MixTapeProducerPanel.this.refreshing) {
                MixTapeProducerPanel.this.mixTapeProducerOptions.setFinalFadeMillis(v * 1000.0);
            }
        }
    }

    protected class InitialFadeControl
    extends AbstractProducerControl {
        protected InitialFadeControl() {
        }

        protected void applyDouble(double v) {
            if (MixTapeProducerPanel.this.mixTapeProducerOptions != null && !MixTapeProducerPanel.this.refreshing) {
                MixTapeProducerPanel.this.mixTapeProducerOptions.setInitialFadeMillis(v * 1000.0);
            }
        }
    }

    protected class MaxFadeControl
    extends AbstractProducerControl {
        protected MaxFadeControl() {
        }

        protected void applyDouble(double v) {
            if (MixTapeProducerPanel.this.mixTapeProducerOptions != null && !MixTapeProducerPanel.this.refreshing) {
                MixTapeProducerPanel.this.mixTapeProducerOptions.setMaxFadeMillis(v * 1000.0);
            }
        }
    }

    protected class MinFadeControl
    extends AbstractProducerControl {
        protected MinFadeControl() {
        }

        protected void applyDouble(double v) {
            if (MixTapeProducerPanel.this.mixTapeProducerOptions != null && !MixTapeProducerPanel.this.refreshing) {
                MixTapeProducerPanel.this.mixTapeProducerOptions.setMinFadeMillis(v * 1000.0);
            }
        }
    }

    protected class MaxPitchControl
    extends AbstractProducerControl {
        protected MaxPitchControl() {
        }

        protected void applyDouble(double v) {
            if (MixTapeProducerPanel.this.mixTapeProducerOptions != null && !MixTapeProducerPanel.this.refreshing) {
                MixTapeProducerPanel.this.mixTapeProducerOptions.setMaxPitchMillis(v * 1000.0);
            }
        }
    }

    protected class MinPitchControl
    extends AbstractProducerControl {
        protected MinPitchControl() {
        }

        protected void applyDouble(double v) {
            if (MixTapeProducerPanel.this.mixTapeProducerOptions != null && !MixTapeProducerPanel.this.refreshing) {
                MixTapeProducerPanel.this.mixTapeProducerOptions.setMinPitchMillis(v * 1000.0);
            }
        }
    }

    protected class MaxTrackControl
    extends AbstractProducerControl {
        protected MaxTrackControl() {
        }

        protected void applyDouble(double v) {
            if (MixTapeProducerPanel.this.mixTapeProducerOptions != null && !MixTapeProducerPanel.this.refreshing) {
                MixTapeProducerPanel.this.mixTapeProducerOptions.setMaxTrackMillis(v * 1000.0);
            }
        }
    }

    protected class MinTrackControl
    extends AbstractProducerControl {
        protected MinTrackControl() {
        }

        protected void applyDouble(double v) {
            if (MixTapeProducerPanel.this.mixTapeProducerOptions != null && !MixTapeProducerPanel.this.refreshing) {
                MixTapeProducerPanel.this.mixTapeProducerOptions.setMinTrackMillis(v * 1000.0);
            }
        }
    }

    protected abstract class AbstractProducerControl
    extends AbstractDoubleControl {
        public AbstractProducerControl() {
            this.setMinimum(0.0);
            this.setMaximum(1000000.0);
        }
    }
}

