/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.mixtape;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.DefaultMediaCrate;
import com.spacekiller.util.media.DefaultMediaCrateEntry;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.MediaEntry;
import com.waxmonster.mixtape.MixTapeGenerator;
import com.waxmonster.mixtape.MixTapeGeneratorOptions;
import com.waxmonster.mixtape.MixTapeValidator;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WaxMonsterMixTapeGenerator
implements MixTapeGenerator {
    private static final Logger logger = Logger.getLogger(WaxMonsterMixTapeGenerator.class.getName());
    private final Random random;
    private final MixTapeValidator validator;
    private volatile boolean stop;
    private volatile double progress;
    private volatile double startErrorRate;
    private volatile double currentErrorRate;

    public WaxMonsterMixTapeGenerator(Random random, MixTapeValidator validator) {
        this.random = random;
        this.validator = validator;
    }

    @Override
    public void stop() {
        this.stop = true;
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    @Override
    public double getStartErrorRate() {
        return this.startErrorRate;
    }

    @Override
    public double getCurrentErrorRate() {
        return this.currentErrorRate;
    }

    @Override
    public MediaCrate generateMixTape(MediaEntry[] entries, MixTapeGeneratorOptions options) {
        MediaEntry me2;
        this.stop = false;
        this.progress = 0.0;
        this.startErrorRate = Double.NaN;
        this.currentErrorRate = Double.NaN;
        int maxIterations = options.getMaxIterations();
        long timeoutMillis = options.getTimeoutMillis();
        if (options.isShuffleEntries() && this.random != null) {
            this.shuffleArray(entries, this.random);
        }
        LinkedList<MediaEntry> validEntries = new LinkedList<MediaEntry>();
        LinkedList<MediaEntry> unusedEntries = new LinkedList<MediaEntry>();
        for (MediaEntry me2 : entries) {
            AudioEntry ae;
            if (me2 == null) continue;
            boolean valid = true;
            double duration = me2.getDuration();
            if (Double.isNaN(duration) || duration <= 0.0) {
                valid = false;
            }
            if ((ae = me2.getAudioEntry()) == null) {
                valid = false;
            } else {
                double rms;
                double bpm = ae.getBpm();
                if (Double.isNaN(bpm) || bpm <= 0.0) {
                    valid = false;
                }
                if (Double.isNaN(rms = ae.getRms()) || rms <= 0.0) {
                    valid = false;
                }
            }
            if (valid) {
                validEntries.add(me2);
                continue;
            }
            unusedEntries.add(me2);
        }
        int validCount = validEntries.size();
        MediaEntry[] arr = new MediaEntry[validCount];
        for (int i = 0; i < validCount; ++i) {
            arr[i] = me2 = (MediaEntry)validEntries.get(i);
        }
        int iteration = 0;
        long totalMoveCount = 0L;
        if (this.validator != null) {
            double err;
            this.startErrorRate = err = this.validator.validate(arr, options);
            this.currentErrorRate = err;
            if (logger.isLoggable(Level.INFO)) {
                logger.info("generateMixTape: Initial error rate=" + err);
            }
            int lastIndex = validCount - 1;
            long startTime = System.currentTimeMillis();
            boolean[] done = new boolean[validCount];
            double maxProgress = maxIterations * validCount;
            while (iteration < maxIterations && !this.stop) {
                double iterProgress = (double)iteration * (double)validCount;
                int moveCount = 0;
                Arrays.fill(done, false);
                for (int i = 0; i < validCount; ++i) {
                    this.progress = (iterProgress + (double)i) / maxProgress;
                    if (this.stop) break;
                    if (done[i]) continue;
                    me2 = arr[i];
                    int bestIndex = i;
                    double bestError = err;
                    if (i > 0) {
                        System.arraycopy(arr, 0, arr, 1, i);
                        arr[0] = me2;
                    }
                    for (int k = 0; k < lastIndex; ++k) {
                        double err2 = this.validator.validate(arr, options);
                        if (err2 < bestError) {
                            bestIndex = k;
                            bestError = err2;
                        }
                        arr[k] = arr[k + 1];
                        arr[k + 1] = me2;
                    }
                    if (bestIndex != lastIndex) {
                        System.arraycopy(arr, bestIndex, arr, bestIndex + 1, lastIndex - bestIndex);
                        arr[bestIndex] = me2;
                    }
                    if (bestIndex == i) continue;
                    if (bestIndex < i) {
                        System.arraycopy(done, bestIndex, done, bestIndex + 1, i - bestIndex);
                        --i;
                    }
                    done[bestIndex] = true;
                    err = bestError;
                    ++moveCount;
                    this.currentErrorRate = err;
                }
                long ms = System.currentTimeMillis() - startTime;
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("generateMixTape: iteration=" + iteration + ", elapsed=" + ms + ", moves=" + moveCount + ", error=" + (double)Math.round(err * 10000.0) / 10000.0);
                }
                if (ms > timeoutMillis) {
                    logger.info("generateMixTape: timeout: " + ms + " > " + timeoutMillis);
                    break;
                }
                if (moveCount <= 0) break;
                totalMoveCount += (long)moveCount;
                ++iteration;
            }
            long endTime = System.currentTimeMillis();
            long totalTime = endTime - startTime;
            if (logger.isLoggable(Level.INFO)) {
                logger.info("generateMixTape: Final error rate=" + err + " (" + totalMoveCount + " moves in " + totalTime + " ms.");
            }
        }
        this.progress = 1.0;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("generateMixTape: validEntries=" + validEntries.size() + ", unusedEntries=" + unusedEntries.size() + ", iterations=" + iteration + " / " + maxIterations);
        }
        String crateId = null;
        String crateName = options.getName();
        DefaultMediaCrate mixTapeCrate = new DefaultMediaCrate(crateId, crateName);
        for (int i = 0; i < validCount; ++i) {
            Resource resource;
            me2 = arr[i];
            Resource resource2 = resource = me2 == null ? null : me2.getResource();
            if (resource == null) continue;
            mixTapeCrate.addEntry((MediaCrateEntry)new DefaultMediaCrateEntry((MediaCrate)mixTapeCrate, resource));
        }
        if (options.isAppendUnusedEntries()) {
            // empty if block
        }
        return mixTapeCrate;
    }

    protected void shuffleArray(Object[] arr, Random random) {
        int num = arr.length;
        for (int i = 0; i < num; ++i) {
            int r = i + random.nextInt(num - i);
            if (r == i) continue;
            Object o = arr[i];
            arr[i] = arr[r];
            arr[r] = o;
        }
    }
}

