/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.mixtape;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaMarker;
import com.spacekiller.util.sound.DoubleArraySampleModel;
import com.spacekiller.util.sound.SampleModel;
import com.waxmonster.editor.FaderMove;
import com.waxmonster.editor.ScratchEditorModel;
import com.waxmonster.editor.WaxEditorItem;
import com.waxmonster.editor.impl.DefaultFaderMove;
import com.waxmonster.editor.impl.DefaultScratchEditorModel;
import com.waxmonster.editor.impl.DefaultWaxEditorItem;
import com.waxmonster.editor.impl.DefaultWaxEditorModel;
import com.waxmonster.mixtape.MixTapeProducer;
import com.waxmonster.mixtape.MixTapeProducerEntry;
import com.waxmonster.mixtape.MixTapeProducerOptions;
import com.waxmonster.model.LineChunk;
import com.waxmonster.waxlab.EditorLine;
import com.waxmonster.waxlab.EditorLineConfig;
import com.waxmonster.waxlab.WaxLab;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.UnsupportedAudioFileException;

public class WaxMonsterMixTapeProducer
implements MixTapeProducer {
    private static final Logger logger = Logger.getLogger(WaxMonsterMixTapeProducer.class.getName());
    protected static final double MIN_TIME_OFFSET = 0.001;
    private final WaxLab waxLab;
    private final Random random;
    private volatile boolean cancel;
    private volatile double progress;

    public WaxMonsterMixTapeProducer(WaxLab waxLab, Random random) {
        this.waxLab = waxLab;
        this.random = random;
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    @Override
    public MixTapeProducerEntry[] prepareMixTape(MediaEntry[] entries, MixTapeProducerOptions options) throws IOException {
        double minTrackMillis = options.getMinTrackMillis();
        double maxTrackMillis = options.getMaxTrackMillis();
        double minPitchMillis = options.getMinPitchMillis();
        double maxPitchMillis = options.getMaxPitchMillis();
        double minFadeMillis = options.getMinFadeMillis();
        double maxFadeMillis = options.getMaxFadeMillis();
        double initFadeMillis = options.getInitialFadeMillis();
        double finalFadeMillis = options.getFinalFadeMillis();
        boolean useMediaMarkers = options.isUseMediaMarkers();
        boolean useFirstCuePoint = options.isUseFirstCuePoint();
        boolean useLastCuePoint = options.isUseLastCuePoint();
        int mixBeats = options.getMixBeats();
        int num = entries.length;
        logger.info("Checking " + num + " mix tape entries...");
        ArrayList<MixTapeProducerEntry> entryList = new ArrayList<MixTapeProducerEntry>();
        for (int i = 0; i < num; ++i) {
            double trackMillis;
            double maxMillis;
            MediaMarker[] markers;
            AudioEntry ae;
            MediaEntry me = entries[i];
            if (me == null || (ae = me.getAudioEntry()) == null) continue;
            Resource resource = me.getResource();
            File file = null;
            if (resource != null && resource.isFile()) {
                file = resource.getFile();
            }
            if (file == null) {
                logger.warning("Invalid file resource: " + resource);
                continue;
            }
            double duration = me.getDuration();
            if (duration < 0.0) {
                logger.warning("Missing duration info for resource: " + me.getResource());
                continue;
            }
            double bpm = ae.getBpm();
            if (bpm <= 0.0) {
                logger.warning("Missing BPM info for resource: " + me.getResource());
                continue;
            }
            double startTime = 0.0;
            double endTime = duration * 1000.0;
            if (useMediaMarkers && (markers = me.getMarkers()) != null && markers.length > 0) {
                double d = this.getStartTime(markers, useFirstCuePoint);
                if (d >= 0.0 && d < endTime) {
                    startTime = d;
                }
                if ((d = this.getEndTime(markers, useLastCuePoint)) >= 0.0 && d < endTime && d > startTime && d >= startTime + minTrackMillis) {
                    endTime = d;
                }
            }
            if ((maxMillis = endTime - startTime) > maxTrackMillis) {
                maxMillis = maxTrackMillis;
            }
            if ((trackMillis = minTrackMillis + (maxMillis - minTrackMillis) * this.random.nextDouble()) > maxMillis) {
                trackMillis = maxMillis;
            }
            if (bpm > 0.0) {
                double beatMillis = WaxMonsterMixTapeProducer.millisPerBeat(bpm);
                long maxBeats = (long)(maxMillis / beatMillis);
                if ((maxBeats = maxBeats / (long)mixBeats * (long)mixBeats) > 0L) {
                    long trackBeats = (long)(trackMillis / beatMillis);
                    if ((trackBeats = trackBeats / (long)mixBeats * (long)mixBeats) < maxBeats) {
                        double trackMillis1 = (double)trackBeats * beatMillis;
                        long trackBeats2 = trackBeats + (long)mixBeats;
                        double trackMillis2 = (double)trackBeats2 * beatMillis;
                        if (trackMillis2 <= maxMillis && (trackBeats < 1L || Math.abs(trackMillis - trackMillis2) < Math.abs(trackMillis - trackMillis1))) {
                            trackBeats = trackBeats2;
                        }
                    }
                    if (trackBeats > 0L && (trackMillis = (double)trackBeats * beatMillis) > maxMillis) {
                        trackMillis = maxMillis;
                    }
                }
            }
            endTime = startTime + trackMillis;
            double startBpm = bpm;
            double endBpm = bpm;
            logger.info(" - Checked mix tape entry #" + i + ": startTime=" + startTime + ", trackMillis=" + trackMillis + ", startBpm=" + startBpm + ", endBpm=" + endBpm);
            MixTapeProducerEntry entry = new MixTapeProducerEntry(me);
            entry.setStartBpm(startBpm);
            entry.setEndBpm(endBpm);
            entry.setStartTime(startTime);
            entry.setEndTime(endTime);
            entryList.add(entry);
        }
        num = entryList.size();
        logger.info("Preparing " + num + " mix tape entries...");
        MixTapeProducerEntry[] entryArray = entryList.toArray(new MixTapeProducerEntry[num]);
        double totalMixTapeMillis = 0.0;
        for (int i = 0; i < num; ++i) {
            double fadeOutMillis;
            double randomPitchOutMillis;
            MixTapeProducerEntry entry = (MixTapeProducerEntry)entryList.get(i);
            double startTime = entry.getStartTime();
            double endTime = entry.getEndTime();
            double trackMillis = endTime - startTime;
            if (trackMillis < 0.0) {
                throw new IllegalStateException("Invalid trackMillis: " + trackMillis + ", startTime=" + startTime + ", endTime=" + endTime);
            }
            double startBpm = entry.getStartBpm();
            double endBpm = entry.getEndBpm();
            double startBpmMillis = WaxMonsterMixTapeProducer.millisPerBeat(startBpm);
            double endBpmMillis = WaxMonsterMixTapeProducer.millisPerBeat(endBpm);
            MixTapeProducerEntry prevEntry = null;
            double prevBpm = startBpm;
            double pitchInMillis = 0.0;
            double fadeInMillis = 0.0;
            if (i > 0) {
                prevEntry = (MixTapeProducerEntry)entryList.get(i - 1);
                prevBpm = prevEntry.getEndBpm();
                if (prevBpm <= 0.0) {
                    prevBpm = startBpm;
                }
                pitchInMillis = prevEntry.getPitchOutMillis();
                fadeInMillis = prevEntry.getFadeOutMillis();
            }
            MixTapeProducerEntry nextEntry = null;
            double nextBpm = endBpm;
            if (i + 1 < num && (nextBpm = (nextEntry = (MixTapeProducerEntry)entryList.get(i + 1)).getStartBpm()) <= 0.0) {
                nextBpm = endBpm;
            }
            double prevBpmMillis = WaxMonsterMixTapeProducer.millisPerBeat(prevBpm);
            double nextBpmMillis = WaxMonsterMixTapeProducer.millisPerBeat(nextBpm);
            double pitchInFactor = (startBpmMillis + prevBpmMillis) / 2.0 / prevBpmMillis;
            double pitchOutFactor = (endBpmMillis + nextBpmMillis) / 2.0 / nextBpmMillis;
            double pitchInNeedle = pitchInMillis * pitchInFactor;
            if (pitchInNeedle > trackMillis) {
                throw new IllegalStateException("Invalid pitchInNeedle: " + pitchInNeedle + " > " + trackMillis + " [pitchInMillis=" + pitchInMillis + ", pitchInFactor=" + pitchInFactor + "]");
            }
            double maxPitchOutNeedle = trackMillis - pitchInNeedle;
            maxPitchOutNeedle -= 1.0;
            double maxNextPitchInMillis = 0.0;
            if (nextEntry != null) {
                double nextPitchInFactor = (nextBpmMillis + endBpmMillis) / 2.0 / endBpmMillis;
                maxNextPitchInMillis = (nextEntry.getEndTime() - nextEntry.getStartTime()) / 2.0 / nextPitchInFactor;
                if ((maxNextPitchInMillis -= 1.0) < 0.0) {
                    maxNextPitchInMillis = 0.0;
                }
            }
            if (maxPitchOutNeedle > maxNextPitchInMillis) {
                maxPitchOutNeedle = maxNextPitchInMillis;
            }
            if ((randomPitchOutMillis = minPitchMillis + (maxPitchMillis - minPitchMillis) * this.random.nextDouble()) > maxPitchOutNeedle) {
                randomPitchOutMillis = maxPitchOutNeedle;
            }
            long randomPitchOutBeats = (long)(randomPitchOutMillis / endBpmMillis);
            if ((randomPitchOutBeats = randomPitchOutBeats / (long)mixBeats * (long)mixBeats) < 0L) {
                randomPitchOutBeats = 0L;
            }
            double randomPitchOutMillis1 = (double)randomPitchOutBeats * endBpmMillis;
            long randomPitchOutBeats2 = randomPitchOutBeats + (long)mixBeats;
            double randomPitchOutMillis2 = (double)randomPitchOutBeats2 * endBpmMillis;
            if (randomPitchOutMillis2 <= maxPitchOutNeedle && (randomPitchOutBeats < 1L || Math.abs(randomPitchOutMillis2 - randomPitchOutMillis) < Math.abs(randomPitchOutMillis1 - randomPitchOutMillis))) {
                randomPitchOutBeats = randomPitchOutBeats2;
            }
            long pitchOutBeats = randomPitchOutBeats;
            double pitchOutNeedle = (double)pitchOutBeats * endBpmMillis;
            double pitchOutMillis = pitchOutNeedle / pitchOutFactor;
            double trackNormalMillis = trackMillis - pitchInNeedle - pitchOutNeedle;
            if (trackNormalMillis < 0.0) {
                throw new IllegalStateException("Invalid trackNormalMillis: " + trackNormalMillis + ", trackMillis=" + trackMillis + ", pitchInNeedle=" + pitchInNeedle + ", pitchOutNeedle=" + pitchOutNeedle);
            }
            double trackPlayTime = pitchInNeedle + trackNormalMillis + pitchOutNeedle;
            double halfPlayTime = trackPlayTime / 2.0;
            if (i == 0) {
                fadeInMillis = initFadeMillis;
            }
            if (fadeInMillis > halfPlayTime) {
                fadeInMillis = halfPlayTime;
            }
            if ((fadeOutMillis = pitchOutMillis) > pitchOutMillis) {
                fadeOutMillis = pitchOutMillis;
            }
            if (i + 1 == num) {
                fadeOutMillis = finalFadeMillis;
            }
            if (fadeOutMillis > halfPlayTime) {
                fadeOutMillis = halfPlayTime;
            }
            entry.setPrevBpm(prevBpm);
            entry.setNextBpm(nextBpm);
            entry.setPitchInMillis(pitchInMillis);
            entry.setPitchInNeedle(pitchInNeedle);
            entry.setPitchOutMillis(pitchOutMillis);
            entry.setPitchOutNeedle(pitchOutNeedle);
            entry.setFadeInMillis(fadeInMillis);
            entry.setFadeOutMillis(fadeOutMillis);
            totalMixTapeMillis += trackNormalMillis + pitchOutNeedle;
        }
        logger.info("Prepared " + num + " mix tape entries: total=" + Math.round(totalMixTapeMillis) + " ms.");
        return entryArray;
    }

    protected double getStartTime(MediaMarker[] markers, boolean useFirstCuePoint) {
        double startTime = -1.0;
        for (MediaMarker marker : markers) {
            double pos;
            if (marker == null) continue;
            int type = marker.getType();
            if (type == 1) {
                return marker.getPosition();
            }
            if ((!useFirstCuePoint || type != 3) && type != 9 || !((pos = marker.getPosition()) < startTime) && !(startTime < 0.0)) continue;
            startTime = pos;
        }
        return startTime;
    }

    protected double getEndTime(MediaMarker[] markers, boolean useLastCuePoint) {
        double endTime = -1.0;
        for (MediaMarker marker : markers) {
            double pos;
            if (marker == null) continue;
            int type = marker.getType();
            if (type == 2) {
                return marker.getPosition();
            }
            if ((!useLastCuePoint || type != 3) && type != 9 || !((pos = marker.getPosition()) > endTime)) continue;
            endTime = pos;
        }
        return endTime;
    }

    @Override
    public long produceMixTape(MixTapeProducerEntry[] entries, MixTapeProducerOptions options, SampleModel targetModel) throws IOException, UnsupportedAudioFileException {
        this.cancel = false;
        this.progress = 0.0;
        boolean normalizeTracks = options.isNormalizeTracks();
        String interpolation = options.getInterpolation();
        if (interpolation == null) {
            interpolation = "HermiteSpline";
        }
        double leadInMillis = 10000.0;
        double leadOutMillis = 10000.0;
        float resampleRate = options.getResampleRate();
        int num = entries.length;
        logger.info("Mixing " + num + " entries using " + interpolation + " interpolation and resample rate " + resampleRate + " Hz.");
        float targetFrameRate = targetModel.getFrameRate();
        int targetChannels = targetModel.getChannels();
        long totalSamples = 0L;
        EditorLineConfig editorLineConfig = new EditorLineConfig();
        editorLineConfig.setPlaybackEnabled(true);
        editorLineConfig.setResampleRate(resampleRate);
        DoubleArraySampleModel prevAudioModel = null;
        int prevAudioModelSamples = 0;
        int prevAudioModelIndex = 0;
        int bufferFrames = (int)targetFrameRate;
        for (int i = 0; i < num && !this.cancel; ++i) {
            int normalSamples;
            int tempIndex;
            int mixSamples;
            double v;
            double o;
            double partTime;
            double nextBpm;
            this.progress = (double)i / (double)num;
            MixTapeProducerEntry entry = entries[i];
            double startTime = entry.getStartTime();
            double endTime = entry.getEndTime();
            double startBpm = entry.getStartBpm();
            double endBpm = entry.getEndBpm();
            double prevBpm = entry.getPrevBpm();
            if (prevBpm <= 0.0) {
                prevBpm = startBpm;
            }
            if ((nextBpm = entry.getNextBpm()) <= 0.0) {
                nextBpm = endBpm;
            }
            double fadeInMillis = entry.getFadeInMillis();
            double fadeOutMillis = entry.getFadeOutMillis();
            double pitchInMillis = entry.getPitchInMillis();
            double pitchInNeedle = entry.getPitchInNeedle();
            double pitchOutMillis = entry.getPitchOutMillis();
            double pitchOutNeedle = entry.getPitchOutNeedle();
            double normalMillis = endTime - startTime - pitchInNeedle - pitchOutNeedle;
            double playTime = pitchInMillis + normalMillis + pitchOutMillis;
            MediaEntry me = entry.getMediaEntry();
            Resource resource = me.getResource();
            double startBpmMillis = WaxMonsterMixTapeProducer.millisPerBeat(startBpm);
            double endBpmMillis = WaxMonsterMixTapeProducer.millisPerBeat(endBpm);
            double prevBpmMillis = WaxMonsterMixTapeProducer.millisPerBeat(prevBpm);
            double nextBpmMillis = WaxMonsterMixTapeProducer.millisPerBeat(nextBpm);
            logger.info("Mixing entry #" + i + " -------------------------------------------------");
            logger.info("Mixing resource=" + resource + ", prevBpm=" + prevBpm + ", startBpm=" + startBpm + ", endBpm=" + endBpm + ", nextBpm=" + nextBpm);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Processing track: playTime=" + playTime + ", startTime=" + startTime + ", endTime=" + endTime + ", normalMillis=" + normalMillis);
            }
            DefaultScratchEditorModel scratchEditorModel = new DefaultScratchEditorModel();
            if (leadInMillis > 0.001) {
                double leadInTempo = startBpmMillis / prevBpmMillis;
                double halfLeadInMillis = leadInMillis / 2.0;
                for (partTime = 0.001; partTime < halfLeadInMillis; partTime *= 2.0) {
                    o = leadInMillis - partTime;
                    v = startTime - partTime * leadInTempo;
                    scratchEditorModel.putTimecodePoint(o, v);
                }
            }
            scratchEditorModel.putTimecodePoint(leadInMillis, startTime);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Playback start point: " + leadInMillis + ", " + startTime);
            }
            if (pitchInMillis > 0.0) {
                o = leadInMillis + pitchInMillis;
                v = startTime + pitchInNeedle;
                scratchEditorModel.putTimecodePoint(o, v);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Pitch-In end point: " + o + ", " + v);
                }
            }
            if (normalMillis > 0.0) {
                double halfTime = normalMillis / 2.0;
                for (partTime = 0.001; partTime < halfTime; partTime *= 2.0) {
                    o = leadInMillis + pitchInMillis + partTime;
                    v = startTime + pitchInNeedle + partTime;
                    scratchEditorModel.putTimecodePoint(o, v);
                    o = leadInMillis + pitchInMillis + normalMillis - partTime;
                    v = startTime + pitchInNeedle + normalMillis - partTime;
                    scratchEditorModel.putTimecodePoint(o, v);
                }
                o = leadInMillis + pitchInMillis + normalMillis;
                v = startTime + pitchInNeedle + normalMillis;
                scratchEditorModel.putTimecodePoint(o, v);
            }
            if (pitchOutMillis > 0.0) {
                o = leadInMillis + playTime;
                v = endTime;
                scratchEditorModel.putTimecodePoint(o, v);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Pitch-Out start point: " + o + ", " + v);
                }
            }
            if (leadOutMillis > 0.001) {
                double leadOutTempo = endBpmMillis / nextBpmMillis;
                for (partTime = 0.001; partTime < leadOutMillis; partTime *= 2.0) {
                    o = leadInMillis + playTime + partTime;
                    v = endTime + partTime * leadOutTempo;
                    scratchEditorModel.putTimecodePoint(o, v);
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("leadInMillis=" + leadInMillis + ", pitchInMillis=" + pitchInMillis + ", normalMillis=" + normalMillis + ", pitchOutMillis=" + pitchOutMillis + ", leadOutMillis=" + leadOutMillis);
            }
            if (leadInMillis > 0.001) {
                scratchEditorModel.putFaderMove(0.001, (FaderMove)new DefaultFaderMove(0.001, 0.0f));
                scratchEditorModel.putFaderMove(leadInMillis, (FaderMove)new DefaultFaderMove(fadeInMillis, 1.0f));
            } else {
                scratchEditorModel.putFaderMove(0.001, (FaderMove)new DefaultFaderMove(fadeInMillis, 1.0f));
            }
            if (fadeOutMillis > 0.0) {
                o = leadInMillis + playTime - fadeOutMillis;
                scratchEditorModel.putFaderMove(o, (FaderMove)new DefaultFaderMove(fadeOutMillis, 0.0f));
            }
            DefaultWaxEditorItem waxEditorItem = new DefaultWaxEditorItem((ScratchEditorModel)scratchEditorModel);
            waxEditorItem.setEditable(true);
            waxEditorItem.setAutoConnect(false);
            waxEditorItem.setStartTime(0.0);
            waxEditorItem.setStartValue(0.0);
            DefaultWaxEditorModel waxEditorModel = new DefaultWaxEditorModel();
            waxEditorModel.setName("MixTapeEntry#" + i);
            waxEditorModel.setEditable(true);
            waxEditorModel.setDefaultInterpolation(interpolation);
            waxEditorModel.addItem((WaxEditorItem)waxEditorItem);
            EditorLine editorLine = this.waxLab.createEditorLine();
            editorLine.setName("MixTapeEntry#" + i);
            editorLine.setEditorLineConfig(editorLineConfig);
            editorLine.setScratchResource(resource, me);
            editorLine.getMutableChunkModel().addChunk((LineChunk)waxEditorModel);
            double lineStartTime = leadInMillis;
            double lineEndTime = lineStartTime + playTime;
            scratchEditorModel.checkConsistency();
            long expectedFrames = 1L + (long)(playTime * (double)targetFrameRate / 1000.0);
            double[] tempArray = new double[(int)expectedFrames * targetChannels];
            DoubleArraySampleModel tempAudioModel = new DoubleArraySampleModel(targetChannels, targetFrameRate, tempArray, 0);
            long lineOfs = (long)Math.floor(lineStartTime * 1000000.0);
            long lineEnd = (long)Math.ceil(lineEndTime * 1000000.0);
            long samples = this.waxLab.exportEditorLineToAudioModel(editorLine, lineOfs, lineEnd, bufferFrames, (SampleModel)tempAudioModel);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Exported editor line: time=" + playTime + ", samples=" + samples);
            }
            int tempSamples = (int)tempAudioModel.getSamples();
            if (normalizeTracks) {
                double min = 0.0;
                double max = 0.0;
                for (int k = 0; k < tempSamples; ++k) {
                    double val = tempAudioModel.getDouble((long)k);
                    if (val < min) {
                        min = val;
                        continue;
                    }
                    if (!(val > max)) continue;
                    max = val;
                }
                double fact = 1.0 / Math.max(Math.abs(min), Math.abs(max));
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Normalizing track: factor=" + fact);
                }
                if (fact != 1.0) {
                    for (int k = 0; k < tempSamples; ++k) {
                        tempAudioModel.set((long)k, fact * tempAudioModel.getDouble((long)k));
                    }
                }
            }
            if ((mixSamples = prevAudioModelSamples - prevAudioModelIndex) > tempSamples) {
                mixSamples = tempSamples;
            }
            if ((mixSamples = mixSamples / targetChannels * targetChannels) > 0) {
                double[] mixArray = new double[mixSamples];
                for (int k = 0; k < mixSamples; ++k) {
                    mixArray[k] = tempAudioModel.getDouble((long)k) + prevAudioModel.getDouble((long)prevAudioModelIndex++);
                }
                targetModel.append(mixArray, 0, mixSamples);
                totalSamples += (long)mixSamples;
            }
            if ((tempIndex = targetChannels * (int)((playTime - pitchOutMillis) * (double)targetFrameRate / 1000.0)) < mixSamples) {
                tempIndex = mixSamples;
            }
            if ((normalSamples = tempIndex - mixSamples) > 0) {
                double[] normArray = new double[normalSamples];
                tempAudioModel.get((long)mixSamples, normArray, 0, normalSamples);
                targetModel.append(normArray, 0, normalSamples);
                totalSamples += (long)normalSamples;
            }
            prevAudioModel = tempAudioModel;
            prevAudioModelSamples = tempSamples;
            prevAudioModelIndex = tempIndex;
        }
        int restSamples = prevAudioModelSamples - prevAudioModelIndex;
        if (restSamples > 0) {
            double[] restArray = new double[restSamples];
            prevAudioModel.get((long)prevAudioModelIndex, restArray, 0, restSamples);
            targetModel.append(restArray, 0, restSamples);
            totalSamples += (long)restSamples;
        }
        this.progress = 1.0;
        return totalSamples;
    }

    private static double millisPerBeat(double bpm) {
        return 60000.0 / bpm;
    }
}

