/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.mixtape;

import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.MediaEntry;
import com.waxmonster.mixtape.MixTapeGeneratorOptions;
import com.waxmonster.mixtape.MixTapeValidator;

public class WaxMonsterMixTapeValidator
implements MixTapeValidator {
    private final double bpmMaximum;
    private final double rmsMaximum;

    public WaxMonsterMixTapeValidator(double bpmMaximum, double rmsMaximum) {
        this.bpmMaximum = bpmMaximum;
        this.rmsMaximum = rmsMaximum;
    }

    @Override
    public double validate(MediaEntry[] entries, MixTapeGeneratorOptions options) {
        double endRmsError;
        double startRmsError;
        double endBpmError;
        double startBpmError;
        int count = entries.length;
        if (count < 1) {
            return Double.NaN;
        }
        double bpmDiffError = 0.0;
        double bpmMax = this.bpmMaximum;
        double firstBpm = this.getBpm(entries[0]);
        double lastBpm = this.getBpm(entries[count - 1]);
        double bpmWeight = options.getBpmWheight();
        if (bpmWeight > 0.0) {
            double prevBpm = firstBpm;
            double bpmDiff = 0.0;
            for (int i = 1; i < count; ++i) {
                double bpm = this.getBpm(entries[i]);
                bpmDiff += this.computeError(prevBpm, bpm, bpmMax);
                prevBpm = bpm;
            }
            bpmDiffError = options.getBpmWheight() * bpmDiff / (double)count;
        }
        double bpmStartError = 0.0;
        double startBpm = options.getStartBpm();
        if (startBpm > 0.0 && (startBpmError = this.computeError(startBpm, firstBpm, bpmMax) * options.getStartBpmWheight() / bpmMax) > 0.0) {
            bpmStartError = startBpmError;
        }
        double bpmEndError = 0.0;
        double endBpm = options.getEndBpm();
        if (endBpm > 0.0 && (endBpmError = this.computeError(lastBpm, endBpm, bpmMax) * options.getEndBpmWheight() / bpmMax) > 0.0) {
            bpmEndError = endBpmError;
        }
        double rmsDiffError = 0.0;
        double rmsMax = this.rmsMaximum;
        double firstRms = this.getRms(entries[0]);
        double lastRms = this.getRms(entries[count - 1]);
        double rmsWeight = options.getRmsWheight();
        if (rmsWeight > 0.0) {
            double prevRms = firstRms;
            double rmsDiff = 0.0;
            for (int i = 1; i < count; ++i) {
                double rms = this.getRms(entries[i]);
                rmsDiff += this.computeError(prevRms, rms, rmsMax);
                prevRms = rms;
            }
            rmsDiffError = options.getRmsWheight() * rmsDiff / (double)count;
        }
        double rmsStartError = 0.0;
        double startRms = options.getStartRms();
        if (startRms > 0.0 && (startRmsError = this.computeError(startRms, firstRms, rmsMax) * options.getStartRmsWheight() / rmsMax) > 0.0) {
            rmsStartError = startRmsError;
        }
        double rmsEndError = 0.0;
        double endRms = options.getEndRms();
        if (endRms > 0.0 && (endRmsError = this.computeError(lastRms, endRms, rmsMax) * options.getEndRmsWheight() / rmsMax) > 0.0) {
            rmsEndError = endRmsError;
        }
        double totalError = bpmDiffError + bpmStartError + bpmEndError + rmsDiffError + rmsStartError + rmsEndError;
        return totalError;
    }

    protected double getBpm(MediaEntry me) {
        AudioEntry ae;
        if (me != null && (ae = me.getAudioEntry()) != null) {
            return ae.getBpm();
        }
        return Double.NaN;
    }

    protected double getRms(MediaEntry me) {
        AudioEntry ae;
        if (me != null && (ae = me.getAudioEntry()) != null) {
            return ae.getRms();
        }
        return Double.NaN;
    }

    protected double computeError(double a, double b, double maximum) {
        if (a > 0.0 && b > 0.0) {
            double x = Math.abs(b - a);
            if (x <= 0.0) {
                return 0.0;
            }
            if (x < maximum) {
                return x;
            }
        }
        return maximum;
    }
}

