/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.media.manager;

import com.spacekiller.util.media.MediaPlayer;
import com.spacekiller.util.media.manager.MediaManagerPanel;
import com.spacekiller.util.media.manager.MediaManagerPlugin;
import com.spacekiller.util.media.manager.MediaManagerToolContext;
import com.spacekiller.util.media.manager.MediaManagerView;
import com.spacekiller.util.media.manager.MediaManagerViewProvider;
import com.spacekiller.util.media.manager.MediaTableToolContext;
import com.spacekiller.util.workbench.View;
import com.waxmonster.media.manager.MediaManagerDevicePanel;
import com.waxmonster.midi.AbstractMidiAction;
import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.MidiException;
import com.waxmonster.midi.MidiInputPort;
import com.waxmonster.midi.MidiInputPortType;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiOutputPort;
import com.waxmonster.midi.MidiOutputPortType;
import com.waxmonster.midi.MidiPort;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.MidiSupport;
import com.waxmonster.midi.MidiSyncGroup;
import com.waxmonster.midi.common.AbstractButtonMidiAction;
import com.waxmonster.midi.common.MidiActionProcessor;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class MediaManagerDevice
extends Device {
    private static final Logger logger = Logger.getLogger(MediaManagerDevice.class.getName());
    public static final String KEY_MIDI_MAPPING_PREFIX = "midiMapping.";
    public static final String KEY_MIDI_MAPPING_COUNT = "midiMappingCount";
    public static final String MIDI_ACTION_CURSOR_PREV = "CursorPrev";
    public static final String MIDI_ACTION_CURSOR_NEXT = "CursorNext";
    public static final String MIDI_ACTION_CURSOR_MOVE = "CursorMove";
    public static final String MIDI_ACTION_CURSOR_PUSH = "CursorPush";
    public static final String MIDI_ACTION_CURSOR_BACK = "CursorBack";
    public static final String MIDI_ACTION_SWITCH_PLAYER_PREFIX = "SwitchPlayer-";
    private static final int MOVE_PREV = -1;
    private static final int MOVE_NEXT = 1;
    private final MidiSupportImpl midiSupport = new MidiSupportImpl();
    private final CursorPrevMidiAction cursorPrevMidiAction = new CursorPrevMidiAction();
    private final CursorNextMidiAction cursorNextMidiAction = new CursorNextMidiAction();
    private final CursorMoveMidiAction cursorMoveMidiAction = new CursorMoveMidiAction();
    private final CursorPushMidiAction cursorPushMidiAction = new CursorPushMidiAction();
    private final CursorBackMidiAction cursorBackMidiAction = new CursorBackMidiAction();
    private final PushMediaCursor pushMediaCursor = new PushMediaCursor();
    private final BackMediaCursor backMediaCursor = new BackMediaCursor();
    private MidiInputPort midiInputPort;
    private MidiOutputPort midiOutputPort;
    private MidiAction[] midiActions;
    private MidiMapping[] midiActionMappings;
    private MediaManagerViewProvider mediaManagerViewProvider;
    private MediaManagerView mediaManagerView;
    private MediaManagerPanel mediaManagerPanel;
    private MediaManagerDevicePanel mediaManagerDevicePanel;

    public MediaManagerDevice(DeviceProvider provider, String name, Icon iconColor16) throws StudioException {
        super(provider, name);
        this.setIconColor16(iconColor16);
        this.midiInputPort = new MidiInputPort("MIDI-In", MidiInputPortType.TYPE, (MidiSupport)this.midiSupport);
        this.midiOutputPort = new MidiOutputPort("MIDI-Out", MidiOutputPortType.TYPE, (MidiSupport)this.midiSupport);
        this.initMidiActions();
        this.refreshPorts();
    }

    protected void activate() throws StudioException {
    }

    protected void deactivate() throws StudioException {
    }

    public synchronized Component getCustomizer() {
        return this.getMediaManagerDevicePanel();
    }

    public synchronized Properties getProperties() {
        MidiMapping[] midiActionMappings;
        Properties props = super.getProperties();
        MediaManagerView view = this.getMediaManagerView();
        if (view != null) {
            try {
                File baseDirectory = null;
                Studio studio = this.getStudio();
                if (studio != null) {
                    baseDirectory = studio.getDirectory();
                }
                view.saveMediaManagerView(props, baseDirectory);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        int num = (midiActionMappings = this.getMidiActionMappings()) == null ? 0 : midiActionMappings.length;
        props.put(KEY_MIDI_MAPPING_COUNT, String.valueOf(num));
        for (int i = 0; i < num; ++i) {
            MidiMapping mam = midiActionMappings[i];
            if (mam == null) continue;
            String key = KEY_MIDI_MAPPING_PREFIX + String.valueOf(1000 + i).substring(1);
            String value = mam.toString();
            props.put(key, value);
        }
        return props;
    }

    public synchronized void setProperties(Properties newProperties) {
        TreeMap<String, MidiMapping> newMidiMappings = new TreeMap<String, MidiMapping>();
        int midiMappingCount = 0;
        String midiMappingCountValue = newProperties.getProperty(KEY_MIDI_MAPPING_COUNT);
        if (midiMappingCountValue != null) {
            try {
                midiMappingCount = Integer.parseInt(midiMappingCountValue.trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        for (Map.Entry<Object, Object> me : newProperties.entrySet()) {
            String key = String.valueOf(me.getKey());
            if (!key.startsWith(KEY_MIDI_MAPPING_PREFIX)) continue;
            try {
                String value;
                MidiMapping mapping;
                int index = Integer.parseInt(key.substring(KEY_MIDI_MAPPING_PREFIX.length()));
                if (index < 0 || index >= midiMappingCount || (mapping = MidiMapping.parseMidiMapping((String)(value = String.valueOf(me.getValue())))) == null) continue;
                newMidiMappings.put(key, mapping);
            }
            catch (NumberFormatException e) {}
        }
        this.setMidiActionMappings(newMidiMappings.values().toArray(new MidiMapping[newMidiMappings.size()]));
        super.setProperties(newProperties);
        MediaManagerView view = this.getMediaManagerView();
        if (view != null) {
            try {
                File baseDirectory = null;
                Studio studio = this.getStudio();
                if (studio != null) {
                    baseDirectory = studio.getDirectory();
                }
                view.loadMediaManagerView(newProperties, baseDirectory);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected void applyProperty(String key, String value) {
    }

    public MediaManagerViewProvider getMediaManagerViewProvider() {
        if (this.mediaManagerViewProvider == null) {
            try {
                this.setMediaManagerViewProvider(this.lookupMediaManagerViewProvider());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return this.mediaManagerViewProvider;
    }

    protected void setMediaManagerViewProvider(MediaManagerViewProvider mediaManagerViewProvider) {
        this.mediaManagerViewProvider = mediaManagerViewProvider;
    }

    protected MediaManagerViewProvider lookupMediaManagerViewProvider() throws Exception {
        MediaManagerPlugin plugin = MediaManagerPlugin.getInstance();
        return plugin.getMediaManagerViewProvider();
    }

    public MediaManagerView getMediaManagerView() {
        if (this.mediaManagerView == null) {
            try {
                this.setMediaManagerView(this.createMediaManagerView());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return this.mediaManagerView;
    }

    protected void setMediaManagerView(MediaManagerView mediaManagerView) {
        this.mediaManagerView = mediaManagerView;
    }

    protected MediaManagerView createMediaManagerView() throws Exception {
        MediaManagerViewProvider provider = this.getMediaManagerViewProvider();
        if (provider == null) {
            return null;
        }
        View view = provider.createView();
        if (view != null && view instanceof MediaManagerView) {
            return (MediaManagerView)view;
        }
        throw new IllegalArgumentException("Invalid MediaManagerView: " + view);
    }

    public MediaManagerPanel getMediaManagerPanel() {
        if (this.mediaManagerPanel == null) {
            this.setMediaManagerPanel(this.prepareMediaManagerPanel());
        }
        return this.mediaManagerPanel;
    }

    protected void setMediaManagerPanel(MediaManagerPanel mediaManagerPanel) {
        this.mediaManagerPanel = mediaManagerPanel;
    }

    protected MediaManagerPanel prepareMediaManagerPanel() {
        MediaManagerView view = this.getMediaManagerView();
        if (view == null) {
            return null;
        }
        MediaManagerPanel mmp = view.getMediaManagerPanel();
        return mmp;
    }

    public MediaManagerDevicePanel getMediaManagerDevicePanel() {
        if (this.mediaManagerDevicePanel == null) {
            this.setMediaManagerDevicePanel(this.createMediaManagerDevicePanel());
            this.propagateCurrentDirectory();
        }
        return this.mediaManagerDevicePanel;
    }

    protected void setMediaManagerDevicePanel(MediaManagerDevicePanel mediaManagerDevicePanel) {
        this.mediaManagerDevicePanel = mediaManagerDevicePanel;
    }

    protected MediaManagerDevicePanel createMediaManagerDevicePanel() {
        MediaManagerPanel mmp = this.getMediaManagerPanel();
        MediaManagerDevicePanel mmdp = new MediaManagerDevicePanel(mmp);
        mmdp.setMediaManagerDevice(this);
        return mmdp;
    }

    protected void studioChanged(Studio studio) {
        super.studioChanged(studio);
        this.propagateCurrentDirectory();
    }

    protected void propagateCurrentDirectory() {
        Studio studio = this.getStudio();
        if (studio == null) {
            return;
        }
        File currentDir = studio.getDirectory();
        if (currentDir == null) {
            return;
        }
        MediaManagerDevicePanel devPanel = this.mediaManagerDevicePanel;
        if (devPanel == null) {
            return;
        }
        MediaManagerPanel mmp = devPanel.getMediaManagerPanel();
        if (mmp == null) {
            return;
        }
        mmp.setCurrentDirectory(currentDir);
    }

    protected synchronized void refreshPorts() throws StudioException {
        Studio studio = this.getStudio();
        Port[] oldPorts = this.getPorts();
        LinkedList<MidiInputPort> newInputPorts = new LinkedList<MidiInputPort>();
        LinkedList<MidiOutputPort> newOutputPorts = new LinkedList<MidiOutputPort>();
        newInputPorts.add(this.midiInputPort);
        newOutputPorts.add(this.midiOutputPort);
        HashSet<Port> oldPortSet = new HashSet<Port>();
        for (int i = 0; i < oldPorts.length; ++i) {
            oldPortSet.add(oldPorts[i]);
        }
        int nextPortIndex = 0;
        ArrayList<Object> newPorts = new ArrayList<Object>(newInputPorts.size() + newOutputPorts.size());
        newPorts.addAll(newInputPorts);
        newPorts.addAll(newOutputPorts);
        for (Port port : newPorts) {
            if (port == null) continue;
            oldPortSet.remove(port);
            if (port.getDevice() == this) {
                this.removePort(port);
            }
            this.insertPortAt(port, nextPortIndex);
            ++nextPortIndex;
        }
        for (Port port : oldPortSet) {
            if (port == null) continue;
            if (studio != null) {
                studio.disconnect(port);
            }
            this.removePort(port);
        }
    }

    public MidiMapping[] getMidiActionMappings() {
        return this.midiActionMappings;
    }

    public void setMidiActionMappings(MidiMapping[] midiActionMappings) {
        this.midiActionMappings = midiActionMappings;
        this.midiSupport.applyMidiActionMappings();
    }

    public MidiAction[] getAvailableMidiActions() {
        return this.midiActions;
    }

    protected void initMidiActions() {
        LinkedList<Object> list = new LinkedList<Object>();
        list.add((Object)this.cursorMoveMidiAction);
        list.add((Object)this.cursorPrevMidiAction);
        list.add((Object)this.cursorNextMidiAction);
        list.add((Object)this.cursorPushMidiAction);
        list.add((Object)this.cursorBackMidiAction);
        for (int i = 0; i < 8; ++i) {
            list.add(new SwitchPlayerMidiAction(i));
        }
        this.midiActions = list.toArray(new MidiAction[list.size()]);
    }

    protected void moveMediaCursorLater(int count) {
        SwingUtilities.invokeLater(new MoveMediaCursor(count));
    }

    protected void pushMediaCursorLater() {
        SwingUtilities.invokeLater(this.pushMediaCursor);
    }

    protected void backMediaCursorLater() {
        SwingUtilities.invokeLater(this.backMediaCursor);
    }

    protected void switchPlayerLater(SwitchPlayerMidiAction action) {
        SwingUtilities.invokeLater(action);
    }

    protected boolean switchPlayer(int playerIndex) {
        MediaManagerPanel mmp;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("switchPlayerLater: #" + playerIndex);
        }
        if ((mmp = this.getMediaManagerPanel()) == null) {
            return false;
        }
        MediaManagerToolContext mmtc = mmp.getMediaManagerToolContext();
        if (mmtc == null) {
            return false;
        }
        MediaTableToolContext mttc = mmtc.getMediaManagerPanel().getMediaTableToolContext();
        if (mttc == null) {
            return false;
        }
        MediaPlayer[] players = mttc.getMediaPlayers();
        if (players == null) {
            return false;
        }
        if (playerIndex < 0 || playerIndex >= players.length) {
            return false;
        }
        MediaPlayer player = players[playerIndex];
        if (player == null) {
            return false;
        }
        mttc.setSelectedMediaPlayer(player);
        return true;
    }

    protected class BackMediaCursor
    implements Runnable {
        protected BackMediaCursor() {
        }

        @Override
        public void run() {
            MediaManagerToolContext mmtc;
            MediaManagerPanel mmp;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("backMediaCursor");
            }
            if ((mmp = MediaManagerDevice.this.getMediaManagerPanel()) != null && (mmtc = mmp.getMediaManagerToolContext()) != null) {
                MediaPlayer player = null;
                mmtc.navigateBack(player);
            }
        }
    }

    protected class PushMediaCursor
    implements Runnable {
        protected PushMediaCursor() {
        }

        @Override
        public void run() {
            MediaManagerToolContext mmtc;
            MediaManagerPanel mmp;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("pushMediaCursor");
            }
            if ((mmp = MediaManagerDevice.this.getMediaManagerPanel()) != null && (mmtc = mmp.getMediaManagerToolContext()) != null) {
                MediaPlayer player = null;
                mmtc.navigatePush(player);
            }
        }
    }

    protected class MoveMediaCursor
    implements Runnable {
        private int count;

        public MoveMediaCursor(int count) {
            this.count = count;
        }

        @Override
        public void run() {
            MediaManagerToolContext mmtc;
            MediaManagerPanel mmp;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("moveMediaCursor: " + this.count);
            }
            if ((mmp = MediaManagerDevice.this.getMediaManagerPanel()) != null && (mmtc = mmp.getMediaManagerToolContext()) != null) {
                MediaPlayer player = null;
                mmtc.navigateMove(player, this.count);
            }
        }
    }

    protected class SwitchPlayerMidiAction
    extends AbstractButtonMidiAction
    implements Runnable {
        private int playerIndex;

        public SwitchPlayerMidiAction(int playerIndex) {
            super(MediaManagerDevice.MIDI_ACTION_SWITCH_PLAYER_PREFIX + (playerIndex + 1));
            this.playerIndex = playerIndex;
        }

        public void buttonPressed(long time) {
            MediaManagerDevice.this.switchPlayerLater(this);
        }

        @Override
        public void run() {
            MediaManagerDevice.this.switchPlayer(this.playerIndex);
        }
    }

    protected class CursorBackMidiAction
    extends AbstractButtonMidiAction {
        public CursorBackMidiAction() {
            super(MediaManagerDevice.MIDI_ACTION_CURSOR_BACK);
        }

        public void buttonPressed(long time) {
            MediaManagerDevice.this.backMediaCursorLater();
        }
    }

    protected class CursorPushMidiAction
    extends AbstractButtonMidiAction {
        public CursorPushMidiAction() {
            super(MediaManagerDevice.MIDI_ACTION_CURSOR_PUSH);
        }

        public void buttonPressed(long time) {
            MediaManagerDevice.this.pushMediaCursorLater();
        }
    }

    protected class CursorMoveMidiAction
    extends AbstractMidiAction {
        public CursorMoveMidiAction() {
            super(MediaManagerDevice.MIDI_ACTION_CURSOR_MOVE);
        }

        public void invoke(long time, int status, int data1, int data2) {
            if (status < 240) {
                switch (status & 0xF0) {
                    case 176: {
                        int count = data2 < 64 ? -1 : 1;
                        MediaManagerDevice.this.moveMediaCursorLater(count);
                        return;
                    }
                }
            }
        }
    }

    protected class CursorNextMidiAction
    extends AbstractButtonMidiAction {
        public CursorNextMidiAction() {
            super(MediaManagerDevice.MIDI_ACTION_CURSOR_NEXT);
        }

        public void buttonPressed(long time) {
            MediaManagerDevice.this.moveMediaCursorLater(1);
        }
    }

    protected class CursorPrevMidiAction
    extends AbstractButtonMidiAction {
        public CursorPrevMidiAction() {
            super(MediaManagerDevice.MIDI_ACTION_CURSOR_PREV);
        }

        public void buttonPressed(long time) {
            MediaManagerDevice.this.moveMediaCursorLater(-1);
        }
    }

    protected class MidiSyncGroupImpl
    extends MidiSyncGroup {
        private Map procs;

        public MidiSyncGroupImpl(String name, MidiInputPort[] inputPorts, MidiOutputPort[] outputPorts) {
            super(name, inputPorts, outputPorts);
            this.procs = new HashMap();
        }

        public void setTargetMidiProcessors(MidiProcessor[] targets) throws MidiException {
            if (targets.length != 1) {
                throw new MidiException("Invalid number of target ports: " + targets.length + " != 1");
            }
        }

        public MidiProcessor createMidiProcessor(MidiInputPort port) throws MidiException {
            MidiActionProcessor proc = (MidiActionProcessor)this.procs.get(port);
            if (proc == null) {
                proc = new MidiActionProcessor(this.getName());
                this.procs.put(port, proc);
                this.applyMidiActionMappings(proc);
            }
            return proc;
        }

        protected void applyMidiActionMappings() {
            for (MidiActionProcessor proc : this.procs.values()) {
                if (proc == null) continue;
                this.applyMidiActionMappings(proc);
            }
        }

        protected void applyMidiActionMappings(MidiActionProcessor proc) {
            proc.reset(MediaManagerDevice.this.getAvailableMidiActions(), MediaManagerDevice.this.getMidiActionMappings());
            proc.validate();
        }
    }

    protected class MidiSupportImpl
    extends MidiSupport {
        private MidiSyncGroupImpl syncGroup;

        protected MidiSupportImpl() {
        }

        public synchronized void reset() {
            if (this.syncGroup != null) {
                this.syncGroup = null;
            }
        }

        public synchronized MidiSyncGroup getMidiSyncGroup(MidiPort port) {
            if (this.syncGroup == null) {
                MidiInputPort[] inputPorts = new MidiInputPort[]{MediaManagerDevice.this.midiInputPort};
                MidiOutputPort[] outputPorts = new MidiOutputPort[]{MediaManagerDevice.this.midiOutputPort};
                this.syncGroup = new MidiSyncGroupImpl(MediaManagerDevice.this.getTitleOrName(), inputPorts, outputPorts);
            }
            return this.syncGroup;
        }

        protected void applyMidiActionMappings() {
            MidiSyncGroupImpl group = this.syncGroup;
            if (group != null) {
                group.applyMidiActionMappings();
            }
        }
    }
}

