/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.media.manager;

import com.spacekiller.util.Editor;
import com.spacekiller.util.EditorContext;
import com.spacekiller.util.media.manager.MediaManagerPanel;
import com.spacekiller.util.midi.MidiFormatter;
import com.spacekiller.util.midi.impl.DefaultMidiFactory;
import com.spacekiller.util.midi.impl.DefaultMidiFormatter;
import com.waxmonster.media.manager.MediaManagerDevice;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.common.MidiMappingManagerPanel;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;

public class MediaManagerDevicePanel
extends JPanel
implements Editor {
    private static final long serialVersionUID = -3657212511775388883L;
    private static final Logger logger = Logger.getLogger(MediaManagerDevicePanel.class.getName());
    private MediaManagerPanel mediaManagerPanel;
    private MediaManagerDevice mediaManagerDevice;

    public MediaManagerDevicePanel(MediaManagerPanel panel) {
        this.mediaManagerPanel = panel;
        this.setLayout(new GridLayout(1, 1));
        this.add((Component)panel);
    }

    public void setEditorContext(EditorContext context) {
        MediaManagerPanel mmp = this.mediaManagerPanel;
        if (mmp != null) {
            mmp.setEditorContext(context);
        }
    }

    public boolean isDirty() throws Exception {
        MediaManagerPanel mmp = this.mediaManagerPanel;
        if (mmp != null) {
            return mmp.isDirty();
        }
        return false;
    }

    public void save() throws Exception {
        MediaManagerPanel mmp = this.mediaManagerPanel;
        if (mmp != null) {
            mmp.save();
        }
    }

    protected MediaManagerDevice getMediaManagerDevice() {
        return this.mediaManagerDevice;
    }

    protected void setMediaManagerDevice(MediaManagerDevice mediaManagerDevice) {
        this.mediaManagerDevice = mediaManagerDevice;
    }

    protected MediaManagerPanel getMediaManagerPanel() {
        return this.mediaManagerPanel;
    }

    protected void setMediaManagerPanel(MediaManagerPanel mediaManagerPanel) {
        this.mediaManagerPanel = mediaManagerPanel;
    }

    protected void showMidiMappingDialog() {
        MediaManagerDevice device = this.getMediaManagerDevice();
        if (device == null) {
            return;
        }
        try {
            MidiMappingManagerPanel panel = new MidiMappingManagerPanel();
            panel.setStudio(device.getStudio());
            panel.setDeviceName("MediaManager-MidiMapping");
            panel.setMidiFactory(DefaultMidiFactory.getInstance());
            panel.setMidiFormatter((MidiFormatter)DefaultMidiFormatter.getSharedInstance());
            panel.setAvailableActions(device.getAvailableMidiActions());
            MidiMapping[] origMappings = device.getMidiActionMappings();
            int origCount = origMappings == null ? 0 : origMappings.length;
            MidiMapping[] cloneMappings = new MidiMapping[origCount];
            if (origCount > 0) {
                System.arraycopy(origMappings, 0, cloneMappings, 0, origCount);
            }
            panel.setMappings(cloneMappings);
            String title = "MIDI Mappings";
            if (!panel.showDialog((Component)this, title)) {
                return;
            }
            MidiMapping[] newMappings = panel.getMappings();
            device.setMidiActionMappings(newMappings);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

