/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.Parameter;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.BeanProperty;
import com.spacekiller.util.beans.ClipboardManager;
import com.spacekiller.util.beans.DynamicPropertyDescriptor;
import com.spacekiller.util.beans.PropertyValue;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.UndoManager;

public abstract class AbstractBeansToolkit
implements BeansToolkit {
    private static final Logger logger = Logger.getLogger(AbstractBeansToolkit.class.getName());

    protected Properties cloneProperties(Properties p) {
        Properties newProps = new Properties();
        if (p != null) {
            Enumeration<Object> en = p.keys();
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                newProps.put(key, p.get(key));
            }
        }
        return newProps;
    }

    protected PropertyDescriptor findMissingPropertyDescriptor(String propName, PropertyDescriptor[] props) {
        String pName;
        int c;
        if (props == null) {
            return null;
        }
        if (propName == null) {
            return null;
        }
        propName = propName.trim().toLowerCase();
        for (c = 0; c < props.length; ++c) {
            pName = props[c].getName();
            if (pName == null || !pName.trim().toLowerCase().equals(propName)) continue;
            return props[c];
        }
        for (c = 0; c < props.length; ++c) {
            pName = props[c].getDisplayName();
            if (pName == null || !pName.trim().toLowerCase().equals(propName)) continue;
            return props[c];
        }
        return null;
    }

    private PropertyDescriptor getPropertyDescriptor(PropertyDescriptor[] pd, String name) {
        int len = pd.length;
        for (int c = 0; c < len; ++c) {
            if (!name.equals(pd[c].getName())) continue;
            return pd[c];
        }
        return null;
    }

    protected PropertyDescriptor[] getReadWritePropertyDescriptors(BeanInfo beanInfo) {
        PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
        Vector<PropertyDescriptor> v = new Vector<PropertyDescriptor>();
        for (PropertyDescriptor p : props) {
            if (p.getReadMethod() == null || p.getWriteMethod() == null) continue;
            v.addElement(p);
        }
        int count = v.size();
        props = new PropertyDescriptor[count];
        for (int c = 0; c < count; ++c) {
            props[c] = (PropertyDescriptor)v.get(c);
        }
        return props;
    }

    protected PropertyDescriptor[] getReadWritePropertyDescriptors(Class beanClass) throws InstantiationException, IllegalAccessException, IntrospectionException {
        BeanInfo info = this.getBeanInfo(beanClass);
        return info == null ? null : this.getReadWritePropertyDescriptors(info);
    }

    public Object getValue(PropertyDescriptor descriptor, Object bean) throws IllegalAccessException, InvocationTargetException {
        if (descriptor instanceof DynamicPropertyDescriptor) {
            return ((DynamicPropertyDescriptor)descriptor).getValue(bean);
        }
        return BeanProperty.getValue(bean, descriptor);
    }

    public void getValues(PropertyDescriptor[] descriptors, Object bean, Collection dstPropertyValues, Collection dstExceptions) {
        if (descriptors != null) {
            for (int c = 0; c < descriptors.length; ++c) {
                try {
                    dstPropertyValues.add(new PropertyValue(descriptors[c].getName(), this.getValue(descriptors[c], bean)));
                    continue;
                }
                catch (Throwable e) {
                    dstExceptions.add(e);
                }
            }
        }
    }

    protected void handleException(Throwable exception) {
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, this.getClass().getName(), exception);
        }
    }

    public Object instantiate(Class beanClass) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return this.getClassRegistry().instantiate(beanClass);
    }

    public Object instantiate(Class beanClass, Parameter[] constructorParams) throws InvocationTargetException, InstantiationException, IllegalAccessException, NoSuchMethodException {
        return this.getClassRegistry().instantiate(beanClass, constructorParams);
    }

    public Object invoke(Object object, String method, Parameter[] parameters) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        int count = parameters.length;
        Class[] paramTypes = new Class[count];
        Object[] paramValues = new Object[count];
        for (int c = 0; c < count; ++c) {
            paramTypes[c] = parameters[c].getType();
            paramValues[c] = parameters[c].getValue();
        }
        Method meth = clazz.getMethod(method, paramTypes);
        return meth.invoke(object, paramValues);
    }

    public void setValue(PropertyDescriptor descriptor, Object bean, Object value) throws IllegalAccessException, InvocationTargetException, PropertyVetoException {
        if (descriptor instanceof DynamicPropertyDescriptor) {
            ((DynamicPropertyDescriptor)descriptor).setValue(bean, value);
        } else {
            BeanProperty.setValue(bean, descriptor, value);
        }
    }

    public void setValues(Object bean, PropertyDescriptor[] descriptors, Iterator propertyValues, Collection dstExceptions) {
        if (descriptors == null || bean == null || propertyValues == null) {
            return;
        }
        while (propertyValues.hasNext()) {
            PropertyValue value = (PropertyValue)propertyValues.next();
            if (value == null) continue;
            String name = value.getName();
            PropertyDescriptor descr = this.getPropertyDescriptor(descriptors, name);
            try {
                if (descr == null) continue;
                this.setValue(descr, bean, value.getValue());
            }
            catch (Throwable e) {
                dstExceptions.add(e);
            }
        }
    }

    public void setValues(Object bean, Iterator propertyValues, Collection dstExceptions) throws InstantiationException, IntrospectionException, IllegalAccessException {
        BeanInfo beanInfo = this.getBeanInfo(bean.getClass());
        PropertyDescriptor[] descriptors = this.getReadWritePropertyDescriptors(beanInfo);
        this.setValues(bean, descriptors, propertyValues, dstExceptions);
    }

    public abstract BeanDropSupport getBeanDropSupport();

    public abstract ClipboardManager getClipboardManager();

    public abstract UndoManager getUndoManager();
}

