/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.beans.Property;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;

public abstract class AbstractProperty
implements Property,
Externalizable {
    private PropertyDescriptor descriptor;
    private Object value;
    private PropertyChangeSupport propertyChangeSupport;
    private VetoableChangeSupport vetoableChangeSupport;

    public AbstractProperty(PropertyDescriptor descriptor) {
        this.setDescriptor(descriptor);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.getPropertyChangeSupport().addPropertyChangeListener(pcl);
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener vcl) {
        this.getVetoableChangeSupport().addVetoableChangeListener(vcl);
    }

    protected PropertyChangeSupport createPropertyChangeSupport() {
        return new PropertyChangeSupport(this);
    }

    protected VetoableChangeSupport createVetoableChangeSupport() {
        return new VetoableChangeSupport(this);
    }

    @Override
    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public String getName() {
        return this.descriptor == null ? null : this.descriptor.getName();
    }

    protected PropertyChangeEvent getPropertyChangeEvent(Object oldValue, Object newValue) {
        return new PropertyChangeEvent(this, this.getName(), oldValue, newValue);
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.setPropertyChangeSupport(this.createPropertyChangeSupport());
        }
        return this.propertyChangeSupport;
    }

    @Override
    public Object getValue() throws InvocationTargetException, IllegalAccessException {
        return this.value;
    }

    protected VetoableChangeSupport getVetoableChangeSupport() {
        if (this.vetoableChangeSupport == null) {
            this.setVetoableChangeSupport(this.createVetoableChangeSupport());
        }
        return this.vetoableChangeSupport;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.setDescriptor((PropertyDescriptor)in.readObject());
            this.setValue(in.readObject());
        }
        catch (IOException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException("" + e);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.getPropertyChangeSupport().removePropertyChangeListener(pcl);
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener vcl) {
        this.getVetoableChangeSupport().removeVetoableChangeListener(vcl);
    }

    protected void setDescriptor(PropertyDescriptor newDescriptor) {
        this.descriptor = newDescriptor;
    }

    protected void setPropertyChangeSupport(PropertyChangeSupport newPropertyChangeSupport) {
        this.propertyChangeSupport = newPropertyChangeSupport;
    }

    @Override
    public synchronized void setValue(Object value) throws InvocationTargetException, IllegalAccessException, PropertyVetoException {
        Object old = this.value;
        if (old == value) {
            return;
        }
        PropertyChangeEvent ev = this.getPropertyChangeEvent(old, value);
        if (this.vetoableChangeSupport != null) {
            this.vetoableChangeSupport.fireVetoableChange(ev);
        }
        this.value = value;
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(ev);
        }
    }

    protected void setVetoableChangeSupport(VetoableChangeSupport newVetoableChangeSupport) {
        this.vetoableChangeSupport = newVetoableChangeSupport;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.descriptor);
        out.writeObject(this.value);
    }
}

