/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.beans.BeanDropSupport;
import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.beans.beancontext.BeanContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanDropManager
implements BeanDropSupport {
    private static DataFlavor javaJVMLocalObjectFlavor;
    private Method methodGetTransferable;
    private List supports = new ArrayList();

    public static DataFlavor getJavaJVMLocalObjectFlavor() throws Exception {
        if (javaJVMLocalObjectFlavor == null) {
            javaJVMLocalObjectFlavor = new DataFlavor("application/x-java-jvm-local-objectref");
        }
        return javaJVMLocalObjectFlavor;
    }

    @Override
    public boolean supportsBeanContext(BeanContext context) {
        int num = this.supports.size();
        for (int c = 0; c < num; ++c) {
            BeanDropSupport bds = (BeanDropSupport)this.supports.get(c);
            if (!bds.supportsBeanContext(context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean enumerateDropBeans(BeanContext context, DropTargetDragEvent dtde, Collection dstBeans) {
        Transferable trans = null;
        try {
            if (this.methodGetTransferable == null) {
                this.methodGetTransferable = dtde.getClass().getDeclaredMethod("getTransferable", new Class[0]);
            }
            trans = (Transferable)this.methodGetTransferable.invoke((Object)dtde, new Object[0]);
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (trans != null) {
            this.enumerateDropBeans(context, trans, dstBeans);
            if (dstBeans.isEmpty()) {
                dtde.rejectDrag();
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean enumerateDropBeans(BeanContext context, Transferable trans, Collection dstBeans) {
        int num = this.supports.size();
        for (int c = 0; c < num; ++c) {
            ArrayList temp;
            BeanDropSupport bds = (BeanDropSupport)this.supports.get(c);
            if (!bds.supportsBeanContext(context) || !bds.enumerateDropBeans(context, trans, temp = new ArrayList()) || temp.isEmpty()) continue;
            dstBeans.addAll(temp);
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptDropBean(BeanContext context, Object bean) {
        int num = this.supports.size();
        for (int c = 0; c < num; ++c) {
            BeanDropSupport bds = (BeanDropSupport)this.supports.get(c);
            if (!bds.supportsBeanContext(context) || !bds.acceptDropBean(context, bean)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int dropBeans(Collection beans, BeanContext target, int dropAction) {
        int rc = 0;
        HashMap map = new HashMap();
        int supportCount = this.supports.size();
        block0: for (Object bean : beans) {
            for (int c = 0; c < supportCount; ++c) {
                BeanDropSupport bds = (BeanDropSupport)this.supports.get(c);
                if (!bds.supportsBeanContext(target) || !bds.acceptDropBean(target, bean)) continue;
                ArrayList beanList = (ArrayList)map.get(bds);
                if (beanList == null) {
                    beanList = new ArrayList();
                    map.put(bds, beanList);
                }
                beanList.add(bean);
                continue block0;
            }
        }
        for (Map.Entry me : map.entrySet()) {
            List beanList;
            BeanDropSupport bds = (BeanDropSupport)me.getKey();
            int done = bds.dropBeans(beanList = (List)me.getValue(), target, dropAction);
            if (done <= 0) continue;
            rc += done;
        }
        return rc;
    }

    @Override
    public double getPriority() {
        return 0.0;
    }

    public void registerBeanDropSupport(BeanDropSupport support) {
        double prio = support.getPriority();
        int num = this.supports.size();
        for (int c = 0; c < num; ++c) {
            BeanDropSupport bds = (BeanDropSupport)this.supports.get(c);
            if (!(prio > bds.getPriority())) continue;
            this.supports.add(c, support);
            return;
        }
        this.supports.add(support);
    }

    public void unregisterBeanDropSupport(BeanDropSupport support) {
        this.supports.remove(support);
    }

    @Override
    public Cursor getCursor(Collection beans, int dropAction, int targetActions) {
        int supportCount = this.supports.size();
        Cursor rc = null;
        for (int c = 0; c < supportCount; ++c) {
            BeanDropSupport bds = (BeanDropSupport)this.supports.get(c);
            rc = bds.getCursor(beans, dropAction, targetActions);
            if (rc == null) continue;
            return rc;
        }
        return null;
    }
}

