/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.FileLink;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

public class BeanTransferable
implements Transferable {
    private transient List beans = new ArrayList();
    private transient DataFlavor[] flavors;
    private static final Logger logger = Logger.getLogger(BeanTransferable.class.getName());

    public BeanTransferable(Collection beans, DataFlavor[] flavors) {
        this.beans.addAll(beans);
        this.flavors = new DataFlavor[flavors.length];
        System.arraycopy(flavors, 0, this.flavors, 0, flavors.length);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.isFlavorJavaFileListType()) {
            ArrayList<File> files = new ArrayList<File>();
            for (Object o : this.beans) {
                FileLink link;
                File f;
                if (o == null) continue;
                if (o instanceof File) {
                    files.add((File)o);
                    continue;
                }
                if (!(o instanceof FileLink) || (f = (link = (FileLink)o).getFile()) == null) continue;
                files.add(f);
            }
            return files;
        }
        if (flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref")) {
            return this.beans;
        }
        logger.fine("DEBUG: unknown flavor: " + flavor);
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        int num = this.flavors.length;
        DataFlavor[] rc = new DataFlavor[num];
        System.arraycopy(this.flavors, 0, rc, 0, num);
        return rc;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        int num = this.flavors.length;
        for (int c = 0; c < num; ++c) {
            if (!this.flavors[c].equals(flavor)) continue;
            return true;
        }
        return false;
    }
}

