/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.beans.AbstractProperty;
import com.spacekiller.util.beans.Property;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;

public class BooleanProperty {
    public static final Property TRUE = new CONST(null, Boolean.TRUE);
    public static final Property FALSE = new CONST(null, Boolean.FALSE);

    private BooleanProperty() {
    }

    public static final class AND
    extends LOGIC {
        private static final long serialVersionUID = 872907238923982L;

        public AND(PropertyDescriptor descriptor, Property[] p) {
            super(descriptor, p);
        }

        @Override
        protected void handlePropertyChange(PropertyChangeEvent e) {
            try {
                if (!((Boolean)e.getNewValue()).booleanValue()) {
                    this.setValue(Boolean.FALSE);
                } else {
                    Boolean value = Boolean.TRUE;
                    Property[] p = this.getDependency();
                    for (int c = 0; c < p.length; ++c) {
                        if (((Boolean)this.getDependency()[c].getValue()).booleanValue()) continue;
                        value = Boolean.FALSE;
                        break;
                    }
                    this.setValue(value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final class OR
    extends LOGIC {
        private static final long serialVersionUID = 890729078232332L;

        public OR(PropertyDescriptor descriptor, Property[] p) {
            super(descriptor, p);
        }

        @Override
        protected void handlePropertyChange(PropertyChangeEvent e) {
            try {
                if (((Boolean)e.getNewValue()).booleanValue()) {
                    this.setValue(Boolean.TRUE);
                } else {
                    Boolean value = Boolean.FALSE;
                    Property[] p = this.getDependency();
                    for (int c = 0; c < p.length; ++c) {
                        if (!((Boolean)this.getDependency()[c].getValue()).booleanValue()) continue;
                        value = Boolean.TRUE;
                        break;
                    }
                    this.setValue(value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final class NOT
    extends LOGIC {
        private static final long serialVersionUID = 709879347089734L;

        public NOT(PropertyDescriptor descriptor, Property p) {
            super(descriptor, new Property[]{p});
        }

        @Override
        protected void handlePropertyChange(PropertyChangeEvent e) {
            try {
                this.setValue((Boolean)this.getDependency()[0].getValue() != false ? Boolean.FALSE : Boolean.TRUE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static abstract class LOGIC
    extends AbstractProperty {
        private Property[] dependency;
        private PropertyChangeHandler propertyChangeHandler = new PropertyChangeHandler();

        public LOGIC(PropertyDescriptor descriptor, Property[] p) {
            super(descriptor);
            this.setDependency(p);
        }

        protected Property[] getDependency() {
            return this.dependency;
        }

        protected synchronized void setDependency(Property[] newDependency) {
            int c;
            if (this.dependency != null) {
                for (c = 0; c < this.dependency.length; ++c) {
                    this.dependency[c].removePropertyChangeListener(this.propertyChangeHandler);
                }
            }
            this.dependency = newDependency;
            if (this.dependency != null) {
                for (c = 0; c < this.dependency.length; ++c) {
                    this.dependency[c].addPropertyChangeListener(this.propertyChangeHandler);
                }
            }
        }

        protected void finalize() throws Throwable {
            this.setDependency(null);
        }

        protected abstract void handlePropertyChange(PropertyChangeEvent var1);

        private class PropertyChangeHandler
        implements PropertyChangeListener {
            private PropertyChangeHandler() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                LOGIC.this.handlePropertyChange(ev);
            }
        }
    }

    protected static final class CONST
    extends AbstractProperty {
        private static final long serialVersionUID = 78697868762978L;
        private Boolean value;

        public CONST(PropertyDescriptor descriptor, Boolean b) {
            super(descriptor);
            this.value = b;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public void setValue(Object o) {
        }

        protected void handlePropertyChange(PropertyChangeEvent e) {
        }
    }
}

