/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.beans.DefaultBeansToolkit;
import com.spacekiller.util.beans.IconProvider;
import java.lang.reflect.Modifier;
import javax.swing.Icon;

public class ClassIconProvider
implements IconProvider {
    private static final Class[] CLASS_CLASS = new Class[]{Class.class};
    private Icon defaultClassIcon;
    private Icon abstractClassIcon;
    private Icon interfaceIcon;

    public ClassIconProvider() {
        this.initClassIconProvider();
    }

    @Override
    public Class[] getBeanTypes() {
        return CLASS_CLASS;
    }

    @Override
    public Icon getIcon(Object bean, int iconKind) {
        if (bean != null && bean instanceof Class) {
            Class clazz = (Class)bean;
            if (clazz.isInterface()) {
                return this.interfaceIcon;
            }
            if (Modifier.isAbstract(clazz.getModifiers())) {
                return this.abstractClassIcon;
            }
            return this.defaultClassIcon;
        }
        return null;
    }

    protected void initClassIconProvider() {
        this.defaultClassIcon = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/class2.gif");
        this.abstractClassIcon = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/abstract_class.gif");
        this.interfaceIcon = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/interface.gif");
    }
}

