/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.FileContext;
import com.spacekiller.util.Platform;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.FileDirNode;
import com.spacekiller.util.beans.FileLeafNode;
import com.spacekiller.util.beans.TypeContext;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.image.BufferedImage;
import java.beans.beancontext.BeanContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class DefaultBeanDropSupport
implements BeanDropSupport {
    private static int cursorCounter = 0;
    private BeansToolkit beansToolkit;
    private ImageIcon moveIcon;
    private ImageIcon copyIcon;
    private ImageIcon shortcutIcon;
    private ImageIcon invalidIcon;
    private Cursor prevCursor;
    private int prevCursorHash;
    private static final Logger logger = Logger.getLogger(DefaultBeanDropSupport.class.getName());

    public DefaultBeanDropSupport(BeansToolkit beansToolkit) {
        this.setBeansToolkit(beansToolkit);
        this.initDefaultBeanDropSupport();
    }

    @Override
    public boolean enumerateDropBeans(BeanContext context, Transferable trans, Collection dstBeans) {
        DataFlavor[] flavors = trans.getTransferDataFlavors();
        if (flavors == null) {
            return false;
        }
        int counter = 0;
        for (int c = 0; c < flavors.length; ++c) {
            DataFlavor flav = flavors[c];
            if (flav.isFlavorJavaFileListType()) {
                try {
                    Object obj = trans.getTransferData(flav);
                    if (obj == null || !(obj instanceof Collection)) break;
                    Collection fileList = (Collection)obj;
                    dstBeans.addAll(fileList);
                    ++counter;
                    break;
                }
                catch (InvalidDnDOperationException e) {
                    return false;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    break;
                }
            }
            if (flav.isMimeTypeEqual("application/x-java-jvm-local-objectref")) {
                try {
                    Object obj = trans.getTransferData(flav);
                    if (obj == null) break;
                    if (obj instanceof List) {
                        List list = (List)obj;
                        dstBeans.addAll(list);
                        ++counter;
                        break;
                    }
                    dstBeans.add(obj);
                    ++counter;
                }
                catch (Exception e) {
                    logger.fine("" + e);
                }
                break;
            }
            logger.fine("DEBUG: unknown DataFlavor: " + flav);
        }
        return counter > 0;
    }

    @Override
    public int dropBeans(Collection beans, BeanContext target, int dropAction) {
        int done = 0;
        if (target instanceof FileContext) {
            FileContext fc = (FileContext)target;
            return this.dropFiles(beans, fc, dropAction);
        }
        for (Object bean : beans) {
            if (bean == null) continue;
            this.dropBean(bean, target, dropAction);
        }
        return done;
    }

    @Override
    public boolean acceptDropBean(BeanContext context, Object bean) {
        if (context == null || bean == null) {
            return false;
        }
        if (context == bean) {
            return false;
        }
        if (context instanceof TypeContext) {
            TypeContext tc = (TypeContext)context;
            if (bean instanceof File) {
                return tc.supports(FileContext.class) || tc.supports(File.class);
            }
            return tc.supports(bean);
        }
        if (context instanceof FileContext) {
            if (bean instanceof File) {
                return true;
            }
            return bean instanceof FileContext;
        }
        return true;
    }

    protected Object resolveDropBean(Object bean) {
        if (bean == null) {
            return null;
        }
        if (bean instanceof File) {
            return this.createFileContext((File)bean);
        }
        if (bean instanceof FileContext) {
            return this.createFileContext((FileContext)bean);
        }
        return bean;
    }

    protected FileContext createFileContext(File f) {
        if (f.exists() && f.isFile()) {
            return new FileLeafNode.NamedFileLeafNode(f, f.getPath());
        }
        return new FileDirNode.NamedFileDirNode(f, f.getPath());
    }

    protected FileContext createFileContext(FileContext fc) {
        File file = fc.getFile();
        return this.createFileContext(file);
    }

    protected int dropFiles(Collection beans, FileContext target, int dropAction) {
        File targetDir = target.getFile();
        if (!targetDir.exists()) {
            return 0;
        }
        if (!targetDir.isDirectory()) {
            return 0;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (Object o : beans) {
            File f = null;
            if (o instanceof File) {
                f = (File)o;
            }
            if (o instanceof FileContext) {
                f = ((FileContext)o).getFile();
            }
            if (f == null) continue;
            files.add(f);
        }
        if (files.isEmpty()) {
            return 0;
        }
        int done = 0;
        switch (dropAction) {
            case 1: {
                logger.fine("dropFiles: action=COPY..");
                this.fileCopy(files, targetDir);
                done = files.size();
                break;
            }
            case 2: {
                logger.fine("dropFiles: action=MOVE..");
                this.fileMove(files, targetDir);
                done = files.size();
                break;
            }
            case 0x40000000: {
                this.fileLink(files, targetDir);
                done = files.size();
            }
            default: {
                throw new UnsupportedOperationException("Drop action not supported: " + dropAction);
            }
        }
        return done;
    }

    protected boolean dropBean(Object bean, BeanContext target, int dropAction) {
        logger.fine("Drop bean: " + bean);
        Object o = this.resolveDropBean(bean);
        if (o != null) {
            if (target.add(o)) {
                return true;
            }
            if (target.add(bean)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsBeanContext(BeanContext context) {
        return true;
    }

    @Override
    public double getPriority() {
        return 0.0;
    }

    @Override
    public boolean enumerateDropBeans(BeanContext context, DropTargetDragEvent dtde, Collection dstBeans) {
        throw new UnsupportedOperationException();
    }

    protected Platform getPlatform() {
        return Platform.getInstance();
    }

    protected void fileCopy(List files, File toDir) {
        throw new UnsupportedOperationException("TODO copy file(s)");
    }

    protected void fileMove(List files, File toDir) {
        throw new UnsupportedOperationException("TODO move file(s)");
    }

    protected void fileLink(List files, File toDir) {
        throw new UnsupportedOperationException("TODO drop file-link(s)");
    }

    @Override
    public Cursor getCursor(Collection beans, int dropAction, int targetActions) {
        if (beans == null) {
            return null;
        }
        ArrayList<Image> images = new ArrayList<Image>();
        Iterator iter = beans.iterator();
        int maxImages = 4;
        HashSet<ImageIcon> iconSet = new HashSet<ImageIcon>();
        int cursorHash = 0;
        BeansToolkit btk = this.getBeansToolkit();
        if (btk != null) {
            while (iter.hasNext()) {
                ImageIcon img;
                Icon icon;
                Object bean = iter.next();
                if (bean == null || (icon = btk.getIcon(bean)) == null || !(icon instanceof ImageIcon) || iconSet.contains(img = (ImageIcon)icon)) continue;
                iconSet.add(img);
                Image image = img.getImage();
                if (image == null) continue;
                images.add(image);
                cursorHash = cursorHash * 13 + System.identityHashCode(icon);
                if (images.size() < maxImages) continue;
                break;
            }
        }
        if (this.prevCursor != null && this.prevCursorHash == (cursorHash += dropAction * 13 + targetActions)) {
            return this.prevCursor;
        }
        if (!images.isEmpty()) {
            Cursor cursor;
            Image x;
            int width = 32;
            int height = 32;
            BufferedImage bi = new BufferedImage(width, height, 2);
            Graphics g = bi.getGraphics();
            int imgWidth = 5;
            int imgHeight = 5;
            int nx = 4;
            int ny = 4;
            int num = images.size();
            for (int c = num - 1; c >= 0; --c) {
                Image image = (Image)images.get(c);
                int x2 = c * nx;
                int y = c * ny;
                g.drawImage(image, x2, y, null);
                imgWidth = Math.max(imgWidth, x2 + image.getWidth(null));
                imgHeight = Math.max(imgHeight, y + image.getHeight(null));
            }
            if (targetActions == 0 && this.invalidIcon != null && (x = this.invalidIcon.getImage()) != null) {
                g.drawImage(x, 5, 5, null);
            }
            if (dropAction == 0x40000000 && this.shortcutIcon != null && (x = this.shortcutIcon.getImage()) != null) {
                int xh = x.getHeight(null);
                g.drawImage(x, 0, imgHeight - xh, null);
            }
            if (dropAction == 1 && this.copyIcon != null && (x = this.copyIcon.getImage()) != null) {
                int xh = x.getHeight(null);
                g.drawImage(x, 0, imgHeight - xh, null);
            }
            if (dropAction == 2 && this.moveIcon != null && (x = this.moveIcon.getImage()) != null) {
                int xh = x.getHeight(null);
                g.drawImage(x, 0, imgHeight - xh, null);
            }
            String cursorName = "BeanTreeCursor_" + ++cursorCounter;
            Point hotSpot = new Point(imgWidth / 2, imgHeight / 2);
            this.prevCursor = cursor = Toolkit.getDefaultToolkit().createCustomCursor(bi, hotSpot, cursorName);
            this.prevCursorHash = cursorHash;
            return cursor;
        }
        return null;
    }

    protected BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    protected void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
    }

    protected ImageIcon getShortcutIcon() {
        return this.shortcutIcon;
    }

    protected void setShortcutIcon(ImageIcon shortcutIcon) {
        this.shortcutIcon = shortcutIcon;
    }

    protected void initDefaultBeanDropSupport() {
        try {
            this.setMoveIcon(null);
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/icons/dropcopy.gif"));
            this.setCopyIcon(icon);
            icon = new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/icons/droplink.gif"));
            this.setShortcutIcon(icon);
            icon = new ImageIcon(this.getClass().getResource("/com/spacekiller/util/beans/icons/cancel.gif"));
            this.setInvalidIcon(icon);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected ImageIcon getCopyIcon() {
        return this.copyIcon;
    }

    protected void setCopyIcon(ImageIcon copyIcon) {
        this.copyIcon = copyIcon;
    }

    protected ImageIcon getMoveIcon() {
        return this.moveIcon;
    }

    protected void setMoveIcon(ImageIcon moveIcon) {
        this.moveIcon = moveIcon;
    }

    protected ImageIcon getInvalidIcon() {
        return this.invalidIcon;
    }

    protected void setInvalidIcon(ImageIcon invalidIcon) {
        this.invalidIcon = invalidIcon;
    }
}

