/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.beans.DefaultFeatureDescriptorFilter;
import com.spacekiller.util.beans.FeatureDescriptorFilter;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.util.Hashtable;

public class DefaultBeanFeatureFilter
implements FeatureDescriptorFilter {
    private static final DefaultFeatureDescriptorFilter excludeFilter = new DefaultFeatureDescriptorFilter(false, false, false, false, false, false);
    private Hashtable filters = new Hashtable();
    private FeatureDescriptorFilter defaultFilter;
    private FeatureDescriptorFilter preFilter;

    public DefaultBeanFeatureFilter(FeatureDescriptorFilter newPreFilter, FeatureDescriptorFilter newDefaultFilter) {
        this.setPreFilter(newPreFilter);
        this.setDefaultFilter(newDefaultFilter);
    }

    @Override
    public boolean accept(BeanInfo beanInfo, FeatureDescriptor feature) {
        FeatureDescriptorFilter filter = this.getPreFilter();
        if (filter != null && !filter.accept(beanInfo, feature)) {
            return false;
        }
        filter = (FeatureDescriptorFilter)this.filters.get(beanInfo.getBeanDescriptor().getBeanClass());
        if (filter == null) {
            filter = this.getDefaultFilter();
        }
        return filter.accept(beanInfo, feature);
    }

    public void deregisterFilter(Class beanType) {
        this.filters.remove(beanType);
    }

    public void excludeAllFeaturesOf(Class beanType) {
        this.registerFilter(beanType, excludeFilter);
    }

    public void excludeAllFeaturesOfPrimitiveTypes() {
        this.excludeAllFeaturesOf(Boolean.class);
        this.excludeAllFeaturesOf(Boolean.TYPE);
        this.excludeAllFeaturesOf(Byte.class);
        this.excludeAllFeaturesOf(Byte.TYPE);
        this.excludeAllFeaturesOf(Character.class);
        this.excludeAllFeaturesOf(Character.TYPE);
        this.excludeAllFeaturesOf(Short.class);
        this.excludeAllFeaturesOf(Short.TYPE);
        this.excludeAllFeaturesOf(Integer.class);
        this.excludeAllFeaturesOf(Integer.TYPE);
        this.excludeAllFeaturesOf(Long.class);
        this.excludeAllFeaturesOf(Long.TYPE);
        this.excludeAllFeaturesOf(Float.class);
        this.excludeAllFeaturesOf(Float.TYPE);
        this.excludeAllFeaturesOf(Double.class);
        this.excludeAllFeaturesOf(Double.TYPE);
    }

    protected FeatureDescriptorFilter getDefaultFilter() {
        return this.defaultFilter;
    }

    protected FeatureDescriptorFilter getPreFilter() {
        return this.preFilter;
    }

    public void registerFilter(Class beanType, FeatureDescriptorFilter f) {
        this.filters.put(beanType, f);
    }

    private void setDefaultFilter(FeatureDescriptorFilter newDefaultFilter) {
        this.defaultFilter = newDefaultFilter;
    }

    private void setPreFilter(FeatureDescriptorFilter newPreFilter) {
        this.preFilter = newPreFilter;
    }
}

