/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.ClassRegistry;
import com.spacekiller.util.Factory;
import com.spacekiller.util.IconConstants;
import com.spacekiller.util.Platform;
import com.spacekiller.util.beans.AbstractBeansToolkit;
import com.spacekiller.util.beans.ArrayIcon;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.ClassIconProvider;
import com.spacekiller.util.beans.ClipboardManager;
import com.spacekiller.util.beans.ColorIconProvider;
import com.spacekiller.util.beans.Customizable;
import com.spacekiller.util.beans.CustomizerProvider;
import com.spacekiller.util.beans.DefaultBeanInfo;
import com.spacekiller.util.beans.DefaultFeatureDescriptorComparator;
import com.spacekiller.util.beans.IconCache;
import com.spacekiller.util.beans.IconProvider;
import com.spacekiller.util.beans.ImageIconProvider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.undo.UndoManager;

public class DefaultBeansToolkit
extends AbstractBeansToolkit
implements IconConstants {
    private static final Logger logger = Logger.getLogger(DefaultBeansToolkit.class.getName());
    private Map customizerTypes = new HashMap();
    private Map indexedCustomizerTypes = new HashMap();
    private Factory customizerFactory;
    private Map propertyEditorTypes = new HashMap();
    private Map indexedPropertyEditorTypes = new HashMap();
    private Factory propertyEditorFactory;
    private Map beanInfos = new HashMap();
    private IconCache iconCache;
    private Map iconProviders = new HashMap();
    private Map customizerProviders = new HashMap();
    private Comparator featureComparator;
    private ClassRegistry classRegistry;
    private int defaultIconKind = 1;
    private BeanDropSupport beanDropSupport;
    private ClipboardManager clipboardManager;
    private UndoManager undoManager;

    public DefaultBeansToolkit(ClassRegistry classRegistry) {
        logger.fine("INIT BeansToolkit: " + this);
        this.setClassRegistry(classRegistry);
        this.initDefaultBeansToolkit();
        this.initDefaultPropertyEditors();
    }

    public DefaultBeansToolkit() {
        this(Platform.getInstance().getClassRegistry());
    }

    protected void initDefaultBeansToolkit() {
        this.iconCache = new IconCache(7);
        this.initDefaultIcons();
    }

    protected void initDefaultIcons() {
        this.registerIcon(this.getClass(), this.defaultIconKind, DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/bean.gif"));
        this.registerIcon(String.class, this.defaultIconKind, DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/string.gif"));
        Icon ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/bool.gif");
        this.registerIcon(Boolean.class, this.defaultIconKind, ico);
        this.registerIcon(Boolean.TYPE, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/byte.gif");
        this.registerIcon(Byte.class, this.defaultIconKind, ico);
        this.registerIcon(Byte.TYPE, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/char.gif");
        this.registerIcon(Character.class, this.defaultIconKind, ico);
        this.registerIcon(Character.TYPE, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/short.gif");
        this.registerIcon(Short.class, this.defaultIconKind, ico);
        this.registerIcon(Short.TYPE, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/integer.gif");
        this.registerIcon(Integer.class, this.defaultIconKind, ico);
        this.registerIcon(Integer.TYPE, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/long.gif");
        this.registerIcon(Long.class, this.defaultIconKind, ico);
        this.registerIcon(Long.TYPE, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/float.gif");
        this.registerIcon(Float.class, this.defaultIconKind, ico);
        this.registerIcon(Float.TYPE, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/double.gif");
        this.registerIcon(Double.class, this.defaultIconKind, ico);
        this.registerIcon(Double.TYPE, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/collection.gif");
        this.registerIcon(Collection.class, this.defaultIconKind, ico);
        this.registerIcon(HashSet.class, this.defaultIconKind, ico);
        this.registerIcon(TreeSet.class, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/array_list.gif");
        this.registerIcon(ArrayList.class, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/linked_list.gif");
        this.registerIcon(LinkedList.class, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/map.gif");
        this.registerIcon(Map.class, this.defaultIconKind, ico);
        this.registerIcon(HashMap.class, this.defaultIconKind, ico);
        this.registerIcon(TreeMap.class, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/file_icon.gif");
        this.registerIcon(File.class, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/url_icon.gif");
        this.registerIcon(URL.class, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/color_icon.gif");
        this.registerIcon(Color.class, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/font_icon.gif");
        this.registerIcon(Font.class, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/point_icon.gif");
        this.registerIcon(Point.class, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/dimension_icon.gif");
        this.registerIcon(Dimension.class, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/rectangle_icon.gif");
        this.registerIcon(Rectangle.class, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/insets_icon.gif");
        this.registerIcon(Insets.class, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/shape_icon.gif");
        this.registerIcon(Shape.class, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/polygon_icon.gif");
        this.registerIcon(Polygon.class, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/locale_icon.gif");
        this.registerIcon(Locale.class, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/datetime_icon.gif");
        this.registerIcon(Date.class, this.defaultIconKind, ico);
        this.registerIcon(Calendar.class, this.defaultIconKind, ico);
        ico = DefaultBeansToolkit.loadIcon("/com/spacekiller/util/beans/icons/timezone_icon.gif");
        this.registerIcon(TimeZone.class, this.defaultIconKind, ico);
        this.registerIconProvider(Class.class, new ClassIconProvider());
        this.registerIconProvider(Image.class, new ImageIconProvider());
        this.registerIconProvider(Color.class, new ColorIconProvider(this));
    }

    protected static Icon loadIcon(String resource) {
        try {
            URL url = DefaultBeansToolkit.class.getResource(resource);
            if (url == null) {
                return null;
            }
            return new ImageIcon(url);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    protected BeanInfo createBeanInfo(Class clazz) throws InstantiationException, IllegalAccessException, IntrospectionException {
        if (clazz == null) {
            return null;
        }
        try {
            BeanInfo introBeanInfo = Introspector.getBeanInfo(clazz);
            DefaultBeanInfo rc = new DefaultBeanInfo(introBeanInfo, this.getFeatureComparator());
            return rc;
        }
        catch (IntrospectionException e) {
            throw e;
        }
        catch (NullPointerException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new NullPointerException("" + e.getMessage() + " >> while introspecting " + clazz);
        }
    }

    protected Comparator createFeatureComparator() {
        return new DefaultFeatureDescriptorComparator();
    }

    public void unregisterCustomizerClass(Class beanClass, Class customizerClass) {
        if (beanClass == null || customizerClass == null) {
            return;
        }
        Vector v = (Vector)this.customizerTypes.get(beanClass);
        if (v == null) {
            return;
        }
        v.removeElement(customizerClass);
        if (v.isEmpty()) {
            this.customizerTypes.remove(beanClass);
        }
    }

    public void unregisterIndexedCustomizerClass(Class indexedPropertyType, Class customizerClass) {
        if (indexedPropertyType == null || customizerClass == null) {
            return;
        }
        Vector v = (Vector)this.indexedCustomizerTypes.get(indexedPropertyType);
        if (v == null) {
            return;
        }
        v.removeElement(customizerClass);
        if (v.isEmpty()) {
            this.indexedCustomizerTypes.remove(indexedPropertyType);
        }
    }

    public void unregisterIndexedPropertyEditorClass(Class indexedPropertyType, Class propertyEditorClass) {
        if (indexedPropertyType == null || propertyEditorClass == null) {
            return;
        }
        Vector v = (Vector)this.indexedPropertyEditorTypes.get(indexedPropertyType);
        if (v == null) {
            return;
        }
        v.removeElement(propertyEditorClass);
        if (v.isEmpty()) {
            this.indexedPropertyEditorTypes.remove(indexedPropertyType);
        }
    }

    public void unregisterPropertyEditorClass(Class beanClass, Class propertyEditorClass) {
        if (beanClass == null || propertyEditorClass == null) {
            return;
        }
        Vector v = (Vector)this.propertyEditorTypes.get(beanClass);
        if (v == null) {
            return;
        }
        v.removeElement(propertyEditorClass);
        if (v.isEmpty()) {
            this.propertyEditorTypes.remove(beanClass);
        }
    }

    protected void findCustomizerClasses(Class beanClass, Collection dstCustomizerClasses) throws Exception {
        BeanDescriptor beanDescr;
        Class<?> clazz;
        BeanInfo beanInfo = this.getBeanInfo(beanClass);
        if (beanInfo != null && (clazz = (beanDescr = beanInfo.getBeanDescriptor()).getCustomizerClass()) != null) {
            dstCustomizerClasses.add(clazz);
            return;
        }
    }

    protected void findPropertyEditorClasses(Class beanClass, Collection dstEditorClasses) {
        PropertyEditor editor = PropertyEditorManager.findEditor(beanClass);
        if (editor == null) {
            return;
        }
        Class<?> editorClass = editor.getClass();
        try {
            PropertyEditor instance = this.getPropertyEditor(editorClass);
            if (instance != null) {
                dstEditorClasses.add(editorClass);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public Icon getIcon(Class beanClass) {
        return this.getIcon(beanClass, this.defaultIconKind);
    }

    public Icon getIcon(Class beanClass, int iconKind) {
        if (beanClass == null) {
            return null;
        }
        Icon rc = this.iconCache.getIcon(beanClass, iconKind);
        if (rc != null) {
            return rc;
        }
        Class<?> clazz = beanClass;
        boolean isArray = clazz.isArray();
        if (isArray) {
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
            }
            rc = this.iconCache.getIcon(clazz, iconKind);
        }
        if (rc == null) {
            try {
                BeanInfo info = this.getBeanInfo(clazz);
                if (info != null) {
                    Image image;
                    int kind = iconKind;
                    if (kind > 4) {
                        kind = 2;
                    }
                    if ((image = info.getIcon(kind)) != null) {
                        rc = new ImageIcon(image);
                    }
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        if (rc != null) {
            if (isArray) {
                rc = this.createArrayIcon(rc);
            }
            this.iconCache.putIcon(beanClass, iconKind, rc);
            return rc;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == null || superClass == Object.class) {
            return null;
        }
        rc = this.getIcon(superClass, iconKind);
        if (rc != null && isArray) {
            rc = this.createArrayIcon(rc);
            this.iconCache.putIcon(beanClass, iconKind, rc);
            return rc;
        }
        return rc;
    }

    protected Icon createArrayIcon(Icon componentIcon) {
        return new ArrayIcon(componentIcon);
    }

    public BeanInfo getBeanInfo(Class clazz) throws InstantiationException, IllegalAccessException, IntrospectionException {
        if (clazz == null) {
            return null;
        }
        try {
            BeanInfo rc = (BeanInfo)this.beanInfos.get(clazz);
            if (rc == null && (rc = this.createBeanInfo(clazz)) != null) {
                this.beanInfos.put(clazz, rc);
            }
            return rc;
        }
        catch (Exception e) {
            logger.fine("Error getting BeanInfo for class: " + clazz.getName());
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new IntrospectionException("" + e);
        }
    }

    private Iterator getClasses(final Class clazz, final Iterator classes) {
        if (clazz == null) {
            return classes;
        }
        return new Iterator(){
            private Object obj;
            {
                this.obj = clazz;
            }

            @Override
            public boolean hasNext() {
                if (this.obj == null) {
                    return classes == null ? false : classes.hasNext();
                }
                return true;
            }

            public Object next() {
                if (this.obj == null) {
                    return classes.next();
                }
                Object rc = this.obj;
                this.obj = null;
                return rc;
            }

            @Override
            public void remove() {
            }
        };
    }

    public ClassRegistry getClassRegistry() {
        return this.classRegistry;
    }

    public Properties getCustomizations(Properties oldProps, Properties newProps) {
        Properties custom = new Properties();
        Enumeration<Object> en = newProps.keys();
        while (en.hasMoreElements()) {
            Object oldValue;
            String key = String.valueOf(en.nextElement());
            Object newValue = newProps.get(key);
            if (oldProps.containsKey(key) && (oldValue = oldProps.get(key)) == newValue) continue;
            custom.put(key, newValue);
        }
        return custom;
    }

    public Customizer createCustomizer(Class beanClass) throws Exception {
        Iterator classes = this.getCustomizerClasses(beanClass);
        while (classes.hasNext()) {
            Class customizerClass = (Class)classes.next();
            try {
                Customizer customizer = this.getCustomizer(customizerClass);
                if (customizer == null) continue;
                return customizer;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public Customizer getCustomizer(Class customizerClass) throws Exception {
        Customizer rc = (Customizer)this.getCustomizerFactory().create(customizerClass);
        return rc;
    }

    public Iterator getCustomizerClasses(PropertyDescriptor property) {
        if (property instanceof IndexedPropertyDescriptor) {
            return this.getIndexedCustomizerClasses((IndexedPropertyDescriptor)property);
        }
        return this.getCustomizerClasses(property.getPropertyType());
    }

    public Iterator getCustomizerClasses(Class beanClass) {
        ArrayList dst = new ArrayList();
        this.getCustomizerClasses(beanClass, dst);
        return dst.iterator();
    }

    protected void getCustomizerClasses(Class beanClass, Collection dst) {
        HashSet ifs = new HashSet();
        for (Class bc = beanClass; bc != null; bc = bc.getSuperclass()) {
            Vector v = (Vector)this.customizerTypes.get(bc);
            if (v == null) {
                v = new Vector();
                this.customizerTypes.put(bc, v);
                try {
                    this.findCustomizerClasses(bc, v);
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
            dst.addAll(v);
            this.getInterfaces(bc, ifs);
        }
        for (Class bc : ifs) {
            Vector v = (Vector)this.customizerTypes.get(bc);
            if (v == null) {
                v = new Vector();
                this.customizerTypes.put(bc, v);
                try {
                    this.findCustomizerClasses(bc, v);
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
            dst.addAll(v);
        }
    }

    public Iterator getCustomizerClasses(Object bean) {
        Iterator rc;
        if (bean == null) {
            return null;
        }
        if (bean instanceof Customizable && (rc = ((Customizable)bean).getCustomizerClasses()) != null) {
            return rc;
        }
        Class<?> beanClass = bean.getClass();
        ArrayList list = new ArrayList();
        this.getProviderCustomizerClasses(bean, list);
        this.getCustomizerClasses(beanClass, list);
        return list.iterator();
    }

    private void getProviderCustomizerClasses(Object bean, Collection dst) {
        if (bean == null) {
            return;
        }
        Class<?> beanClass = bean.getClass();
        HashSet interfaces = new HashSet();
        for (Class<?> bc = beanClass; bc != null; bc = bc.getSuperclass()) {
            List provList = (List)this.customizerProviders.get(bc);
            if (provList != null) {
                for (CustomizerProvider cp : provList) {
                    Class[] ccs = cp.getCustomizerClasses(bean);
                    if (ccs == null) continue;
                    for (int j = 0; j < ccs.length; ++j) {
                        Class cc = ccs[j];
                        if (cc == null) continue;
                        dst.add(cc);
                    }
                }
            }
            this.getInterfaces(bc, interfaces);
        }
        for (Class bc : interfaces) {
            List provList = (List)this.customizerProviders.get(bc);
            if (provList == null) continue;
            for (CustomizerProvider cp : provList) {
                Class[] ccs = cp.getCustomizerClasses(bean);
                if (ccs == null) continue;
                for (int j = 0; j < ccs.length; ++j) {
                    Class cc = ccs[j];
                    if (cc == null) continue;
                    dst.add(cc);
                }
            }
        }
    }

    private void getInterfaces(Class clazz, Set dst) {
        Class<?>[] ifs = clazz.getInterfaces();
        for (int i = 0; i < ifs.length; ++i) {
            if (!dst.add(ifs[i])) continue;
            this.getInterfaces(ifs[i], dst);
        }
    }

    public PropertyEditor getDefaultPropertyEditor(PropertyDescriptor property) throws Exception {
        Class editorClass = null;
        Iterator i = this.getPropertyEditorClasses(property);
        if (i.hasNext()) {
            editorClass = (Class)i.next();
        }
        return editorClass == null ? null : this.getPropertyEditor(editorClass);
    }

    protected Comparator getFeatureComparator() {
        if (this.featureComparator == null) {
            this.featureComparator = this.createFeatureComparator();
        }
        return this.featureComparator;
    }

    public Iterator getIndexedCustomizerClasses(IndexedPropertyDescriptor property) {
        Class<?> indexedPropertyType = property.getIndexedPropertyType();
        Vector v = indexedPropertyType == null ? null : (Vector)this.indexedCustomizerTypes.get(indexedPropertyType);
        return v == null ? null : v.iterator();
    }

    public Iterator getIndexedPropertyEditorClasses(IndexedPropertyDescriptor property) {
        Class<?> indexedPropertyType = property.getIndexedPropertyType();
        Vector v = indexedPropertyType == null ? null : (Vector)this.indexedPropertyEditorTypes.get(indexedPropertyType);
        return this.getClasses(property.getPropertyEditorClass(), v == null ? null : v.iterator());
    }

    public PropertyEditor createPropertyEditor(PropertyDescriptor property) throws Exception {
        Class<?> editorClass = property.getPropertyEditorClass();
        if (editorClass != null) {
            try {
                PropertyEditor propertyEditor = this.getPropertyEditor(editorClass);
                if (propertyEditor != null) {
                    return propertyEditor;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Class<?> propertyType = property.getPropertyType();
        return this.createPropertyEditor(propertyType);
    }

    public PropertyEditor createPropertyEditor(Class propertyType) throws Exception {
        if (propertyType != null) {
            Iterator classes = this.getPropertyEditorClasses(propertyType);
            while (classes.hasNext()) {
                Class editorClass = (Class)classes.next();
                try {
                    PropertyEditor propertyEditor = this.getPropertyEditor(editorClass);
                    if (propertyEditor == null) continue;
                    return propertyEditor;
                }
                catch (Exception e) {
                }
            }
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(propertyType);
            if (propertyEditor != null) {
                return propertyEditor;
            }
        }
        return null;
    }

    public PropertyEditor getPropertyEditor(Class propertyEditorClass) throws Exception {
        PropertyEditor rc = (PropertyEditor)this.getPropertyEditorFactory().create(propertyEditorClass);
        return rc;
    }

    public Iterator getPropertyEditorClasses(PropertyDescriptor property) {
        if (property instanceof IndexedPropertyDescriptor) {
            return this.getIndexedPropertyEditorClasses((IndexedPropertyDescriptor)property);
        }
        return this.getClasses(property.getPropertyEditorClass(), this.getPropertyEditorClasses(property.getPropertyType()));
    }

    public Iterator getPropertyEditorClasses(Class beanClass) {
        Vector v = (Vector)this.propertyEditorTypes.get(beanClass);
        if (v == null) {
            v = new Vector();
            this.propertyEditorTypes.put(beanClass, v);
            try {
                this.findPropertyEditorClasses(beanClass, v);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        if (v.isEmpty()) {
            // empty if block
        }
        return v.iterator();
    }

    public Iterator getPropertyEditorClasses(Object bean) {
        return this.getPropertyEditorClasses(bean.getClass());
    }

    protected final void initDefaultPropertyEditor(Class beanClass, Class editorClass) {
        this.registerPropertyEditorClass(beanClass, editorClass);
        PropertyEditorManager.registerEditor(beanClass, editorClass);
    }

    protected void initDefaultPropertyEditors() {
        this.initPrimitivePropertyEditors();
    }

    protected final void initPrimitivePropertyEditors() {
        this.initPrimitiveWrapperPropertyEditor(Boolean.class, Boolean.TYPE);
        this.initPrimitiveWrapperPropertyEditor(Byte.class, Byte.TYPE);
        this.initPrimitiveWrapperPropertyEditor(Character.class, Character.TYPE);
        this.initPrimitiveWrapperPropertyEditor(Double.class, Double.TYPE);
        this.initPrimitiveWrapperPropertyEditor(Float.class, Float.TYPE);
        this.initPrimitiveWrapperPropertyEditor(Integer.class, Integer.TYPE);
        this.initPrimitiveWrapperPropertyEditor(Long.class, Long.TYPE);
        this.initPrimitiveWrapperPropertyEditor(Short.class, Short.TYPE);
    }

    private void initPrimitiveWrapperPropertyEditor(Class wrapperClass, Class primitiveType) {
        PropertyEditor wrapperEditor = PropertyEditorManager.findEditor(wrapperClass);
        if (wrapperEditor == null) {
            wrapperEditor = PropertyEditorManager.findEditor(primitiveType);
            if (wrapperEditor == null) {
                return;
            }
            PropertyEditorManager.registerEditor(wrapperClass, wrapperEditor.getClass());
        }
        Class<?> editorClass = wrapperEditor.getClass();
        try {
            PropertyEditor instance = this.getPropertyEditor(editorClass);
            if (instance != null) {
                this.registerPropertyEditorClass(wrapperClass, editorClass);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void registerCustomizerClass(Class beanClass, Class customizerClass) {
        if (beanClass == null || customizerClass == null) {
            return;
        }
        Vector<Class> v = (Vector<Class>)this.customizerTypes.get(beanClass);
        if (v == null) {
            v = new Vector<Class>();
            this.customizerTypes.put(beanClass, v);
        }
        v.addElement(customizerClass);
    }

    public void registerCustomizerClass(String beanClassName, String customizerClassName) throws Exception {
        Class beanClass = this.getClassRegistry().getClass(beanClassName);
        Class customClass = this.getClassRegistry().getClass(customizerClassName);
        this.registerCustomizerClass(beanClass, customClass);
    }

    public void registerIndexedCustomizerClass(Class indexedPropertyType, Class customizerClass) {
        if (indexedPropertyType == null || customizerClass == null) {
            return;
        }
        Vector<Class> v = (Vector<Class>)this.indexedCustomizerTypes.get(indexedPropertyType);
        if (v == null) {
            v = new Vector<Class>();
            this.indexedCustomizerTypes.put(indexedPropertyType, v);
        }
        v.addElement(customizerClass);
    }

    public void registerIndexedPropertyEditorClass(Class indexedPropertyType, Class propertyEditorClass) {
        if (indexedPropertyType == null || propertyEditorClass == null) {
            return;
        }
        Vector<Class> v = (Vector<Class>)this.indexedPropertyEditorTypes.get(indexedPropertyType);
        if (v == null) {
            v = new Vector<Class>();
            this.indexedPropertyEditorTypes.put(indexedPropertyType, v);
        }
        v.addElement(propertyEditorClass);
    }

    public void registerPropertyEditorClass(Class beanClass, Class propertyEditorClass) {
        if (beanClass == null || propertyEditorClass == null) {
            return;
        }
        Vector<Class> v = (Vector<Class>)this.propertyEditorTypes.get(beanClass);
        if (v == null) {
            v = new Vector<Class>();
            this.propertyEditorTypes.put(beanClass, v);
        }
        v.addElement(propertyEditorClass);
    }

    public void registerPropertyEditorClass(String beanClassName, String propertyEditorClassName) throws Exception {
        Class beanClass = this.getClassRegistry().getClass(beanClassName);
        Class editorClass = this.getClassRegistry().getClass(propertyEditorClassName);
        this.registerPropertyEditorClass(beanClass, editorClass);
    }

    public void registerIcon(Class beanClass, int iconKind, Icon icon) {
        if (beanClass != null && icon != null) {
            this.iconCache.putIcon(beanClass, iconKind, icon);
        }
    }

    public void unregisterIcon(Class beanClass, int iconKind) {
        if (beanClass != null) {
            this.iconCache.removeIcon(beanClass, iconKind);
        }
    }

    public void registerIconProvider(Class beanClass, IconProvider iconProvider) {
        if (beanClass != null && iconProvider != null) {
            this.iconProviders.put(beanClass, iconProvider);
        }
    }

    public void unregisterIconProvider(Class beanClass) {
        if (beanClass != null) {
            this.iconProviders.remove(beanClass);
        }
    }

    public void registerCustomizerProvider(Class beanClass, CustomizerProvider customizerProvider) {
        if (beanClass != null && customizerProvider != null) {
            ArrayList<CustomizerProvider> list = (ArrayList<CustomizerProvider>)this.customizerProviders.get(beanClass);
            if (list == null) {
                list = new ArrayList<CustomizerProvider>();
                this.customizerProviders.put(beanClass, list);
            }
            list.add(customizerProvider);
        }
    }

    public void unregisterCustomizerProvider(Class beanClass, CustomizerProvider customizerProvider) {
        if (beanClass != null) {
            // empty if block
        }
    }

    protected void setClassRegistry(ClassRegistry newClassRegistry) {
        this.classRegistry = newClassRegistry;
    }

    void setFeatureComparator(Comparator newFeatureComparator) {
        this.featureComparator = newFeatureComparator;
    }

    public Icon getIcon(Object bean) {
        return this.getIcon(bean, this.defaultIconKind);
    }

    public Icon getIcon(Object bean, int iconKind) {
        if (bean == null) {
            return null;
        }
        Class<?> beanClass = bean.getClass();
        Class<?> clazz = beanClass;
        if (!clazz.isArray()) {
            while (clazz != null) {
                Icon icon;
                IconProvider ip = (IconProvider)this.iconProviders.get(clazz);
                if (ip != null && (icon = ip.getIcon(bean, iconKind)) != null) {
                    return icon;
                }
                clazz = clazz.getSuperclass();
            }
        }
        return this.getIcon(beanClass, iconKind);
    }

    protected Factory createCustomizerFactory() {
        return Factory.DEFAULT;
    }

    protected Factory getCustomizerFactory() {
        if (this.customizerFactory == null) {
            this.setCustomizerFactory(this.createCustomizerFactory());
        }
        return this.customizerFactory;
    }

    protected void setCustomizerFactory(Factory customizerFactory) {
        this.customizerFactory = customizerFactory;
    }

    protected Factory createPropertyEditorFactory() {
        return Factory.DEFAULT;
    }

    protected Factory getPropertyEditorFactory() {
        if (this.propertyEditorFactory == null) {
            this.setPropertyEditorFactory(this.createPropertyEditorFactory());
        }
        return this.propertyEditorFactory;
    }

    protected void setPropertyEditorFactory(Factory propertyEditorFactory) {
        this.propertyEditorFactory = propertyEditorFactory;
    }

    public int getDefaultIconKind() {
        return this.defaultIconKind;
    }

    protected void setDefaultIconKind(int defaultIconKind) {
        this.defaultIconKind = defaultIconKind;
    }

    @Override
    public BeanDropSupport getBeanDropSupport() {
        return this.beanDropSupport;
    }

    public void setBeanDropSupport(BeanDropSupport bds) {
        this.beanDropSupport = bds;
    }

    @Override
    public ClipboardManager getClipboardManager() {
        return this.clipboardManager;
    }

    public void setClipboardManager(ClipboardManager cm) {
        this.clipboardManager = cm;
    }

    public Icon getDefaultIcon() {
        return this.getDefaultIcon(this.defaultIconKind);
    }

    public Icon getDefaultIcon(int kind) {
        return this.getIcon(this.getClass(), kind);
    }

    public Dimension getIconKindSize(int iconKind) {
        switch (iconKind) {
            case 1: 
            case 3: {
                return new Dimension(16, 16);
            }
            case 2: 
            case 4: {
                return new Dimension(32, 32);
            }
            case 5: {
                return new Dimension(48, 48);
            }
            case 6: {
                return new Dimension(64, 64);
            }
        }
        return new Dimension(16, 16);
    }

    @Override
    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    public PropertyDescriptor getPropertyDescriptor(Class clazz, String propertyName) throws InstantiationException, IntrospectionException, IllegalAccessException {
        BeanInfo info = this.getBeanInfo(clazz);
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        int n = pds.length;
        for (int i = 0; i < n; ++i) {
            if (!propertyName.equals(pds[i].getName())) continue;
            return pds[i];
        }
        throw new IntrospectionException("Property '" + propertyName + "' not found for type: " + clazz.getName());
    }
}

