/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import java.beans.FeatureDescriptor;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.util.Comparator;

public class DefaultFeatureDescriptorComparator
implements Comparator {
    private boolean comparePreferredFlag;
    private boolean compareExpertFlag;
    private boolean compareHiddenFlag;

    public DefaultFeatureDescriptorComparator() {
        this(true, true, true);
    }

    public DefaultFeatureDescriptorComparator(boolean newComparePreferredFlag, boolean newCompareExpertFlag, boolean newCompareHiddenFlag) {
        this.setComparePreferredFlag(newComparePreferredFlag);
        this.setCompareExpertFlag(newCompareExpertFlag);
        this.setCompareHiddenFlag(newCompareHiddenFlag);
    }

    protected int compare(FeatureDescriptor a, FeatureDescriptor b) {
        boolean bb;
        boolean ba;
        int pb;
        int pa = this.getFeaturePriority(a);
        if (pa != (pb = this.getFeaturePriority(b))) {
            return pa > pb ? -1 : 1;
        }
        if (this.compareHiddenFlag && (ba = a.isHidden()) != (bb = b.isHidden())) {
            return ba ? 1 : -1;
        }
        if (this.compareExpertFlag && (ba = a.isExpert()) != (bb = b.isExpert())) {
            return ba ? 1 : -1;
        }
        if (this.comparePreferredFlag && (ba = DefaultFeatureDescriptorComparator.isPreferredFeature(a)) != (bb = DefaultFeatureDescriptorComparator.isPreferredFeature(b))) {
            return ba ? -1 : 1;
        }
        return a.getName().compareToIgnoreCase(b.getName());
    }

    public int compare(Object a, Object b) {
        return this.compare((FeatureDescriptor)a, (FeatureDescriptor)b);
    }

    protected int getFeaturePriority(FeatureDescriptor descr) {
        if (descr instanceof PropertyDescriptor) {
            return 20;
        }
        if (descr instanceof MethodDescriptor) {
            return 10;
        }
        return 0;
    }

    public boolean isCompareExpertFlag() {
        return this.compareExpertFlag;
    }

    public boolean isCompareHiddenFlag() {
        return this.compareHiddenFlag;
    }

    public boolean isComparePreferredFlag() {
        return this.comparePreferredFlag;
    }

    public static boolean isPreferredFeature(FeatureDescriptor f) {
        if (f.isPreferred()) {
            return true;
        }
        Object o = f.getValue("preferred");
        if (o != null && o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    private void setCompareExpertFlag(boolean newCompareExpertFlag) {
        this.compareExpertFlag = newCompareExpertFlag;
    }

    private void setCompareHiddenFlag(boolean newCompareHiddenFlag) {
        this.compareHiddenFlag = newCompareHiddenFlag;
    }

    private void setComparePreferredFlag(boolean newComparePreferredFlag) {
        this.comparePreferredFlag = newComparePreferredFlag;
    }
}

