/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.beans.FeatureDescriptorFilter;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;

public class DefaultFeatureDescriptorFilter
implements FeatureDescriptorFilter {
    private boolean includeProperties;
    private boolean includeMethods;
    private boolean includeEvents;
    private boolean includeExpert;
    private boolean includeHidden;
    private boolean includeReadOnly;

    public DefaultFeatureDescriptorFilter(boolean properties, boolean methods, boolean events, boolean expert, boolean hidden, boolean readonly) {
        this.setIncludeProperties(properties);
        this.setIncludeMethods(methods);
        this.setIncludeEvents(events);
        this.setIncludeExpert(expert);
        this.setIncludeHidden(hidden);
        this.setIncludeReadOnly(readonly);
    }

    @Override
    public boolean accept(BeanInfo beanInfo, FeatureDescriptor descriptor) {
        if (descriptor instanceof PropertyDescriptor && this.acceptProperty((PropertyDescriptor)descriptor)) {
            return true;
        }
        if (descriptor instanceof MethodDescriptor && this.acceptMethod((MethodDescriptor)descriptor)) {
            return true;
        }
        return descriptor instanceof EventSetDescriptor && this.acceptEvent((EventSetDescriptor)descriptor);
    }

    protected boolean acceptEvent(EventSetDescriptor descriptor) {
        if (!this.isIncludeEvents()) {
            return false;
        }
        if (!this.isIncludeHidden() && descriptor.isHidden()) {
            return false;
        }
        return this.isIncludeExpert() || !descriptor.isExpert();
    }

    protected boolean acceptMethod(MethodDescriptor descriptor) {
        if (!this.isIncludeMethods()) {
            return false;
        }
        if (!this.isIncludeHidden() && descriptor.isHidden()) {
            return false;
        }
        return this.isIncludeExpert() || !descriptor.isExpert();
    }

    protected boolean acceptProperty(PropertyDescriptor descriptor) {
        if (!this.isIncludeProperties()) {
            return false;
        }
        if (!this.isIncludeHidden() && descriptor.isHidden()) {
            return false;
        }
        if (!this.isIncludeExpert() && descriptor.isExpert()) {
            return false;
        }
        if (descriptor.getReadMethod() == null) {
            return false;
        }
        return this.isIncludeReadOnly() || descriptor.getWriteMethod() != null;
    }

    public boolean isIncludeEvents() {
        return this.includeEvents;
    }

    public boolean isIncludeExpert() {
        return this.includeExpert;
    }

    public boolean isIncludeHidden() {
        return this.includeHidden;
    }

    public boolean isIncludeMethods() {
        return this.includeMethods;
    }

    public boolean isIncludeProperties() {
        return this.includeProperties;
    }

    public boolean isIncludeReadOnly() {
        return this.includeReadOnly;
    }

    private void setIncludeEvents(boolean newIncludeEvents) {
        this.includeEvents = newIncludeEvents;
    }

    private void setIncludeExpert(boolean newIncludeExpert) {
        this.includeExpert = newIncludeExpert;
    }

    private void setIncludeHidden(boolean newIncludeHidden) {
        this.includeHidden = newIncludeHidden;
    }

    private void setIncludeMethods(boolean newIncludeMethods) {
        this.includeMethods = newIncludeMethods;
    }

    private void setIncludeProperties(boolean newIncludeProperties) {
        this.includeProperties = newIncludeProperties;
    }

    private void setIncludeReadOnly(boolean newIncludeReadOnly) {
        this.includeReadOnly = newIncludeReadOnly;
    }
}

