/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.beans.DefaultBeanContextServices;
import com.spacekiller.util.beans.TypeContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultTypeContext
extends DefaultBeanContextServices
implements TypeContext {
    private static final long serialVersionUID = 879846513156645623L;
    private String name;
    private List beanTypes = new ArrayList();

    public DefaultTypeContext(String name, Class[] beanTypes) {
        this.setName(name);
        for (int c = 0; c < beanTypes.length; ++c) {
            this.addBeanType(beanTypes[c]);
        }
    }

    public DefaultTypeContext(String name, Class beanType) {
        this.setName(name);
        this.addBeanType(beanType);
    }

    @Override
    public boolean add(Object targetChild) {
        if (!this.supports(targetChild)) {
            return false;
        }
        return super.add(targetChild);
    }

    protected void addBeanType(Class type) {
        this.insertBeanTypeAt(type, this.getBeanTypeCount());
    }

    public Class getBeanTypeAt(int i) {
        return (Class)this.beanTypes.get(i);
    }

    public int getBeanTypeCount() {
        return this.beanTypes.size();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Iterator getSupportedTypes() {
        return this.beanTypes.iterator();
    }

    protected void insertBeanTypeAt(Class type, int i) {
        if (type == null) {
            return;
        }
        if (this.beanTypes.contains(type)) {
            return;
        }
        this.beanTypes.add(i, type);
    }

    protected void removeBeanType(Class type) {
        this.beanTypes.remove(type);
    }

    protected void removeBeanTypeAt(int i) {
        this.beanTypes.remove(i);
    }

    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public boolean supports(Class type) {
        int count = this.getBeanTypeCount();
        for (int c = 0; c < count; ++c) {
            Class beanType = this.getBeanTypeAt(c);
            if (!beanType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supports(Object bean) {
        return this.supports(bean.getClass());
    }

    public String toString() {
        return String.valueOf(this.getName());
    }
}

