/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.beans.DynamicBean;
import com.spacekiller.util.beans.Property;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DynamicPropertyDescriptor
extends PropertyDescriptor {
    private static Method dynamicReadMethod;
    private static Method dynamicWriteMethod;
    private Class propertyType;
    private static final Logger logger;

    public DynamicPropertyDescriptor(String name) throws IntrospectionException {
        super(name, Object.class, null, null);
    }

    public DynamicPropertyDescriptor(String name, Class propertyType) throws IntrospectionException {
        this(name);
        this.setPropertyType(propertyType);
    }

    public Class getPropertyType() {
        Class rc = this.getSuperPropertyType();
        if (rc == null) {
            rc = this.propertyType;
        }
        return rc;
    }

    protected Class getSuperPropertyType() {
        return super.getPropertyType();
    }

    public static void main(String[] args) {
        try {
            DynamicPropertyDescriptor descr = new DynamicPropertyDescriptor("hello", (Class)Integer.class);
            logger.fine("==> Descr=" + descr);
            logger.fine("==> Type=" + ((PropertyDescriptor)descr).getPropertyType());
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void setPropertyType(Class newPropertyType) {
        this.propertyType = newPropertyType;
    }

    public Object getValue(Object bean) throws IllegalAccessException, InvocationTargetException {
        Property prop = ((DynamicBean)bean).getProperty(this.getName());
        return prop == null ? null : prop.getValue();
    }

    public void setValue(Object bean, Object value) throws IllegalAccessException, InvocationTargetException, PropertyVetoException {
        Property prop = ((DynamicBean)bean).getProperty(this.getName());
        if (prop != null) {
            prop.setValue(value);
        }
    }

    protected static Method getDynamicReadMethod() {
        if (dynamicReadMethod == null) {
            try {
                dynamicReadMethod = DynamicPropertyDescriptor.class.getMethod("getValue", Object.class);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return dynamicReadMethod;
    }

    protected static Method getDynamicWriteMethod() {
        if (dynamicWriteMethod == null) {
            try {
                dynamicWriteMethod = DynamicPropertyDescriptor.class.getMethod("setValue", Object.class, Object.class);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return dynamicWriteMethod;
    }

    @Override
    public synchronized Method getReadMethod() {
        return DynamicPropertyDescriptor.getDynamicReadMethod();
    }

    @Override
    public synchronized Method getWriteMethod() {
        return DynamicPropertyDescriptor.getDynamicWriteMethod();
    }

    static {
        logger = Logger.getLogger(DynamicPropertyDescriptor.class.getName());
    }
}

