/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.FileLink;
import com.spacekiller.util.FileType;
import com.spacekiller.util.beans.CustomizerProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileCustomizerProvider
implements CustomizerProvider {
    private Class[] beanTypes;
    private List fileTypes = new ArrayList();
    private Map fileTypeByExtension = new HashMap();
    private static final Logger logger = Logger.getLogger(FileCustomizerProvider.class.getName());

    @Override
    public Class[] getBeanTypes() {
        return this.beanTypes;
    }

    public void setBeanTypes(Class[] beanTypes) {
        this.beanTypes = beanTypes;
    }

    @Override
    public Class[] getCustomizerClasses(Object bean) {
        if (bean == null) {
            return null;
        }
        if (bean instanceof FileLink) {
            return this.getFileCustomizerClasses(((FileLink)bean).getFile());
        }
        if (bean instanceof File) {
            return this.getFileCustomizerClasses((File)bean);
        }
        return null;
    }

    protected Class[] getFileCustomizerClasses(File file) {
        if (file.getParentFile() == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        if (file.isDirectory()) {
            return null;
        }
        ArrayList rcList = null;
        String name = file.getName().toLowerCase();
        int i = name.indexOf(46);
        while (i >= 0) {
            FileType fileType = (FileType)this.fileTypeByExtension.get(name.substring(i));
            if (fileType != null) {
                String[] classNames = fileType.getCustomizerClassNames();
                if (classNames == null) break;
                if (rcList == null) {
                    rcList = new ArrayList();
                }
                for (int j = 0; j < classNames.length; ++j) {
                    String cn = classNames[j];
                    if (cn == null) continue;
                    try {
                        Class<?> customClass = Class.forName(cn);
                        rcList.add(customClass);
                        continue;
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                break;
            }
            i = name.indexOf(46, i + 1);
        }
        if (rcList == null) {
            return null;
        }
        Class[] rc = new Class[rcList.size()];
        rc = rcList.toArray(rc);
        return rc;
    }

    public void registerFileType(FileType type) {
        if (type == null) {
            return;
        }
        this.fileTypes.add(type);
        String[] ext = type.getFileExtensions();
        if (ext != null) {
            for (int c = 0; c < ext.length; ++c) {
                String x = ext[c];
                if (x == null || this.fileTypeByExtension.containsKey(x = x.toLowerCase())) continue;
                this.fileTypeByExtension.put(x, type);
            }
        }
    }

    public void unregisterFileType(FileType type) {
        if (type == null) {
            return;
        }
        if (this.fileTypes.remove(type)) {
            Iterator i = this.fileTypeByExtension.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry me = i.next();
                if (me.getValue() != type) continue;
                i.remove();
            }
        }
    }
}

