/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import com.spacekiller.util.beans.IconProvider;
import java.awt.Image;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ImageIconProvider
implements IconProvider {
    private static final Class[] BEAN_TYPES = new Class[]{Image.class};
    public static final int DEFAULT_CACHE_SIZE = 256;
    private Map[] cache = new Map[7];

    public ImageIconProvider() {
        this(256);
    }

    public ImageIconProvider(int cacheSize) {
        for (int c = 0; c < this.cache.length; ++c) {
            this.cache[c] = new WeakHashMap();
        }
    }

    @Override
    public Class[] getBeanTypes() {
        return BEAN_TYPES;
    }

    @Override
    public Icon getIcon(Object bean, int iconKind) {
        if (bean instanceof Image) {
            return this.getImageIcon((Image)bean, iconKind);
        }
        return null;
    }

    protected Icon getImageIcon(Image image, int iconKind) {
        if (iconKind < 0 || iconKind >= 7) {
            return null;
        }
        Map map = this.cache[iconKind];
        Icon icon = (Icon)map.get(image);
        if (icon == null && (icon = this.createImageIcon(image, iconKind)) != null) {
            map.put(image, icon);
        }
        return icon;
    }

    protected Icon createImageIcon(Image image, int iconKind) {
        int w = -1;
        int h = -1;
        switch (iconKind) {
            case 1: 
            case 3: {
                w = 16;
                h = 16;
                break;
            }
            case 2: 
            case 4: {
                w = 32;
                h = 32;
                break;
            }
            case 5: {
                w = 48;
                h = 48;
                break;
            }
            case 6: {
                w = 64;
                h = 64;
            }
        }
        if (w < 0 || h < 0) {
            return null;
        }
        Image scaled = image.getScaledInstance(w, h, 2);
        ImageIcon icon = new ImageIcon(scaled);
        return icon;
    }
}

