/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;

public abstract class PropertySupport {
    private ChangeHandler changeHandler;
    private PropertyChangeSupport propertyChangeSupport;
    private VetoableChangeSupport vetoableChangeSupport;

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.getPropertyChangeSupport().addPropertyChangeListener(pcl);
    }

    public void addVetoableChangeListener(VetoableChangeListener vcl) {
        this.getVetoableChangeSupport().addVetoableChangeListener(vcl);
    }

    protected ChangeHandler createChangeHandler() {
        return new ChangeHandler();
    }

    protected PropertyChangeSupport createPropertyChangeSupport() {
        return new PropertyChangeSupport(this);
    }

    protected VetoableChangeSupport createVetoableChangeSupport() {
        return new VetoableChangeSupport(this);
    }

    protected ChangeHandler getChangeHandler() {
        if (this.changeHandler == null) {
            this.setChangeHandler(this.createChangeHandler());
        }
        return this.changeHandler;
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.setPropertyChangeSupport(this.createPropertyChangeSupport());
        }
        return this.propertyChangeSupport;
    }

    protected VetoableChangeSupport getVetoableChangeSupport() {
        if (this.vetoableChangeSupport == null) {
            this.setVetoableChangeSupport(this.createVetoableChangeSupport());
        }
        return this.vetoableChangeSupport;
    }

    protected synchronized void handlePropertyChange(PropertyChangeEvent e) {
        this.getPropertyChangeSupport().firePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
    }

    protected synchronized void handleVetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        this.getVetoableChangeSupport().fireVetoableChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.getPropertyChangeSupport().removePropertyChangeListener(pcl);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vcl) {
        this.getVetoableChangeSupport().removeVetoableChangeListener(vcl);
    }

    protected void setChangeHandler(ChangeHandler handler) {
        this.changeHandler = handler;
    }

    protected void setPropertyChangeSupport(PropertyChangeSupport newPropertyChangeSupport) {
        this.propertyChangeSupport = newPropertyChangeSupport;
    }

    protected void setVetoableChangeSupport(VetoableChangeSupport newVetoableChangeSupport) {
        this.vetoableChangeSupport = newVetoableChangeSupport;
    }

    public class ChangeHandler
    implements PropertyChangeListener,
    VetoableChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            PropertySupport.this.handlePropertyChange(e);
        }

        @Override
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            PropertySupport.this.handleVetoableChange(e);
        }
    }
}

