/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.beans;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SerializedTransferable
implements Transferable {
    private DataFlavor flavor;
    private byte[] data;
    private static final Logger logger = Logger.getLogger(SerializedTransferable.class.getName());

    public SerializedTransferable(byte[] data, DataFlavor flavor) {
        this.data = data;
        this.flavor = flavor;
    }

    public SerializedTransferable(Object object) throws IOException {
        Class<?> clazz = object.getClass();
        String name = clazz.getName();
        this.flavor = new DataFlavor(clazz, name);
        this.data = this.serialize(object);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this.flavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor f) {
        return f.isFlavorSerializedObjectType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] serialize(Object o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            byte[] b;
            oos.writeObject(o);
            oos.flush();
            baos.flush();
            byte[] byArray = b = baos.toByteArray();
            return byArray;
        }
        finally {
            oos.close();
        }
    }

    protected Object deserialize(byte[] data) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        ObjectInputStream ois = new ObjectInputStream(bais);
        try {
            Object obj;
            Object object = obj = ois.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new IOException("" + e);
        }
        finally {
            ois.close();
        }
    }

    @Override
    public Object getTransferData(DataFlavor f) throws UnsupportedFlavorException, IOException {
        if (!f.isFlavorSerializedObjectType()) {
            throw new UnsupportedFlavorException(f);
        }
        try {
            Object obj = this.deserialize(this.data);
            return obj;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("" + e);
        }
    }

    public int getSerializedDataLength() {
        return this.data.length;
    }

    public void copySerializedData(byte[] dst, int off, int len) {
        System.arraycopy(this.data, 0, dst, off, len);
    }
}

