/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.player;

import com.spacekiller.util.media.AbstractPlayer;
import com.spacekiller.util.media.PlayerItem;
import com.spacekiller.util.sound.RawSampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleCursor;
import com.spacekiller.util.sound.SampleType;
import com.spacekiller.util.sound.SoundUtil;
import com.waxmonster.audio.player.AbstractAudioPlayer;
import com.waxmonster.audio.player.AudioPlayerItem;
import java.io.InputStream;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class AudioPlayerCursor
implements SampleCursor,
Runnable {
    private static final Logger logger = Logger.getLogger(AudioPlayerCursor.class.getName());
    protected static final int ACTION_IDLE = 0;
    protected static final int ACTION_ACTIVE = 1;
    protected static final int ACTION_RECYCLE = 2;
    protected static final int ACTION_SHUTDOWN = 3;
    private final AbstractAudioPlayer player;
    private int action;
    private final int nc;
    private final float fr;
    private final int bs;
    private final AudioFormat af;
    private final Buf first;
    private final Buf last;
    private volatile Buf buf;
    private long bp;
    private volatile PlayerItem item;
    private volatile long isp;
    private volatile long pos;
    private AudioInputStream is;
    private RawSampleBuffer rb;
    private int rs;
    private int ss;
    private volatile long outs;
    private volatile long debugTime = Long.MIN_VALUE;

    public AudioPlayerCursor(AbstractAudioPlayer player, int channels, float frameRate, int bufferSamples) {
        if (player == null) {
            throw new NullPointerException("player");
        }
        this.player = player;
        this.nc = channels;
        this.fr = frameRate;
        this.bs = bufferSamples;
        this.af = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, frameRate, -1, channels, -1, frameRate, false);
        this.pos = 0L;
        this.first = new Buf(new double[bufferSamples]);
        this.first.abs = this.pos;
        this.last = new Buf(new double[bufferSamples]);
        this.last.abs = this.pos + (long)bufferSamples;
        this.first.next = this.last;
        this.last.next = this.first;
        this.buf = this.first;
    }

    public String toString() {
        return super.toString() + "[player=" + (Object)((Object)this.player) + "]";
    }

    public AbstractPlayer getPlayer() {
        return this.player;
    }

    protected synchronized void reset(AudioPlayerItem item, long framePos) throws Exception {
        this.prepare(item, framePos);
        this.pos = 0L;
        this.isp = this.pos - framePos * (long)this.nc;
        this.bp = 0L;
        this.first.ready = false;
        this.loadBuf(this.first);
        this.last.ready = false;
        this.loadBuf(this.last);
        this.bufferSwitch(this.first);
    }

    protected synchronized void closeStream() {
        AudioInputStream oldStream = this.is;
        if (oldStream == null) {
            return;
        }
        this.is = null;
        if (oldStream != null) {
            try {
                AbstractAudioPlayer player = this.player;
                if (player != null) {
                    PlayerItem oldItem = this.item;
                    player.closeAudioInputStream(oldStream, oldItem);
                } else {
                    oldStream.close();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected synchronized boolean prepare(AudioPlayerItem item, long framePos) throws Exception {
        this.closeStream();
        AbstractAudioPlayer player = this.player;
        if (player == null) {
            return false;
        }
        if (item != this.item) {
            this.item = item;
            player.fireItem(this);
        }
        if (item == null) {
            return false;
        }
        AudioFormat targetFormat = this.af;
        boolean seekable = true;
        AudioInputStream ais = player.createAudioInputStream(item, targetFormat, seekable, framePos);
        if (ais == null) {
            return false;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Created audio stream: " + ais);
        }
        AudioFormat inputFormat = ais.getFormat();
        this.prepareBuffer(inputFormat);
        int channels = inputFormat.getChannels();
        int frameSize = inputFormat.getFrameSize();
        this.item = item;
        this.is = ais;
        this.ss = frameSize / channels;
        this.rs = this.bs * this.ss;
        return true;
    }

    protected synchronized void prepareBuffer(AudioFormat inputFormat) throws Exception {
        SampleType sampleType = SoundUtil.guessSampleType((AudioFormat)inputFormat);
        if (sampleType == null) {
            throw new Exception("Unsupported audio format: " + inputFormat);
        }
        int channels = inputFormat.getChannels();
        if (channels < 1) {
            throw new Exception("Unsupported audio format: " + inputFormat);
        }
        float frameRate = inputFormat.getFrameRate();
        if (frameRate <= 0.0f) {
            throw new Exception("Unsupported audio format: " + inputFormat);
        }
        RawSampleBuffer buffer = this.rb;
        if (buffer != null && buffer.getSampleType() == sampleType && buffer.getChannels() == channels && buffer.getFrameRate() == frameRate) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Reusing existing sample buffer: " + buffer);
            }
            return;
        }
        int samples = this.bs;
        this.rb = buffer = sampleType.createRawSampleBuffer(channels, frameRate, samples);
    }

    public long getDropOutCount() {
        return this.outs;
    }

    protected synchronized void recycle() {
        this.action = 2;
        this.notifyAll();
    }

    public synchronized void close() {
        this.action = 3;
        this.notifyAll();
    }

    public int getChannels() {
        return this.nc;
    }

    public float getFrameRate() {
        return this.fr;
    }

    public long getPosition() {
        return this.pos;
    }

    public long getSamples() {
        throw new UnsupportedOperationException();
    }

    public void move(int n) {
        throw new UnsupportedOperationException();
    }

    public void get(SampleBuffer dst, int off, int len) {
        int n = this.buf.get(dst, off, len);
        this.pos += (long)n;
        if (n < len) {
            len -= n;
            off += n;
            n = this.buf.get(dst, off, len);
            this.pos += (long)n;
            if (n < len) {
                long ms;
                dst.clear(off += n, len -= n);
                this.outs += (long)len;
                if (logger.isLoggable(Level.FINE) && (ms = System.currentTimeMillis()) - 1000L > this.debugTime) {
                    this.debugTime = ms;
                    logger.fine("Cursor drop-out: total=" + this.outs);
                }
            }
        }
    }

    public void get(double[] dst, int off, int len) {
        throw new UnsupportedOperationException();
    }

    public void get(DoubleBuffer dst, int len) {
        throw new UnsupportedOperationException();
    }

    public void get(float[] dst, int off, int len) {
        throw new UnsupportedOperationException();
    }

    public void get(FloatBuffer dst, int len) {
        throw new UnsupportedOperationException();
    }

    public boolean isReadOnly() {
        return true;
    }

    public void set(double[] src, int off, int len) {
        throw new UnsupportedOperationException();
    }

    public void set(DoubleBuffer src, int len) {
        throw new UnsupportedOperationException();
    }

    public void set(float[] src, int off, int len) {
        throw new UnsupportedOperationException();
    }

    public void set(FloatBuffer src, int len) {
        throw new UnsupportedOperationException();
    }

    public void set(SampleBuffer src, int off, int len) {
        throw new UnsupportedOperationException();
    }

    public void flush() {
    }

    public PlayerItem getPlayerItem() {
        return this.item;
    }

    public long getFramePosition(PlayerItem i) {
        if (i == this.item) {
            long p = this.pos - this.isp;
            if (p < 0L) {
                return -1L;
            }
            return p / (long)this.nc;
        }
        return -1L;
    }

    protected synchronized void bufferSwitch(Buf b) {
        this.buf = b;
        this.notifyAll();
    }

    protected void loadBuf(Buf buf) {
        int ns;
        if (buf.ready) {
            return;
        }
        buf.end = ns = this.loadRaw(buf, this.bp);
        buf.ofs = 0;
        buf.ready = true;
        this.bp += (long)ns;
    }

    protected int loadRaw(Buf buf, long abs) {
        int ns;
        int r;
        AudioInputStream ais;
        double[] dst = buf.arr;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("loadRaw: array=" + dst + ", samples=" + this.bs + ", bytes=" + this.rs);
        }
        if ((ais = this.is) == null) {
            if (!buf.idle) {
                Arrays.fill(dst, 0, this.bs, 0.0);
                buf.idle = true;
            }
            return this.bs;
        }
        buf.idle = false;
        try {
            r = this.rb.write(0, (InputStream)ais, this.rs);
            if (r == this.rs) {
                this.rb.get(0, dst, 0, this.bs);
                return this.bs;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            r = -1;
        }
        if (r > 0) {
            ns = r / this.ss;
            this.rb.get(0, dst, 0, ns);
        } else {
            r = 0;
            ns = 0;
            ais = null;
        }
        while (true) {
            if (ais == null) {
                this.closeStream();
                long itemFramePos = 0L;
                AbstractAudioPlayer player = this.player;
                if (player != null && (itemFramePos = player.nextItem(this)) < 0L) {
                    itemFramePos = 0L;
                }
                this.isp = abs + (long)ns - itemFramePos * (long)this.nc;
                ais = this.is;
                if (ais == null) {
                    return ns;
                }
            }
            int ds = this.bs - ns;
            int db = ds * this.ss;
            try {
                r = this.rb.write(0, (InputStream)ais, db);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                ais = null;
                continue;
            }
            if (r == db) {
                this.rb.get(0, dst, ns, ds);
                return this.bs;
            }
            if (r > 0) {
                ds = r / this.ss;
                this.rb.get(0, dst, ns, ds);
                ns += ds;
                continue;
            }
            ais = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            AudioPlayerCursor audioPlayerCursor = this;
            // MONITORENTER : audioPlayerCursor
            this.action = 1;
            // MONITOREXIT : audioPlayerCursor
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Cursor started: " + this);
            }
            int act = 1;
            while (true) {
                switch (act) {
                    case 1: {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Cursor active: " + this);
                        }
                        Buf b = this.buf.next;
                        this.loadBuf(b);
                        if (!b.idle) break;
                        this.player.idle(this);
                        break;
                    }
                    case 2: {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Cursor recycle: " + this);
                        }
                        try {
                            this.prepare(null, 0L);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                        break;
                    }
                    case 3: {
                        if (!logger.isLoggable(Level.FINER)) return;
                        logger.finer("Cursor shutdown: " + this);
                        return;
                    }
                }
                try {
                    AudioPlayerCursor e = this;
                    // MONITORENTER : e
                    act = this.action;
                    if (act == 1) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("Cursor waiting: " + this);
                        }
                        this.wait();
                        act = this.action;
                    } else {
                        this.action = 1;
                    }
                    // MONITOREXIT : e
                }
                catch (InterruptedException e) {
                    AudioPlayerCursor audioPlayerCursor2 = this;
                    // MONITORENTER : audioPlayerCursor2
                    act = this.action;
                    // MONITOREXIT : audioPlayerCursor2
                }
                continue;
                break;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        finally {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Cursor stopped: " + this + " (dropped: " + this.outs + " samples)");
            }
            try {
                this.prepare(null, 0L);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected class Buf {
        protected Buf next;
        protected final double[] arr;
        protected long abs;
        protected volatile int ofs;
        protected volatile int end;
        protected volatile boolean ready;
        protected volatile boolean idle;

        public Buf(double[] arr) {
            this.arr = arr;
        }

        public int get(SampleBuffer dst, int off, int len) {
            int n = this.end - this.ofs;
            if (len < n) {
                dst.set(off, this.arr, this.ofs, len);
                this.ofs += len;
                return len;
            }
            dst.set(off, this.arr, this.ofs, n);
            this.ofs = this.end;
            this.ready = false;
            if (this.next.ready) {
                AudioPlayerCursor.this.bufferSwitch(this.next);
            }
            return n;
        }
    }
}

