/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.player;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.Player;
import com.spacekiller.util.media.PlayerItem;
import com.spacekiller.util.media.PlayerSequence;
import com.spacekiller.util.media.SeekableStream;
import com.spacekiller.util.media.SingleItemPlayerSequence;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.thread.ThreadPool;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.player.AbstractAudioPlayer;
import com.waxmonster.audio.player.AudioPlayerCursor;
import com.waxmonster.audio.player.AudioPlayerItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class WaxMonsterAudioPlayer
extends AbstractAudioPlayer
implements AudioProcessor {
    private static final Logger logger = Logger.getLogger(WaxMonsterAudioPlayer.class.getName());
    protected static final int ACTION_IDLE = 0;
    protected static final int ACTION_PLAY = 1;
    protected static final int ACTION_PAUSE = 2;
    protected static final int ACTION_RESUME = 3;
    protected static final int ACTION_SWITCH = 4;
    protected static final int ACTION_STOP = 5;
    protected final SampleBuffer dst;
    protected final int nc;
    protected final float fr;
    protected final double mpf;
    protected final int bufferSamples;
    protected final ThreadPool playerPool;
    protected final ThreadPool preparePool;
    private int state = 0;
    private volatile int action;
    private volatile AudioPlayerCursor cur;
    private volatile AudioPlayerCursor nex;
    private volatile PlayerItem nextItem;
    private List cursors;
    private LinkedList avail;
    private PlayerSequence seq;
    private PlayerItem opi;
    private AudioInputStream ois;
    private final Object streamLock = new Object();
    private final SeekAsync seekAsync = new SeekAsync();
    private final SkipAsync skipAsync = new SkipAsync();
    private volatile int skipCounter;

    public WaxMonsterAudioPlayer(SampleBuffer outputBuffer, int inputBufSamples, ThreadPool playerThreadPool, int minCursorCount, ThreadPool prepareThreadPool) throws InterruptedException {
        this.dst = outputBuffer;
        this.nc = outputBuffer.getChannels();
        this.fr = outputBuffer.getFrameRate();
        this.mpf = 1000.0 / (double)this.fr;
        this.bufferSamples = inputBufSamples;
        this.playerPool = playerThreadPool;
        this.preparePool = prepareThreadPool;
        this.cursors = new ArrayList();
        this.avail = new LinkedList();
        this.nex = this.cur = this.createCursor();
        if (minCursorCount < 2) {
            minCursorCount = 2;
        }
        for (int i = 1; i < minCursorCount; ++i) {
            AudioPlayerCursor apc = this.createCursor();
            this.avail.add(apc);
        }
    }

    public double getFrameRate() {
        return this.fr;
    }

    public int getState() {
        return this.state;
    }

    protected synchronized void setState(int state) {
        if (this.state == state) {
            return;
        }
        this.state = state;
        this.fireStateChanged((Player)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("stop...");
        }
        WaxMonsterAudioPlayer waxMonsterAudioPlayer = this;
        synchronized (waxMonsterAudioPlayer) {
            if (this.action != 0) {
                this.action = 5;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("waiting...");
                }
                while (this.action == 5) {
                    ((Object)((Object)this)).wait();
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("stopped.");
                }
            }
            if (this.action == 0 && this.state != 0) {
                this.setState(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("pause...");
        }
        WaxMonsterAudioPlayer waxMonsterAudioPlayer = this;
        synchronized (waxMonsterAudioPlayer) {
            if (this.action == 0 || this.action == 5) {
                return;
            }
            this.action = 2;
            while (this.action == 2) {
                ((Object)((Object)this)).wait();
            }
            if (this.action == 0) {
                this.setState(2);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("paused");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("resume...");
        }
        WaxMonsterAudioPlayer waxMonsterAudioPlayer = this;
        synchronized (waxMonsterAudioPlayer) {
            if (this.action == 1) {
                return;
            }
            this.action = 3;
            while (this.action == 3) {
                ((Object)((Object)this)).wait();
            }
            if (this.action == 1) {
                this.setState(1);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("resumed");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long seek(AudioPlayerItem item, long framePos, int skipCounter, AudioPlayerCursor oldCursor) throws Exception {
        AudioPlayerCursor old;
        boolean okay;
        AudioPlayerCursor cursor;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("seek: framePos=" + framePos + ", item=" + (Object)((Object)item));
        }
        if ((cursor = this.prepare(item, framePos, oldCursor)) == oldCursor) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("seeked: framePos=" + framePos + ", item=" + (Object)((Object)item));
            }
            return framePos;
        }
        WaxMonsterAudioPlayer waxMonsterAudioPlayer = this;
        synchronized (waxMonsterAudioPlayer) {
            okay = skipCounter == this.skipCounter;
        }
        if (okay) {
            old = this.switchCursor(cursor);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("switched: framePos=" + framePos + ", item=" + (Object)((Object)item));
            }
        } else {
            old = cursor;
            cursor = null;
            framePos = -1L;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ignored: framePos=" + framePos + ", item=" + (Object)((Object)item));
            }
        }
        if (old != null && old != cursor) {
            old.recycle();
            LinkedList linkedList = this.avail;
            synchronized (linkedList) {
                this.avail.add(old);
            }
        }
        return framePos;
    }

    protected synchronized AudioPlayerCursor switchCursor(AudioPlayerCursor cursor) {
        AudioPlayerCursor old = this.cur;
        this.nex = cursor;
        this.action = 4;
        while (this.action == 4) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (this.action == 1) {
            this.setState(1);
        }
        this.fireItemChanged((Player)this);
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected long nextItem(AudioPlayerCursor cursor) {
        int counter;
        PlayerSequence sequence = this.seq;
        if (sequence == null) {
            return -1L;
        }
        if (cursor != null) {
            WaxMonsterAudioPlayer waxMonsterAudioPlayer = this;
            synchronized (waxMonsterAudioPlayer) {
                if (cursor != this.cur) {
                    return -1L;
                }
            }
        }
        WaxMonsterAudioPlayer waxMonsterAudioPlayer = this;
        synchronized (waxMonsterAudioPlayer) {
            counter = ++this.skipCounter;
        }
        Object failedResource = null;
        try {
            while (true) {
                PlayerItem item;
                if ((item = sequence.nextItem()) == null) {
                    long l = -1L;
                    return l;
                }
                Resource resource = item.getResource();
                if (failedResource != null && failedResource.equals(resource)) {
                    logger.warning("Player item already failed: resource=" + resource);
                    long l = -1L;
                    return l;
                }
                this.nextItem = item;
                if (item instanceof AudioPlayerItem) {
                    String msg;
                    try {
                        AudioPlayerItem playerItem = (AudioPlayerItem)item;
                        long framePos = 0L;
                        long result = this.seek(playerItem, framePos, counter, cursor);
                        if (result >= 0L) {
                            long l = result;
                            return l;
                        }
                    }
                    catch (UnsupportedAudioFileException e) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, e.getMessage(), e);
                        }
                        if (logger.isLoggable(Level.WARNING)) {
                            msg = "Unsupported audio file: " + resource;
                            logger.warning(msg);
                        }
                    }
                    catch (Exception e) {
                        msg = "Failed to play resource: '" + resource + "', Cause: " + e.getMessage();
                        logger.log(Level.SEVERE, msg, e);
                    }
                    if (failedResource == null) {
                        failedResource = resource;
                    }
                } else {
                    logger.warning("Unsupported nextItem: " + item);
                }
                WaxMonsterAudioPlayer waxMonsterAudioPlayer2 = this;
                synchronized (waxMonsterAudioPlayer2) {
                    if (counter != this.skipCounter) {
                        long l = -1L;
                        return l;
                    }
                }
            }
        }
        finally {
            this.nextItem = null;
        }
    }

    @Override
    protected void fireItem(AudioPlayerCursor cursor) {
        this.fireItemChanged((Player)this);
    }

    @Override
    protected void idle(AudioPlayerCursor cursor) {
        try {
            this.stop();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AudioInputStream createAudioInputStream(AudioPlayerItem item, AudioFormat targetFormat, boolean seekable, long framePos) throws IOException, UnsupportedAudioFileException {
        AudioFormat inputFormat;
        int frameSize;
        long bytePos;
        AudioInputStream ais;
        if (item == null) {
            return null;
        }
        Resource res = item.getResource();
        if (res == null) {
            return null;
        }
        MediaLibrary lib = item.getMediaLibrary();
        if (lib == null) {
            return null;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Creating audio stream: " + (Object)((Object)item));
        }
        Object object = this.streamLock;
        synchronized (object) {
            AudioInputStream old;
            if (item == this.opi && (old = this.ois) != null && old instanceof SeekableStream && (ais = lib.createSeekableAudioInputStream(old, bytePos = framePos * (long)(frameSize = (inputFormat = old.getFormat()).getFrameSize()))) != null) {
                Object object2 = this.streamLock;
                synchronized (object2) {
                    this.opi = item;
                    this.ois = ais;
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Audio stream seeked: " + ais);
                }
                return ais;
            }
        }
        boolean done = false;
        ais = lib.createAudioInputStream(res, targetFormat, seekable);
        try {
            if (framePos > 0L) {
                if (ais instanceof SeekableStream) {
                    SeekableStream sk = (SeekableStream)ais;
                    inputFormat = ais.getFormat();
                    frameSize = inputFormat.getFrameSize();
                    bytePos = framePos * (long)frameSize;
                    sk.seek(bytePos);
                } else {
                    logger.warning("Audio stream is not seekable: " + ais);
                }
            }
            Object object3 = this.streamLock;
            synchronized (object3) {
                this.opi = item;
                this.ois = ais;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Audio stream created: " + (Object)((Object)item) + " => " + ais);
            }
            done = true;
            object3 = ais;
            return object3;
        }
        finally {
            if (!done) {
                ais.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeAudioInputStream(AudioInputStream stream, PlayerItem item) throws IOException {
        if (stream == null) {
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Closing audio stream: " + item + " => " + stream);
        }
        Object object = this.streamLock;
        synchronized (object) {
            if (this.ois == stream) {
                this.ois = null;
                this.opi = null;
            }
        }
        stream.close();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Audio stream closed: " + item + " => " + stream);
        }
    }

    @Override
    protected void dumpOpenStreams() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(long time, int frames) throws AudioException {
        switch (this.action) {
            case 1: {
                break;
            }
            case 4: {
                this.cur = this.nex;
                WaxMonsterAudioPlayer waxMonsterAudioPlayer = this;
                synchronized (waxMonsterAudioPlayer) {
                    this.action = 1;
                    ((Object)((Object)this)).notifyAll();
                    break;
                }
            }
            case 3: {
                WaxMonsterAudioPlayer waxMonsterAudioPlayer = this;
                synchronized (waxMonsterAudioPlayer) {
                    this.action = 1;
                    ((Object)((Object)this)).notifyAll();
                    break;
                }
            }
            case 2: 
            case 5: {
                this.dst.clear(0, this.dst.getSamples());
                WaxMonsterAudioPlayer waxMonsterAudioPlayer = this;
                synchronized (waxMonsterAudioPlayer) {
                    this.action = 0;
                    ((Object)((Object)this)).notifyAll();
                }
                return;
            }
            default: {
                return;
            }
        }
        int len = frames * this.nc;
        this.cur.get(this.dst, 0, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() throws AudioException {
        this.action = 0;
        this.setState(0);
        List list = this.avail;
        synchronized (list) {
            this.avail.clear();
        }
        list = this.cursors;
        synchronized (list) {
            int num = this.cursors.size();
            for (int i = 0; i < num; ++i) {
                AudioPlayerCursor cursor = (AudioPlayerCursor)this.cursors.get(i);
                cursor.close();
            }
            this.cursors.clear();
        }
        ((Object)((Object)this)).notifyAll();
    }

    public void play(PlayerItem item) throws Exception {
        if (item == null) {
            return;
        }
        this.play((PlayerSequence)new SingleItemPlayerSequence(item));
    }

    public void play(PlayerSequence sequence) throws Exception {
        this.seq = sequence;
        this.skip();
    }

    public void skip() throws Exception {
        PlayerSequence sequence = this.seq;
        if (sequence == null) {
            return;
        }
        this.preparePool.start((Runnable)this.skipAsync);
    }

    public PlayerItem getCurrentItem() {
        return this.cur.getPlayerItem();
    }

    public PlayerItem getNextItem() {
        PlayerItem item = this.nextItem;
        if (item != null) {
            return item;
        }
        return this.nex.getPlayerItem();
    }

    public long getFramePosition(PlayerItem item) {
        return this.cur.getFramePosition(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long setFramePosition(PlayerItem item, long p) {
        try {
            AudioPlayerItem api = (AudioPlayerItem)item;
            WaxMonsterAudioPlayer waxMonsterAudioPlayer = this;
            synchronized (waxMonsterAudioPlayer) {
                int counter = ++this.skipCounter;
                this.seekAsync.reset(api, p, counter);
            }
            this.preparePool.start((Runnable)this.seekAsync);
            return p;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return -1L;
        }
    }

    public double getNormalPosition(PlayerItem item) {
        long p = this.cur.getFramePosition(item);
        if (p < 0L) {
            return -1.0;
        }
        AudioPlayerItem wmapi = (AudioPlayerItem)item;
        long frameLen = wmapi.frameLength;
        if (frameLen < 0L) {
            return -1.0;
        }
        return (double)p / (double)frameLen;
    }

    public boolean setNormalPosition(PlayerItem item, double p) {
        AudioPlayerItem wmapi = (AudioPlayerItem)item;
        long frameLen = wmapi.frameLength;
        if (frameLen < 0L) {
            return false;
        }
        long framePos = Math.round((double)frameLen * p);
        if (framePos < 0L) {
            return false;
        }
        long newPos = this.setFramePosition(item, framePos);
        return newPos == framePos;
    }

    public double getTimePosition(PlayerItem item) {
        long p = this.cur.getFramePosition(item);
        if (p < 0L) {
            return -1.0;
        }
        return (double)p * this.mpf;
    }

    public boolean setTimePosition(PlayerItem item, double p) {
        AudioPlayerItem wmapi = (AudioPlayerItem)item;
        long frameLen = wmapi.frameLength;
        if (frameLen < 0L) {
            return false;
        }
        long framePos = Math.round(p / this.mpf);
        if (framePos < 0L) {
            return false;
        }
        long newPos = this.setFramePosition(item, framePos);
        return newPos == framePos;
    }

    public long getFrameLength(PlayerItem item) {
        AudioPlayerItem wmapi = (AudioPlayerItem)item;
        return wmapi.frameLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AudioPlayerCursor prepare(AudioPlayerItem item, long framePos, AudioPlayerCursor cursor) throws Exception {
        if (item == null) {
            return null;
        }
        if (framePos < 0L) {
            return null;
        }
        if (cursor == null) {
            LinkedList linkedList = this.avail;
            synchronized (linkedList) {
                if (!this.avail.isEmpty()) {
                    cursor = (AudioPlayerCursor)this.avail.removeFirst();
                }
            }
            if (cursor == null) {
                cursor = this.createCursor();
            }
            cursor.reset(item, framePos);
        } else {
            cursor.prepare(item, framePos);
        }
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AudioPlayerCursor createCursor() throws InterruptedException {
        AudioPlayerCursor cursor = new AudioPlayerCursor(this, this.nc, this.fr, this.bufferSamples);
        List list = this.cursors;
        synchronized (list) {
            this.cursors.add(cursor);
        }
        this.playerPool.start((Runnable)cursor);
        return cursor;
    }

    protected class SeekAsync
    implements Runnable {
        private AudioPlayerItem item;
        private long framePos;
        private int skipCounter;

        protected SeekAsync() {
        }

        protected void reset(AudioPlayerItem item, long framePos, int skipCounter) {
            this.item = item;
            this.framePos = framePos;
            this.skipCounter = skipCounter;
        }

        @Override
        public void run() {
            try {
                AudioPlayerCursor oldCursor = null;
                WaxMonsterAudioPlayer.this.seek(this.item, this.framePos, this.skipCounter, oldCursor);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected class SkipAsync
    implements Runnable {
        protected SkipAsync() {
        }

        @Override
        public void run() {
            WaxMonsterAudioPlayer.this.nextItem(null);
        }
    }
}

