/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.player;

import com.spacekiller.util.media.DefaultMediaMarker;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.MediaMarker;
import com.spacekiller.util.media.MediaPlayer;
import com.spacekiller.util.media.MediaPlayerContext;
import com.spacekiller.util.media.PlaybackHistory;
import com.spacekiller.util.media.PlayerItem;
import com.spacekiller.util.media.manager.DefaultPlaybackHistory;
import com.spacekiller.util.media.manager.MediaManagerPlugin;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.thread.ThreadPool;
import com.spacekiller.util.tooling.Tool;
import com.spacekiller.util.tooling.ToolGroup;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.common.AbstractAudioPlayerDevice;
import com.waxmonster.audio.player.WaxMonsterAudioPlayer;
import com.waxmonster.audio.player.WaxMonsterAudioPlayerPanel;
import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.common.AbstractButtonMidiAction;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class WaxMonsterAudioPlayerDevice
extends AbstractAudioPlayerDevice
implements MediaPlayer {
    private static final Logger logger = Logger.getLogger(WaxMonsterAudioPlayerDevice.class.getName());
    public static final String KEY_PLAYBACK_HISTORY_LIMIT = "playbackHistoryLimit";
    public static final String KEY_MIN_BUFFER_MILLIS = "minBufferMillis";
    public static final String KEY_MIN_CURSOR_COUNT = "minCursorCount";
    public static final int DEFAULT_PLAYBACK_HISTORY_LIMIT = 1000;
    public static final int DEFAULT_MIN_BUFFER_MILLIS = 1000;
    public static final int DEFAULT_MIN_CURSOR_COUNT = 4;
    private ThreadPool playerThreadPool;
    private ThreadPool prepareThreadPool;
    private ToolGroup playerToolBarGroup;
    private ToolGroup playerPopupMenuGroup;
    private Tool shuffleModeAction;
    private Tool togglePauseResumeAction;
    private WaxMonsterAudioPlayerPanel audioPlayerPanel;
    private WaxMonsterAudioPlayer audioPlayer;
    private PlaybackMidiAction playbackMidiAction;
    private StopMidiAction stopMidiAction;
    private ToggleStartStopMidiAction toggleStartStopMidiAction;
    private PauseMidiAction pauseMidiAction;
    private ResumeMidiAction resumeMidiAction;
    private TogglePauseResumeMidiAction togglePauseResumeMidiAction;
    private TogglePlayPauseMidiAction togglePlayPauseMidiAction;
    private SkipNextMidiAction skipNextMidiAction;
    private SkipPrevMidiAction skipPrevMidiAction;
    private MarkerMidiAction markerMidiAction;
    private UserRatingMidiAction incrementRatingMidiAction;
    private UserRatingMidiAction decrementRatingMidiAction;
    private int playbackHistoryLimit = 1000;
    private int minBufferMillis = 1000;
    private int minCursorCount = 4;

    public WaxMonsterAudioPlayerDevice(DeviceProvider provider, String name, Icon iconColor16, int channels, ThreadPool playerThreadPool, ThreadPool prepareThreadPool, ToolGroup playerToolBarGroup, ToolGroup playerPopupMenuGroup, Tool shuffleModeAction, Tool togglePauseResumeAction) throws StudioException {
        super(provider, name, iconColor16, channels);
        this.playerThreadPool = playerThreadPool;
        this.prepareThreadPool = prepareThreadPool;
        this.playerToolBarGroup = playerToolBarGroup;
        this.playerPopupMenuGroup = playerPopupMenuGroup;
        this.shuffleModeAction = shuffleModeAction;
        this.togglePauseResumeAction = togglePauseResumeAction;
        this.initWaxMonsterAudioPlayerDevice();
    }

    protected void initWaxMonsterAudioPlayerDevice() throws StudioException {
        this.playbackMidiAction = new PlaybackMidiAction();
        this.stopMidiAction = new StopMidiAction();
        this.toggleStartStopMidiAction = new ToggleStartStopMidiAction();
        this.pauseMidiAction = new PauseMidiAction();
        this.resumeMidiAction = new ResumeMidiAction();
        this.togglePauseResumeMidiAction = new TogglePauseResumeMidiAction();
        this.togglePlayPauseMidiAction = new TogglePlayPauseMidiAction();
        this.skipNextMidiAction = new SkipNextMidiAction();
        this.skipPrevMidiAction = new SkipPrevMidiAction();
        this.markerMidiAction = new MarkerMidiAction("AddMarker", 3);
        this.incrementRatingMidiAction = new UserRatingMidiAction("IncrementRating", 0.1);
        this.decrementRatingMidiAction = new UserRatingMidiAction("DecrementRating", -0.1);
        this.setMidiActions(new MidiAction[]{this.playbackMidiAction, this.stopMidiAction, this.toggleStartStopMidiAction, this.pauseMidiAction, this.resumeMidiAction, this.togglePauseResumeMidiAction, this.togglePlayPauseMidiAction, this.skipNextMidiAction, this.skipPrevMidiAction, this.markerMidiAction, this.incrementRatingMidiAction, this.decrementRatingMidiAction});
    }

    protected AudioProcessor createAudioPlayer(SampleBuffer outputSampleBuffer) throws AudioException {
        float frameRate = outputSampleBuffer.getFrameRate();
        int channels = outputSampleBuffer.getChannels();
        int bufferFrames = outputSampleBuffer.getSamples() / channels;
        if (bufferFrames < 1) {
            throw new IllegalArgumentException("Invalid buffer size: " + outputSampleBuffer);
        }
        int inputBufferFrames = bufferFrames;
        int minBufferFrames = (int)((double)((float)this.minBufferMillis * frameRate) / 1000.0);
        if (inputBufferFrames < minBufferFrames) {
            int frames;
            int factor = minBufferFrames / bufferFrames;
            if (factor < 1) {
                factor = 1;
            }
            if ((frames = bufferFrames * factor) < minBufferFrames && (frames += bufferFrames) < minBufferFrames) {
                frames = minBufferFrames;
            }
            inputBufferFrames = frames;
        }
        int inputBufferSamples = inputBufferFrames * channels;
        try {
            WaxMonsterAudioPlayer player;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("createAudioPlayer: outputSampleBuffer=" + outputSampleBuffer + ", inputBufferSamples=" + inputBufferSamples + ", playerThreadPool=" + this.playerThreadPool + ", prepareThreadPool=" + this.prepareThreadPool);
            }
            this.audioPlayer = player = new WaxMonsterAudioPlayer(outputSampleBuffer, inputBufferSamples, this.playerThreadPool, this.minCursorCount, this.prepareThreadPool);
            WaxMonsterAudioPlayerPanel panel = this.audioPlayerPanel;
            if (panel != null) {
                panel.setPlayer(player);
            }
            return player;
        }
        catch (Exception e) {
            throw new AudioException((Throwable)e);
        }
    }

    protected void disposeAudioPlayer(AudioProcessor audioPlayer) {
        WaxMonsterAudioPlayer player = (WaxMonsterAudioPlayer)audioPlayer;
        WaxMonsterAudioPlayerPanel panel = this.audioPlayerPanel;
        if (panel != null && panel.getPlayer() == audioPlayer) {
            panel.setPlayer(null);
        }
        try {
            player.shutdown();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public synchronized Component getCustomizer() {
        return this.getAudioPlayerPanel();
    }

    public int getMinBufferMillis() {
        return this.minBufferMillis;
    }

    public void setMinBufferMillis(int minBufferMillis) {
        this.minBufferMillis = minBufferMillis;
    }

    public synchronized Properties getProperties() {
        Properties props = super.getProperties();
        String sPlaybackHistoryLimit = this.playbackHistoryLimit == 1000 ? "" : Integer.toString(this.playbackHistoryLimit);
        props.setProperty(KEY_PLAYBACK_HISTORY_LIMIT, sPlaybackHistoryLimit);
        String sMinBufferMillis = this.minBufferMillis == 1000 ? "" : Integer.toString(this.minBufferMillis);
        props.setProperty(KEY_MIN_BUFFER_MILLIS, sMinBufferMillis);
        String sMinCursorCount = this.minCursorCount == 4 ? "" : Integer.toString(this.minCursorCount);
        props.setProperty(KEY_MIN_CURSOR_COUNT, sMinCursorCount);
        WaxMonsterAudioPlayerPanel panel = this.getAudioPlayerPanel();
        try {
            panel.saveViewPreferences(props);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return props;
    }

    public void setProperties(Properties newProperties) {
        super.setProperties(newProperties);
        int vPlaybackHistoryLimit = -1;
        String value = newProperties.getProperty(KEY_PLAYBACK_HISTORY_LIMIT);
        if (value != null && value.length() > 0) {
            try {
                vPlaybackHistoryLimit = Integer.parseInt(value.trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (vPlaybackHistoryLimit < 0) {
            vPlaybackHistoryLimit = 1000;
        }
        this.setPlaybackHistoryLimit(vPlaybackHistoryLimit);
        int vMinBufferMillis = -1;
        value = newProperties.getProperty(KEY_MIN_BUFFER_MILLIS);
        if (value != null && value.length() > 0) {
            try {
                vMinBufferMillis = Integer.parseInt(value.trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (vMinBufferMillis < 1) {
            vMinBufferMillis = 1000;
        }
        this.setMinBufferMillis(vMinBufferMillis);
        int vMinCursorCount = -1;
        value = newProperties.getProperty(KEY_MIN_CURSOR_COUNT);
        if (value != null && value.length() > 0) {
            try {
                vMinCursorCount = Integer.parseInt(value.trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (vMinCursorCount < 1) {
            vMinCursorCount = 4;
        }
        this.setMinCursorCount(vMinCursorCount);
        WaxMonsterAudioPlayerPanel panel = this.getAudioPlayerPanel();
        try {
            panel.loadViewPreferences(newProperties);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WaxMonsterAudioPlayerPanel getAudioPlayerPanel() {
        if (this.audioPlayerPanel == null) {
            WaxMonsterAudioPlayerDevice waxMonsterAudioPlayerDevice = this;
            synchronized (waxMonsterAudioPlayerDevice) {
                if (this.audioPlayerPanel == null) {
                    this.setAudioPlayerPanel(this.createAudioPlayerPanel());
                }
            }
        }
        return this.audioPlayerPanel;
    }

    protected void setAudioPlayerPanel(WaxMonsterAudioPlayerPanel audioPlayerPanel) {
        this.audioPlayerPanel = audioPlayerPanel;
    }

    protected WaxMonsterAudioPlayerPanel createAudioPlayerPanel() {
        WaxMonsterAudioPlayerPanel panel = new WaxMonsterAudioPlayerPanel();
        panel.setDevice(this);
        panel.setPlaybackHistory((PlaybackHistory)new DefaultPlaybackHistory(this.playbackHistoryLimit));
        panel.setPlayerToolBarGroup(this.playerToolBarGroup);
        panel.setPlayerPopupMenuGroup(this.playerPopupMenuGroup);
        panel.setShuffleModeAction(this.shuffleModeAction);
        panel.setTogglePauseResumeAction(this.togglePauseResumeAction);
        panel.setOpaque(false);
        panel.setPreferredSize(new Dimension(400, 350));
        panel.setPlayer(this.audioPlayer);
        return panel;
    }

    protected WaxMonsterAudioPlayer getAudioPlayer() {
        return this.audioPlayer;
    }

    public PlaybackMidiAction getPlaybackMidiAction() {
        return this.playbackMidiAction;
    }

    public StopMidiAction getStopMidiAction() {
        return this.stopMidiAction;
    }

    public ToggleStartStopMidiAction getToggleStartStopMidiAction() {
        return this.toggleStartStopMidiAction;
    }

    public PauseMidiAction getPauseMidiAction() {
        return this.pauseMidiAction;
    }

    public ResumeMidiAction getResumeMidiAction() {
        return this.resumeMidiAction;
    }

    public TogglePauseResumeMidiAction getTogglePauseResumeMidiAction() {
        return this.togglePauseResumeMidiAction;
    }

    public TogglePlayPauseMidiAction getTogglePlayPauseMidiAction() {
        return this.togglePlayPauseMidiAction;
    }

    public SkipNextMidiAction getSkipNextMidiAction() {
        return this.skipNextMidiAction;
    }

    public SkipPrevMidiAction getSkipPrevMidiAction() {
        return this.skipPrevMidiAction;
    }

    public MarkerMidiAction getMarkerMidiAction() {
        return this.markerMidiAction;
    }

    public UserRatingMidiAction getIncrementRatingMidiAction() {
        return this.incrementRatingMidiAction;
    }

    public UserRatingMidiAction getDecrementRatingMidiAction() {
        return this.decrementRatingMidiAction;
    }

    protected void studioChanged(Studio studio) {
        super.studioChanged(studio);
        try {
            MediaManagerPlugin mediaManagerPlugin = MediaManagerPlugin.getInstance();
            WaxMonsterAudioPlayerDevice owner = this;
            if (studio == null) {
                mediaManagerPlugin.unregisterMediaPlayer((MediaPlayer)this, (Object)owner);
            } else {
                mediaManagerPlugin.registerMediaPlayer((MediaPlayer)this, (Object)owner);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public String getPlayerName() {
        String s = this.getTitle();
        if (s == null || s.length() < 1) {
            s = this.getName();
        }
        return s;
    }

    public Icon getPlayerIcon(int iconKind) {
        return this.getIcon(iconKind);
    }

    public void setCurrentEntry(final MediaCrateEntry entry, final MediaPlayerContext context, final int index) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WaxMonsterAudioPlayerDevice.this.getAudioPlayerPanel().setCurrentEntry(entry, context, index);
            }
        });
    }

    public MediaMarker createMediaMarker() {
        WaxMonsterAudioPlayer ap = this.audioPlayer;
        if (ap == null) {
            return null;
        }
        PlayerItem item = ap.getCurrentItem();
        if (item == null) {
            return null;
        }
        double millis = ap.getTimePosition(item);
        if (millis < 0.0) {
            return null;
        }
        int type = 3;
        double position = millis;
        int index = -1;
        String name = null;
        return new DefaultMediaMarker(type, index, position, name);
    }

    public int getPlaybackHistoryLimit() {
        return this.playbackHistoryLimit;
    }

    public void setPlaybackHistoryLimit(int playbackHistoryLimit) {
        this.playbackHistoryLimit = playbackHistoryLimit;
    }

    public int getMinCursorCount() {
        return this.minCursorCount;
    }

    public void setMinCursorCount(int minCursorCount) {
        this.minCursorCount = minCursorCount;
    }

    protected class UserRatingMidiAction
    extends AbstractButtonMidiAction {
        private double ratingIncrement;

        public UserRatingMidiAction(String name, double ratingIncrement) {
            super(name);
            this.ratingIncrement = ratingIncrement;
        }

        public void buttonPressed(long time) {
            try {
                WaxMonsterAudioPlayerDevice.this.getAudioPlayerPanel().increaseUserRating(this.ratingIncrement);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }

        public String toString() {
            return super.toString() + "[ratingIncrement=" + this.ratingIncrement + "]";
        }
    }

    protected class MarkerMidiAction
    extends AbstractButtonMidiAction {
        private int markerType;

        public MarkerMidiAction(String name, int markerType) {
            super(name);
            this.markerType = markerType;
        }

        public void buttonPressed(long time) {
            try {
                int markerIndex = -1;
                String markerName = null;
                WaxMonsterAudioPlayerDevice.this.getAudioPlayerPanel().putMediaMarker(this.markerType, markerIndex, markerName);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }

        public String toString() {
            return super.toString() + "[markerType=" + this.markerType + "]";
        }
    }

    protected class SkipPrevMidiAction
    extends AbstractButtonMidiAction {
        public SkipPrevMidiAction() {
            super("SkipPrev");
        }

        public void buttonPressed(long time) {
            try {
                WaxMonsterAudioPlayerDevice.this.getAudioPlayerPanel().skipPrev();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected class SkipNextMidiAction
    extends AbstractButtonMidiAction {
        public SkipNextMidiAction() {
            super("SkipNext");
        }

        public void buttonPressed(long time) {
            try {
                WaxMonsterAudioPlayerDevice.this.getAudioPlayerPanel().skipNext();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected class TogglePlayPauseMidiAction
    extends AbstractButtonMidiAction {
        public TogglePlayPauseMidiAction() {
            super("TogglePlayPause");
        }

        public void buttonPressed(long time) {
            try {
                WaxMonsterAudioPlayer ap = WaxMonsterAudioPlayerDevice.this.audioPlayer;
                if (ap == null) {
                    return;
                }
                if (ap.isPaused()) {
                    WaxMonsterAudioPlayerDevice.this.getAudioPlayerPanel().play();
                } else {
                    ap.pause();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected class TogglePauseResumeMidiAction
    extends AbstractButtonMidiAction {
        public TogglePauseResumeMidiAction() {
            super("TogglePauseResume");
        }

        public void buttonPressed(long time) {
            try {
                WaxMonsterAudioPlayer ap = WaxMonsterAudioPlayerDevice.this.audioPlayer;
                if (ap == null) {
                    return;
                }
                if (ap.isPaused()) {
                    ap.resume();
                } else {
                    ap.pause();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected class ResumeMidiAction
    extends AbstractButtonMidiAction {
        public ResumeMidiAction() {
            super("Resume");
        }

        public void buttonPressed(long time) {
            WaxMonsterAudioPlayer ap = WaxMonsterAudioPlayerDevice.this.audioPlayer;
            if (ap == null) {
                return;
            }
            try {
                ap.resume();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected class PauseMidiAction
    extends AbstractButtonMidiAction {
        public PauseMidiAction() {
            super("Pause");
        }

        public void buttonPressed(long time) {
            WaxMonsterAudioPlayer ap = WaxMonsterAudioPlayerDevice.this.audioPlayer;
            if (ap == null) {
                return;
            }
            try {
                ap.pause();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected class ToggleStartStopMidiAction
    extends AbstractButtonMidiAction {
        public ToggleStartStopMidiAction() {
            super("ToggleStartStop");
        }

        public void buttonPressed(long time) {
            try {
                WaxMonsterAudioPlayer ap = WaxMonsterAudioPlayerDevice.this.audioPlayer;
                if (ap != null && ap.isPlaying()) {
                    WaxMonsterAudioPlayerDevice.this.getAudioPlayerPanel().stop();
                } else {
                    WaxMonsterAudioPlayerDevice.this.getAudioPlayerPanel().play();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected class StopMidiAction
    extends AbstractButtonMidiAction {
        public StopMidiAction() {
            super("Stop");
        }

        public void buttonPressed(long time) {
            try {
                WaxMonsterAudioPlayerDevice.this.getAudioPlayerPanel().stop();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected class PlaybackMidiAction
    extends AbstractButtonMidiAction {
        public PlaybackMidiAction() {
            super("Play");
        }

        public void buttonPressed(long time) {
            try {
                WaxMonsterAudioPlayerDevice.this.getAudioPlayerPanel().play();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

