/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.player;

import com.spacekiller.util.Platform;
import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.Tools;
import com.spacekiller.util.thread.DefaultThreadPool;
import com.spacekiller.util.thread.ThreadPool;
import com.spacekiller.util.tooling.Tool;
import com.spacekiller.util.tooling.ToolGroup;
import com.waxmonster.audio.AudioPortType;
import com.waxmonster.audio.player.WaxMonsterAudioPlayerDevice;
import com.waxmonster.audio.player.WaxMonsterAudioPlayerDeviceInfo;
import com.waxmonster.audio.player.WaxMonsterAudioPlayerPlugin;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceInfo;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.StudioException;
import javax.swing.Icon;

public class WaxMonsterAudioPlayerDeviceProvider
extends DeviceProvider {
    public static final String PROVIDER_NAME = "WaxMonsterAudioPlayerDeviceProvider";
    public static final int DEFAULT_PLAYER_THREAD_PRIORITY = 6;
    public static final int DEFAULT_PLAYER_THREAD_COUNT = 8;
    public static final int DEFAULT_PLAYER_THREAD_TIMEOUT = 60000;
    public static final int DEFAULT_PREPARE_THREAD_PRIORITY = 4;
    public static final int DEFAULT_PREPARE_THREAD_COUNT = 4;
    public static final int DEFAULT_PREPARE_THREAD_TIMEOUT = 60000;
    private ThreadPool playerThreadPool;
    private ThreadPool prepareThreadPool;

    public WaxMonsterAudioPlayerDeviceProvider() {
        super(PROVIDER_NAME);
        this.initAudioPlayerDeviceProvider();
    }

    protected void initAudioPlayerDeviceProvider() {
        String name = "Audio Player";
        String tooltip = "Audio player";
        Icon playerIcon = Tools.getIcon(WaxMonsterAudioPlayerDeviceProvider.class, (String)"/com/waxmonster/audio/player/icons/waxmonster_audio_player.gif");
        WaxMonsterAudioPlayerDeviceInfo audioPlayerDevInfo = new WaxMonsterAudioPlayerDeviceInfo(name, tooltip, playerIcon);
        this.addDeviceInfo(audioPlayerDevInfo);
    }

    public void refreshDeviceInfo() {
    }

    public Device createDevice(DeviceInfo info) throws StudioException {
        if (info == null) {
            return null;
        }
        String name = info.getDeviceName();
        Icon icon = info.getIcon(1);
        if (info instanceof WaxMonsterAudioPlayerDeviceInfo) {
            int channels = 2;
            ThreadPool playerThreadPool = this.getPlayerThreadPool();
            ThreadPool prepareThreadPool = this.getPrepareThreadPool();
            ToolGroup playerToolBarGroup = this.lookupPlayerToolBarGroup();
            ToolGroup playerPopupMenuGroup = this.lookupPlayerPopupMenuGroup();
            Tool toggleShuffleModeAction = this.lookupToggleShuffleModeAction();
            Tool togglePauseResumeAction = this.lookupTogglePauseResumeAction();
            return new WaxMonsterAudioPlayerDevice(this, name, icon, channels, playerThreadPool, prepareThreadPool, playerToolBarGroup, playerPopupMenuGroup, toggleShuffleModeAction, togglePauseResumeAction);
        }
        return null;
    }

    public PortType getPortType(String typeName) {
        return AudioPortType.getAudioPortType((String)typeName);
    }

    protected ThreadPool createPlayerThreadPool() throws StudioException {
        ClassLoader contextLoader = ((Object)((Object)this)).getClass().getClassLoader();
        int priority = 6;
        int minThreadCount = 8;
        int maxThreadCount = 1000;
        int idleTimeout = 60000;
        boolean daemon = true;
        String namePrefix = "WaxMonsterAudioPlayer-";
        try {
            ThreadManager manager = Platform.getInstance().getThreadManager();
            return new DefaultThreadPool(manager, namePrefix, priority, daemon, contextLoader, minThreadCount, maxThreadCount, (long)idleTimeout);
        }
        catch (Exception e) {
            throw new StudioException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThreadPool getPlayerThreadPool() throws StudioException {
        if (this.playerThreadPool == null) {
            WaxMonsterAudioPlayerDeviceProvider waxMonsterAudioPlayerDeviceProvider = this;
            synchronized (waxMonsterAudioPlayerDeviceProvider) {
                if (this.playerThreadPool == null) {
                    this.setPlayerThreadPool(this.createPlayerThreadPool());
                }
            }
        }
        return this.playerThreadPool;
    }

    protected void setPlayerThreadPool(ThreadPool playerThreadPool) {
        this.playerThreadPool = playerThreadPool;
    }

    protected ThreadPool createPrepareThreadPool() throws StudioException {
        ClassLoader contextLoader = ((Object)((Object)this)).getClass().getClassLoader();
        int priority = 4;
        int minThreadCount = 4;
        int maxThreadCount = 1000;
        int idleTimeout = 60000;
        boolean daemon = true;
        String namePrefix = "WaxMonsterAudioPrepare-";
        try {
            ThreadManager manager = Platform.getInstance().getThreadManager();
            return new DefaultThreadPool(manager, namePrefix, priority, daemon, contextLoader, minThreadCount, maxThreadCount, (long)idleTimeout);
        }
        catch (Exception e) {
            throw new StudioException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThreadPool getPrepareThreadPool() throws StudioException {
        if (this.prepareThreadPool == null) {
            WaxMonsterAudioPlayerDeviceProvider waxMonsterAudioPlayerDeviceProvider = this;
            synchronized (waxMonsterAudioPlayerDeviceProvider) {
                if (this.prepareThreadPool == null) {
                    this.setPrepareThreadPool(this.createPrepareThreadPool());
                }
            }
        }
        return this.prepareThreadPool;
    }

    protected void setPrepareThreadPool(ThreadPool prepareThreadPool) {
        this.prepareThreadPool = prepareThreadPool;
    }

    protected ToolGroup lookupPlayerToolBarGroup() throws StudioException {
        try {
            return WaxMonsterAudioPlayerPlugin.getInstance().getPlayerToolBarGroup();
        }
        catch (Exception e) {
            throw new StudioException((Throwable)e);
        }
    }

    protected ToolGroup lookupPlayerPopupMenuGroup() throws StudioException {
        try {
            return WaxMonsterAudioPlayerPlugin.getInstance().getPlayerPopupMenuGroup();
        }
        catch (Exception e) {
            throw new StudioException((Throwable)e);
        }
    }

    protected Tool lookupToggleShuffleModeAction() throws StudioException {
        try {
            return WaxMonsterAudioPlayerPlugin.getInstance().getToggleShuffleModeAction();
        }
        catch (Exception e) {
            throw new StudioException((Throwable)e);
        }
    }

    protected Tool lookupTogglePauseResumeAction() throws StudioException {
        try {
            return WaxMonsterAudioPlayerPlugin.getInstance().getTogglePauseResumeAction();
        }
        catch (Exception e) {
            throw new StudioException((Throwable)e);
        }
    }
}

