/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.player;

import com.spacekiller.util.tooling.TAction;
import com.spacekiller.util.tooling.TToggleAction;
import com.spacekiller.util.tooling.ToolContext;
import com.waxmonster.audio.player.WaxMonsterAudioPlayerPanel;
import com.waxmonster.audio.player.WaxMonsterAudioPlayerToolContext;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JToggleButton;

public class WaxMonsterAudioPlayerExtensions {
    private WaxMonsterAudioPlayerExtensions() {
    }

    public static class EditMidiMappingsAction
    extends TAction {
        public void invoke(Object instance) {
            ToolContext context = this.getToolContext(instance);
            if (context == null) {
                return;
            }
            if (context instanceof WaxMonsterAudioPlayerToolContext) {
                WaxMonsterAudioPlayerToolContext wmaptc = (WaxMonsterAudioPlayerToolContext)context;
                WaxMonsterAudioPlayerPanel panel = wmaptc.getWaxMonsterAudioPlayerPanel();
                if (panel == null) {
                    return;
                }
                panel.showMidiMappingDialog();
            }
        }
    }

    public static class ToggleShuffleModeAction
    extends TToggleAction {
        public void invoke(Object instance) {
            ToolContext context = this.getToolContext(instance);
            if (context == null) {
                return;
            }
            if (context instanceof WaxMonsterAudioPlayerToolContext) {
                WaxMonsterAudioPlayerToolContext wmaptc = (WaxMonsterAudioPlayerToolContext)context;
                WaxMonsterAudioPlayerPanel panel = wmaptc.getWaxMonsterAudioPlayerPanel();
                if (panel == null) {
                    return;
                }
                boolean shuffle = this.isSelected(instance);
                panel.setShuffleMode(shuffle);
            }
        }

        protected void refreshInstance(Object instance) {
            super.refreshInstance(instance);
            if (instance != null) {
                ToolContext context = this.getToolContext(instance);
                if (context == null) {
                    return;
                }
                if (context instanceof WaxMonsterAudioPlayerToolContext) {
                    WaxMonsterAudioPlayerToolContext wmaptc = (WaxMonsterAudioPlayerToolContext)context;
                    WaxMonsterAudioPlayerPanel panel = wmaptc.getWaxMonsterAudioPlayerPanel();
                    if (panel == null) {
                        return;
                    }
                    boolean sel = panel.isShuffleMode();
                    if (instance instanceof JToggleButton) {
                        ((JToggleButton)instance).setSelected(sel);
                    } else if (instance instanceof JCheckBoxMenuItem) {
                        ((JCheckBoxMenuItem)instance).setSelected(sel);
                    }
                }
            }
        }
    }

    public static class TogglePauseResumeAction
    extends TToggleAction {
        public void invoke(Object instance) {
            ToolContext context = this.getToolContext(instance);
            if (context == null) {
                return;
            }
            if (context instanceof WaxMonsterAudioPlayerToolContext) {
                WaxMonsterAudioPlayerToolContext wmaptc = (WaxMonsterAudioPlayerToolContext)context;
                WaxMonsterAudioPlayerPanel panel = wmaptc.getWaxMonsterAudioPlayerPanel();
                if (panel == null) {
                    return;
                }
                panel.togglePauseResume();
            }
        }

        protected void refreshInstance(Object instance) {
            super.refreshInstance(instance);
            if (instance != null) {
                ToolContext context = this.getToolContext(instance);
                if (context == null) {
                    return;
                }
                if (context instanceof WaxMonsterAudioPlayerToolContext) {
                    boolean sel;
                    WaxMonsterAudioPlayerToolContext wmaptc = (WaxMonsterAudioPlayerToolContext)context;
                    WaxMonsterAudioPlayerPanel panel = wmaptc.getWaxMonsterAudioPlayerPanel();
                    if (panel == null) {
                        return;
                    }
                    int state = panel.getPlayerState();
                    boolean bl = sel = state == 2;
                    if (instance instanceof JToggleButton) {
                        ((JToggleButton)instance).setSelected(sel);
                    } else if (instance instanceof JCheckBoxMenuItem) {
                        ((JCheckBoxMenuItem)instance).setSelected(sel);
                    }
                }
            }
        }
    }

    public static class SkipPrevAction
    extends TAction {
        public void invoke(Object instance) {
            ToolContext context = this.getToolContext(instance);
            if (context == null) {
                return;
            }
            if (context instanceof WaxMonsterAudioPlayerToolContext) {
                WaxMonsterAudioPlayerToolContext wmaptc = (WaxMonsterAudioPlayerToolContext)context;
                WaxMonsterAudioPlayerPanel panel = wmaptc.getWaxMonsterAudioPlayerPanel();
                if (panel == null) {
                    return;
                }
                panel.skipPrev();
            }
        }
    }

    public static class SkipNextAction
    extends TAction {
        public void invoke(Object instance) {
            ToolContext context = this.getToolContext(instance);
            if (context == null) {
                return;
            }
            if (context instanceof WaxMonsterAudioPlayerToolContext) {
                WaxMonsterAudioPlayerToolContext wmaptc = (WaxMonsterAudioPlayerToolContext)context;
                WaxMonsterAudioPlayerPanel panel = wmaptc.getWaxMonsterAudioPlayerPanel();
                if (panel == null) {
                    return;
                }
                panel.skipNext();
            }
        }
    }

    public static class StopPlaybackAction
    extends TAction {
        public void invoke(Object instance) {
            ToolContext context = this.getToolContext(instance);
            if (context == null) {
                return;
            }
            if (context instanceof WaxMonsterAudioPlayerToolContext) {
                WaxMonsterAudioPlayerToolContext wmaptc = (WaxMonsterAudioPlayerToolContext)context;
                WaxMonsterAudioPlayerPanel panel = wmaptc.getWaxMonsterAudioPlayerPanel();
                if (panel == null) {
                    return;
                }
                panel.stop();
            }
        }
    }

    public static class StartPlaybackAction
    extends TAction {
        public void invoke(Object instance) {
            ToolContext context = this.getToolContext(instance);
            if (context == null) {
                return;
            }
            if (context instanceof WaxMonsterAudioPlayerToolContext) {
                WaxMonsterAudioPlayerToolContext wmaptc = (WaxMonsterAudioPlayerToolContext)context;
                WaxMonsterAudioPlayerPanel panel = wmaptc.getWaxMonsterAudioPlayerPanel();
                if (panel == null) {
                    return;
                }
                panel.play();
            }
        }
    }
}

