/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.player;

import com.spacekiller.util.beans.BeanProperty;
import com.spacekiller.util.beans.Property;
import com.spacekiller.util.media.AbstractPlayer;
import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.DefaultMediaMarker;
import com.spacekiller.util.media.EntryOrder;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaMarker;
import com.spacekiller.util.media.MediaPlayer;
import com.spacekiller.util.media.MediaPlayerContext;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.media.PlaybackHistory;
import com.spacekiller.util.media.PlaybackHistoryEntry;
import com.spacekiller.util.media.Player;
import com.spacekiller.util.media.PlayerItem;
import com.spacekiller.util.media.PlayerListener;
import com.spacekiller.util.media.PlayerSequence;
import com.spacekiller.util.media.control.TrackPositionSlider;
import com.spacekiller.util.media.manager.AbstractEntryPropertiesPanel;
import com.spacekiller.util.media.manager.AudioEntryPropertiesPanel;
import com.spacekiller.util.media.manager.MediaEntryDetailsPanel;
import com.spacekiller.util.media.manager.MediaEntryOverviewPanel;
import com.spacekiller.util.media.manager.MediaEntryTabbedPanel;
import com.spacekiller.util.media.manager.MediaMarkerPropertiesPanel;
import com.spacekiller.util.media.manager.MediaTableEntry;
import com.spacekiller.util.media.manager.NormalEntryOrder;
import com.spacekiller.util.media.manager.PictureEntryPropertiesPanel;
import com.spacekiller.util.media.manager.ShuffledEntryOrder;
import com.spacekiller.util.midi.MidiFormatter;
import com.spacekiller.util.midi.impl.DefaultMidiFactory;
import com.spacekiller.util.midi.impl.DefaultMidiFormatter;
import com.spacekiller.util.tooling.AbstractToolContext;
import com.spacekiller.util.tooling.Tool;
import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.tooling.ToolGroup;
import com.waxmonster.audio.player.AudioPlayerItem;
import com.waxmonster.audio.player.WaxMonsterAudioPlayerDevice;
import com.waxmonster.audio.player.WaxMonsterAudioPlayerToolContext;
import com.waxmonster.midi.MidiMappable;
import com.waxmonster.midi.MidiMapper;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.common.AbstractMidiMapper;
import com.waxmonster.midi.common.MidiMappingManagerPanel;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class WaxMonsterAudioPlayerPanel
extends JPanel
implements MidiMappable {
    private static final long serialVersionUID = 8363984517918242274L;
    private static final Logger logger = Logger.getLogger(WaxMonsterAudioPlayerPanel.class.getName());
    private static final String KEY_SHUFFLE_MODE = "shuffleMode";
    private WaxMonsterAudioPlayerDevice device;
    private final MidiMapperImpl midiMapper = new MidiMapperImpl();
    private AbstractPlayer player;
    private ToolGroup playerToolBarGroup;
    private JToolBar playerToolBar;
    private ToolGroup playerPopupMenuGroup;
    private JPopupMenu playerPopupMenu;
    private ToolContextImpl toolContextImpl = new ToolContextImpl();
    private EntryRefresher entryRefresher = new EntryRefresher();
    private boolean playEnabled;
    private boolean pauseEnabled;
    private boolean stopEnabled;
    private Tool togglePauseResumeAction;
    private EntryOrder entryOrder;
    private boolean shuffleMode;
    private Tool shuffleModeAction;
    private boolean loopPlaylist;
    private PlaybackHistory playbackHistory;
    private final PlayerHandler playerHandler = new PlayerHandler();
    private final PlayerStateChanged playerStateChanged = new PlayerStateChanged();
    private MediaPlayerContext playerContext;
    private volatile MediaTableEntry activeEntry;
    private volatile int activeEntryRow;
    private long activeEntryStartTime;
    private PlaybackHistoryEntry activeHistoryEntry;
    private final Object playSequenceLock = new Object();
    private PlayerSequenceImpl primarySequence = new PlayerSequenceImpl();
    private PlayerSequenceImpl secondarySequence = new PlayerSequenceImpl();
    private volatile AudioPlayerItem nextItem;
    private MediaEntryTabbedPanel mediaEntryTabbedPanel;
    private JPanel panelPlayerToolBar;
    private JPanel panelPlayerTools;
    private JPanel panelPlayerSlider;
    private TrackPositionSlider trackPositionSlider;
    private MediaEntryOverviewPanel mediaEntryOverviewPanel;
    private AudioEntryPropertiesPanel audioEntryPropertiesPanel;
    private PictureEntryPropertiesPanel pictureEntryPropertiesPanel;
    private MediaMarkerPropertiesPanel mediaMarkerPropertiesPanel;
    private MediaEntryDetailsPanel mediaEntryDetailsPanel;

    public WaxMonsterAudioPlayerPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.panelPlayerTools = new JPanel();
        GridBagConstraints gbc_panelPlayerTools = new GridBagConstraints();
        gbc_panelPlayerTools.fill = 1;
        gbc_panelPlayerTools.gridx = 0;
        gbc_panelPlayerTools.gridy = 0;
        this.add((Component)this.panelPlayerTools, gbc_panelPlayerTools);
        GridBagLayout gbl_panelPlayerTools = new GridBagLayout();
        gbl_panelPlayerTools.columnWidths = new int[]{0, 0, 0};
        gbl_panelPlayerTools.rowHeights = new int[]{0, 0, 0};
        gbl_panelPlayerTools.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelPlayerTools.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        this.panelPlayerTools.setLayout(gbl_panelPlayerTools);
        this.panelPlayerToolBar = new JPanel();
        GridBagConstraints gbc_panelPlayerToolBar = new GridBagConstraints();
        gbc_panelPlayerToolBar.insets = new Insets(0, 0, 0, 4);
        gbc_panelPlayerToolBar.fill = 1;
        gbc_panelPlayerToolBar.gridx = 0;
        gbc_panelPlayerToolBar.gridy = 0;
        this.panelPlayerTools.add((Component)this.panelPlayerToolBar, gbc_panelPlayerToolBar);
        this.panelPlayerToolBar.setLayout(new GridLayout(1, 0, 0, 0));
        JLabel lblDummyToolbar = new JLabel("Toolbar");
        this.panelPlayerToolBar.add(lblDummyToolbar);
        this.panelPlayerSlider = new JPanel();
        GridBagConstraints gbc_panelPlayerSlider = new GridBagConstraints();
        gbc_panelPlayerSlider.insets = new Insets(0, 0, 0, 4);
        gbc_panelPlayerSlider.weightx = 1.0;
        gbc_panelPlayerSlider.fill = 2;
        gbc_panelPlayerSlider.gridx = 1;
        gbc_panelPlayerSlider.gridy = 0;
        this.panelPlayerTools.add((Component)this.panelPlayerSlider, gbc_panelPlayerSlider);
        this.panelPlayerSlider.setLayout(new GridLayout(1, 0, 0, 0));
        this.trackPositionSlider = new TrackPositionSlider();
        this.panelPlayerSlider.add((Component)this.trackPositionSlider);
        this.mediaEntryTabbedPanel = new MediaEntryTabbedPanel();
        GridBagConstraints gbc_mediaEntryPropertiesPanel = new GridBagConstraints();
        gbc_mediaEntryPropertiesPanel.weighty = 1.0;
        gbc_mediaEntryPropertiesPanel.weightx = 1.0;
        gbc_mediaEntryPropertiesPanel.fill = 1;
        gbc_mediaEntryPropertiesPanel.gridx = 0;
        gbc_mediaEntryPropertiesPanel.gridy = 1;
        this.add((Component)this.mediaEntryTabbedPanel, gbc_mediaEntryPropertiesPanel);
        this.initWaxMonsterAudioPlayerPanel();
    }

    protected void initWaxMonsterAudioPlayerPanel() {
        MouseHandler popupMouseHandler = new MouseHandler();
        this.addMouseListener(popupMouseHandler);
        this.mediaEntryTabbedPanel.addMouseListener((MouseListener)popupMouseHandler);
        this.mediaEntryTabbedPanel.getTextFieldResource().addMouseListener(popupMouseHandler);
        this.mediaEntryTabbedPanel.getTabbedPane().addMouseListener(popupMouseHandler);
        this.mediaEntryOverviewPanel = new MediaEntryOverviewPanel();
        this.audioEntryPropertiesPanel = new AudioEntryPropertiesPanel();
        this.pictureEntryPropertiesPanel = new PictureEntryPropertiesPanel();
        this.mediaMarkerPropertiesPanel = new MediaMarkerPropertiesPanel();
        this.mediaEntryDetailsPanel = new MediaEntryDetailsPanel();
        this.mediaEntryTabbedPanel.setMediaEntryPropertiesPanels(new AbstractEntryPropertiesPanel[]{this.mediaEntryOverviewPanel, this.audioEntryPropertiesPanel, this.pictureEntryPropertiesPanel, this.mediaMarkerPropertiesPanel, this.mediaEntryDetailsPanel});
    }

    public WaxMonsterAudioPlayerDevice getDevice() {
        return this.device;
    }

    public synchronized void setDevice(WaxMonsterAudioPlayerDevice device) {
        if (this.device == device) {
            return;
        }
        this.device = device;
        this.mediaEntryTabbedPanel.setMediaPlayer((MediaPlayer)device);
    }

    protected synchronized void refreshMidiMapper() {
        try {
            this.midiMapper.unregisterAllMidiActions();
            WaxMonsterAudioPlayerDevice dev = this.device;
            if (dev == null) {
                return;
            }
            JToolBar playerToolBar = this.playerToolBar;
            if (playerToolBar == null) {
                return;
            }
            Component[] comps = playerToolBar.getComponents();
            Component comp = this.getComponent(comps, "MenuItem_WaxMonsterAudioPlayer_StartPlayback");
            if (comp != null) {
                this.midiMapper.registerMidiAction(comp, dev.getTogglePlayPauseMidiAction().getName());
            }
            if ((comp = this.getComponent(comps, "MenuItem_WaxMonsterAudioPlayer_PausePlayback")) != null) {
                this.midiMapper.registerMidiAction(comp, dev.getTogglePauseResumeMidiAction().getName());
            }
            if ((comp = this.getComponent(comps, "MenuItem_WaxMonsterAudioPlayer_StopPlayback")) != null) {
                this.midiMapper.registerMidiAction(comp, dev.getStopMidiAction().getName());
            }
            if ((comp = this.getComponent(comps, "MenuItem_WaxMonsterAudioPlayer_SkipPrev")) != null) {
                this.midiMapper.registerMidiAction(comp, dev.getSkipPrevMidiAction().getName());
            }
            if ((comp = this.getComponent(comps, "MenuItem_WaxMonsterAudioPlayer_SkipNext")) != null) {
                this.midiMapper.registerMidiAction(comp, dev.getSkipNextMidiAction().getName());
            }
            Component component = comp = this.mediaEntryOverviewPanel == null ? null : this.mediaEntryOverviewPanel.getIncreaseRatingButton();
            if (comp != null) {
                this.midiMapper.registerMidiAction(comp, dev.getIncrementRatingMidiAction().getName());
            }
            Component component2 = comp = this.mediaEntryOverviewPanel == null ? null : this.mediaEntryOverviewPanel.getDecreaseRatingButton();
            if (comp != null) {
                this.midiMapper.registerMidiAction(comp, dev.getDecrementRatingMidiAction().getName());
            }
            Component component3 = comp = this.mediaMarkerPropertiesPanel == null ? null : this.mediaMarkerPropertiesPanel.getAddMarkerButton();
            if (comp != null) {
                this.midiMapper.registerMidiAction(comp, dev.getMarkerMidiAction().getName());
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected Component getComponent(Component[] comps, String name) {
        int num = comps.length;
        for (int i = 0; i < num; ++i) {
            if (!name.equals(comps[i].getName())) continue;
            return comps[i];
        }
        return null;
    }

    protected AbstractPlayer getPlayer() {
        return this.player;
    }

    public synchronized void setPlayer(AbstractPlayer newPlayer) {
        if (newPlayer == this.player) {
            return;
        }
        if (this.player != null) {
            this.player.removePlayerListener((PlayerListener)this.playerHandler);
        }
        this.player = newPlayer;
        if (newPlayer != null) {
            newPlayer.addPlayerListener((PlayerListener)this.playerHandler);
        }
        this.trackPositionSlider.setAudioPlayer((Player)newPlayer);
        this.mediaMarkerPropertiesPanel.setAudioPlayer((Player)newPlayer);
        this.playerStateChanged((Player)newPlayer);
    }

    protected void showMidiMappingDialog() {
        if (this.device == null) {
            return;
        }
        try {
            MidiMappingManagerPanel panel = new MidiMappingManagerPanel();
            panel.setStudio(this.device.getStudio());
            panel.setDeviceName("AudioPlayerMidiControl");
            panel.setMidiFactory(DefaultMidiFactory.getInstance());
            panel.setMidiFormatter((MidiFormatter)DefaultMidiFormatter.getSharedInstance());
            panel.setAvailableActions(this.device.getAvailableMidiActions());
            MidiMapping[] origMappings = this.device.getMidiActionMappings();
            int origCount = origMappings == null ? 0 : origMappings.length;
            MidiMapping[] cloneMappings = new MidiMapping[origCount];
            if (origCount > 0) {
                System.arraycopy(origMappings, 0, cloneMappings, 0, origCount);
            }
            panel.setMappings(cloneMappings);
            String title = "MIDI Mappings";
            if (!panel.showDialog((Component)this, title)) {
                return;
            }
            MidiMapping[] newMappings = panel.getMappings();
            this.device.setMidiActionMappings(newMappings);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public boolean play() {
        try {
            MediaPlayerContext mpc = this.playerContext;
            if (mpc == null) {
                return false;
            }
            int leadIndex = mpc.getSelectedIndex();
            if (leadIndex < 0) {
                leadIndex = 0;
            }
            return this.play(leadIndex);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean play(int tableRow) throws Exception {
        AudioPlayerItem item;
        AbstractPlayer wmap = this.getPlayer();
        if (wmap == null) {
            return false;
        }
        MediaPlayerContext mpc = this.playerContext;
        if (mpc == null) {
            return false;
        }
        int entryCount = mpc.getEntryCount();
        if (tableRow < 0 || tableRow >= entryCount) {
            return false;
        }
        MediaTableEntry mte = null;
        MediaCrateEntry mce = mpc.getEntryAt(tableRow);
        if (mce != null && mce instanceof MediaTableEntry) {
            mte = (MediaTableEntry)mce;
        }
        if (mte == null) {
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("play: " + mce.getResource() + ", row=" + tableRow);
        }
        if ((item = this.createAudioPlayerItem(mte, tableRow)) == null) {
            return false;
        }
        WaxMonsterAudioPlayerPanel waxMonsterAudioPlayerPanel = this;
        synchronized (waxMonsterAudioPlayerPanel) {
            this.nextItem = item;
            this.activeHistoryEntry = null;
        }
        wmap.play((PlayerSequence)this.swapPlayerSequence());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PlayerSequenceImpl swapPlayerSequence() {
        PlayerSequenceImpl seq;
        Object object = this.playSequenceLock;
        synchronized (object) {
            seq = this.secondarySequence;
            this.secondarySequence = this.primarySequence;
            this.primarySequence = seq;
        }
        return seq;
    }

    protected PlayerItem nextPlayerItem() {
        EntryOrder order;
        MediaCrateEntry crateEntry;
        AudioPlayerItem item = this.nextItem;
        if (item != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("nextPlayerItem: nextItem=" + (Object)((Object)item));
            }
            this.nextItem = null;
            return item;
        }
        MediaPlayerContext mpc = this.playerContext;
        if (mpc == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("nextPlayerItem: No player context available!");
            }
            return null;
        }
        MediaTableEntry currentEntry = null;
        PlayerItem crateItem = this.player.getNextItem();
        if (crateItem == null) {
            crateItem = this.player.getCurrentItem();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("nextPlayerItem: crateItem=" + crateItem);
        }
        int currentIndex = -1;
        if (crateItem != null && (crateEntry = crateItem.getCrateEntry()) != null && crateEntry instanceof MediaTableEntry) {
            currentEntry = (MediaTableEntry)crateEntry;
            currentIndex = mpc.getEntryIndex((MediaCrateEntry)currentEntry, crateItem.getCrateEntryIndex());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("nextPlayerItem: crateItem=" + crateItem + ", currentIndex=" + currentIndex);
        }
        if ((order = this.entryOrder) != null) {
            MediaCrateEntry crateEntry2;
            order.setCurrentEntry((MediaCrateEntry)currentEntry);
            order.setCurrentIndex(currentIndex);
            int maxRetries = 10;
            for (int x = 0; x <= maxRetries && (crateEntry2 = order.skipNextEntry()) != null; ++x) {
                int nextIndex;
                MediaTableEntry nextEntry;
                if (!(crateEntry2 instanceof MediaTableEntry) || (item = this.createAudioPlayerItem(nextEntry = (MediaTableEntry)crateEntry2, nextIndex = order.getCurrentIndex())) == null) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("nextPlayerItem: #" + nextIndex + " = " + nextEntry.getResource());
                }
                return item;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("nextPlayerItem: No more items to play.");
        }
        return null;
    }

    protected AudioPlayerItem createAudioPlayerItem(MediaTableEntry entry, int tableRow) {
        AudioEntry ae;
        if (entry == null) {
            return null;
        }
        MediaEntry me = entry.getMediaEntry();
        if (me == null) {
            MediaPlayerContext ctx = this.playerContext;
            if (ctx == null) {
                return null;
            }
            me = ctx.getMediaEntry((MediaCrateEntry)entry);
            if (me == null) {
                return null;
            }
        }
        if ((ae = me.getAudioEntry()) == null) {
            return null;
        }
        long frameCount = ae.getFrameCount();
        double frameRate = ae.getFrameRate();
        long frameLen = -1L;
        AbstractPlayer wmap = this.getPlayer();
        if (frameCount > 0L && frameRate > 0.0 && wmap != null) {
            double playRate = wmap.getFrameRate();
            double frames = (double)frameCount * playRate / frameRate;
            frameLen = (long)Math.ceil(frames);
        }
        return new AudioPlayerItem(entry, tableRow, me, frameLen);
    }

    public void togglePauseResume() {
        try {
            AbstractPlayer wmap = this.getPlayer();
            if (wmap.isPaused()) {
                wmap.resume();
            } else {
                wmap.pause();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void stop() {
        try {
            AbstractPlayer wmap = this.getPlayer();
            wmap.stop();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipNext() {
        try {
            Object nextHistoryEntry;
            PlaybackHistory hist;
            PlaybackHistoryEntry actHistEntry = null;
            MediaTableEntry skipEntry = null;
            int skipTableRow = -1;
            WaxMonsterAudioPlayerPanel waxMonsterAudioPlayerPanel = this;
            synchronized (waxMonsterAudioPlayerPanel) {
                actHistEntry = this.activeHistoryEntry;
            }
            if (actHistEntry != null && (hist = this.playbackHistory) != null) {
                MediaCrateEntry mce;
                nextHistoryEntry = hist.getNextEntry(actHistEntry);
                if (nextHistoryEntry != null && (mce = nextHistoryEntry.getMediaCrateEntry()) != null && mce instanceof MediaTableEntry) {
                    skipEntry = (MediaTableEntry)mce;
                    skipTableRow = nextHistoryEntry.getExpectedRow();
                }
                actHistEntry = nextHistoryEntry;
            }
            AudioPlayerItem item = null;
            if (skipEntry != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("skipNext: " + skipEntry.getResource());
                }
                item = this.createAudioPlayerItem(skipEntry, skipTableRow);
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine("skipNext...");
            }
            nextHistoryEntry = this;
            synchronized (nextHistoryEntry) {
                this.nextItem = item;
                this.activeHistoryEntry = actHistEntry;
            }
            AbstractPlayer wmap = this.getPlayer();
            if (wmap != null) {
                wmap.play((PlayerSequence)this.swapPlayerSequence());
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipPrev() {
        try {
            AudioPlayerItem item;
            WaxMonsterAudioPlayerPanel prevHistoryEntry;
            MediaTableEntry actEntry = null;
            int actEntryRow = -1;
            Object actHistEntry = null;
            MediaTableEntry skipEntry = null;
            int skipTableRow = -1;
            WaxMonsterAudioPlayerPanel waxMonsterAudioPlayerPanel = this;
            synchronized (waxMonsterAudioPlayerPanel) {
                actEntry = this.activeEntry;
                actEntryRow = this.activeEntryRow;
                actHistEntry = this.activeHistoryEntry;
            }
            if (skipEntry == null) {
                PlaybackHistory hist = this.playbackHistory;
                if (hist != null) {
                    prevHistoryEntry = null;
                    prevHistoryEntry = actHistEntry == null ? hist.getLastEntry() : hist.getPrevEntry(actHistEntry);
                    if (prevHistoryEntry != null) {
                        MediaCrateEntry mce = prevHistoryEntry.getMediaCrateEntry();
                        if (mce != null && mce instanceof MediaTableEntry) {
                            skipEntry = (MediaTableEntry)mce;
                            skipTableRow = prevHistoryEntry.getExpectedRow();
                        }
                        actHistEntry = prevHistoryEntry;
                    } else {
                        actHistEntry = null;
                    }
                }
                if (skipEntry == null) {
                    if (actEntry != null && actEntryRow > 0) {
                        skipTableRow = actEntryRow - 1;
                        logger.warning("TODO skip to previous row: " + skipTableRow);
                    }
                    if (skipEntry == null) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("skipPrev: " + skipEntry);
                        }
                        return;
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("skipPrev: " + skipEntry.getResource());
                }
            }
            if ((item = this.createAudioPlayerItem(skipEntry, skipTableRow)) == null) {
                return;
            }
            prevHistoryEntry = this;
            synchronized (prevHistoryEntry) {
                this.nextItem = item;
                this.activeHistoryEntry = actHistEntry;
            }
            AbstractPlayer wmap = this.getPlayer();
            if (wmap != null) {
                wmap.play((PlayerSequence)this.swapPlayerSequence());
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public synchronized boolean isShuffleMode() {
        return this.shuffleMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setShuffleMode(boolean shuffleMode) {
        if (this.shuffleMode == shuffleMode) {
            return;
        }
        try {
            this.shuffleMode = shuffleMode;
            this.adjustEntryOrder();
            this.activeHistoryEntry = null;
        }
        finally {
            if (this.shuffleModeAction != null) {
                this.shuffleModeAction.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setCurrentEntry(MediaCrateEntry entry, MediaPlayerContext context, int index) {
        MediaTableEntry mte = null;
        MediaEntry me = null;
        try {
            Studio studio;
            WaxMonsterAudioPlayerDevice dev;
            AbstractPlayer wmap;
            if (context != null) {
                this.setPlayerContext(context);
            }
            if (entry != null && entry instanceof MediaTableEntry) {
                mte = (MediaTableEntry)entry;
                me = mte.getMediaEntry();
            }
            if ((wmap = this.player) == null && mte != null && (dev = this.device) != null && (studio = dev.getStudio()) != null && !studio.isStarted()) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Starting studio automatically: " + studio);
                }
                studio.start();
                if (!studio.isStarted()) {
                    throw new StudioException("Studio is not started: " + studio);
                }
                wmap = this.player;
            }
            if (mte == null || wmap == null) {
                this.mediaEntryTabbedPanel.setMediaEntry(me);
                this.mediaEntryTabbedPanel.refresh();
                return;
            }
            AudioPlayerItem item = this.createAudioPlayerItem(mte, index);
            if (item == null) {
                return;
            }
            WaxMonsterAudioPlayerPanel waxMonsterAudioPlayerPanel = this;
            synchronized (waxMonsterAudioPlayerPanel) {
                this.nextItem = item;
                this.activeHistoryEntry = null;
            }
            wmap.play((PlayerSequence)this.swapPlayerSequence());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            this.mediaEntryTabbedPanel.setMediaEntry(me);
            this.mediaEntryTabbedPanel.refresh();
        }
    }

    protected void playerStateChanged(Player player) {
        if (logger.isLoggable(Level.FINE)) {
            int state = player == null ? 0 : player.getState();
            logger.fine("playerStateChanged: state=" + state + ", player=" + player);
        }
        SwingUtilities.invokeLater(this.playerStateChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void playerItemChanged(Player player) {
        PlaybackHistory hist;
        MediaPlayerContext mpc;
        AudioPlayerItem crateItem;
        MediaCrateEntry crateEntry;
        long timeMillis = System.currentTimeMillis();
        MediaTableEntry tableEntry = null;
        int expectedRow = -1;
        PlayerItem item = player.getCurrentItem();
        if (item != null && item instanceof AudioPlayerItem && (crateEntry = (crateItem = (AudioPlayerItem)item).getCrateEntry()) != null && crateEntry instanceof MediaTableEntry) {
            tableEntry = (MediaTableEntry)crateEntry;
            expectedRow = crateItem.getCrateEntryIndex();
        }
        if (logger.isLoggable(Level.FINE)) {
            if (tableEntry == null) {
                logger.fine("playerItemChanged: <none>");
            } else {
                logger.fine("playerItemChanged: resource=" + tableEntry.getResource() + ", expectedRow=" + expectedRow);
            }
        }
        MediaTableEntry prevEntry = null;
        int prevEntryRow = -1;
        long prevEntryStartTime = 0L;
        WaxMonsterAudioPlayerPanel waxMonsterAudioPlayerPanel = this;
        synchronized (waxMonsterAudioPlayerPanel) {
            if (this.activeHistoryEntry == null) {
                prevEntry = this.activeEntry;
                prevEntryRow = this.activeEntryRow;
                prevEntryStartTime = this.activeEntryStartTime;
            }
            this.activeEntry = tableEntry;
            this.activeEntryRow = expectedRow;
            this.activeEntryStartTime = timeMillis;
            mpc = this.getPlayerContext();
            if (mpc != null) {
                mpc.playerEntryChanged((MediaPlayer)this.device, (MediaCrateEntry)tableEntry, expectedRow);
            }
        }
        if (prevEntry != null && (hist = this.playbackHistory) != null) {
            MediaCrateEntry lastEntry;
            boolean append = true;
            PlaybackHistoryEntry lastHist = hist.getLastEntry();
            if (lastHist != null && (lastEntry = lastHist.getMediaCrateEntry()) == prevEntry) {
                append = false;
            }
            if (append) {
                hist.appendEntry((MediaCrateEntry)prevEntry, prevEntryRow, prevEntryStartTime, timeMillis);
            }
        }
        MediaEntry me = null;
        if (tableEntry != null && (me = tableEntry.getMediaEntry()) == null) {
            try {
                mpc = this.playerContext;
                if (mpc != null && (me = mpc.getMediaEntry((MediaCrateEntry)tableEntry)) != null) {
                    tableEntry.setMediaEntry(me);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (this.mediaEntryTabbedPanel.getMediaEntry() != me) {
            SwingUtilities.invokeLater(this.entryRefresher);
        }
    }

    public PlaybackHistory getPlaybackHistory() {
        return this.playbackHistory;
    }

    public void setPlaybackHistory(PlaybackHistory playbackHistory) {
        this.playbackHistory = playbackHistory;
    }

    public boolean isLoopPlaylist() {
        return this.loopPlaylist;
    }

    public void setLoopPlaylist(boolean loopPlaylist) {
        this.loopPlaylist = loopPlaylist;
    }

    public MidiMapper getMidiMapper() {
        return this.midiMapper;
    }

    public MediaMarker putMediaMarker(int markerType, int markerIndex, String markerName) {
        AbstractPlayer wmap = this.player;
        if (wmap == null) {
            return null;
        }
        PlayerItem currentItem = wmap.getCurrentItem();
        if (currentItem != null && currentItem instanceof AudioPlayerItem) {
            AudioPlayerItem audioPlayerItem = (AudioPlayerItem)currentItem;
            double positionMillis = wmap.getTimePosition((PlayerItem)audioPlayerItem);
            if (positionMillis < 0.0) {
                return null;
            }
            MediaPlayerContext mpc = this.playerContext;
            if (mpc == null) {
                return null;
            }
            MediaTableEntry currentEntry = null;
            MediaCrateEntry crateEntry = audioPlayerItem.getCrateEntry();
            if (crateEntry != null && crateEntry instanceof MediaTableEntry) {
                currentEntry = (MediaTableEntry)crateEntry;
            }
            if (currentEntry == null) {
                return null;
            }
            MediaEntry me = currentEntry.getMediaEntry();
            if (me != null && me instanceof MutableMediaEntry) {
                MutableMediaEntry ame = (MutableMediaEntry)me;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("putMediaMarker: type=" + markerType + ", index=" + markerIndex + ", name=" + markerName + ", positionMillis=" + positionMillis);
                }
                DefaultMediaMarker marker = new DefaultMediaMarker(markerType, markerIndex, positionMillis, markerName);
                mpc.putMediaMarker(ame, (MediaMarker)marker);
                SwingUtilities.invokeLater(this.entryRefresher);
                return marker;
            }
        }
        return null;
    }

    public boolean increaseUserRating(double amount) {
        WaxMonsterAudioPlayerDevice dev = this.device;
        if (dev == null) {
            return false;
        }
        MediaPlayerContext mpc = this.getPlayerContext();
        if (mpc == null) {
            return false;
        }
        MediaTableEntry entry = this.activeEntry;
        if (entry == null) {
            return false;
        }
        MediaEntry me = mpc.getMediaEntry((MediaCrateEntry)entry);
        if (me != null && me instanceof MutableMediaEntry) {
            MutableMediaEntry mme = (MutableMediaEntry)me;
            mpc.increaseUserRating(mme, amount);
            SwingUtilities.invokeLater(this.entryRefresher);
            return true;
        }
        return false;
    }

    public void saveViewPreferences(Properties props) throws Exception {
        props.setProperty(KEY_SHUFFLE_MODE, Boolean.toString(this.shuffleMode));
    }

    public void loadViewPreferences(Properties props) throws Exception {
        String s = props.getProperty(KEY_SHUFFLE_MODE);
        if (s != null) {
            this.setShuffleMode("true".equalsIgnoreCase(s));
        }
    }

    protected MediaEntryTabbedPanel getMediaEntryTabbedPanel() {
        return this.mediaEntryTabbedPanel;
    }

    protected JPanel getPanelPlayerToolBar() {
        return this.panelPlayerToolBar;
    }

    public ToolGroup getPlayerToolBarGroup() {
        return this.playerToolBarGroup;
    }

    public synchronized void setPlayerToolBarGroup(ToolGroup playerToolBarGroup) {
        this.playerToolBarGroup = playerToolBarGroup;
        this.panelPlayerToolBar.removeAll();
        if (playerToolBarGroup != null) {
            this.playerToolBar = (JToolBar)playerToolBarGroup.createInstance((ToolContext)this.toolContextImpl, JToolBar.class);
            if (this.playerToolBar != null) {
                this.panelPlayerToolBar.add(this.playerToolBar);
            }
        }
        this.panelPlayerToolBar.validate();
        this.panelPlayerToolBar.repaint();
        this.refreshMidiMapper();
    }

    public Tool getShuffleModeAction() {
        return this.shuffleModeAction;
    }

    public void setShuffleModeAction(Tool shuffleModeAction) {
        this.shuffleModeAction = shuffleModeAction;
    }

    public MediaPlayerContext getPlayerContext() {
        return this.playerContext;
    }

    protected void setPlayerContext(MediaPlayerContext playerContext) {
        if (this.playerContext == playerContext) {
            return;
        }
        this.playerContext = playerContext;
        this.adjustEntryOrder();
        this.getMediaEntryTabbedPanel().setMediaPlayerContext(playerContext);
        this.setPlayEnabled(playerContext != null);
    }

    protected void adjustEntryOrder() {
        EntryOrder order = null;
        if (this.playerContext != null) {
            order = this.createEntryOrder(this.shuffleMode);
        }
        this.setEntryOrder(order);
    }

    protected EntryOrder createEntryOrder(boolean shuffleMode) {
        if (shuffleMode) {
            return new ShuffledEntryOrder(this.playerContext);
        }
        return new NormalEntryOrder(this.playerContext);
    }

    protected JPanel getPanelPlayerSlider() {
        return this.panelPlayerSlider;
    }

    protected TrackPositionSlider getTrackPositionSlider() {
        return this.trackPositionSlider;
    }

    public ToolGroup getPlayerPopupMenuGroup() {
        return this.playerPopupMenuGroup;
    }

    public void setPlayerPopupMenuGroup(ToolGroup playerPopupMenuGroup) {
        this.playerPopupMenuGroup = playerPopupMenuGroup;
    }

    protected void showPopupMenu(MouseEvent ev) {
        int y;
        Component comp = ev.getComponent();
        if (comp == null) {
            return;
        }
        int x = ev.getX();
        if (this.showPopupMenu(comp, x, y = ev.getY())) {
            ev.consume();
        }
    }

    protected boolean showPopupMenu(Component invoker, int x, int y) {
        if (this.playerPopupMenu == null) {
            if (this.playerPopupMenuGroup == null) {
                return false;
            }
            this.playerPopupMenu = (JPopupMenu)this.playerPopupMenuGroup.createInstance((ToolContext)this.toolContextImpl, JPopupMenu.class);
        }
        this.playerPopupMenu.show(invoker, x, y);
        return true;
    }

    public boolean isPlayEnabled() {
        return this.playEnabled;
    }

    protected void setPlayEnabled(boolean playEnabled) {
        if (this.playEnabled == playEnabled) {
            return;
        }
        this.playEnabled = playEnabled;
        this.firePropertyChange("playEnabled", !playEnabled, playEnabled);
    }

    public boolean isPauseEnabled() {
        return this.pauseEnabled;
    }

    protected void setPauseEnabled(boolean pauseEnabled) {
        if (this.pauseEnabled == pauseEnabled) {
            return;
        }
        this.pauseEnabled = pauseEnabled;
        this.firePropertyChange("pauseEnabled", !pauseEnabled, pauseEnabled);
    }

    public boolean isStopEnabled() {
        return this.stopEnabled;
    }

    protected void setStopEnabled(boolean stopEnabled) {
        if (this.stopEnabled == stopEnabled) {
            return;
        }
        this.stopEnabled = stopEnabled;
        this.firePropertyChange("stopEnabled", !stopEnabled, stopEnabled);
    }

    protected EntryOrder getEntryOrder() {
        return this.entryOrder;
    }

    protected void setEntryOrder(EntryOrder entryOrder) {
        this.entryOrder = entryOrder;
    }

    public int getPlayerState() {
        AbstractPlayer player = this.getPlayer();
        int state = player == null ? 0 : player.getState();
        return state;
    }

    public Tool getTogglePauseResumeAction() {
        return this.togglePauseResumeAction;
    }

    public void setTogglePauseResumeAction(Tool togglePauseResumeAction) {
        this.togglePauseResumeAction = togglePauseResumeAction;
    }

    protected class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (e.isPopupTrigger()) {
                WaxMonsterAudioPlayerPanel.this.showPopupMenu(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (e.isPopupTrigger()) {
                WaxMonsterAudioPlayerPanel.this.showPopupMenu(e);
            }
        }
    }

    protected class EntryRefresher
    implements Runnable {
        protected EntryRefresher() {
        }

        @Override
        public void run() {
            MediaTableEntry mte = WaxMonsterAudioPlayerPanel.this.activeEntry;
            MediaEntry me = mte == null ? null : mte.getMediaEntry();
            WaxMonsterAudioPlayerPanel.this.mediaEntryTabbedPanel.setMediaEntry(me);
            WaxMonsterAudioPlayerPanel.this.mediaEntryTabbedPanel.refresh();
        }
    }

    protected class ToolContextImpl
    extends AbstractToolContext
    implements WaxMonsterAudioPlayerToolContext {
        public ToolContextImpl() {
            this.initToolContextImpl();
        }

        protected void initToolContextImpl() {
            try {
                BeanProperty playEnabledProperty = BeanProperty.getBeanProperty((Object)WaxMonsterAudioPlayerPanel.this, (String)"playEnabled");
                this.setProperty("playEnabled", (Property)playEnabledProperty);
                BeanProperty pauseEnabledProperty = BeanProperty.getBeanProperty((Object)WaxMonsterAudioPlayerPanel.this, (String)"pauseEnabled");
                this.setProperty("pauseEnabled", (Property)pauseEnabledProperty);
                BeanProperty stopEnabledProperty = BeanProperty.getBeanProperty((Object)WaxMonsterAudioPlayerPanel.this, (String)"stopEnabled");
                this.setProperty("stopEnabled", (Property)stopEnabledProperty);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public WaxMonsterAudioPlayerPanel getWaxMonsterAudioPlayerPanel() {
            return WaxMonsterAudioPlayerPanel.this;
        }
    }

    protected class MidiMapperImpl
    extends AbstractMidiMapper {
        protected MidiMapperImpl() {
        }

        public MidiMapping[] getMidiMappings(Object component) {
            return WaxMonsterAudioPlayerPanel.this.device.getMidiActionMappings();
        }

        public void setMidiMappings(Object component, MidiMapping[] mappings) {
            WaxMonsterAudioPlayerPanel.this.device.setMidiActionMappings(mappings);
        }
    }

    protected class PlayerStateChanged
    implements Runnable {
        protected PlayerStateChanged() {
        }

        @Override
        public void run() {
            AbstractPlayer player = WaxMonsterAudioPlayerPanel.this.getPlayer();
            int state = player == null ? 0 : player.getState();
            switch (state) {
                case 1: {
                    WaxMonsterAudioPlayerPanel.this.setPauseEnabled(true);
                    WaxMonsterAudioPlayerPanel.this.setStopEnabled(true);
                    break;
                }
                case 2: {
                    break;
                }
                case 0: {
                    WaxMonsterAudioPlayerPanel.this.setPauseEnabled(false);
                    WaxMonsterAudioPlayerPanel.this.setStopEnabled(false);
                }
            }
            if (WaxMonsterAudioPlayerPanel.this.togglePauseResumeAction != null) {
                WaxMonsterAudioPlayerPanel.this.togglePauseResumeAction.refresh();
            }
        }
    }

    protected class PlayerHandler
    implements PlayerListener {
        protected PlayerHandler() {
        }

        public void stateChanged(Player player) {
            WaxMonsterAudioPlayerPanel.this.playerStateChanged(player);
        }

        public void itemChanged(Player player) {
            WaxMonsterAudioPlayerPanel.this.playerItemChanged(player);
        }
    }

    protected class PlayerSequenceImpl
    implements PlayerSequence {
        protected PlayerSequenceImpl() {
        }

        public PlayerItem nextItem() {
            return WaxMonsterAudioPlayerPanel.this.nextPlayerItem();
        }
    }
}

