/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioInputPort;
import com.waxmonster.audio.AudioOutputPort;
import com.waxmonster.audio.AudioOutputPortType;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.AudioSupport;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.MidiException;
import com.waxmonster.midi.MidiInputPort;
import com.waxmonster.midi.MidiInputPortType;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiOutputPort;
import com.waxmonster.midi.MidiOutputPortType;
import com.waxmonster.midi.MidiPort;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.MidiSupport;
import com.waxmonster.midi.MidiSyncGroup;
import com.waxmonster.midi.common.MidiActionProcessor;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.Icon;

public abstract class AbstractAudioPlayerDevice
extends Device {
    public static final String DEVICE_CATEGORY_NAME = "Audio Players";
    public static final String KEY_CHANNELS = "channels";
    public static final String KEY_MIDI_MAPPING_PREFIX = "midiMapping.";
    public static final String KEY_MIDI_MAPPING_COUNT = "midiMappingCount";
    private final AudioSupportImpl audioSupport = new AudioSupportImpl();
    private final MidiSupportImpl midiSupport = new MidiSupportImpl();
    private int channels;
    private AudioOutputPort audioOutputPort;
    private MidiInputPort midiInputPort;
    private MidiOutputPort midiOutputPort;
    private MidiAction[] midiActions;
    private MidiMapping[] midiActionMappings;
    private AudioProcessor audioPlayer;

    public AbstractAudioPlayerDevice(DeviceProvider provider, String name, Icon iconColor16, int channels) throws StudioException {
        super(provider, name);
        this.setIconColor16(iconColor16);
        this.channels = 0;
        this.midiInputPort = new MidiInputPort("MIDI-In", MidiInputPortType.TYPE, (MidiSupport)this.midiSupport);
        this.midiOutputPort = new MidiOutputPort("MIDI-Out", MidiOutputPortType.TYPE, (MidiSupport)this.midiSupport);
        this.setChannels(channels);
    }

    public MidiMapping[] getMidiActionMappings() {
        return this.midiActionMappings;
    }

    public void setMidiActionMappings(MidiMapping[] midiActionMappings) {
        this.midiActionMappings = midiActionMappings;
        this.midiSupport.applyMidiActionMappings();
    }

    public MidiAction[] getAvailableMidiActions() {
        int n = this.midiActions == null ? 0 : this.midiActions.length;
        MidiAction[] arr = new MidiAction[n];
        if (n > 0) {
            System.arraycopy(this.midiActions, 0, arr, 0, arr.length);
        }
        return arr;
    }

    protected void activate() throws StudioException {
    }

    protected void deactivate() throws StudioException {
        this.audioSupport.reset();
        this.midiSupport.reset();
    }

    public synchronized Properties getProperties() {
        Properties props = super.getProperties();
        props.put(KEY_CHANNELS, String.valueOf(this.channels));
        MidiMapping[] midiActionMappings = this.getMidiActionMappings();
        int num = midiActionMappings == null ? 0 : midiActionMappings.length;
        props.put(KEY_MIDI_MAPPING_COUNT, String.valueOf(num));
        for (int i = 0; i < num; ++i) {
            MidiMapping mam = midiActionMappings[i];
            if (mam == null) continue;
            String key = KEY_MIDI_MAPPING_PREFIX + String.valueOf(1000 + i).substring(1);
            String value = mam.toString();
            props.put(key, value);
        }
        return props;
    }

    public synchronized void setProperties(Properties newProperties) {
        String sChannels = newProperties.getProperty(KEY_CHANNELS);
        if (sChannels != null) {
            this.applyProperty(KEY_CHANNELS, sChannels);
        }
        TreeMap<String, MidiMapping> newMidiMappings = new TreeMap<String, MidiMapping>();
        int midiMappingCount = 0;
        String midiMappingCountValue = newProperties.getProperty(KEY_MIDI_MAPPING_COUNT);
        if (midiMappingCountValue != null) {
            try {
                midiMappingCount = Integer.parseInt(midiMappingCountValue.trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        for (Map.Entry<Object, Object> me : newProperties.entrySet()) {
            String key = String.valueOf(me.getKey());
            if (!key.startsWith(KEY_MIDI_MAPPING_PREFIX)) continue;
            try {
                String value;
                MidiMapping mapping;
                int index = Integer.parseInt(key.substring(KEY_MIDI_MAPPING_PREFIX.length()));
                if (index < 0 || index >= midiMappingCount || (mapping = MidiMapping.parseMidiMapping((String)(value = String.valueOf(me.getValue())))) == null) continue;
                newMidiMappings.put(key, mapping);
            }
            catch (NumberFormatException e) {}
        }
        this.setMidiActionMappings(newMidiMappings.values().toArray(new MidiMapping[newMidiMappings.size()]));
        super.setProperties(newProperties);
    }

    protected void applyProperty(String key, String value) {
        if (key == null) {
            return;
        }
        if (KEY_CHANNELS.equals(key)) {
            try {
                this.setChannels(this.parseIntProperty(key, value));
            }
            catch (StudioException e) {
                throw new RuntimeException(e);
            }
            return;
        }
    }

    public synchronized int getChannels() {
        return this.channels;
    }

    public synchronized void setChannels(int channels) throws StudioException {
        if (channels < 1) {
            throw new IllegalArgumentException("Invalid number of audio channels: " + channels + " < 1");
        }
        int oldChannels = this.channels;
        if (oldChannels == channels) {
            return;
        }
        AudioOutputPortType outputPortType = AudioOutputPortType.getAudioOutputPortType((int)channels);
        AudioOutputPort newOutputPort = new AudioOutputPort("Audio-Out", outputPortType, (AudioSupport)this.audioSupport);
        this.channels = channels;
        this.audioOutputPort = newOutputPort;
        this.refreshPorts();
    }

    protected synchronized void refreshPorts() throws StudioException {
        Studio studio = this.getStudio();
        Port[] oldPorts = this.getPorts();
        LinkedList<MidiInputPort> newInputPorts = new LinkedList<MidiInputPort>();
        LinkedList<Object> newOutputPorts = new LinkedList<Object>();
        newInputPorts.add(this.midiInputPort);
        newOutputPorts.add(this.midiOutputPort);
        if (this.audioOutputPort != null) {
            newOutputPorts.add(this.audioOutputPort);
        }
        HashSet<Port> oldPortSet = new HashSet<Port>();
        for (int i = 0; i < oldPorts.length; ++i) {
            oldPortSet.add(oldPorts[i]);
        }
        int nextPortIndex = 0;
        ArrayList<Object> newPorts = new ArrayList<Object>(newInputPorts.size() + newOutputPorts.size());
        newPorts.addAll(newInputPorts);
        newPorts.addAll(newOutputPorts);
        for (Port port : newPorts) {
            if (port == null) continue;
            oldPortSet.remove(port);
            if (port.getDevice() == this) {
                this.removePort(port);
            }
            this.insertPortAt(port, nextPortIndex);
            ++nextPortIndex;
        }
        for (Port port : oldPortSet) {
            if (port == null) continue;
            if (studio != null) {
                studio.disconnect(port);
            }
            this.removePort(port);
        }
    }

    protected MidiAction[] getMidiActions() {
        return this.midiActions;
    }

    protected void setMidiActions(MidiAction[] midiActions) {
        this.midiActions = midiActions;
    }

    protected abstract AudioProcessor createAudioPlayer(SampleBuffer var1) throws AudioException;

    protected abstract void disposeAudioPlayer(AudioProcessor var1);

    protected class MidiSyncGroupImpl
    extends MidiSyncGroup {
        private Map procs;

        public MidiSyncGroupImpl(String name, MidiInputPort[] inputPorts, MidiOutputPort[] outputPorts) {
            super(name, inputPorts, outputPorts);
            this.procs = new HashMap();
        }

        public void setTargetMidiProcessors(MidiProcessor[] targets) throws MidiException {
            if (targets.length != 1) {
                throw new MidiException("Invalid number of target ports: " + targets.length + " != 1");
            }
        }

        public MidiProcessor createMidiProcessor(MidiInputPort port) throws MidiException {
            MidiActionProcessor proc = (MidiActionProcessor)this.procs.get(port);
            if (proc == null) {
                proc = new MidiActionProcessor(this.getName());
                this.procs.put(port, proc);
                this.applyMidiActionMappings(proc);
            }
            return proc;
        }

        protected void applyMidiActionMappings() {
            for (MidiActionProcessor proc : this.procs.values()) {
                if (proc == null) continue;
                this.applyMidiActionMappings(proc);
            }
        }

        protected void applyMidiActionMappings(MidiActionProcessor proc) {
            proc.reset(AbstractAudioPlayerDevice.this.getAvailableMidiActions(), AbstractAudioPlayerDevice.this.getMidiActionMappings());
            proc.validate();
        }
    }

    protected class MidiSupportImpl
    extends MidiSupport {
        private MidiSyncGroupImpl syncGroup;

        protected MidiSupportImpl() {
        }

        public synchronized void reset() {
            if (this.syncGroup != null) {
                this.syncGroup = null;
            }
        }

        public synchronized MidiSyncGroup getMidiSyncGroup(MidiPort port) {
            if (this.syncGroup == null) {
                MidiInputPort[] inputPorts = new MidiInputPort[]{AbstractAudioPlayerDevice.this.midiInputPort};
                MidiOutputPort[] outputPorts = new MidiOutputPort[]{AbstractAudioPlayerDevice.this.midiOutputPort};
                this.syncGroup = new MidiSyncGroupImpl(AbstractAudioPlayerDevice.this.getTitleOrName(), inputPorts, outputPorts);
            }
            return this.syncGroup;
        }

        protected void applyMidiActionMappings() {
            MidiSyncGroupImpl group = this.syncGroup;
            if (group != null) {
                group.applyMidiActionMappings();
            }
        }
    }

    protected class AudioSyncGroupImpl
    extends AudioSyncGroup {
        public AudioSyncGroupImpl(String name, AudioInputPort[] inputPorts, AudioOutputPort[] outputPorts) {
            super(name, inputPorts, outputPorts);
        }

        public AudioProcessor createAudioProcessor(SampleBuffer[] in, SampleBuffer[] out) throws AudioException {
            if (out.length != 1) {
                throw new AudioException("Invalid number of output buffers: " + out.length + " != " + 1);
            }
            SampleBuffer outputSampleBuffer = out[0];
            if (outputSampleBuffer == null) {
                return null;
            }
            AbstractAudioPlayerDevice.this.audioPlayer = AbstractAudioPlayerDevice.this.createAudioPlayer(outputSampleBuffer);
            return AbstractAudioPlayerDevice.this.audioPlayer;
        }
    }

    protected class AudioSupportImpl
    extends AudioSupport {
        private AudioSyncGroup syncGroup;

        protected AudioSupportImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void reset() {
            if (this.syncGroup != null) {
                this.syncGroup = null;
            }
            if (AbstractAudioPlayerDevice.this.audioPlayer != null) {
                try {
                    AbstractAudioPlayerDevice.this.disposeAudioPlayer(AbstractAudioPlayerDevice.this.audioPlayer);
                }
                finally {
                    AbstractAudioPlayerDevice.this.audioPlayer = null;
                }
            }
        }

        public synchronized AudioSyncGroup getAudioSyncGroup(AudioPort port) {
            if (this.syncGroup == null) {
                this.syncGroup = new AudioSyncGroupImpl(AbstractAudioPlayerDevice.this.getName(), new AudioInputPort[0], new AudioOutputPort[]{AbstractAudioPlayerDevice.this.audioOutputPort});
            }
            return this.syncGroup;
        }
    }
}

