/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;

public class AudioDelay
implements AudioProcessor {
    private final float frameRate;
    private final int maxDelay;
    private final Delay[] delays;
    private final int nd;
    private int delay;
    private double dry;
    private double wet;
    private volatile boolean reset;
    private volatile int newDelay;

    public AudioDelay(SampleBuffer[] inputs, SampleBuffer[] outputs, int maxDelay, int delay, double dry, double wet) throws AudioException {
        if (inputs.length != outputs.length) {
            throw new AudioException("Invalid number of input/output buffers: " + inputs.length + " != " + outputs.length);
        }
        if (inputs.length < 1) {
            throw new AudioException("Invalid number of input/output buffers: " + inputs.length + " < 1");
        }
        this.maxDelay = maxDelay;
        this.delay = delay;
        this.dry = dry;
        this.wet = wet;
        this.frameRate = outputs[0].getFrameRate();
        this.nd = inputs.length;
        this.delays = new Delay[this.nd];
        for (int i = 0; i < this.nd; ++i) {
            int outChannels;
            SampleBuffer in = inputs[i];
            SampleBuffer out = outputs[i];
            int inChannels = in.getChannels();
            if (inChannels != (outChannels = out.getChannels())) {
                throw new AudioException("Invalid number of input/output audio channels: " + inChannels + " != " + outChannels);
            }
            int samples = maxDelay * inChannels;
            double[] buf = new double[samples];
            this.delays[i] = new Delay(in, out, buf, delay);
        }
    }

    public void process(long time, int frames) throws AudioException {
        int i;
        if (this.reset) {
            this.reset = false;
            this.delay = this.newDelay;
            for (i = 0; i < this.nd; ++i) {
                this.delays[i].applyDelay(this.delay);
            }
        }
        for (i = 0; i < this.nd; ++i) {
            this.delays[i].process(time, frames);
        }
    }

    public void shutdown() throws AudioException {
        for (int i = 0; i < this.nd; ++i) {
            this.delays[i].shutdown();
        }
    }

    public final float getFrameRate() {
        return this.frameRate;
    }

    public void resetDelay(int newDelay) {
        if (newDelay < 0) {
            throw new IllegalArgumentException("Invalid new delay: " + newDelay);
        }
        if (newDelay > this.maxDelay) {
            throw new IllegalArgumentException("Invalid new delay: " + newDelay + " > " + this.maxDelay);
        }
        if (this.newDelay == newDelay) {
            return;
        }
        this.newDelay = newDelay;
        this.reset = true;
    }

    public void resetDryWet(double newDry, double newWet) {
        if (newDry < 0.0) {
            newDry = 0.0;
        }
        if (newDry > 1.0) {
            newDry = 1.0;
        }
        if (newWet < 0.0) {
            newWet = 0.0;
        }
        if (newWet > 1.0) {
            newWet = 1.0;
        }
        this.dry = newDry;
        this.wet = newWet;
    }

    protected class Delay
    implements AudioProcessor {
        protected final int nc;
        protected final SampleBuffer in;
        protected final SampleBuffer out;
        protected final double[] buf;
        protected int head;
        protected int tail;

        public Delay(SampleBuffer in, SampleBuffer out, double[] buf, int delay) {
            this.nc = in.getChannels();
            this.in = in;
            this.out = out;
            this.buf = buf;
            this.head = 0;
            this.applyDelay(delay);
        }

        public void process(long time, int frames) throws AudioException {
            int x;
            int n = frames * this.nc;
            if (this.tail + n < this.buf.length) {
                this.in.get(0, this.buf, this.tail, n);
                this.tail += n;
            } else {
                x = this.buf.length - this.tail;
                this.in.get(0, this.buf, this.tail, x);
                this.tail = n - x;
                this.in.get(x, this.buf, 0, this.tail);
            }
            if (this.head + n < this.buf.length) {
                for (int i = 0; i < n; ++i) {
                    this.out.set(i, this.in.getDouble(i) * AudioDelay.this.dry + this.buf[this.head++] * AudioDelay.this.wet);
                }
            } else {
                int i;
                x = this.buf.length - this.head;
                for (i = 0; i < x; ++i) {
                    this.out.set(i, this.in.getDouble(i) * AudioDelay.this.dry + this.buf[this.head++] * AudioDelay.this.wet);
                }
                this.head = 0;
                for (i = x; i < n; ++i) {
                    this.out.set(i, this.in.getDouble(i) * AudioDelay.this.dry + this.buf[this.head++] * AudioDelay.this.wet);
                }
            }
        }

        public void shutdown() throws AudioException {
        }

        protected void applyDelay(int newDelay) {
            int n = newDelay * this.nc;
            this.tail = (this.head + n) % this.buf.length;
        }
    }
}

