/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.spacekiller.util.media.control.AbstractDoubleControl;
import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.media.control.DoubleControl;
import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioInputPort;
import com.waxmonster.audio.AudioInputPortType;
import com.waxmonster.audio.AudioOutputPort;
import com.waxmonster.audio.AudioOutputPortType;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.AudioSupport;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.audio.common.AudioDelay;
import com.waxmonster.audio.common.AudioDelayPanel;
import com.waxmonster.midi.AbstractMidiAction;
import com.waxmonster.midi.MidiAction;
import com.waxmonster.midi.MidiException;
import com.waxmonster.midi.MidiInputPort;
import com.waxmonster.midi.MidiInputPortType;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.MidiOutputPort;
import com.waxmonster.midi.MidiOutputPortType;
import com.waxmonster.midi.MidiPort;
import com.waxmonster.midi.MidiProcessor;
import com.waxmonster.midi.MidiSupport;
import com.waxmonster.midi.MidiSyncGroup;
import com.waxmonster.midi.common.MidiActionProcessor;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.Icon;

public class AudioDelayDevice
extends Device {
    public static final String KEY_CHANNELS = "channels";
    public static final String KEY_PORT_COUNT = "portCount";
    public static final String KEY_MAX_DELAY = "maxDelay";
    public static final String KEY_DELAY = "delay";
    public static final String KEY_DRY_WET = "dryWet";
    public static final String KEY_MIDI_MAPPING_PREFIX = "midiMapping.";
    public static final String KEY_MIDI_MAPPING_COUNT = "midiMappingCount";
    public static final int DEFAULT_CHANNELS = 1;
    public static final int DEFAULT_PORT_COUNT = 2;
    public static final int MAX_PORT_COUNT = 16;
    private final AudioSupportImpl audioSupport = new AudioSupportImpl();
    private final MidiSupportImpl midiSupport = new MidiSupportImpl();
    private final DelayControl delayControl;
    private final DryWetControl dryWetControl;
    private int channels;
    private int portCount;
    private AudioInputPort[] audioInputPorts;
    private AudioOutputPort[] audioOutputPorts;
    private MidiInputPort midiInputPort;
    private MidiOutputPort midiOutputPort;
    private MidiAction[] midiActions;
    private MidiMapping[] midiActionMappings;
    private DelayControlMidiAction delayControlMidiAction;
    private DryWetControlMidiAction dryWetControlMidiAction;
    private AudioDelay audioDelay;
    private int maxDelay = 20000;
    private AudioDelayPanel audioDelayPanel;

    public AudioDelayDevice(DeviceProvider provider, String name, Icon iconColor16) throws StudioException {
        this(provider, name, iconColor16, 1, 2);
    }

    public AudioDelayDevice(DeviceProvider provider, String name, Icon iconColor16, int channels, int portCount) throws StudioException {
        super(provider, name);
        this.setIconColor16(iconColor16);
        this.channels = channels;
        this.portCount = 0;
        this.audioInputPorts = new AudioInputPort[0];
        this.audioOutputPorts = new AudioOutputPort[0];
        this.delayControl = new DelayControl();
        this.dryWetControl = new DryWetControl();
        this.delayControlMidiAction = new DelayControlMidiAction();
        this.dryWetControlMidiAction = new DryWetControlMidiAction();
        this.midiInputPort = new MidiInputPort("MIDI-In", MidiInputPortType.TYPE, (MidiSupport)this.midiSupport);
        this.midiOutputPort = new MidiOutputPort("MIDI-Out", MidiOutputPortType.TYPE, (MidiSupport)this.midiSupport);
        this.addControl((Control)this.delayControl);
        this.addControl((Control)this.dryWetControl);
        this.initMidiActions();
        this.setMaxDelay(10000);
        this.setPortCount(portCount);
    }

    protected void activate() throws StudioException {
    }

    protected void deactivate() throws StudioException {
        this.audioSupport.reset();
        this.midiSupport.reset();
    }

    public synchronized Properties getProperties() {
        Properties props = super.getProperties();
        props.put(KEY_CHANNELS, String.valueOf(this.channels));
        props.put(KEY_PORT_COUNT, String.valueOf(this.portCount));
        props.put(KEY_MAX_DELAY, String.valueOf(this.maxDelay));
        props.remove(KEY_DELAY);
        props.remove(KEY_DRY_WET);
        MidiMapping[] midiActionMappings = this.getMidiActionMappings();
        int num = midiActionMappings == null ? 0 : midiActionMappings.length;
        props.put(KEY_MIDI_MAPPING_COUNT, String.valueOf(num));
        for (int i = 0; i < num; ++i) {
            MidiMapping mam = midiActionMappings[i];
            if (mam == null) continue;
            String key = KEY_MIDI_MAPPING_PREFIX + String.valueOf(1000 + i).substring(1);
            String value = mam.toString();
            props.put(key, value);
        }
        return props;
    }

    public synchronized void setProperties(Properties newProperties) {
        String sMaxDelay;
        String sPortCount;
        String sChannels = newProperties.getProperty(KEY_CHANNELS);
        if (sChannels != null) {
            this.applyProperty(KEY_CHANNELS, sChannels);
        }
        if ((sPortCount = newProperties.getProperty(KEY_PORT_COUNT)) != null) {
            this.applyProperty(KEY_PORT_COUNT, sPortCount);
        }
        if ((sMaxDelay = newProperties.getProperty(KEY_MAX_DELAY)) != null) {
            this.applyProperty(KEY_MAX_DELAY, sMaxDelay);
        }
        TreeMap<String, MidiMapping> newMidiMappings = new TreeMap<String, MidiMapping>();
        int midiMappingCount = 0;
        String midiMappingCountValue = newProperties.getProperty(KEY_MIDI_MAPPING_COUNT);
        if (midiMappingCountValue != null) {
            try {
                midiMappingCount = Integer.parseInt(midiMappingCountValue.trim());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        for (Map.Entry<Object, Object> me : newProperties.entrySet()) {
            String key = String.valueOf(me.getKey());
            if (!key.startsWith(KEY_MIDI_MAPPING_PREFIX)) continue;
            try {
                String value;
                MidiMapping mapping;
                int index = Integer.parseInt(key.substring(KEY_MIDI_MAPPING_PREFIX.length()));
                if (index < 0 || index >= midiMappingCount || (mapping = MidiMapping.parseMidiMapping((String)(value = String.valueOf(me.getValue())))) == null) continue;
                newMidiMappings.put(key, mapping);
            }
            catch (NumberFormatException e) {}
        }
        this.setMidiActionMappings(newMidiMappings.values().toArray(new MidiMapping[newMidiMappings.size()]));
        super.setProperties(newProperties);
    }

    protected void applyProperty(String key, String value) {
        if (key == null) {
            return;
        }
        if (KEY_CHANNELS.equals(key)) {
            try {
                this.setChannels(this.parseIntProperty(key, value));
            }
            catch (StudioException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        if (KEY_PORT_COUNT.equals(key)) {
            try {
                this.setPortCount(this.parseIntProperty(key, value));
            }
            catch (StudioException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        if (KEY_MAX_DELAY.equals(key)) {
            this.setMaxDelay(this.parseIntProperty(key, value));
            return;
        }
        if (KEY_DELAY.equals(key)) {
            this.delayControl.setDouble(this.parseDoubleProperty(key, value));
            return;
        }
        if (KEY_DRY_WET.equals(key)) {
            this.dryWetControl.setDouble(this.parseDoubleProperty(key, value));
            return;
        }
    }

    public synchronized int getPortCount() {
        return this.portCount;
    }

    public synchronized void setPortCount(int portCount) throws StudioException {
        if (portCount < 1) {
            throw new IllegalArgumentException("Invalid number of ports: " + portCount + " < 1");
        }
        if (portCount > 16) {
            throw new IllegalArgumentException("Invalid number of ports: " + portCount + " > " + 16);
        }
        int oldCount = this.portCount;
        if (oldCount == portCount) {
            return;
        }
        AudioInputPortType inputPortType = AudioInputPortType.getAudioInputPortType((int)this.channels);
        AudioOutputPortType outputPortType = AudioOutputPortType.getAudioOutputPortType((int)this.channels);
        AudioInputPort[] newInputPorts = new AudioInputPort[portCount];
        AudioOutputPort[] newOutputPorts = new AudioOutputPort[portCount];
        if (portCount > oldCount) {
            if (oldCount > 0) {
                System.arraycopy(this.audioInputPorts, 0, newInputPorts, 0, oldCount);
                System.arraycopy(this.audioOutputPorts, 0, newOutputPorts, 0, oldCount);
            }
            for (int i = oldCount; i < portCount; ++i) {
                String portId = Integer.toString(i + 1);
                newInputPorts[i] = new AudioInputPort("In-" + portId, inputPortType, (AudioSupport)this.audioSupport);
                newOutputPorts[i] = new AudioOutputPort("Out-" + portId, outputPortType, (AudioSupport)this.audioSupport);
            }
        } else {
            System.arraycopy(this.audioInputPorts, 0, newInputPorts, 0, portCount);
            System.arraycopy(this.audioOutputPorts, 0, newOutputPorts, 0, portCount);
        }
        this.portCount = portCount;
        this.audioInputPorts = newInputPorts;
        this.audioOutputPorts = newOutputPorts;
        this.refreshPorts();
    }

    public synchronized int getChannels() {
        return this.channels;
    }

    public synchronized void setChannels(int channels) throws StudioException {
        if (channels < 1) {
            throw new IllegalArgumentException("Invalid number of audio channels: " + channels + " < 1");
        }
        int oldChannels = this.channels;
        if (oldChannels == channels) {
            return;
        }
        AudioInputPortType inputPortType = AudioInputPortType.getAudioInputPortType((int)channels);
        AudioOutputPortType outputPortType = AudioOutputPortType.getAudioOutputPortType((int)channels);
        AudioInputPort[] newInputPorts = new AudioInputPort[this.portCount];
        AudioOutputPort[] newOutputPorts = new AudioOutputPort[this.portCount];
        for (int i = 0; i < this.portCount; ++i) {
            String portId = Integer.toString(i + 1);
            newInputPorts[i] = new AudioInputPort("In-" + portId, inputPortType, (AudioSupport)this.audioSupport);
            newOutputPorts[i] = new AudioOutputPort("Out-" + portId, outputPortType, (AudioSupport)this.audioSupport);
        }
        this.channels = channels;
        this.audioInputPorts = newInputPorts;
        this.audioOutputPorts = newOutputPorts;
        this.refreshPorts();
    }

    public synchronized Component getCustomizer() {
        if (this.audioDelayPanel == null) {
            this.audioDelayPanel = new AudioDelayPanel();
            this.audioDelayPanel.setOpaque(false);
            this.audioDelayPanel.setDevice(this);
        }
        return this.audioDelayPanel;
    }

    protected synchronized void refreshPorts() throws StudioException {
        Studio studio = this.getStudio();
        Port[] oldPorts = this.getPorts();
        LinkedList<Object> newInputPorts = new LinkedList<Object>();
        LinkedList<Object> newOutputPorts = new LinkedList<Object>();
        newInputPorts.add(this.midiInputPort);
        newOutputPorts.add(this.midiOutputPort);
        for (int i = 0; i < this.portCount; ++i) {
            newInputPorts.add(this.audioInputPorts[i]);
            newOutputPorts.add(this.audioOutputPorts[i]);
        }
        HashSet<Port> oldPortSet = new HashSet<Port>();
        for (int i = 0; i < oldPorts.length; ++i) {
            oldPortSet.add(oldPorts[i]);
        }
        int nextPortIndex = 0;
        ArrayList<Object> newPorts = new ArrayList<Object>(newInputPorts.size() + newOutputPorts.size());
        newPorts.addAll(newInputPorts);
        newPorts.addAll(newOutputPorts);
        for (Port port : newPorts) {
            if (port == null) continue;
            oldPortSet.remove(port);
            if (port.getDevice() == this) {
                this.removePort(port);
            }
            this.insertPortAt(port, nextPortIndex);
            ++nextPortIndex;
        }
        for (Port port : oldPortSet) {
            if (port == null) continue;
            if (studio != null) {
                studio.disconnect(port);
            }
            this.removePort(port);
        }
    }

    public DoubleControl getDelayControl() {
        return this.delayControl;
    }

    public DoubleControl getDryWetControl() {
        return this.dryWetControl;
    }

    protected int computeDelay(double delayMillis, float frameRate) {
        long frames = Math.round(delayMillis * (double)frameRate / 1000.0);
        if (frames < 0L) {
            frames = 0L;
        }
        return (int)frames;
    }

    protected double computeDry(double dryWet) {
        return dryWet < 0.5 ? 1.0 : (1.0 - dryWet) * 2.0;
    }

    protected double computeWet(double dryWet) {
        return dryWet > 0.5 ? 1.0 : dryWet * 2.0;
    }

    public int getMaxDelay() {
        return this.maxDelay;
    }

    public synchronized void setMaxDelay(int maxDelay) {
        if (maxDelay < 1) {
            maxDelay = 1;
        }
        if (this.maxDelay == maxDelay) {
            return;
        }
        this.maxDelay = maxDelay;
        this.delayControl.setMaximum(maxDelay);
    }

    public MidiMapping[] getMidiActionMappings() {
        return this.midiActionMappings;
    }

    public void setMidiActionMappings(MidiMapping[] midiActionMappings) {
        this.midiActionMappings = midiActionMappings;
        this.midiSupport.applyMidiActionMappings();
    }

    public MidiAction[] getAvailableMidiActions() {
        return this.midiActions;
    }

    protected void initMidiActions() {
        this.midiActions = new MidiAction[]{this.delayControlMidiAction, this.dryWetControlMidiAction};
    }

    public DelayControlMidiAction getDelayControlMidiAction() {
        return this.delayControlMidiAction;
    }

    public DryWetControlMidiAction getDryWetControlMidiAction() {
        return this.dryWetControlMidiAction;
    }

    protected class DryWetControl
    extends AbstractDoubleControl {
        public DryWetControl() {
            this.setName(AudioDelayDevice.KEY_DRY_WET);
            this.setTooltip("Dry/Wet control");
            this.setMinimum(0.0);
            this.setMaximum(1.0);
            this.setDouble(0.5);
        }

        protected void applyDouble(double v) {
            AudioDelay del = AudioDelayDevice.this.audioDelay;
            if (del != null) {
                double dry = AudioDelayDevice.this.computeDry(v);
                double wet = AudioDelayDevice.this.computeWet(v);
                del.resetDryWet(dry, wet);
            }
        }
    }

    protected class DelayControl
    extends AbstractDoubleControl {
        public DelayControl() {
            this.setName(AudioDelayDevice.KEY_DELAY);
            this.setTooltip("Delay in milliseconds");
            this.setMinimum(0.0);
            this.setMaximum(60000.0);
            this.setDouble(100.0);
        }

        protected void applyDouble(double v) {
            AudioDelay del = AudioDelayDevice.this.audioDelay;
            if (del != null) {
                double delayMillis = v;
                float frameRate = del.getFrameRate();
                int newDelay = AudioDelayDevice.this.computeDelay(delayMillis, frameRate);
                del.resetDelay(newDelay);
            }
        }

        protected void setMaximum(double maximum) {
            super.setMaximum(maximum);
        }
    }

    protected class DryWetControlMidiAction
    extends AbstractMidiAction {
        public DryWetControlMidiAction() {
            super("DryWetControl");
        }

        public void invoke(long time, int status, int data1, int data2) {
            if (status < 240) {
                switch (status & 0xF0) {
                    case 176: {
                        AudioDelayDevice.this.dryWetControl.setDouble((double)data2 / 127.0);
                        return;
                    }
                }
            }
        }
    }

    protected class DelayControlMidiAction
    extends AbstractMidiAction {
        public DelayControlMidiAction() {
            super("DelayControl");
        }

        public void invoke(long time, int status, int data1, int data2) {
            if (status < 240) {
                switch (status & 0xF0) {
                    case 176: {
                        double delayMillis = (double)data2 / 127.0 * (double)AudioDelayDevice.this.maxDelay;
                        AudioDelayDevice.this.delayControl.setDouble(delayMillis);
                        return;
                    }
                }
            }
        }
    }

    protected class MidiSyncGroupImpl
    extends MidiSyncGroup {
        private Map procs;

        public MidiSyncGroupImpl(String name, MidiInputPort[] inputPorts, MidiOutputPort[] outputPorts) {
            super(name, inputPorts, outputPorts);
            this.procs = new HashMap();
        }

        public void setTargetMidiProcessors(MidiProcessor[] targets) throws MidiException {
            if (targets.length != 1) {
                throw new MidiException("Invalid number of target ports: " + targets.length + " != 1");
            }
        }

        public MidiProcessor createMidiProcessor(MidiInputPort port) throws MidiException {
            MidiActionProcessor proc = (MidiActionProcessor)this.procs.get(port);
            if (proc == null) {
                proc = new MidiActionProcessor(this.getName());
                this.procs.put(port, proc);
                this.applyMidiActionMappings(proc);
            }
            return proc;
        }

        protected void applyMidiActionMappings() {
            for (MidiActionProcessor proc : this.procs.values()) {
                if (proc == null) continue;
                this.applyMidiActionMappings(proc);
            }
        }

        protected void applyMidiActionMappings(MidiActionProcessor proc) {
            proc.reset(AudioDelayDevice.this.getAvailableMidiActions(), AudioDelayDevice.this.getMidiActionMappings());
            proc.validate();
        }
    }

    protected class MidiSupportImpl
    extends MidiSupport {
        private MidiSyncGroupImpl syncGroup;

        protected MidiSupportImpl() {
        }

        public synchronized void reset() {
            if (this.syncGroup != null) {
                this.syncGroup = null;
            }
        }

        public synchronized MidiSyncGroup getMidiSyncGroup(MidiPort port) {
            if (this.syncGroup == null) {
                MidiInputPort[] inputPorts = new MidiInputPort[]{AudioDelayDevice.this.midiInputPort};
                MidiOutputPort[] outputPorts = new MidiOutputPort[]{AudioDelayDevice.this.midiOutputPort};
                this.syncGroup = new MidiSyncGroupImpl(AudioDelayDevice.this.getTitleOrName(), inputPorts, outputPorts);
            }
            return this.syncGroup;
        }

        protected void applyMidiActionMappings() {
            MidiSyncGroupImpl group = this.syncGroup;
            if (group != null) {
                group.applyMidiActionMappings();
            }
        }
    }

    protected class AudioSyncGroupImpl
    extends AudioSyncGroup {
        public AudioSyncGroupImpl(String name, AudioInputPort[] inputPorts, AudioOutputPort[] outputPorts) {
            super(name, inputPorts, outputPorts);
        }

        public AudioProcessor createAudioProcessor(SampleBuffer[] in, SampleBuffer[] out) throws AudioException {
            if (in.length != AudioDelayDevice.this.portCount) {
                throw new AudioException("Invalid number of input buffers: " + in.length + " != " + AudioDelayDevice.this.portCount);
            }
            if (out.length != AudioDelayDevice.this.portCount) {
                throw new AudioException("Invalid number of output buffers: " + out.length + " != " + AudioDelayDevice.this.portCount);
            }
            if (out.length < 1) {
                throw new AudioException("Invalid number of input/output buffers: " + out.length + " < 1");
            }
            float frameRate = out[0].getFrameRate();
            int maxDelayFrames = AudioDelayDevice.this.computeDelay(AudioDelayDevice.this.maxDelay, frameRate);
            double delayMillis = AudioDelayDevice.this.delayControl.getDouble();
            int delayFrames = AudioDelayDevice.this.computeDelay(delayMillis, frameRate);
            double dryWet = AudioDelayDevice.this.dryWetControl.getDouble();
            double dry = AudioDelayDevice.this.computeDry(dryWet);
            double wet = AudioDelayDevice.this.computeWet(dryWet);
            AudioDelayDevice.this.audioDelay = new AudioDelay(in, out, maxDelayFrames, delayFrames, dry, wet);
            return AudioDelayDevice.this.audioDelay;
        }
    }

    protected class AudioSupportImpl
    extends AudioSupport {
        private AudioSyncGroup syncGroup;

        protected AudioSupportImpl() {
        }

        public synchronized void reset() {
            if (this.syncGroup != null) {
                this.syncGroup = null;
                AudioDelayDevice.this.audioDelay = null;
            }
        }

        public synchronized AudioSyncGroup getAudioSyncGroup(AudioPort port) {
            if (this.syncGroup == null) {
                AudioInputPort[] inputPorts = new AudioInputPort[AudioDelayDevice.this.portCount];
                System.arraycopy(AudioDelayDevice.this.audioInputPorts, 0, inputPorts, 0, AudioDelayDevice.this.portCount);
                AudioOutputPort[] outputPorts = new AudioOutputPort[AudioDelayDevice.this.portCount];
                System.arraycopy(AudioDelayDevice.this.audioOutputPorts, 0, outputPorts, 0, AudioDelayDevice.this.portCount);
                this.syncGroup = new AudioSyncGroupImpl(AudioDelayDevice.this.getName(), inputPorts, outputPorts);
            }
            return this.syncGroup;
        }
    }
}

