/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.spacekiller.util.media.control.Control;
import com.spacekiller.util.media.control.DoubleControl;
import com.spacekiller.util.media.control.FaderControlPanel;
import com.spacekiller.util.media.control.TextFieldControlPanel;
import com.spacekiller.util.midi.MidiFormatter;
import com.spacekiller.util.midi.impl.DefaultMidiFactory;
import com.spacekiller.util.midi.impl.DefaultMidiFormatter;
import com.waxmonster.audio.common.AudioDelayDevice;
import com.waxmonster.midi.MidiMappable;
import com.waxmonster.midi.MidiMapper;
import com.waxmonster.midi.MidiMapping;
import com.waxmonster.midi.common.AbstractMidiMapper;
import com.waxmonster.midi.common.MidiMappingManagerPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AudioDelayPanel
extends JPanel
implements MidiMappable {
    private static final long serialVersionUID = -6793083648550575193L;
    private static final Logger logger = Logger.getLogger(AudioDelayPanel.class.getName());
    private static final String CHANNELS_MONO = "Mono";
    private static final String CHANNELS_STEREO = "Stereo";
    private AudioDelayDevice device;
    private final MidiMapperImpl midiMapper = new MidiMapperImpl();
    private boolean refreshing = false;
    private JComboBox comboBoxChannels;
    private JComboBox comboBoxInputCount;
    private FaderControlPanel delayFaderControlPanel;
    private FaderControlPanel dryWetFaderControlPanel;
    private TextFieldControlPanel delayTextFieldControlPanel;

    public AudioDelayPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panel_1 = new JPanel();
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.insets = new Insets(4, 4, 4, 4);
        gbc_panel_1.weighty = 1.0;
        gbc_panel_1.weightx = 1.0;
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 0;
        gbc_panel_1.gridy = 0;
        this.add((Component)panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{0, 0, 0};
        gbl_panel_1.rowHeights = new int[]{0, 0, 0, 0, 0};
        gbl_panel_1.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panel_1.setLayout(gbl_panel_1);
        JLabel lblChannels = new JLabel("Channels:");
        GridBagConstraints gbc_lblChannels = new GridBagConstraints();
        gbc_lblChannels.anchor = 17;
        gbc_lblChannels.insets = new Insets(0, 0, 5, 5);
        gbc_lblChannels.gridx = 0;
        gbc_lblChannels.gridy = 0;
        panel_1.add((Component)lblChannels, gbc_lblChannels);
        JPanel panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.fill = 1;
        gbc_panel.insets = new Insets(0, 0, 5, 0);
        gbc_panel.gridx = 1;
        gbc_panel.gridy = 0;
        panel_1.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        this.comboBoxChannels = new JComboBox();
        GridBagConstraints gbc_comboBoxChannels = new GridBagConstraints();
        gbc_comboBoxChannels.insets = new Insets(0, 0, 0, 5);
        gbc_comboBoxChannels.gridx = 0;
        gbc_comboBoxChannels.gridy = 0;
        panel.add((Component)this.comboBoxChannels, gbc_comboBoxChannels);
        this.comboBoxChannels.setOpaque(false);
        this.comboBoxChannels.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!AudioDelayPanel.this.refreshing) {
                    AudioDelayPanel.this.applyChannels();
                }
            }
        });
        JLabel lblInputPorts = new JLabel("Ports:");
        GridBagConstraints gbc_lblInputPorts = new GridBagConstraints();
        gbc_lblInputPorts.insets = new Insets(0, 4, 0, 5);
        gbc_lblInputPorts.gridx = 1;
        gbc_lblInputPorts.gridy = 0;
        panel.add((Component)lblInputPorts, gbc_lblInputPorts);
        this.comboBoxInputCount = new JComboBox();
        GridBagConstraints gbc_comboBoxInputCount = new GridBagConstraints();
        gbc_comboBoxInputCount.gridx = 2;
        gbc_comboBoxInputCount.gridy = 0;
        panel.add((Component)this.comboBoxInputCount, gbc_comboBoxInputCount);
        this.comboBoxInputCount.setOpaque(false);
        JLabel lblMidiMappings = new JLabel("MIDI:");
        GridBagConstraints gbc_lblMidiMappings = new GridBagConstraints();
        gbc_lblMidiMappings.anchor = 17;
        gbc_lblMidiMappings.insets = new Insets(0, 0, 5, 5);
        gbc_lblMidiMappings.gridx = 0;
        gbc_lblMidiMappings.gridy = 1;
        panel_1.add((Component)lblMidiMappings, gbc_lblMidiMappings);
        JButton buttonMidiMappings = new JButton("Mappings");
        GridBagConstraints gbc_buttonMidiMappings = new GridBagConstraints();
        gbc_buttonMidiMappings.anchor = 17;
        gbc_buttonMidiMappings.insets = new Insets(0, 0, 5, 0);
        gbc_buttonMidiMappings.gridx = 1;
        gbc_buttonMidiMappings.gridy = 1;
        panel_1.add((Component)buttonMidiMappings, gbc_buttonMidiMappings);
        buttonMidiMappings.setToolTipText("Edit MIDI mapping(s)...");
        buttonMidiMappings.setIcon(new ImageIcon(AudioDelayPanel.class.getResource("/com/waxmonster/midi/common/icons/midi_mapping_icon16.png")));
        buttonMidiMappings.setMargin(new Insets(2, 4, 2, 4));
        buttonMidiMappings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioDelayPanel.this.showMidiMappingDialog();
            }
        });
        JLabel lblInputSwitch = new JLabel("Delay:");
        GridBagConstraints gbc_lblInputSwitch = new GridBagConstraints();
        gbc_lblInputSwitch.anchor = 17;
        gbc_lblInputSwitch.insets = new Insets(0, 0, 5, 5);
        gbc_lblInputSwitch.gridx = 0;
        gbc_lblInputSwitch.gridy = 2;
        panel_1.add((Component)lblInputSwitch, gbc_lblInputSwitch);
        JPanel panelDelay = new JPanel();
        GridBagConstraints gbc_panelDelay = new GridBagConstraints();
        gbc_panelDelay.fill = 1;
        gbc_panelDelay.insets = new Insets(0, 0, 5, 0);
        gbc_panelDelay.gridx = 1;
        gbc_panelDelay.gridy = 2;
        panel_1.add((Component)panelDelay, gbc_panelDelay);
        GridBagLayout gbl_panelDelay = new GridBagLayout();
        gbl_panelDelay.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panelDelay.rowHeights = new int[]{0, 0};
        gbl_panelDelay.columnWeights = new double[]{1.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelDelay.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        panelDelay.setLayout(gbl_panelDelay);
        this.delayFaderControlPanel = new FaderControlPanel();
        this.delayFaderControlPanel.setOpaque(false);
        this.delayFaderControlPanel.setOrientation(0);
        GridBagConstraints gbc_delayFaderControlPanel = new GridBagConstraints();
        gbc_delayFaderControlPanel.insets = new Insets(0, 0, 0, 5);
        gbc_delayFaderControlPanel.fill = 1;
        gbc_delayFaderControlPanel.gridx = 0;
        gbc_delayFaderControlPanel.gridy = 0;
        panelDelay.add((Component)this.delayFaderControlPanel, gbc_delayFaderControlPanel);
        this.delayTextFieldControlPanel = new TextFieldControlPanel();
        this.delayTextFieldControlPanel.setColumns(6);
        this.delayTextFieldControlPanel.setOpaque(false);
        GridBagConstraints gbc_delayTextFieldControlPanel = new GridBagConstraints();
        gbc_delayTextFieldControlPanel.insets = new Insets(0, 0, 0, 5);
        gbc_delayTextFieldControlPanel.fill = 1;
        gbc_delayTextFieldControlPanel.gridx = 1;
        gbc_delayTextFieldControlPanel.gridy = 0;
        panelDelay.add((Component)this.delayTextFieldControlPanel, gbc_delayTextFieldControlPanel);
        JLabel lblNewLabel = new JLabel("ms.");
        lblNewLabel.setToolTipText("Milliseconds");
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.gridx = 2;
        gbc_lblNewLabel.gridy = 0;
        panelDelay.add((Component)lblNewLabel, gbc_lblNewLabel);
        JLabel lblOutputSwitch = new JLabel("Mix Level:");
        GridBagConstraints gbc_lblOutputSwitch = new GridBagConstraints();
        gbc_lblOutputSwitch.anchor = 17;
        gbc_lblOutputSwitch.insets = new Insets(0, 0, 0, 5);
        gbc_lblOutputSwitch.gridx = 0;
        gbc_lblOutputSwitch.gridy = 3;
        panel_1.add((Component)lblOutputSwitch, gbc_lblOutputSwitch);
        JPanel panelDryWet = new JPanel();
        GridBagConstraints gbc_panelDryWet = new GridBagConstraints();
        gbc_panelDryWet.fill = 1;
        gbc_panelDryWet.gridx = 1;
        gbc_panelDryWet.gridy = 3;
        panel_1.add((Component)panelDryWet, gbc_panelDryWet);
        GridBagLayout gbl_panelDryWet = new GridBagLayout();
        gbl_panelDryWet.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panelDryWet.rowHeights = new int[]{0, 0};
        gbl_panelDryWet.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_panelDryWet.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        panelDryWet.setLayout(gbl_panelDryWet);
        JLabel lblDry = new JLabel("Dry");
        GridBagConstraints gbc_lblDry = new GridBagConstraints();
        gbc_lblDry.insets = new Insets(0, 0, 0, 5);
        gbc_lblDry.gridx = 0;
        gbc_lblDry.gridy = 0;
        panelDryWet.add((Component)lblDry, gbc_lblDry);
        this.dryWetFaderControlPanel = new FaderControlPanel();
        this.dryWetFaderControlPanel.setOrientation(0);
        this.dryWetFaderControlPanel.setOpaque(false);
        GridBagConstraints gbc_dryWetFaderControlPanel = new GridBagConstraints();
        gbc_dryWetFaderControlPanel.insets = new Insets(0, 0, 0, 5);
        gbc_dryWetFaderControlPanel.fill = 1;
        gbc_dryWetFaderControlPanel.gridx = 1;
        gbc_dryWetFaderControlPanel.gridy = 0;
        panelDryWet.add((Component)this.dryWetFaderControlPanel, gbc_dryWetFaderControlPanel);
        JLabel lblWet = new JLabel("Wet");
        GridBagConstraints gbc_lblWet = new GridBagConstraints();
        gbc_lblWet.gridx = 2;
        gbc_lblWet.gridy = 0;
        panelDryWet.add((Component)lblWet, gbc_lblWet);
        this.comboBoxInputCount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!AudioDelayPanel.this.refreshing) {
                    AudioDelayPanel.this.applyPortCount();
                }
            }
        });
        this.initAudioDelayPanel();
    }

    public AudioDelayDevice getDevice() {
        return this.device;
    }

    public void setDevice(AudioDelayDevice device) {
        this.device = device;
        this.refresh();
    }

    protected void initAudioDelayPanel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void refresh() {
        try {
            this.refreshing = true;
            this.midiMapper.unregisterAllMidiActions();
            this.comboBoxChannels.removeAllItems();
            this.comboBoxInputCount.removeAllItems();
            int channels = 2;
            int portCount = 0;
            DoubleControl delayControl = null;
            DoubleControl dryWetControl = null;
            if (this.device != null) {
                channels = this.device.getChannels();
                portCount = this.device.getPortCount();
                delayControl = this.device.getDelayControl();
                dryWetControl = this.device.getDryWetControl();
                this.midiMapper.registerMidiAction(this.getDelayFaderControlPanel(), this.device.getDelayControlMidiAction().getName());
                this.midiMapper.registerMidiAction(this.getDelayTextFieldControlPanel(), this.device.getDelayControlMidiAction().getName());
                this.midiMapper.registerMidiAction(this.getDryWetFaderControlPanel(), this.device.getDryWetControlMidiAction().getName());
            }
            this.comboBoxChannels.addItem(CHANNELS_MONO);
            this.comboBoxChannels.addItem(CHANNELS_STEREO);
            switch (channels) {
                case 1: {
                    this.comboBoxChannels.setSelectedItem(CHANNELS_MONO);
                    break;
                }
                case 2: {
                    this.comboBoxChannels.setSelectedItem(CHANNELS_STEREO);
                    break;
                }
                default: {
                    String item = String.valueOf(channels);
                    this.comboBoxChannels.addItem(item);
                    this.comboBoxChannels.setSelectedItem(item);
                }
            }
            for (int i = 1; i <= 16; ++i) {
                this.comboBoxInputCount.addItem(Integer.toString(i));
            }
            this.comboBoxInputCount.setSelectedItem(Integer.toString(portCount));
            this.getDelayFaderControlPanel().setControl((Control)delayControl);
            this.getDelayTextFieldControlPanel().setControl((Control)delayControl);
            this.getDryWetFaderControlPanel().setControl((Control)dryWetControl);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void applyChannels() {
        try {
            if (this.device != null) {
                Object item = this.getComboBoxChannels().getSelectedItem();
                int newChannels = CHANNELS_MONO == item ? 1 : (CHANNELS_STEREO == item ? 2 : Integer.parseInt(String.valueOf(item)));
                this.device.setChannels(newChannels);
            }
            this.refresh();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void applyPortCount() {
        try {
            if (this.device != null) {
                Object item = this.getComboBoxInputCount().getSelectedItem();
                int newInputCount = Integer.parseInt(String.valueOf(item));
                this.device.setPortCount(newInputCount);
            }
            this.refresh();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected JComboBox getComboBoxChannels() {
        return this.comboBoxChannels;
    }

    protected JComboBox getComboBoxInputCount() {
        return this.comboBoxInputCount;
    }

    protected void showMidiMappingDialog() {
        if (this.device == null) {
            return;
        }
        try {
            MidiMappingManagerPanel panel = new MidiMappingManagerPanel();
            panel.setStudio(this.device.getStudio());
            panel.setDeviceName(this.device.getName() + "-MidiMapping");
            panel.setMidiFactory(DefaultMidiFactory.getInstance());
            panel.setMidiFormatter((MidiFormatter)DefaultMidiFormatter.getSharedInstance());
            panel.setAvailableActions(this.device.getAvailableMidiActions());
            MidiMapping[] origMappings = this.device.getMidiActionMappings();
            int origCount = origMappings == null ? 0 : origMappings.length;
            MidiMapping[] cloneMappings = new MidiMapping[origCount];
            if (origCount > 0) {
                System.arraycopy(origMappings, 0, cloneMappings, 0, origCount);
            }
            panel.setMappings(cloneMappings);
            String title = "MIDI Mappings";
            if (!panel.showDialog((Component)this, title)) {
                return;
            }
            MidiMapping[] newMappings = panel.getMappings();
            this.device.setMidiActionMappings(newMappings);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected FaderControlPanel getDelayFaderControlPanel() {
        return this.delayFaderControlPanel;
    }

    protected FaderControlPanel getDryWetFaderControlPanel() {
        return this.dryWetFaderControlPanel;
    }

    protected TextFieldControlPanel getDelayTextFieldControlPanel() {
        return this.delayTextFieldControlPanel;
    }

    public MidiMapper getMidiMapper() {
        return this.midiMapper;
    }

    protected class MidiMapperImpl
    extends AbstractMidiMapper {
        protected MidiMapperImpl() {
        }

        public MidiMapping[] getMidiMappings(Object component) {
            return AudioDelayPanel.this.device.getMidiActionMappings();
        }

        public void setMidiMappings(Object component, MidiMapping[] mappings) {
            AudioDelayPanel.this.device.setMidiActionMappings(mappings);
        }
    }
}

