/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioInputPort;
import com.waxmonster.audio.AudioInputPortType;
import com.waxmonster.audio.AudioOutputPort;
import com.waxmonster.audio.AudioOutputPortType;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.AudioSupport;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.audio.common.AudioDither;
import com.waxmonster.audio.common.AudioDitherPanel;
import com.waxmonster.audio.common.Dither;
import com.waxmonster.audio.common.NullDither;
import com.waxmonster.audio.common.RectangleDither;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Random;
import javax.swing.Icon;

public class AudioDitherDevice
extends Device {
    public static final String KEY_PORT_COUNT = "portCount";
    public static final String KEY_BIT_DEPTH = "bitDepth";
    public static final String KEY_DITHER_TYPE = "ditherType";
    public static final int DEFAULT_PORT_COUNT = 2;
    public static final int MAX_PORT_COUNT = 16;
    public static final int DEFAULT_BIT_DEPTH = 16;
    public static final int DITHER_NULL = 0;
    public static final int DITHER_RECTANGLE = 1;
    public static final int DEFAULT_DITHER_TYPE = 1;
    private final AudioSupportImpl audioSupport = new AudioSupportImpl();
    private int portCount;
    private int bitDepth;
    private int ditherType;
    private AudioInputPort[] audioInputPorts;
    private AudioOutputPort[] audioOutputPorts;
    private AudioDither audioDither;
    private Dither[] ditherArray;
    private DitherInfo[] ditherInfo;
    private AudioDitherPanel audioDitherPanel;

    public AudioDitherDevice(DeviceProvider provider, String name, Icon iconColor16) throws StudioException {
        this(provider, name, iconColor16, 2, 16, 1);
    }

    public AudioDitherDevice(DeviceProvider provider, String name, Icon iconColor16, int portCount, int bitDepth, int ditherType) throws StudioException {
        super(provider, name);
        this.setIconColor16(iconColor16);
        this.portCount = 0;
        this.audioInputPorts = new AudioInputPort[0];
        this.audioOutputPorts = new AudioOutputPort[0];
        this.bitDepth = bitDepth;
        this.ditherType = ditherType;
        this.setPortCount(portCount);
    }

    protected void activate() throws StudioException {
    }

    protected void deactivate() throws StudioException {
        this.audioSupport.reset();
    }

    public synchronized Properties getProperties() {
        Properties props = super.getProperties();
        props.put(KEY_PORT_COUNT, String.valueOf(this.portCount));
        props.put(KEY_BIT_DEPTH, String.valueOf(this.bitDepth));
        props.put(KEY_DITHER_TYPE, String.valueOf(this.ditherType));
        return props;
    }

    public synchronized void setProperties(Properties newProperties) {
        String sPortCount = newProperties.getProperty(KEY_PORT_COUNT);
        if (sPortCount != null) {
            this.applyProperty(KEY_PORT_COUNT, sPortCount);
        }
        super.setProperties(newProperties);
    }

    protected void applyProperty(String key, String value) {
        if (key == null) {
            return;
        }
        if (KEY_PORT_COUNT.equals(key)) {
            try {
                this.setPortCount(this.parseIntProperty(key, value));
            }
            catch (StudioException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        if (KEY_BIT_DEPTH.equals(key)) {
            this.setBitDepth(this.parseIntProperty(key, value));
            return;
        }
        if (KEY_DITHER_TYPE.equals(key)) {
            this.setDitherType(this.parseIntProperty(key, value));
            return;
        }
    }

    public synchronized int getPortCount() {
        return this.portCount;
    }

    public synchronized void setPortCount(int portCount) throws StudioException {
        if (portCount < 1) {
            throw new IllegalArgumentException("Invalid number of ports: " + portCount + " < 1");
        }
        if (portCount > 16) {
            throw new IllegalArgumentException("Invalid number of ports: " + portCount + " > " + 16);
        }
        int oldCount = this.portCount;
        if (oldCount == portCount) {
            return;
        }
        AudioInputPort[] newInputPorts = new AudioInputPort[portCount];
        AudioOutputPort[] newOutputPorts = new AudioOutputPort[portCount];
        if (portCount > oldCount) {
            if (oldCount > 0) {
                System.arraycopy(this.audioInputPorts, 0, newInputPorts, 0, oldCount);
                System.arraycopy(this.audioOutputPorts, 0, newOutputPorts, 0, oldCount);
            }
            for (int i = oldCount; i < portCount; ++i) {
                String portId = Integer.toString(i + 1);
                newInputPorts[i] = new AudioInputPort("In-" + portId, AudioInputPortType.MONO, (AudioSupport)this.audioSupport);
                newOutputPorts[i] = new AudioOutputPort("Out-" + portId, AudioOutputPortType.MONO, (AudioSupport)this.audioSupport);
            }
        } else {
            System.arraycopy(this.audioInputPorts, 0, newInputPorts, 0, portCount);
            System.arraycopy(this.audioOutputPorts, 0, newOutputPorts, 0, portCount);
        }
        this.portCount = portCount;
        this.audioInputPorts = newInputPorts;
        this.audioOutputPorts = newOutputPorts;
        this.refreshPorts();
    }

    public synchronized Component getCustomizer() {
        if (this.audioDitherPanel == null) {
            this.audioDitherPanel = new AudioDitherPanel();
            this.audioDitherPanel.setOpaque(false);
            this.audioDitherPanel.setDevice(this);
        }
        return this.audioDitherPanel;
    }

    protected synchronized void refreshPorts() throws StudioException {
        Studio studio = this.getStudio();
        Port[] oldPorts = this.getPorts();
        LinkedList<AudioInputPort> newInputPorts = new LinkedList<AudioInputPort>();
        LinkedList<AudioOutputPort> newOutputPorts = new LinkedList<AudioOutputPort>();
        for (int i = 0; i < this.portCount; ++i) {
            newInputPorts.add(this.audioInputPorts[i]);
            newOutputPorts.add(this.audioOutputPorts[i]);
        }
        HashSet<Port> oldPortSet = new HashSet<Port>();
        for (int i = 0; i < oldPorts.length; ++i) {
            oldPortSet.add(oldPorts[i]);
        }
        int nextPortIndex = 0;
        ArrayList<Object> newPorts = new ArrayList<Object>(newInputPorts.size() + newOutputPorts.size());
        newPorts.addAll(newInputPorts);
        newPorts.addAll(newOutputPorts);
        for (Port port : newPorts) {
            if (port == null) continue;
            oldPortSet.remove(port);
            if (port.getDevice() == this) {
                this.removePort(port);
            }
            this.insertPortAt(port, nextPortIndex);
            ++nextPortIndex;
        }
        for (Port port : oldPortSet) {
            if (port == null) continue;
            if (studio != null) {
                studio.disconnect(port);
            }
            this.removePort(port);
        }
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    public synchronized void setBitDepth(int bitDepth) {
        if (this.bitDepth == bitDepth) {
            return;
        }
        this.bitDepth = bitDepth;
        this.refreshDitherArray();
    }

    public int getDitherType() {
        return this.ditherType;
    }

    public synchronized void setDitherType(int ditherType) {
        if (this.ditherType == ditherType) {
            return;
        }
        this.ditherType = ditherType;
        this.refreshDitherArray();
    }

    protected double computeDitherFactor(int bits) {
        return 1.0 / (double)(1 << bits);
    }

    protected synchronized void refreshDitherArray() {
        Dither[] arr = this.ditherArray;
        if (arr == null) {
            return;
        }
        DitherInfo[] infos = this.ditherInfo;
        if (infos == null) {
            return;
        }
        double factor = this.computeDitherFactor(this.bitDepth);
        if (factor <= 0.0) {
            throw new RuntimeException("Invalid dither factor: " + factor);
        }
        int type = this.ditherType;
        int num = Math.min(infos.length, arr.length);
        for (int i = 0; i < num; ++i) {
            DitherInfo info = infos[i];
            SampleBuffer in = info.in;
            SampleBuffer out = info.out;
            arr[i] = this.createDither(in, out, type, factor);
        }
    }

    protected Dither createDither(SampleBuffer in, SampleBuffer out, int type, double factor) {
        switch (type) {
            case 0: {
                return new NullDither(in, out);
            }
        }
        Random random = this.createRandom();
        return new RectangleDither(in, out, random, factor);
    }

    protected Random createRandom() {
        return new Random();
    }

    static /* synthetic */ Dither[] access$102(AudioDitherDevice x0, Dither[] x1) {
        x0.ditherArray = x1;
        return x1;
    }

    static /* synthetic */ DitherInfo[] access$502(AudioDitherDevice x0, DitherInfo[] x1) {
        x0.ditherInfo = x1;
        return x1;
    }

    protected static class DitherInfo {
        protected final SampleBuffer in;
        protected final SampleBuffer out;

        public DitherInfo(SampleBuffer in, SampleBuffer out) {
            this.in = in;
            this.out = out;
        }
    }

    protected class AudioSyncGroupImpl
    extends AudioSyncGroup {
        public AudioSyncGroupImpl(String name, AudioInputPort[] inputPorts, AudioOutputPort[] outputPorts) {
            super(name, inputPorts, outputPorts);
        }

        public AudioProcessor createAudioProcessor(SampleBuffer[] in, SampleBuffer[] out) throws AudioException {
            if (in.length != AudioDitherDevice.this.portCount) {
                throw new AudioException("Invalid number of input buffers: " + in.length + " != " + AudioDitherDevice.this.portCount);
            }
            if (out.length != AudioDitherDevice.this.portCount) {
                throw new AudioException("Invalid number of output buffers: " + out.length + " != " + AudioDitherDevice.this.portCount);
            }
            if (out.length < 1) {
                throw new AudioException("Invalid number of input/output buffers: " + out.length + " < 1");
            }
            LinkedList<DitherInfo> ditherList = new LinkedList<DitherInfo>();
            for (int i = 0; i < in.length; ++i) {
                SampleBuffer ib = in[i];
                SampleBuffer ob = out[i];
                if (ib == null || ob == null) continue;
                ditherList.add(new DitherInfo(in[i], out[i]));
            }
            if (ditherList.isEmpty()) {
                return null;
            }
            AudioDitherDevice.access$502(AudioDitherDevice.this, ditherList.toArray(new DitherInfo[ditherList.size()]));
            AudioDitherDevice.access$102(AudioDitherDevice.this, new Dither[AudioDitherDevice.this.ditherInfo.length]);
            AudioDitherDevice.this.refreshDitherArray();
            AudioDitherDevice.this.audioDither = new AudioDither(AudioDitherDevice.this.ditherArray);
            return AudioDitherDevice.this.audioDither;
        }
    }

    protected class AudioSupportImpl
    extends AudioSupport {
        private AudioSyncGroup syncGroup;

        protected AudioSupportImpl() {
        }

        public synchronized void reset() {
            if (this.syncGroup != null) {
                this.syncGroup = null;
                AudioDitherDevice.this.audioDither = null;
                AudioDitherDevice.access$102(AudioDitherDevice.this, null);
            }
        }

        public synchronized AudioSyncGroup getAudioSyncGroup(AudioPort port) {
            if (this.syncGroup == null) {
                AudioInputPort[] inputPorts = new AudioInputPort[AudioDitherDevice.this.portCount];
                System.arraycopy(AudioDitherDevice.this.audioInputPorts, 0, inputPorts, 0, AudioDitherDevice.this.portCount);
                AudioOutputPort[] outputPorts = new AudioOutputPort[AudioDitherDevice.this.portCount];
                System.arraycopy(AudioDitherDevice.this.audioOutputPorts, 0, outputPorts, 0, AudioDitherDevice.this.portCount);
                this.syncGroup = new AudioSyncGroupImpl(AudioDitherDevice.this.getName(), inputPorts, outputPorts);
            }
            return this.syncGroup;
        }
    }
}

