/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.waxmonster.audio.common.AudioDitherDevice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AudioDitherPanel
extends JPanel {
    private static final long serialVersionUID = -1593809052531051797L;
    private static final Logger logger = Logger.getLogger(AudioDitherPanel.class.getName());
    private static final String TYPE_NULL = "No Dither";
    private static final String TYPE_RECT = "Rectangle Dither";
    private AudioDitherDevice device;
    private boolean refreshing = false;
    private JComboBox comboBoxBitDepth;
    private JComboBox comboBoxDitherType;
    private JComboBox comboBoxPortCount;

    public AudioDitherPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lblPorts = new JLabel("Ports:");
        GridBagConstraints gbc_lblPorts = new GridBagConstraints();
        gbc_lblPorts.anchor = 17;
        gbc_lblPorts.insets = new Insets(4, 4, 4, 4);
        gbc_lblPorts.gridx = 0;
        gbc_lblPorts.gridy = 0;
        this.add((Component)lblPorts, gbc_lblPorts);
        this.comboBoxPortCount = new JComboBox();
        this.comboBoxPortCount.setToolTipText("Number of input/output ports");
        this.comboBoxPortCount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!AudioDitherPanel.this.refreshing) {
                    AudioDitherPanel.this.apply();
                }
            }
        });
        this.comboBoxPortCount.setOpaque(false);
        GridBagConstraints gbc_comboBoxPortCount = new GridBagConstraints();
        gbc_comboBoxPortCount.weightx = 1.0;
        gbc_comboBoxPortCount.insets = new Insets(4, 4, 4, 4);
        gbc_comboBoxPortCount.fill = 2;
        gbc_comboBoxPortCount.gridx = 1;
        gbc_comboBoxPortCount.gridy = 0;
        this.add((Component)this.comboBoxPortCount, gbc_comboBoxPortCount);
        JLabel lblBitDepth = new JLabel("Bit Depth:");
        GridBagConstraints gbc_lblBitDepth = new GridBagConstraints();
        gbc_lblBitDepth.anchor = 17;
        gbc_lblBitDepth.insets = new Insets(4, 4, 4, 4);
        gbc_lblBitDepth.gridx = 2;
        gbc_lblBitDepth.gridy = 0;
        this.add((Component)lblBitDepth, gbc_lblBitDepth);
        this.comboBoxBitDepth = new JComboBox();
        this.comboBoxBitDepth.setEditable(true);
        this.comboBoxBitDepth.setToolTipText("Dither bit depth");
        this.comboBoxBitDepth.setOpaque(false);
        this.comboBoxBitDepth.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!AudioDitherPanel.this.refreshing) {
                    AudioDitherPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_comboBoxBitDepth = new GridBagConstraints();
        gbc_comboBoxBitDepth.weightx = 1.0;
        gbc_comboBoxBitDepth.insets = new Insets(4, 4, 4, 4);
        gbc_comboBoxBitDepth.fill = 2;
        gbc_comboBoxBitDepth.gridx = 3;
        gbc_comboBoxBitDepth.gridy = 0;
        this.add((Component)this.comboBoxBitDepth, gbc_comboBoxBitDepth);
        JLabel lblDitherType = new JLabel("Type:");
        GridBagConstraints gbc_lblDitherType = new GridBagConstraints();
        gbc_lblDitherType.anchor = 17;
        gbc_lblDitherType.insets = new Insets(4, 4, 4, 4);
        gbc_lblDitherType.gridx = 0;
        gbc_lblDitherType.gridy = 1;
        this.add((Component)lblDitherType, gbc_lblDitherType);
        this.comboBoxDitherType = new JComboBox();
        this.comboBoxDitherType.setToolTipText("Dither type");
        this.comboBoxDitherType.setOpaque(false);
        this.comboBoxDitherType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!AudioDitherPanel.this.refreshing) {
                    AudioDitherPanel.this.apply();
                }
            }
        });
        GridBagConstraints gbc_comboBoxDitherType = new GridBagConstraints();
        gbc_comboBoxDitherType.gridwidth = 3;
        gbc_comboBoxDitherType.insets = new Insets(4, 4, 4, 4);
        gbc_comboBoxDitherType.fill = 2;
        gbc_comboBoxDitherType.gridx = 1;
        gbc_comboBoxDitherType.gridy = 1;
        this.add((Component)this.comboBoxDitherType, gbc_comboBoxDitherType);
    }

    public AudioDitherDevice getDevice() {
        return this.device;
    }

    public void setDevice(AudioDitherDevice device) {
        this.device = device;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void refresh() {
        try {
            this.refreshing = true;
            this.comboBoxPortCount.removeAllItems();
            this.comboBoxBitDepth.removeAllItems();
            this.comboBoxDitherType.removeAllItems();
            int portCount = 0;
            int bitDepth = 16;
            int ditherType = 0;
            if (this.device != null) {
                portCount = this.device.getPortCount();
                bitDepth = this.device.getBitDepth();
                ditherType = this.device.getDitherType();
            }
            for (int i = 1; i <= 16; ++i) {
                this.comboBoxPortCount.addItem(Integer.toString(i));
            }
            this.comboBoxPortCount.setSelectedItem(Integer.toString(portCount));
            this.comboBoxBitDepth.addItem(Integer.toString(16));
            this.comboBoxBitDepth.addItem(Integer.toString(24));
            this.comboBoxBitDepth.setSelectedItem(Integer.toString(bitDepth));
            int ditherIndex = -1;
            if (ditherType == 0) {
                ditherIndex = this.comboBoxDitherType.getItemCount();
            }
            this.comboBoxDitherType.addItem(TYPE_NULL);
            if (ditherType == 1) {
                ditherIndex = this.comboBoxDitherType.getItemCount();
            }
            this.comboBoxDitherType.addItem(TYPE_RECT);
            if (ditherIndex < 0) {
                ditherIndex = this.comboBoxDitherType.getItemCount();
                this.comboBoxDitherType.addItem(Integer.toString(ditherType));
            }
            this.comboBoxDitherType.setSelectedIndex(ditherIndex);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected JComboBox getComboBoxBitDepth() {
        return this.comboBoxBitDepth;
    }

    protected JComboBox getComboBoxDitherType() {
        return this.comboBoxDitherType;
    }

    protected JComboBox getComboBoxPortCount() {
        return this.comboBoxPortCount;
    }

    protected void apply() {
        Object item;
        if (this.device == null) {
            return;
        }
        try {
            item = this.comboBoxPortCount.getSelectedItem();
            int portCount = Integer.parseInt(String.valueOf(item).trim());
            if (portCount > 0 && portCount <= 16 && portCount != this.device.getPortCount()) {
                this.device.setPortCount(portCount);
            }
        }
        catch (NumberFormatException e) {
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        try {
            item = this.comboBoxBitDepth.getSelectedItem();
            int bitDepth = Integer.parseInt(String.valueOf(item).trim());
            if (bitDepth > 0 && bitDepth <= 64 && bitDepth != this.device.getBitDepth()) {
                this.device.setBitDepth(bitDepth);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        int ditherType = -1;
        Object item2 = this.comboBoxDitherType.getSelectedItem();
        if (TYPE_NULL.equals(item2)) {
            ditherType = 0;
        } else if (TYPE_RECT.equals(item2)) {
            ditherType = 1;
        } else {
            try {
                ditherType = Integer.parseInt(String.valueOf(item2).trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (ditherType >= 0 && ditherType != this.device.getDitherType()) {
            this.device.setDitherType(ditherType);
        }
    }
}

