/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AudioMonitor
implements AudioProcessor {
    private static final Logger logger = Logger.getLogger(AudioMonitor.class.getName());
    private final SampleBuffer[] in;
    private final int num;
    private volatile boolean reset;
    long events;
    long frames;
    long firstTime;
    long lastTime;
    int lastFrames;
    private volatile boolean meter;
    double[] peaks;

    public AudioMonitor(SampleBuffer[] in) {
        this.in = in;
        this.num = in.length;
        this.events = 0L;
        this.frames = 0L;
        this.firstTime = 0L;
        this.lastTime = 0L;
        this.lastFrames = 0;
        this.reset = true;
        this.meter = false;
        this.peaks = new double[this.num];
    }

    public void process(long t, int f) throws AudioException {
        this.lastTime = t;
        this.lastFrames = f;
        if (this.reset) {
            this.reset = false;
            this.events = 1L;
            this.frames = this.lastFrames;
            this.firstTime = this.lastTime;
        } else {
            ++this.events;
            this.frames += (long)this.lastFrames;
        }
        if (this.meter) {
            for (int i = 0; i < this.num; ++i) {
                int n;
                double peak;
                SampleBuffer sb = this.in[i];
                if (sb == null || !((peak = Math.abs(sb.peakDouble(0, n = f * sb.getChannels()))) > this.peaks[i])) continue;
                this.peaks[i] = peak;
            }
        }
    }

    public void shutdown() throws AudioException {
        if (logger.isLoggable(Level.FINE)) {
            long nanos = 0L;
            double fps = 0.0;
            if (this.events > 0L && (nanos = this.lastTime - this.firstTime) > 0L) {
                fps = (this.frames - (long)this.lastFrames) * 1000000000L / nanos;
            }
            long millis = nanos / 1000000L;
            logger.fine("AudioMonitor stopped: buffers=" + this.in.length + ", events=" + this.events + ", frames=" + this.frames + ", millis=" + millis + ", fps=" + (double)Math.round(fps * 1000.0) / 1000.0);
        }
    }

    public void reset() {
        this.reset = true;
    }

    public boolean isMeter() {
        return this.meter;
    }

    public void setMeter(boolean meter) {
        this.meter = meter;
    }
}

