/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioInputPort;
import com.waxmonster.audio.AudioInputPortType;
import com.waxmonster.audio.AudioOutputPort;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.AudioSupport;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.audio.common.AudioMonitor;
import com.waxmonster.audio.common.AudioMonitorPanel;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import java.awt.Component;
import java.util.Properties;
import javax.swing.Icon;

public class AudioMonitorDevice
extends Device {
    public static final String KEY_INPUT_PORTS = "inputPorts";
    public static final String KEY_REFRESH_RATE = "refreshRate";
    public static final String KEY_METER_ENABLED = "meterEnabled";
    public static final int MAX_INPUT_PORTS = 16;
    public static final double MAX_REFRESH_RATE = 1000.0;
    public static final double DEFAULT_REFRESH_RATE = 13.0;
    private final AudioSupportImpl audioSupport = new AudioSupportImpl();
    private int inputPortCount;
    private AudioInputPort[] inputPorts;
    private double refreshRate;
    private boolean meterEnabled;
    private AudioMonitor audioMonitor;
    private AudioMonitorPanel audioMonitorPanel;

    public AudioMonitorDevice(DeviceProvider provider, String name, Icon iconColor16, int inputPortCount) throws StudioException {
        super(provider, name);
        this.setIconColor16(iconColor16);
        this.inputPorts = new AudioInputPort[0];
        this.inputPortCount = 0;
        this.meterEnabled = true;
        this.setInputPortCount(inputPortCount);
    }

    public AudioMonitorDevice(DeviceProvider provider, String name, Icon iconColor16) throws StudioException {
        this(provider, name, iconColor16, 2);
    }

    protected void activate() throws StudioException {
    }

    protected void deactivate() throws StudioException {
        this.audioSupport.reset();
    }

    public int getInputPortCount() {
        return this.inputPortCount;
    }

    public synchronized void setInputPortCount(int newInputPortCount) throws StudioException {
        if (this.inputPortCount == newInputPortCount) {
            return;
        }
        AudioInputPort[] newArray = new AudioInputPort[newInputPortCount];
        if (newInputPortCount > this.inputPortCount) {
            System.arraycopy(this.inputPorts, 0, newArray, 0, this.inputPortCount);
            for (int i = this.inputPortCount; i < newInputPortCount; ++i) {
                AudioInputPort inputPort;
                newArray[i] = inputPort = new AudioInputPort("In-" + Integer.toString(i + 1), AudioInputPortType.MONO, (AudioSupport)this.audioSupport);
                this.addPort((Port)inputPort);
            }
        } else {
            System.arraycopy(this.inputPorts, 0, newArray, 0, newInputPortCount);
            for (int i = this.inputPortCount - 1; i >= newInputPortCount; --i) {
                AudioInputPort inputPort = this.inputPorts[i];
                this.getStudio().disconnect((Port)inputPort);
                this.removePort((Port)inputPort);
            }
        }
        this.inputPorts = newArray;
        this.inputPortCount = newArray.length;
    }

    public synchronized Component getCustomizer() {
        if (this.audioMonitorPanel == null) {
            this.audioMonitorPanel = new AudioMonitorPanel();
            this.audioMonitorPanel.setOpaque(false);
            this.audioMonitorPanel.setDevice(this);
            this.adjustTimerDelay();
            this.audioMonitorPanel.setStudio(this.getStudio());
            this.audioMonitorPanel.setMonitor(this.audioMonitor);
        }
        return this.audioMonitorPanel;
    }

    public synchronized Properties getProperties() {
        Properties props = super.getProperties();
        props.put(KEY_INPUT_PORTS, String.valueOf(this.getInputPortCount()));
        props.put(KEY_METER_ENABLED, String.valueOf(this.isMeterEnabled()));
        double rate = this.getRefreshRate();
        if (rate > 0.0) {
            props.put(KEY_REFRESH_RATE, String.valueOf(rate));
        }
        return props;
    }

    protected void applyProperty(String key, String value) {
        if (KEY_INPUT_PORTS.equals(key)) {
            if (value != null) {
                try {
                    this.setInputPortCount(this.parseIntProperty(key, value));
                }
                catch (StudioException e) {
                    throw new RuntimeException(e);
                }
            }
            return;
        }
        if (KEY_REFRESH_RATE.equals(key)) {
            if (value != null) {
                this.setRefreshRate(this.parseDoubleProperty(key, value));
            }
            return;
        }
        if (KEY_METER_ENABLED.equals(key)) {
            if (value != null) {
                this.setMeterEnabled("true".equalsIgnoreCase(value));
            }
            return;
        }
    }

    public boolean isMeterEnabled() {
        return this.meterEnabled;
    }

    public synchronized void setMeterEnabled(boolean meterEnabled) {
        if (this.meterEnabled == meterEnabled) {
            return;
        }
        this.meterEnabled = meterEnabled;
        AudioMonitor mon = this.audioMonitor;
        if (mon != null) {
            mon.setMeter(meterEnabled);
        }
    }

    public double getRefreshRate() {
        return this.refreshRate;
    }

    public synchronized void setRefreshRate(double refreshRate) {
        if (this.refreshRate == refreshRate) {
            return;
        }
        this.refreshRate = refreshRate;
        this.adjustTimerDelay();
    }

    protected void adjustTimerDelay() {
        AudioMonitorPanel panel = this.audioMonitorPanel;
        if (panel == null) {
            return;
        }
        int timerDelay = -1;
        double rate = this.refreshRate;
        if (rate <= 0.0) {
            rate = 13.0;
        }
        if (rate > 0.0) {
            long millis = Math.round(1000.0 / rate);
            if (millis > Integer.MAX_VALUE) {
                millis = Integer.MAX_VALUE;
            }
            timerDelay = (int)millis;
        }
        if (timerDelay <= 0) {
            timerDelay = 1;
        }
        panel.setTimerDelay(timerDelay);
    }

    protected void studioChanged(Studio studio) {
        super.studioChanged(studio);
        AudioMonitorPanel panel = this.audioMonitorPanel;
        if (panel != null) {
            panel.setStudio(studio);
        }
    }

    protected class AudioSyncGroupImpl
    extends AudioSyncGroup {
        public AudioSyncGroupImpl(String name, AudioInputPort[] inputPorts, AudioOutputPort[] outputPorts) {
            super(name, inputPorts, outputPorts);
        }

        public AudioProcessor createAudioProcessor(SampleBuffer[] in, SampleBuffer[] out) throws AudioException {
            AudioMonitorDevice.this.audioMonitor = new AudioMonitor(in);
            AudioMonitorDevice.this.audioMonitor.setMeter(AudioMonitorDevice.this.meterEnabled);
            AudioMonitorPanel amp = AudioMonitorDevice.this.audioMonitorPanel;
            if (amp != null) {
                amp.setMonitor(AudioMonitorDevice.this.audioMonitor);
            }
            return AudioMonitorDevice.this.audioMonitor;
        }
    }

    protected class AudioSupportImpl
    extends AudioSupport {
        private AudioSyncGroup syncGroup;

        protected AudioSupportImpl() {
        }

        public synchronized void reset() {
            AudioMonitorPanel amp;
            if (this.syncGroup != null) {
                this.syncGroup = null;
            }
            if (AudioMonitorDevice.this.audioMonitor != null) {
                AudioMonitorDevice.this.audioMonitor = null;
            }
            if ((amp = AudioMonitorDevice.this.audioMonitorPanel) != null) {
                amp.setMonitor(null);
            }
        }

        public synchronized AudioSyncGroup getAudioSyncGroup(AudioPort port) {
            if (this.syncGroup == null) {
                this.syncGroup = new AudioSyncGroupImpl(AudioMonitorDevice.this.getName(), AudioMonitorDevice.this.inputPorts, new AudioOutputPort[0]);
            }
            return this.syncGroup;
        }
    }
}

