/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.spacekiller.util.Timer;
import com.waxmonster.audio.common.AudioCommonConst;
import com.waxmonster.audio.common.AudioMonitor;
import com.waxmonster.audio.common.AudioMonitorDevice;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.common.BarUnitMeter;
import com.waxmonster.studio.common.CharSeq;
import com.waxmonster.studio.common.Monitor;
import com.waxmonster.studio.common.MonitorComponent;
import com.waxmonster.view.FontCache;
import com.waxmonster.view.ImageFontCache;
import com.waxmonster.view.TextView;
import com.waxmonster.view.View;
import com.waxmonster.view.ViewComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class AudioMonitorPanel
extends JPanel
implements AudioCommonConst {
    private static final long serialVersionUID = -1163821216608448391L;
    private static final Logger logger = Logger.getLogger(AudioMonitorPanel.class.getName());
    private final Update update = new Update();
    private final UpdateLater updateLater = new UpdateLater();
    private volatile boolean updatePending = false;
    private Studio studio;
    private AudioMonitorDevice device;
    private AudioMonitor monitor;
    private Timer timer;
    private int timerDelay = 1000;
    private long oldEvents = -1L;
    private double oldFPS = -1.0;
    private CharSeq charSeqEvents;
    private CharSeq charSeqFrames;
    private CharSeq charSeqTime;
    private CharSeq charSeqFPS;
    private TextView textViewEvents;
    private TextView textViewFrames;
    private TextView textViewTime;
    private TextView textViewFPS;
    private BarUnitMeter[] meters = new BarUnitMeter[0];
    private Paint[] ledPaints;
    private Paint[] errPaints;
    private Paint[] disPaints;
    private boolean meter;
    private boolean wasMeter;
    private MouseHandler mouseHandler = new MouseHandler();
    private HierarchyHandler hierarchyHandler = new HierarchyHandler();
    private JPopupMenu popupMenu;
    private JCheckBoxMenuItem popupItemAudioMeter;
    private boolean refreshing = false;
    private JButton btnReset;
    private JPanel portPanel;
    private JLabel lblNewLabel_4;
    private JLabel labelStatus;
    private JPanel panelTitle;
    private JPanel meterPanel;
    private ViewComponent viewComponent;

    public AudioMonitorPanel() {
        this.initialize();
        this.initAudioMonitorPanel();
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0};
        gridBagLayout.columnWeights = new double[]{0.0};
        this.setLayout(gridBagLayout);
        this.setSize(new Dimension(239, 233));
        this.portPanel = new JPanel();
        this.portPanel.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Ports", 4, 2, null, null));
        GridBagConstraints gbc_portPanel = new GridBagConstraints();
        gbc_portPanel.weighty = 1.0;
        gbc_portPanel.insets = new Insets(4, 4, 0, 4);
        gbc_portPanel.fill = 1;
        gbc_portPanel.gridx = 0;
        gbc_portPanel.gridy = 0;
        this.add((Component)this.portPanel, gbc_portPanel);
        GridBagLayout gbl_portPanel = new GridBagLayout();
        gbl_portPanel.columnWidths = new int[]{0};
        gbl_portPanel.rowHeights = new int[]{0};
        gbl_portPanel.columnWeights = new double[]{0.0};
        gbl_portPanel.rowWeights = new double[]{0.0};
        this.portPanel.setLayout(gbl_portPanel);
        this.meterPanel = new JPanel();
        this.meterPanel.setToolTipText("Audio Meter");
        this.meterPanel.setOpaque(false);
        GridBagConstraints gbc_meterPanel = new GridBagConstraints();
        gbc_meterPanel.insets = new Insets(4, 4, 4, 4);
        gbc_meterPanel.weighty = 1.0;
        gbc_meterPanel.weightx = 1.0;
        gbc_meterPanel.fill = 1;
        gbc_meterPanel.gridx = 0;
        gbc_meterPanel.gridy = 0;
        this.portPanel.add((Component)this.meterPanel, gbc_meterPanel);
        this.meterPanel.setLayout(new GridLayout(0, 1, 0, 0));
        JPanel statusPanel = new JPanel();
        statusPanel.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Status", 4, 2, null, null));
        GridBagConstraints gbc_statusPanel = new GridBagConstraints();
        gbc_statusPanel.weightx = 1.0;
        gbc_statusPanel.insets = new Insets(4, 4, 4, 4);
        gbc_statusPanel.fill = 1;
        gbc_statusPanel.gridx = 0;
        gbc_statusPanel.gridy = 1;
        this.add((Component)statusPanel, gbc_statusPanel);
        GridBagLayout gbl_statusPanel = new GridBagLayout();
        gbl_statusPanel.columnWidths = new int[]{0, 0, 0};
        gbl_statusPanel.rowHeights = new int[]{0, 0, 0};
        gbl_statusPanel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_statusPanel.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        statusPanel.setLayout(gbl_statusPanel);
        this.btnReset = new JButton("Reset");
        this.btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioMonitorPanel.this.actionReset();
            }
        });
        this.labelStatus = new JLabel("N/A");
        GridBagConstraints gbc_labelStatus = new GridBagConstraints();
        gbc_labelStatus.anchor = 17;
        gbc_labelStatus.insets = new Insets(0, 4, 5, 5);
        gbc_labelStatus.gridx = 0;
        gbc_labelStatus.gridy = 0;
        statusPanel.add((Component)this.labelStatus, gbc_labelStatus);
        this.btnReset.setMargin(new Insets(2, 4, 2, 4));
        this.btnReset.setOpaque(false);
        this.btnReset.setToolTipText("Reset counters");
        GridBagConstraints gbc_btnReset = new GridBagConstraints();
        gbc_btnReset.weightx = 1.0;
        gbc_btnReset.insets = new Insets(0, 4, 5, 4);
        gbc_btnReset.anchor = 13;
        gbc_btnReset.gridx = 1;
        gbc_btnReset.gridy = 0;
        statusPanel.add((Component)this.btnReset, gbc_btnReset);
        this.panelTitle = new JPanel();
        this.panelTitle.setOpaque(false);
        GridBagConstraints gbc_panelTitle = new GridBagConstraints();
        gbc_panelTitle.insets = new Insets(4, 4, 4, 4);
        gbc_panelTitle.fill = 1;
        gbc_panelTitle.gridx = 0;
        gbc_panelTitle.gridy = 1;
        statusPanel.add((Component)this.panelTitle, gbc_panelTitle);
        this.panelTitle.setLayout(new GridLayout(4, 1, 0, 0));
        JLabel lblNewLabel_1 = new JLabel("Events:");
        this.panelTitle.add(lblNewLabel_1);
        lblNewLabel_1.setToolTipText("Number of events");
        this.lblNewLabel_4 = new JLabel("Time:");
        this.panelTitle.add(this.lblNewLabel_4);
        this.lblNewLabel_4.setToolTipText("Elapsed time (millis)");
        JLabel lblNewLabel = new JLabel("Frames:");
        this.panelTitle.add(lblNewLabel);
        lblNewLabel.setToolTipText("Number of frames");
        JLabel lblFps = new JLabel("Rate~:");
        this.panelTitle.add(lblFps);
        lblFps.setToolTipText("Average frames per second");
        this.viewComponent = new ViewComponent();
        GridBagConstraints gbc_viewComponent = new GridBagConstraints();
        gbc_viewComponent.insets = new Insets(4, 0, 4, 4);
        gbc_viewComponent.fill = 1;
        gbc_viewComponent.weightx = 1.0;
        gbc_viewComponent.gridx = 1;
        gbc_viewComponent.gridy = 1;
        statusPanel.add((Component)this.viewComponent, gbc_viewComponent);
    }

    public AudioMonitorDevice getDevice() {
        return this.device;
    }

    public void setDevice(AudioMonitorDevice device) {
        this.device = device;
        this.refresh();
    }

    protected void initAudioMonitorPanel() {
        this.charSeqEvents = new CharSeq(new char[CharSeq.MIN_LONG_LEN], 0, 0);
        this.charSeqFrames = new CharSeq(new char[CharSeq.MIN_LONG_LEN], 0, 0);
        this.charSeqFPS = new CharSeq(new char[CharSeq.MIN_LONG_LEN], 0, 0);
        this.charSeqTime = new CharSeq(new char[CharSeq.MIN_LONG_LEN], 0, 0);
        this.textViewEvents = new TextView();
        this.textViewEvents.setText((CharSequence)this.charSeqEvents);
        this.textViewFrames = new TextView();
        this.textViewFrames.setText((CharSequence)this.charSeqFrames);
        this.textViewTime = new TextView();
        this.textViewTime.setText((CharSequence)this.charSeqTime);
        this.textViewFPS = new TextView();
        this.textViewFPS.setText((CharSequence)this.charSeqFPS);
        this.viewComponent.setOpaque(true);
        this.viewComponent.setViews(new View[]{this.textViewEvents, this.textViewTime, this.textViewFrames, this.textViewFPS});
        this.initTextViews();
        this.addHierarchyListener(this.hierarchyHandler);
        this.addMouseListener(this.mouseHandler);
        this.meterPanel.addMouseListener(this.mouseHandler);
        this.ledPaints = BarUnitMeter.createColorArray((Color)COLOR_LED_LO, (Color)COLOR_LED_HI, (int)20);
        this.errPaints = BarUnitMeter.createColorArray((Color)COLOR_ERR_LO, (Color)COLOR_ERR_HI, (int)30);
        this.disPaints = new Paint[]{COLOR_DISABLED, COLOR_DISABLED};
        this.popupMenu = new JPopupMenu();
        JMenuItem popupItemInputPorts = new JMenuItem("Input Ports...");
        this.popupMenu.add(popupItemInputPorts);
        popupItemInputPorts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioMonitorPanel.this.showPortCountDialog();
            }
        });
        popupItemInputPorts.setToolTipText("Set number of ports...");
        JMenuItem popupItemRefreshRate = new JMenuItem("Refresh Rate...");
        this.popupMenu.add(popupItemRefreshRate);
        popupItemRefreshRate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AudioMonitorPanel.this.showRefreshRateDialog();
            }
        });
        popupItemRefreshRate.setToolTipText("Set refresh rate...");
        this.popupItemAudioMeter = new JCheckBoxMenuItem("Audio Meter");
        this.popupMenu.add(this.popupItemAudioMeter);
        this.popupItemAudioMeter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!AudioMonitorPanel.this.refreshing) {
                    AudioMonitorPanel.this.setMeter(e.getStateChange() == 1);
                }
            }
        });
        this.popupItemAudioMeter.setToolTipText("Toggle audio meter (on/off)");
        this.actionReset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        try {
            this.refreshing = true;
            int inputPortCount = 1;
            boolean meterEnabled = false;
            AudioMonitorDevice dev = this.getDevice();
            if (dev != null) {
                inputPortCount = dev.getInputPortCount();
                meterEnabled = dev.isMeterEnabled();
            }
            if (meterEnabled != this.meter) {
                this.setMeter(meterEnabled);
            }
            LineBorder border = new LineBorder(new Color(0.0f, 0.0f, 0.0f, 0.5f));
            int gap = 2;
            this.meterPanel.removeAll();
            this.meterPanel.setLayout(new GridLayout(inputPortCount, 1, gap, gap));
            this.meterPanel.setOpaque(false);
            BarUnitMeter[] oldMeters = this.meters;
            BarUnitMeter[] newMeters = new BarUnitMeter[inputPortCount];
            for (int i = 0; i < inputPortCount; ++i) {
                BarUnitMeter bum = null;
                if (oldMeters != null && i < oldMeters.length) {
                    bum = oldMeters[i];
                }
                if (bum == null) {
                    bum = new BarUnitMeter();
                    bum.setOrientation(0);
                    bum.setMin(0.0);
                    bum.setThreshold(0.001);
                    bum.setLimit(1.0);
                    bum.setMax(1.1);
                }
                if (this.meter && this.monitor != null) {
                    bum.setLedPaints(this.ledPaints);
                    bum.setErrPaints(this.errPaints);
                } else {
                    bum.setLedPaints(this.disPaints);
                    bum.setErrPaints(this.disPaints);
                }
                newMeters[i] = bum;
                MonitorComponent mc = new MonitorComponent();
                mc.setOpaque(true);
                mc.setBackgroundPaint((Paint)Color.BLACK);
                mc.setMonitor((Monitor)bum);
                mc.setPreferredSize(new Dimension(10, 10));
                JPanel mp = new JPanel();
                mp.setLayout(new GridLayout(1, 1));
                mp.setBorder(border);
                mp.setOpaque(false);
                mp.add((Component)mc);
                this.meterPanel.add(mp);
            }
            this.meters = newMeters;
            this.meterPanel.validate();
            this.meterPanel.repaint();
        }
        finally {
            this.refreshing = false;
        }
    }

    protected JButton getBtnReset() {
        return this.btnReset;
    }

    public void update() {
        AudioMonitor mon = this.monitor;
        if (mon == null) {
            return;
        }
        long events = mon.events;
        if (events != this.oldEvents) {
            long frames = mon.frames;
            int lastFrms = mon.lastFrames;
            long nanos = mon.lastTime - mon.firstTime;
            this.charSeqEvents.setLong(events);
            this.charSeqFrames.setLong(frames);
            this.charSeqTime.setMillis(nanos / 1000000L);
            long fps = 0L;
            if (nanos > 0L) {
                fps = Math.round((double)((frames - (long)lastFrms) * 1000000000L) / (double)nanos);
            }
            if ((double)fps != this.oldFPS) {
                this.charSeqFPS.setLong(fps);
            }
            this.oldEvents = events;
            this.oldFPS = fps;
            this.viewComponent.repaint();
            if (this.meter) {
                int i;
                BarUnitMeter[] arr = this.meters;
                double[] peaks = mon.peaks;
                int n = Math.min(arr.length, peaks.length);
                for (i = 0; i < n; ++i) {
                    double peak = peaks[i];
                    peaks[i] = Double.NEGATIVE_INFINITY;
                    if (peak == Double.NEGATIVE_INFINITY) continue;
                    arr[i].setValue(peak);
                }
                if (!this.wasMeter) {
                    this.wasMeter = true;
                    for (i = 0; i < n; ++i) {
                        arr[i].setLedPaints(this.ledPaints);
                        arr[i].setErrPaints(this.errPaints);
                    }
                }
                this.meterPanel.repaint();
            } else if (this.wasMeter) {
                this.wasMeter = false;
                BarUnitMeter[] arr = this.meters;
                double[] peaks = mon.peaks;
                int n = Math.min(arr.length, peaks.length);
                for (int i = 0; i < n; ++i) {
                    peaks[i] = Double.NEGATIVE_INFINITY;
                    arr[i].setValue(0.0);
                    arr[i].setLedPaints(this.disPaints);
                    arr[i].setErrPaints(this.disPaints);
                }
                this.meterPanel.repaint();
            }
        }
    }

    protected void actionReset() {
        AudioMonitor mon = this.monitor;
        if (mon != null) {
            mon.reset();
        } else {
            this.oldEvents = 0L;
            this.labelStatus.setText("Idle");
            this.charSeqEvents.setLong(0L);
            this.charSeqFrames.setLong(0L);
            this.charSeqTime.setMillis(0L);
            this.charSeqFPS.setLong(0L);
            this.viewComponent.repaint();
        }
    }

    public AudioMonitor getMonitor() {
        return this.monitor;
    }

    public synchronized void setMonitor(AudioMonitor newMonitor) {
        if (this.monitor == newMonitor) {
            return;
        }
        if (newMonitor == null) {
            this.monitor = null;
            this.startStopTimer();
            this.labelStatus.setText("Idle");
            BarUnitMeter[] bums = this.meters;
            for (int i = 0; i < bums.length; ++i) {
                BarUnitMeter bum = bums[i];
                bum.setValue(0.0);
                bum.setLedPaints(this.disPaints);
                bum.setErrPaints(this.disPaints);
            }
            this.meterPanel.repaint();
        } else if (this.monitor == null) {
            this.monitor = newMonitor;
            this.labelStatus.setText("Active");
            if (this.meter) {
                BarUnitMeter[] bums = this.meters;
                for (int i = 0; i < bums.length; ++i) {
                    BarUnitMeter bum = bums[i];
                    bum.setValue(0.0);
                    bum.setLedPaints(this.ledPaints);
                    bum.setErrPaints(this.errPaints);
                }
                this.meterPanel.repaint();
            }
            this.startStopTimer();
        } else {
            this.monitor = newMonitor;
        }
    }

    protected void startStopTimer() {
        Timer tima = this.timer;
        if (tima == null) {
            return;
        }
        if (this.monitor != null && this.isShowing()) {
            if (!tima.isActive()) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Starting AudioMonitor update timer: " + this.timer);
                }
                tima.start();
            }
        } else if (tima.isActive()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Stopping AudioMonitor update timer: " + this.timer);
            }
            tima.stop();
        }
    }

    protected JLabel getLabelStatus() {
        return this.labelStatus;
    }

    public boolean isMeter() {
        return this.meter;
    }

    public synchronized void setMeter(boolean meter) {
        if (this.meter == meter) {
            return;
        }
        this.meter = meter;
        AudioMonitorDevice amd = this.device;
        if (amd != null && amd.isMeterEnabled() != meter) {
            amd.setMeterEnabled(meter);
        }
        if (this.popupItemAudioMeter.isSelected() != meter) {
            this.popupItemAudioMeter.setSelected(meter);
        }
    }

    protected void showMonitorPopup(Component comp, int x, int y) {
        if (this.popupMenu != null && comp != null) {
            this.popupMenu.show(comp, x, y);
        }
    }

    protected void showPortCountDialog() {
        int newCount;
        if (this.device == null || this.refreshing) {
            return;
        }
        String message = "Input Ports: 1-16";
        int oldCount = this.device.getInputPortCount();
        String initialSelectionValue = String.valueOf(oldCount);
        String newValue = JOptionPane.showInputDialog(this, message, initialSelectionValue);
        if (newValue == null) {
            return;
        }
        if ((newValue = newValue.trim()).length() < 1) {
            return;
        }
        try {
            newCount = Integer.parseInt(newValue);
        }
        catch (NumberFormatException e) {
            return;
        }
        if (newCount > 0 && newCount <= 16) {
            try {
                this.device.setInputPortCount(newCount);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            this.refresh();
        }
    }

    protected ViewComponent getViewComponent() {
        return this.viewComponent;
    }

    public Studio getStudio() {
        return this.studio;
    }

    public void setStudio(Studio studio) {
        if (this.studio == studio) {
            return;
        }
        this.studio = studio;
        Timer tima = null;
        if (studio != null) {
            tima = studio.createTimer((Runnable)this.updateLater, this.timerDelay);
        }
        this.timer = tima;
    }

    public int getTimerDelay() {
        return this.timerDelay;
    }

    public void setTimerDelay(int timerDelay) {
        this.timerDelay = timerDelay;
        Timer tima = this.timer;
        if (tima != null) {
            tima.setDelay(timerDelay);
        }
    }

    protected void showRefreshRateDialog() {
        double newRate;
        String initialSelectionValue;
        String message;
        String newValue;
        if (this.device == null || this.refreshing) {
            return;
        }
        double oldRate = this.device.getRefreshRate();
        if (oldRate <= 0.0) {
            oldRate = 13.0;
        }
        if ((newValue = JOptionPane.showInputDialog(this, message = "Refresh Rate: > 0.0 .. max. 1000.0 / sec.", initialSelectionValue = String.valueOf(oldRate))) == null) {
            return;
        }
        if ((newValue = newValue.trim()).length() < 1) {
            return;
        }
        try {
            newRate = Double.parseDouble(newValue);
        }
        catch (NumberFormatException e) {
            return;
        }
        if (newRate > 0.0 && newRate <= 1000.0) {
            try {
                this.device.setRefreshRate(newRate);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.viewComponent != null) {
            this.initTextViews();
        }
    }

    protected void initTextViews() {
        Font font = this.labelStatus.getFont();
        Color fontBack = this.getBackground();
        Color fontColor = this.getForeground();
        FontMetrics metrics = this.getFontMetrics(font);
        int trans = 1;
        ImageFontCache fontCache = new ImageFontCache(metrics, fontBack, fontColor, trans);
        this.textViewEvents.setFont((FontCache)fontCache);
        this.textViewTime.setFont((FontCache)fontCache);
        this.textViewFrames.setFont((FontCache)fontCache);
        this.textViewFPS.setFont((FontCache)fontCache);
        int fontHeight = metrics.getHeight();
        this.textViewEvents.setBounds(new Rectangle(0, 0, Integer.MAX_VALUE, fontHeight));
        this.textViewTime.setBounds(new Rectangle(0, fontHeight, Integer.MAX_VALUE, fontHeight));
        this.textViewFrames.setBounds(new Rectangle(0, fontHeight * 2, Integer.MAX_VALUE, fontHeight));
        this.textViewFPS.setBounds(new Rectangle(0, fontHeight * 3, Integer.MAX_VALUE, fontHeight));
        this.viewComponent.setBack((Paint)fontBack);
    }

    protected class HierarchyHandler
    implements HierarchyListener {
        protected HierarchyHandler() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            long flags = e.getChangeFlags();
            if ((flags & 4L) != 0L) {
                AudioMonitorPanel.this.startStopTimer();
            }
        }
    }

    protected class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (e.isPopupTrigger()) {
                AudioMonitorPanel.this.showMonitorPopup(e.getComponent(), e.getX(), e.getY());
                e.consume();
                return;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (e.isPopupTrigger()) {
                AudioMonitorPanel.this.showMonitorPopup(e.getComponent(), e.getX(), e.getY());
                e.consume();
                return;
            }
        }
    }

    protected class UpdateLater
    implements Runnable {
        protected UpdateLater() {
        }

        @Override
        public void run() {
            if (!AudioMonitorPanel.this.updatePending) {
                AudioMonitorPanel.this.updatePending = true;
                SwingUtilities.invokeLater(AudioMonitorPanel.this.update);
            }
        }
    }

    protected class Update
    implements Runnable {
        protected Update() {
        }

        @Override
        public void run() {
            AudioMonitorPanel.this.updatePending = false;
            AudioMonitorPanel.this.update();
        }
    }
}

