/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.common;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;

public class AudioSwitchBox
implements AudioProcessor {
    private final int nc;
    private final SampleBuffer[] inputs;
    private final SampleBuffer[] outputs;
    private int inputIndex;
    private int outputIndex;
    private SampleBuffer in;
    private SampleBuffer out;
    private volatile boolean update;
    private volatile int newInputIndex;
    private volatile int newOutputIndex;

    public AudioSwitchBox(SampleBuffer[] inputs, int inputIndex, SampleBuffer[] outputs, int outputIndex) throws AudioException {
        int sbChannels;
        SampleBuffer sb;
        int i;
        int channels = -1;
        for (i = 0; i < inputs.length; ++i) {
            sb = inputs[i];
            if (sb == null) continue;
            sbChannels = sb.getChannels();
            if (channels < 0) {
                channels = sbChannels;
                continue;
            }
            if (sbChannels == channels) continue;
            throw new AudioException("Invalid number of audio channels: buf=" + sb + ", channels=" + sbChannels + " != " + channels);
        }
        for (i = 0; i < outputs.length; ++i) {
            sb = outputs[i];
            sbChannels = sb.getChannels();
            if (channels < 0) {
                channels = sbChannels;
            } else if (sbChannels != channels) {
                throw new AudioException("Invalid number of audio channels: buf=" + sb + ", channels=" + sbChannels + " != " + channels);
            }
            sb.clear(0, sb.getSamples());
        }
        if (channels < 1) {
            throw new AudioException("Invalid number of audio channels: " + channels);
        }
        this.nc = channels;
        this.inputs = inputs;
        this.outputs = outputs;
        this.inputIndex = inputIndex;
        this.outputIndex = outputIndex;
        this.in = inputs[inputIndex];
        this.out = outputs[outputIndex];
        this.newInputIndex = inputIndex;
        this.newOutputIndex = outputIndex;
        this.update = false;
    }

    public void process(long time, int frames) throws AudioException {
        int n = frames * this.nc;
        if (this.update) {
            SampleBuffer oldOut = this.out;
            this.update = false;
            this.inputIndex = this.newInputIndex;
            this.outputIndex = this.newOutputIndex;
            this.in = this.inputs[this.inputIndex];
            this.out = this.outputs[this.outputIndex];
            if (this.in == null) {
                this.out.clear(0, this.out.getSamples());
            }
            if (oldOut != null && oldOut != this.out) {
                oldOut.clear(0, oldOut.getSamples());
            }
        }
        if (this.in != null) {
            this.out.set(0, this.in, 0, n);
        }
    }

    public void shutdown() throws AudioException {
    }

    public void switchInput(int newInputIndex) {
        this.switchInputOutput(newInputIndex, this.newOutputIndex);
    }

    public void switchOutput(int newOutputIndex) {
        this.switchInputOutput(this.newInputIndex, newOutputIndex);
    }

    public void switchInputOutput(int newInputIndex, int newOutputIndex) {
        if (newInputIndex < 0 || newInputIndex >= this.inputs.length) {
            throw new IllegalArgumentException("Invalid new input index: " + newInputIndex);
        }
        if (newOutputIndex < 0 || newOutputIndex >= this.outputs.length) {
            throw new IllegalArgumentException("Invalid new output index: " + newOutputIndex);
        }
        this.newInputIndex = newInputIndex;
        this.newOutputIndex = newOutputIndex;
        this.update = true;
    }
}

